function[DataMatOut]=CalcUserFile(DataMatIn);	%function name
%==================================================================
%
%	CalcUserFile.m
%
%	Name of user	[December,1996]
%
%
%	Function definition
%	
%	Definition of my own calculation
%
%=================================================================
if nargin<1; return; end
[NChanIn,NPointsIn]=size(DataMatIn);

% DataMatOut=abs(DataMatIn);	%Example: type "Help abs" in Matlab Command Window for further details
% DataMatOut=DataMatOut(1:100,:);
%DataMatOut=DataMatIn.*10^15;
%DataMatOut=DataMatIn.*10^15;
% MeanMeanDataMatIn=mean(mean(DataMatIn));
% DataMatOut=DataMatIn./MeanMeanDataMatIn;
% DataMatOut=DataMatIn;
% for i=1:NPointsIn
%     DataMatOut(:,i)=DataMatIn(:,i)./sqrt(sum(DataMatIn(:,i).^2)');
% end
DataMatOut=abs((DataMatIn-0.9).*10);

fprintf('\n');clc;
Message=char('Use "CalcUserFile.m" ');
Message=char(Message,'in folder "CalcUserFiles": ');
Message=char(Message,'');
% Message=char(Message,'Example: Calculate abs of data.');
% Message=char(Message,'Example: Divide by mean(mean(...');
% Message=char(Message,'Example: Vector scaling of data.');
Message=char(Message,'Example: DataMatOut=abs((DataMatIn-0.9).*10).');
hmsgbox=msgbox(Message,'Info:','help'); 
[NChanOut,NPointsOut]=size(DataMatOut);
if NChanIn~=NChanOut | NPointsIn~= NPointsOut
	Message=char('Sorry, ');
	Message=char(Message,'bad size of outgoing data matrix in "CalcUserFile.m".');
	Message=char(Message,'');
	Message=char(Message,'The outgoing data matrix must be the same ');
	Message=char(Message,'size as the incoming data matrix.');
	hmsgbox=msgbox(Message,'Info:','help'); 
	pause(.1)
	DataMatOut=DataMatIn;
end
return;
