function []=BatchFixResults(ConStart,ConEnd,SubVec,SubgroupDir)

%   BatchFixResults

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.  


if nargin<1; ConStart=[]; end
if nargin<2; ConEnd=[]; end
if nargin<3; SubVec=[]; end
if nargin<4; SubgroupDir=[]; end

global BATCHMJ BATCHMJSPM BATCHMJVOL hReg PRINTSTR

%Changes in (search for BATCHMJ):
%spm_spm_ui
%spm_result_ui
%spm_getSPM
%spm_conman
%spm_render

if isempty(ConStart); ConStart=1; end %Starts with Con+1
if isempty(ConEnd);   ConEnd=[9];  end %Ends with Con+1; if isempty(ConEnd); ConEnd=size(F.names,2); end
if isempty(SubgroupDir); SubgroupDir='Male'; end

PrintFullGlassStatsStatus=0;
WriteFilteredStatus=0;
CalcVoiStatus=1;

ucStr='u' % 'u'=>uncorrected; 'c'=>corrected
uu=0.05
uuStr=uu.*1000;
if uuStr<10
    uuStr=['00',num2str(uuStr)] 
elseif uuStr<100
    uuStr=['0',num2str(uuStr)]
else
    uuStr=num2str(uuStr)
end
k=20
kStr=int2str(k);

BATCHMJ.ucStr=ucStr
BATCHMJ.uu=uu;
BATCHMJ.k=k
BATCHMJ.SPACE='I'
BATCHMJ.TabDat=[]

BaseStr='0';
SmoothStr='15';

FlipStatus=0;
if isempty(SubVec)   
    FemaleVec=[7 9 10 11 13 14 16 17 18 20 22]
    MaleVec  =[3 4  5  6  12 15 21 23 24 25] % 2
    if strcmp(SubgroupDir,'All') | strcmp(SubgroupDir,'Gender')
        SubVec=[MaleVec,FemaleVec]
    elseif strcmp(SubgroupDir,'Female')
        SubVec=FemaleVec
    elseif strcmp(SubgroupDir,'Male')
        SubVec=MaleVec
    end
end
NSub=length(SubVec);

StatsDir=['K:\ValAro\00_Stats_NoScaling\FixStatsSmooth',SmoothStr,'\',SubgroupDir];
RendFilePath='C:\Programme\Matlab12\toolbox\spm99\rend\render_smooth_average.mat';

%=================================================================
F = struct( ...
    'names',  {{...
            'CPosHiGTNeutAll','CPosHiLTNeutAll','CNegHiGTNeutAll','CNegHiLTNeutAll','CPosLoGTNeutAll',...
            'CPosLoLTNeutAll','CNegLoGTNeutAll','CNegLoLTNeutAll','CPosHiGTNegHiAll','CPosHiLTNegHiAll',...                 %10
            'CPosLoGTNegLoAll','CPosLoLTNegLoAll','CAroHiGTLoAll','CAroHiLTLoAll','CAroLinHiGTLoAll',...
            'CAroLinHiLTLoAll','CAroExp1HiGTLoAll','CAroExp1HiLTLoAll','CAroExp2HiGTLoAll','CAroExp2HiLTLoAll',...           %20
            'CValPosGTNegAll','CValPosLTNegAll','CPosHiGTNeutSlow','CPosHiLTNeutSlow','CNegHiGTNeutSlow',...
            'CNegHiLTNeutSlow','CPosLoGTNeutSlow','CPosLoLTNeutSlow','CNegLoGTNeutSlow','CNegLoLTNeutSlow',...               %30
            'CPosHiGTNegHiSlow','CPosHiLTNegHiSlow','CPosLoGTNegLoSlow','CPosLoLTNegLoSlow','CAroHiGTLoSlow',...
            'CAroHiLTLoSlow','CAroLinHiGTLoSlow','CAroLinHiLTLoSlow','CAroExp1HiGTLoSlow','CAroExp1HiLTLoSlow',...           %40
            'CAroExp2HiGTLoSlow','CAroExp2HiLTLoSlow','CValPosGTNegSlow','CValPosLTNegSlow','CPosHiGTNeutFast',...
            'CPosHiLTNeutFast','CNegHiGTNeutFast','CNegHiLTNeutFast','CPosLoGTNeutFast','CPosLoLTNeutFast',...               %50
            'CNegLoGTNeutFast','CNegLoLTNeutFast','CPosHiGTNegHiFast','CPosHiLTNegHiFast','CPosLoGTNegLoFast',...             
            'CPosLoLTNegLoFast','CAroHiGTLoFast','CAroHiLTLoFast','CAroLinHiGTLoFast','CAroLinHiLTLoFast',...                 %60
            'CAroExp1HiGTLoFast','CAroExp1HiLTLoFast','CAroExp2HiGTLoFast','CAroExp2HiLTLoFast','CValPosGTNegFast',...
            'CValPosLTNegFast','CFastGTSlow','CFastLTSlow','CFastGTSlowNegHi','CFastLTSlowNegHi',...                            %70
            'CFastGTSlowNegLo','CFastLTSlowNegLo','CFastGTSlowNeut','CFastLTSlowNeut','CFastGTSlowPosLo',...
            'CFastLTSlowPosLo','CFastGTSlowPosHi','CFastLTSlowPosHi','CFastGTSlowHiAro','CFastLTSlowHiAro',...                  %80
            'CFastGTSlowLoAro','CFastLTSlowLoAro','CFastGTSlowNegVal','CFastLTSlowNegVal','CFastGTSlowPosVal', ...
            'CFastLTSlowPosVal','CPosHiLTPosLoAll','CPosHiGTPosLoAll','CPosHiLTPosLoSlow','CPosHiGTPosLoSlow', ...              %90
            'CPosHiLTPosLoFast','CPosHiGTPosLoFast','CNegHiLTNegLoAll','CNegHiGTNegLoAll','CNegHiLTNegLoSlow', ...
            'CNegHiGTNegLoSlow','CNegHiLTNegLoFast','CNegHiGTNegLoFast','CPosHiLTNegLoAll','CPosHiGTNegLoAll', ...             %100
            'CPosHiLTNegLoSlow','CPosHiGTNegLoSlow','CPosHiLTNegLoFast','CPosHiGTNegLoFast','CNegHiLTPosLoAll', ...
            'CNegHiGTPosLoAll', 'CNegHiLTPosLoSlow','CNegHiGTPosLoSlow','CNegHiLTPosLoFast','CNegHiGTPosLoFast', ...            %110
            'CAroHiGTLoNoNeutralAll','CAroHiLTLoNoNeutralAll','CAroHiGTLoNoNeutralSlow','CAroHiLTLoNoNeutralSlow','CAroHiGTLoNoNeutralFast',...
            'CAroHiLTLoNoNeutralFast','CAroLoGTNeutralAll','CAroLoLTNeutralAll','CAroLoGTNeutralSlow','CAroLoLTNeutralSlow',... %120
            'CAroLoGTNeutralFast','CAroLoLTNeutralFast','CAroHiGTNeutralAll','CAroHiLTNeutralAll','CAroHiGTNeutralSlow',...
            'CAroHiLTNeutralSlow','CAroHiGTNeutralFast','CAroHiLTNeutralFast', ...
        }})
%=================================================================
MaskPath='C:\Programme\Matlab12\toolbox\spm99\masken\';
MaskFileMat=char('ac_l.img');                 
MaskFileMat=char(MaskFileMat,'ac_r.img');                   
MaskFileMat=char(MaskFileMat,'amy_l_us.img');               
MaskFileMat=char(MaskFileMat,'amy_r_us.img');               
MaskFileMat=char(MaskFileMat,'bg_l_us.img');                
MaskFileMat=char(MaskFileMat,'bg_r_us.img');                
MaskFileMat=char(MaskFileMat,'hipp_para_l_us.img');     
MaskFileMat=char(MaskFileMat,'hipp_para_r_us.img');     
MaskFileMat=char(MaskFileMat,'ins_l_us.img');               
MaskFileMat=char(MaskFileMat,'ins_r_us.img');               
MaskFileMat=char(MaskFileMat,'mpc_l.img');                  
MaskFileMat=char(MaskFileMat,'mpc_r.img');                  
MaskFileMat=char(MaskFileMat,'obf_l_us.img');               
MaskFileMat=char(MaskFileMat,'obf_r_us.img');               
MaskFileMat=char(MaskFileMat,'oc_l.img');                   
MaskFileMat=char(MaskFileMat,'oc_r.img');                   
MaskFileMat=char(MaskFileMat,'pc_l_us.img'); 
MaskFileMat=char(MaskFileMat,'pc_r_us.img'); 
MaskFileMat=char(MaskFileMat,'tha_l.img');                  
MaskFileMat=char(MaskFileMat,'tha_r.img');   
NMask=size(MaskFileMat,1)

%=================================================================

if isempty(ConEnd)
    ConEnd=size(F.names,2);
end
NCon=ConEnd-ConStart+1;
MaskMat=-1.*ones(NCon,NMask,5);
MaskMat(:,:,2)=zeros(NCon,NMask,1);
for i=ConStart:ConEnd
    Con=i+1;
    BATCHMJ.Ic=Con
    if Con<10
        PreConStr=['00',int2str(Con)];
    elseif Con>9 & Con<100
        PreConStr=['0',int2str(Con)];
    else
        PreConStr=[int2str(Con)];
    end
    if Con==1
        ConStr='EffectsOfInterest'
        File=['spmF_0001.img'];
    else
        ConStr=char(F.names(Con-1))
        File=['spm_0',PreConStr,'.img']
    end
    BATCHMJ.SWD=StatsDir
    %========================================================
    hReg=spm_results_ui; %vargout(1){hReg,SPM,VOL,xX,xCon,xSDM};
    spm_list('List',BATCHMJSPM,BATCHMJVOL,[],[],'',hReg);
 
    if CalcVoiStatus==1;
        for MaskInd=1:NMask
            BATCHMJ.MaskImage=[MaskPath,deblank(MaskFileMat(MaskInd,:))];
            spm_VOI(BATCHMJSPM,BATCHMJVOL);
            TabDat=BATCHMJ.TabDat;
            TabDatDat=TabDat.dat;
            NCluster=size(TabDatDat,1);
            NSigCluster=0;
            ClusterSigVec=[];
            SigCluster=[];
            Clusterxyz=zeros(NCluster,3);
            for i=1:NCluster
                if ~isempty(TabDatDat{i,3})
                    NSigCluster=NSigCluster+1;
                    ClusterSigVec(NSigCluster)=TabDatDat{i,3};
                    ClusterNVoxVec(NSigCluster)=TabDatDat{i,4};
                    Clusterxyz(NSigCluster,:)=TabDatDat{i,10}';
                end
            end
            if ~isempty(ClusterSigVec)
                SigCluster=find(ClusterSigVec<=0.05);
            end
            if ~isempty(SigCluster)
                [Sig,SigInd]=min(ClusterSigVec(SigCluster))
                NSigVox=sum(ClusterNVoxVec(SigCluster))
                Sigxyz=Clusterxyz(SigInd,:)
                MaskMat(Con-1,MaskInd,1)=Sig;
                MaskMat(Con-1,MaskInd,2)=NSigVox;
                MaskMat(Con-1,MaskInd,3)=Sigxyz(1);
                MaskMat(Con-1,MaskInd,4)=Sigxyz(2);
                MaskMat(Con-1,MaskInd,5)=Sigxyz(3);
            end
            pause(.1)
        end  
    end
end


%============================================================
fid1=fopen([StatsDir,filesep,SubgroupDir,'SigP.txt'],'w','b');
fid2=fopen([StatsDir,filesep,SubgroupDir,'NSigVox.txt'],'w','b');
fid3=fopen([StatsDir,filesep,SubgroupDir,'SigVoxCart.txt'],'w','b');
fprintf(fid1,['Contrast\t']);
fprintf(fid2,['Contrast\t']);
fprintf(fid3,['Contrast\t']);
for MaskInd=1:NMask
    Str=deblank(MaskFileMat(MaskInd,:));
    Str=Str(1:end-4);
    fprintf(fid1,Str);
    fprintf(fid2,Str);
    fprintf(fid3,Str);
    if MaskInd<NMask
        fprintf(fid1,'\t');
        fprintf(fid2,'\t');
        fprintf(fid3,'\t');
    end
end
fprintf(fid1,'\n');
fprintf(fid2,'\n');
fprintf(fid3,'\n');
for ConInd=ConStart:ConEnd
    fprintf(fid1,[char(F.names(ConInd)),'\t']);
    fprintf(fid2,[char(F.names(ConInd)),'\t']);
    fprintf(fid3,[char(F.names(ConInd)),'\t']);
    for MaskInd=1:NMask
        if MaskMat(ConInd,MaskInd,1)<0
            fprintf(fid1,' > 0.05');
        elseif MaskMat(ConInd,MaskInd,1)<0.0001
            fprintf(fid1,' < 0.0001');
        else
            fprintf(fid1,'%1.4f',MaskMat(ConInd,MaskInd,1));
        end
        fprintf(fid2,'%g',MaskMat(ConInd,MaskInd,2));
        if MaskMat(ConInd,MaskInd,2)>0
            fprintf(fid3,'%g %g %g',MaskMat(ConInd,MaskInd,3:5));
        else
            fprintf(fid3,'p > 0.05');
        end
        if MaskInd<NMask
            fprintf(fid1,'\t');
            fprintf(fid2,'\t');
            fprintf(fid3,'\t');
        end
        
    end
    if ConInd<NCon
        fprintf(fid1,'\n');
        fprintf(fid2,'\n');
        fprintf(fid3,'\n');
    end
end
fclose(fid1);
fclose(fid2);
fclose(fid3);
return;