%   BatchKal

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION. 

FemaleVec=[7 9 10 11 13 14 16 17 18 20 22]
MaleVec  =[3 4  5  6  12 15 21 23 24 25] % 2
SubVec=[MaleVec,FemaleVec]
SubVec=[3 4 5 6 7 9 10 11 12 13 14 15 16]
NSub=length(SubVec);
NCond=5;
ParentDir=['G:\ValAro'];
AllData=zeros(NSub,NCond,11);
AllMeanSubData=AllData;
for SubInd=1:NSub
    ActSub=SubVec(SubInd);
    SubIndDir=int2str(ActSub);
    if ActSub<10
        SubIndDir=['0',SubIndDir]
    end
    FilePath=[ParentDir,filesep,SubIndDir,filesep,'snraS',SubIndDir,'Base0Smooth08',filesep,'Matrix.dat']
    AllData(SubInd,:,:)=ReadData(FilePath);
end
MeanData=squeeze(mean(AllData));
for SubInd=1:NSub
    AllMeanSubData(SubInd,:,:)=squeeze(AllData(SubInd,:,:))-MeanData;
end
StdData=squeeze(std(AllMeanSubData))./10;
figure;
ColStr = ['r','m','k','c','b']; 
x=linspace(0,30,11);
for CondInd=1:NCond
    errorbar(x,MeanData(CondInd,:)',StdData(CondInd,:)',ColStr(CondInd))
    hold on
    axis([0 30 157 161])
end