function []=BatchVoi(ConStart,ConEnd,SubVec,SubgroupDir)

%   BatchVoi.m

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.  

if nargin<1; ConStart=[]; end
if nargin<2; ConEnd=[]; end
if nargin<3; SubVec=[]; end
if nargin<4; SubgroupDir=[]; end

global BATCHMJ BATCHMJSPM BATCHMJVOL hReg PRINTSTR

%Changes in (search for BATCHMJ):
%spm_spm_ui
%spm_result_ui
%spm_getSPM
%spm_conman
%spm_render

if isempty(ConStart); ConStart=17; end %Starts with Con+1
if isempty(ConEnd);   ConEnd=[17];  end %Ends with Con+1; if isempty(ConEnd); ConEnd=size(F.names,2); end
if isempty(SubgroupDir); SubgroupDir='All'; end
  
ucStr='u' % 'u'=>uncorrected; 'c'=>corrected
uu=0.01
uuStr=uu.*1000;
if uuStr<10
  uuStr=['00',num2str(uuStr)] 
elseif uuStr<100
  uuStr=['0',num2str(uuStr)]
else
  uuStr=num2str(uuStr)
end
k=2
kStr=int2str(k);

BATCHMJ.ucStr=ucStr
BATCHMJ.uu=uu;
BATCHMJ.k=k
BATCHMJ.Ic=2

BaseStr='0';
SmoothStr='08';

FlipStatus=0;
if isempty(SubVec)   
    FemaleVec=[7 9 10 11 13 14 16 17 18 20 22]
    MaleVec  =[3 4  5  6  12 15 21 23 24 25] % 2
    if strcmp(SubgroupDir,'All') | strcmp(SubgroupDir,'Gender')
        SubVec=[MaleVec,FemaleVec]
    elseif strcmp(SubgroupDir,'Female')
        SubVec=FemaleVec
    elseif strcmp(SubgroupDir,'Male')
        SubVec=MaleVec
    end
end
NSub=length(SubVec);

GrandParentDir=['D:\ValAro\00_Stats_NoScaling\RandStatsSmooth',SmoothStr];
RendFilePath='C:\Programme\Matlab12\toolbox\spm99\rend\render_smooth_average.mat';

%======================Create ParentDir==================
ParentDir=[GrandParentDir,filesep,SubgroupDir];
[MkDirStatus,MkDirMsg]=mkdir(GrandParentDir,SubgroupDir);
if MkDirStatus==1;
    fprintf(['Make directory: ',SubgroupDir,' !\n\n'])
elseif MkDirStatus==2;
    fprintf(['Directory: ',SubgroupDir,' already exists !\n\n'])
elseif MkDirStatus==0;
    MkDirStatus=MkDirStatus
    MkDirMsg=MkDirMsg
    pause;
end
%======================Create ContrastDir==================
ContrastDir='XContrasts';
FullContrastDir=[ParentDir,filesep,ContrastDir];
[MkDirStatus,MkDirMsg]=mkdir(ParentDir,ContrastDir);
if MkDirStatus==1;
    fprintf(['Make directory: ',ContrastDir,' !\n\n'])
elseif MkDirStatus==2;
    fprintf(['Directory: ',ContrastDir,' already exists !\n\n'])
elseif MkDirStatus==0;
    MkDirStatus=MkDirStatus
    MkDirMsg=MkDirMsg
    pause;
end
%======================Create StatsDir==================
StatsDir=[ucStr,uuStr,'k',kStr]
FullStatsDir=[ParentDir,filesep,StatsDir]
[MkDirStatus,MkDirMsg]=mkdir(ParentDir,StatsDir);
if MkDirStatus==1;
    fprintf(['Make directory: ',StatsDir,' !\n\n'])
elseif MkDirStatus==2;
    fprintf(['Directory: ',StatsDir,' already exists !\n\n'])
elseif MkDirStatus==0;
    MkDirStatus=MkDirStatus
    MkDirMsg=MkDirMsg
    pause;
end
%======================Create FullGlassStatsDir==================
GlassStatsDir='GlassStatsJpg'
FullGlassStatsDir=[FullStatsDir,filesep,GlassStatsDir]
[MkDirStatus,MkDirMsg]=mkdir(FullStatsDir,GlassStatsDir);
if MkDirStatus==1;
    fprintf(['Make directory: ',GlassStatsDir,' !\n\n'])
elseif MkDirStatus==2;
    fprintf(['Directory: ',GlassStatsDir,' already exists !\n\n'])
elseif MkDirStatus==0;
    MkDirStatus=MkDirStatus
    MkDirMsg=MkDirMsg
    pause;
end
%======================Create FullGlassRenderDir==================
GlassRenderDir='GlassRenderJpg'
FullGlassRenderDir=[FullStatsDir,filesep,GlassRenderDir]
[MkDirStatus,MkDirMsg]=mkdir(FullStatsDir,GlassRenderDir);
if MkDirStatus==1;
    fprintf(['Make directory: ',GlassRenderDir,' !\n\n'])
elseif MkDirStatus==2;
    fprintf(['Directory: ',GlassRenderDir,' already exists !\n\n'])
elseif MkDirStatus==0;
    MkDirStatus=MkDirStatus
    MkDirMsg=MkDirMsg
    pause;
end
%======================Create FilteredDir==================
FilteredDir='Filtered'
FullFilteredDir=[FullStatsDir,filesep,FilteredDir]
[MkDirStatus,MkDirMsg]=mkdir(FullStatsDir,FilteredDir);
if MkDirStatus==1;
    fprintf(['Make directory: ',FilteredDir,' !\n\n'])
elseif MkDirStatus==2;
    fprintf(['Directory: ',FilteredDir,' already exists !\n\n'])
elseif MkDirStatus==0;
    MkDirStatus=MkDirStatus
    MkDirMsg=MkDirMsg
    pause;
end

%=================================================================

F = struct( ...
    'names',  {{...
            'CPosHiGTNeutAll','CPosHiLTNeutAll','CNegHiGTNeutAll','CNegHiLTNeutAll','CPosLoGTNeutAll',...
            'CPosLoLTNeutAll','CNegLoGTNeutAll','CNegLoLTNeutAll','CPosHiGTNegHiAll','CPosHiLTNegHiAll',...                 %10
            'CPosLoGTNegLoAll','CPosLoLTNegLoAll','CAroHiGTLoAll','CAroHiLTLoAll','CAroLinHiGTLoAll',...
            'CAroLinHiLTLoAll','CAroExp1HiGTLoAll','CAroExp1HiLTLoAll','CAroExp2HiGTLoAll','CAroExp2HiLTLoAll',...           %20
            'CValPosGTNegAll','CValPosLTNegAll','CPosHiGTNeutSlow','CPosHiLTNeutSlow','CNegHiGTNeutSlow',...
            'CNegHiLTNeutSlow','CPosLoGTNeutSlow','CPosLoLTNeutSlow','CNegLoGTNeutSlow','CNegLoLTNeutSlow',...               %30
            'CPosHiGTNegHiSlow','CPosHiLTNegHiSlow','CPosLoGTNegLoSlow','CPosLoLTNegLoSlow','CAroHiGTLoSlow',...
            'CAroHiLTLoSlow','CAroLinHiGTLoSlow','CAroLinHiLTLoSlow','CAroExp1HiGTLoSlow','CAroExp1HiLTLoSlow',...           %40
            'CAroExp2HiGTLoSlow','CAroExp2HiLTLoSlow','CValPosGTNegSlow','CValPosLTNegSlow','CPosHiGTNeutFast',...
            'CPosHiLTNeutFast','CNegHiGTNeutFast','CNegHiLTNeutFast','CPosLoGTNeutFast','CPosLoLTNeutFast',...               %50
            'CNegLoGTNeutFast','CNegLoLTNeutFast','CPosHiGTNegHiFast','CPosHiLTNegHiFast','CPosLoGTNegLoFast',...             
            'CPosLoLTNegLoFast','CAroHiGTLoFast','CAroHiLTLoFast','CAroLinHiGTLoFast','CAroLinHiLTLoFast',...                 %60
            'CAroExp1HiGTLoFast','CAroExp1HiLTLoFast','CAroExp2HiGTLoFast','CAroExp2HiLTLoFast','CValPosGTNegFast',...
            'CValPosLTNegFast','CFastGTSlow','CFastLTSlow','CFastGTSlowNegHi','CFastLTSlowNegHi',...                            %70
            'CFastGTSlowNegLo','CFastLTSlowNegLo','CFastGTSlowNeut','CFastLTSlowNeut','CFastGTSlowPosLo',...
            'CFastLTSlowPosLo','CFastGTSlowPosHi','CFastLTSlowPosHi','CFastGTSlowHiAro','CFastLTSlowHiAro',...                  %80
            'CFastGTSlowLoAro','CFastLTSlowLoAro','CFastGTSlowNegVal','CFastLTSlowNegVal','CFastGTSlowPosVal', ...
            'CFastLTSlowPosVal','CPosHiLTPosLoAll','CPosHiGTPosLoAll','CPosHiLTPosLoSlow','CPosHiGTPosLoSlow', ...              %90
            'CPosHiLTPosLoFast','CPosHiGTPosLoFast','CNegHiLTNegLoAll','CNegHiGTNegLoAll','CNegHiLTNegLoSlow', ...
            'CNegHiGTNegLoSlow','CNegHiLTNegLoFast','CNegHiGTNegLoFast','CPosHiLTNegLoAll','CPosHiGTNegLoAll', ...             %100
            'CPosHiLTNegLoSlow','CPosHiGTNegLoSlow','CPosHiLTNegLoFast','CPosHiGTNegLoFast','CNegHiLTPosLoAll', ...
            'CNegHiGTPosLoAll', 'CNegHiLTPosLoSlow','CNegHiGTPosLoSlow','CNegHiLTPosLoFast','CNegHiGTPosLoFast', ...            %110
            'CAroHiGTLoNoNeutralAll','CAroHiLTLoNoNeutralAll','CAroHiGTLoNoNeutralSlow','CAroHiLTLoNoNeutralSlow','CAroHiGTLoNoNeutralFast',...
            'CAroHiLTLoNoNeutralFast','CAroLoGTNeutralAll','CAroLoLTNeutralAll','CAroLoGTNeutralSlow','CAroLoLTNeutralSlow',... %120
            'CAroLoGTNeutralFast','CAroLoLTNeutralFast','CAroHiGTNeutralAll','CAroHiLTNeutralAll','CAroHiGTNeutralSlow',...
            'CAroHiLTNeutralSlow','CAroHiGTNeutralFast','CAroHiLTNeutralFast', ...
        }})
if isempty(ConEnd)
    ConEnd=size(F.names,2);
end
for i=ConStart:ConEnd
    Con=i+1;
    if Con<10
        PreConStr=['00',int2str(Con)];
    elseif Con>9 & Con<100
        PreConStr=['0',int2str(Con)];
    else
        PreConStr=[int2str(Con)];
    end
    if Con==1
        ConStr='EffectsOfInterest'
        ConDir=[PreConStr,'_EffectsOfInterest'];
        File=['ess_0',PreConStr,'.img'];
    else
        ConStr=char(F.names(Con-1));
        ConName=[PreConStr,'_',ConStr];
        ConDir=[PreConStr,'_',ConStr(2:length(ConStr))]
        File=['con_0',PreConStr,'.img'];
    end
    FullConDir=[FullContrastDir,filesep,ConDir]; 
    BATCHMJ.SWD=FullConDir
   %========================================================
   hReg=spm_results_ui; %vargout(1){hReg,SPM,VOL,xX,xCon,xSDM};
   spm_list('List',BATCHMJSPM,BATCHMJVOL,[],[],'',hReg);
   eval(['cd ',FullGlassStatsDir])
   PRINTSTR=['print -djpeg100 -painters -append -noui ',ConDir,'.jpg']
   spm_figure('Print')
   pause(2)
   FilterPath=[FullFilteredDir,filesep,ConDir];
   [MkDirStatus,MkDirMsg]=mkdir(FullFilteredDir,ConDir);
   if MkDirStatus==1;
       fprintf(['Make directory: ',ConDir,' !\n\n'])
   elseif MkDirStatus==2;
       fprintf(['Directory: ',ConDir,' already exists !\n\n'])
   elseif MkDirStatus==0;
       MkDirStatus=MkDirStatus
       MkDirMsg=MkDirMsg
       pause;
   end
   eval(['cd ',FilterPath])
   spm_write_filtered(BATCHMJSPM.Z,BATCHMJSPM.XYZ,BATCHMJVOL.DIM,BATCHMJVOL.M,...
   sprintf('SPM{%c}-filtered: u = %5.3f, k = %d',BATCHMJSPM.STAT,BATCHMJSPM.u,BATCHMJSPM.k),ConDir);
   FilterFilePathImg=[FilterPath,filesep,ConDir,'.img'];
   [TValVec,BMat,MMat,MniMat,ValFilePath,BTalFilePath,MTalFilePath,MniFilePath]=Vox2Tal(FilterFilePathImg);
   TDStrFilePath=['H:\TD\TDStrSort.txt'];
   TDCoorFilePath=['H:\TD\TDCoorSort.txt'];
   [BTalFile,BTalPath]=SepFilePath(BTalFilePath)
   TdFilePath=[BTalPath,'TD_',BTalFile];
   FindTD([],BTalFilePath,TDStrFilePath,TDCoorFilePath,TdFilePath)
   CalcTalStat(20,TdFilePath,ValFilePath);
   CalcTalStatBA(20,TdFilePath,ValFilePath);
   if ~isempty(TValVec)
        spm_render(struct('XYZ',BATCHMJSPM.XYZ,'t',BATCHMJSPM.Z,'mat',BATCHMJVOL.M,'dim',BATCHMJVOL.DIM),NaN,RendFilePath);
   end
   eval(['cd ',FullGlassRenderDir])
   PRINTSTR=['print -djpeg100 -painters -append -noui ',ConDir,'.jpg']
   spm_figure('Print')
   pause(2)
end
