function []=BatchDelete(SubVec,SessVec,MaskStr,Str)

%   BatchDelete

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
if nargin<1; SubVec=[]; end
if nargin<2; SessVec=[]; end
if nargin<3; MaskStr=[]; end
if nargin<4; Str='Test'; end

if isempty(SubVec) | isempty(MaskStr)
   fprintf('[]=BatchDelete(SubVec,SessVec,MaskStr,Str)')
   return
end
if isempty(SessVec); SessVec=[1:6]; end
NSub=length(SubVec);
NSess=length(SessVec);

for SubInd=1:NSub;
   ActSub=SubVec(SubInd)
   ActSubStr=int2str(ActSub);
  	if ActSub<10
     	ActSubStr=['0',ActSubStr];
  	end
	for SessInd=1:NSess
   	ActSessStr=int2str(SessInd);
   	if SessInd<10
      	ActSessStr=['0',ActSessStr];
   	end
   	FolderName=['E:\fMRIData\fMRIDataGV\',ActSubStr,'\',ActSessStr,'\']
      Tmp=spm_get('Files',FolderName,MaskStr)
      if strcmp(Str,'Delete')
         DeleteFileMat(Tmp)
      else
         disp(Str)
      end
	end
end

