%   BAT.m

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.  


global Base BaseStr MaskStr

%---------------------------------------------------------------
% model(1) Low-Off vs High Off
%---------------------------------------------------------------
                                                                    

Mask=[MaskStr,'*.img']

NSess=4
SubIndVec=[1 2 3 4 5 6 7 8 10 11 12 13 14 15 16]
% SubIndVec=[14 16 17 20 22]
% FemSubIndVec=[3 7 9 10 11 14 16 17 18 20 22]
% MalSubIndVec=[4 5 6 12 13 15 21 23 24 25]
NSub=length(SubIndVec)
for SubInd=1:NSub
    ActSubInd=SubIndVec(SubInd)
    if ActSubInd<10
        ActSubIndStr=['00',int2str(ActSubInd)];    
    elseif ActSubInd>=10
        ActSubIndStr=['0',int2str(ActSubInd)];
    end
    for SessInd=1:NSess
        if SessInd==1
            FolderName=['G:\JungSchupp\0030JS\0030_',ActSubIndStr,'\0003\']
        elseif SessInd==2
            FolderName=['G:\JungSchupp\0030JS\0030_',ActSubIndStr,'\0004\']
        elseif SessInd==3
            FolderName=['G:\JungSchupp\0030JS\0030_',ActSubIndStr,'\0005\']
        elseif SessInd==4
            FolderName=['G:\JungSchupp\0030JS\0030_',ActSubIndStr,'\0006\']
        end
        F=spm_get('Files',FolderName,Mask);
        RFile=spm_get('Files',FolderName,['realignment*.*'])
        R=ReadTxtMat(RFile,[6 200]);
        R=R';
        if size(R)~=[200,6]
            error('size(R)~=[200,6]')
        end
        eval(['F',int2str((SubInd-1).*NSess+SessInd),'=F'])
        eval(['R',int2str((SubInd-1).*NSess+SessInd),'=R;'])
    end
end

%---------------------------------------------------------------
% batch variables defined here for analysis 'model'
%---------------------------------------------------------------

model(1) = struct( ...
 'types',          4, ...
 'global_effects', {'Scaling'}, ...
 'burst_mode',     0, ...
 'HF_fil',         'specify',  ...
 'HF_cut',         [125 125 125 125 125 125 125 125 125 125 125 125 125 125 125 125 125 125 125 125 ...
                    125 125 125 125 125 125 125 125 125 125 125 125 125 125 125 125 125 125 125 125 ...
                    125 125 125 125 125 125 125 125 125 125 125 125 125 125 125 125 125 125 125 125], ...
 'LF_fil',         'Gaussian', ...
 'LF_cut',         [4], ...
 'int_corr',       'none', ... 
 'now_later',      1, ...
 'stop_writing',   0, ...
 'trial_fcon',     0, ...
 'RT',             2.6, ...
 'replicated',     0, ...
 'same_time_param',0, ...
 'nsess',          60, ...
 'nscans',         [200 200 200 200 200 200 200 200 200 200 200 200 200 200 200 200 200 200 200 200 ...
                    200 200 200 200 200 200 200 200 200 200 200 200 200 200 200 200 200 200 200 200 ...
                    200 200 200 200 200 200 200 200 200 200 200 200 200 200 200 200 200 200 200 200], ...
 'files',          {{F1	F2	F3	F4	F5	F6	F7	F8	F9	F10	F11	F12	F13	F14	F15	...
                    F16	F17	F18	F19	F20	F21	F22	F23	F24	F25	F26	F27	F28	F29	F30	...
                    F31	F32	F33	F34	F35	F36	F37	F38	F39	F40	F41	F42	F43	F44	F45	...
                    F46	F47	F48	F49	F50	F51	F52	F53	F54	F55	F56	F57	F58	F59	F60}}, ...
 'conditions_nb',  [4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 ...
                    4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 ...
                    4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4 4], ...     
 'conditions',     [1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	...
                   16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	...
                   31	32	33	34	35	36	37	38	39	40	41	42	43	44	45	...
                   46	47	48	49	50	51	52	53	54	55	56	57	58	59	60], ...
 'regressors_nb',  [6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 ...
                    6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 ...
                    6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6 6], ...
 'regressors',     [1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	...
                   16	17	18	19	20	21	22	23	24	25	26	27	28	29	30	...
                   31	32	33	34	35	36	37	38	39	40	41	42	43	44	45	...
                   46	47	48	49	50	51	52	53	54	55	56	57	58	59	60], ...
 'parametrics_type', {{'none','none','none','none','none','none','none','none','none','none','none','none','none','none','none','none','none','none','none','none', ...
                       'none','none','none','none','none','none','none','none','none','none','none','none','none','none','none','none','none','none','none','none', ...
                       'none','none','none','none','none','none','none','none','none','none','none','none','none','none','none','none','none','none','none','none'}}, ...
 'parametrics',    [], ...
 'stochastics_flag',[0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 ...
                     0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 ...
                     0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0], ...
 'stochastics',    []);

NScanPerBlock=4.61538461538;
OnsetMat=zeros(4,4,10);
for SubInd=1:NSub
    ActSubInd=SubIndVec(SubInd)
    if ActSubInd<10
        ActSubIndStr=['00',int2str(ActSubInd)];    
    elseif ActSubInd>=10
        ActSubIndStr=['0',int2str(ActSubInd)];
    end
    for i=1:4
        if i==1
            SessStr='__0';
        elseif i==2
            SessStr='_11';
        elseif i==3
            SessStr='_33';
        elseif i==4
            SessStr='100';
        end
        for j=1:4
            if j==1
                ConStr='neutpos';
            elseif j==2
                ConStr='neutneg';
            elseif j==3
                ConStr='positive';
            elseif j==4
                ConStr='negative';
            end
            File=['G:\JungSchupp\0030JS\0030logfiles\onsets\onsets_',ConStr,'_',ActSubIndStr,'backmask',SessStr,'.txt']
            OnsetMat(i,j,:)=ReadTxtMat(File,[1 10]);
        end
    end
    
    NeutPos1=squeeze(OnsetMat(1,1,:));
    NeutNeg1=squeeze(OnsetMat(1,2,:));
    Pos1=squeeze(OnsetMat(1,3,:));
    Neg1=squeeze(OnsetMat(1,4,:));
    
    NeutPos2=squeeze(OnsetMat(2,1,:));
    NeutNeg2=squeeze(OnsetMat(2,2,:));
    Pos2=squeeze(OnsetMat(2,3,:));
    Neg2=squeeze(OnsetMat(2,4,:));
    
    NeutPos3=squeeze(OnsetMat(3,1,:));
    NeutNeg3=squeeze(OnsetMat(3,2,:));
    Pos3=squeeze(OnsetMat(3,3,:));
    Neg3=squeeze(OnsetMat(3,4,:));
    
    NeutPos4=squeeze(OnsetMat(4,1,:));
    NeutNeg4=squeeze(OnsetMat(4,2,:));
    Pos4=squeeze(OnsetMat(4,3,:));
    Neg4=squeeze(OnsetMat(4,4,:));
    
    %-------------------------------------------
    
    conditions((SubInd-1).*4 + 1) = struct( ...
        'names',   {{'NeutPos1','NeutNeg1','Positiv1','Negativ1'}}, ...
        'onsets',{{NeutPos1,NeutNeg1,Pos1,Neg1,}}, ...   
        'types',    {{'epochs','epochs','epochs','epochs'}}, ...  
        'bf_ep',   [1 1 1 1], ...                                       
        'volterra',  0, ...
        'variable_dur',0);
    
    conditions((SubInd-1).*4 + 2) = struct( ...
        'names',   {{'NeutPos2','NeutNeg2','Positiv2','Negativ2'}}, ...
        'onsets',{{NeutPos2,NeutNeg2,Pos2,Neg2,}}, ...   
        'types',    {{'epochs','epochs','epochs','epochs'}}, ...  
        'bf_ep',   [1 1 1 1], ...                                       
        'volterra',  0, ...
        'variable_dur',0);
    
    conditions((SubInd-1).*4 + 3) = struct( ...
        'names',   {{'NeutPos3','NeutNeg3','Positiv3','Negativ3'}}, ...
        'onsets',{{NeutPos3,NeutNeg3,Pos3,Neg3,}}, ...   
        'types',    {{'epochs','epochs','epochs','epochs'}}, ...  
        'bf_ep',   [1 1 1 1], ...                                       
        'volterra',  0, ...
        'variable_dur',0);
    
    conditions((SubInd-1).*4 + 4) = struct( ...
        'names',   {{'NeutPos4','NeutNeg4','Positiv4','Negativ4'}}, ...
        'onsets',{{NeutPos4,NeutNeg4,Pos4,Neg4,}}, ...   
        'types',    {{'epochs','epochs','epochs','epochs'}}, ...  
        'bf_ep',   [1 1 1 1], ... % Index fr Basisfunktion-Definition --> siehe unten bf_ep(1)/bf_ep(2)/usw.                                      
        'volterra',  0, ...
        'variable_dur',0);
    
    %-------------------------------------------
    
    bf_ep(1) = struct( ...
        'ep_type',4, ...
        'length',NScanPerBlock, ...
        'conv',  1, ...  
        'deriv', 0);
    
    eval(['R=R',int2str((SubInd-1).*NSess+1)])
    regressors((SubInd-1).*4 + 1) = struct( ...
        'names', {{'x0','y0','z0','Pitch0','Roll0','Yaw0'}}, ...
        'values',R);
    
    eval(['R=R',int2str((SubInd-1).*NSess+2)])
    regressors((SubInd-1).*4 + 2) = struct( ...
        'names', {{'x11','y11','z11','Pitch11','Roll11','Yaw11'}}, ...
        'values',R);
    
    eval(['R=R',int2str((SubInd-1).*NSess+3)])
    regressors((SubInd-1).*4 + 3) = struct( ...
        'names', {{'x33','y33','z33','Pitch33','Roll33','Yaw33'}}, ...
        'values',R);
    
    eval(['R=R',int2str((SubInd-1).*NSess+4)])
    regressors((SubInd-1).*4 + 4) = struct( ...
        'names', {{'x100','y100','z100','Pitch100','Roll100','Yaw100'}}, ...
        'values',R);
    
end

NZeros=zeros(1,NSub.*NSess)


%-------------------------------------------

%-----------Arousal Complex-----------------

%-------------------------------------------


Tmp1          =[-1 -1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CAro_g_0 =[Tmp2 NZeros];

Tmp1          =[0 0 0 0 0 0 0 0 0 0 -1 -1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CAro_g_11=[Tmp2 NZeros];

Tmp1          =[0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 -1 -1 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CAro_g_33  =[Tmp2 NZeros];

Tmp1          =[0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 -1 -1 1 1 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CAro_g_100 =[Tmp2 NZeros];

Tmp1          =[-1 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CAro_pos_0 =[Tmp2 NZeros];

Tmp1          =[0 0 0 0 0 0 0 0 0 0 -1 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CAro_pos_11 =[Tmp2 NZeros];

Tmp1          =[0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 -1 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CAro_pos_33=[Tmp2 NZeros];

Tmp1          =[0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 -1 0 1 0 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CAro_pos_100 =[Tmp2 NZeros];

Tmp1          =[0 -1 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CAro_neg_0 =[Tmp2 NZeros];

Tmp1          =[0 0 0 0 0 0 0 0 0 0 0 -1 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CAro_neg_11 =[Tmp2 NZeros];

Tmp1          =[0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 -1 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CAro_neg_33 =[Tmp2 NZeros];

Tmp1          =[0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 -1 0 1 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CAro_neg_100 =[Tmp2 NZeros];




%-------------------------------------------

%-----------Valence Complex-----------------

%-------------------------------------------


Tmp1          =[0 0 1 -1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CPosGTNeg_0 =[Tmp2 NZeros];

Tmp1          =[0 0 0 0 0 0 0 0 0 0 0 0 1 -1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CPosGTNeg_11 =[Tmp2 NZeros];

Tmp1          =[0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 -1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CPosGTNeg_33 =[Tmp2 NZeros];

Tmp1          =[0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 -1 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CPosGTNeg_100 =[Tmp2 NZeros];

Tmp1          =[0 0 -1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CPosLTNeg_0 =[Tmp2 NZeros];

Tmp1          =[0 0 0 0 0 0 0 0 0 0 0 0 -1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CPosLTNeg_11 =[Tmp2 NZeros];

Tmp1          =[0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 -1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CPosLTNeg_33 =[Tmp2 NZeros];

Tmp1          =[0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 -1 1 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CPosLTNeg_100 =[Tmp2 NZeros];


%-------------------------------------------

%-----------Neutral Complex-----------------

%-------------------------------------------


Tmp1          =[1 -1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CNeutPosGTNeutNeg_0 =[Tmp2 NZeros];

Tmp1          =[0 0 0 0 0 0 0 0 0 0 1 -1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0]; 
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CNeutPosGTNeutNeg_11 =[Tmp2 NZeros];

Tmp1          =[0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 -1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0]; 
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CNeutPosGTNeutNeg_33 =[Tmp2 NZeros];

Tmp1          =[0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 -1 0 0 0 0 0 0 0 0]; 
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CNeutPosGTNeutNeg_100 =[Tmp2 NZeros];

Tmp1          =[-1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CNeutPosLTNeutNeg_0 =[Tmp2 NZeros];

Tmp1          =[0 0 0 0 0 0 0 0 0 0 -1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CNeutPosLTNeutNeg_11 =[Tmp2 NZeros];

Tmp1          =[0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 -1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CNeutPosLTNeutNeg_33 =[Tmp2 NZeros];

Tmp1          =[0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 -1 1 0 0 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CNeutPosLTNeutNeg_100 =[Tmp2 NZeros];



%-------------------------------------------

%-------------All---------------------------

%-------------------------------------------


Tmp1          =[-1 -1 1 1 0 0 0 0 0 0 -1 -1 1 1 0 0 0 0 0 0 -1 -1 1 1 0 0 0 0 0 0 -1 -1 1 1 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CAro_g_All =[Tmp2 NZeros];

Tmp1          =[-1 0 1 0 0 0 0 0 0 0 -1 0 1 0 0 0 0 0 0 0 -1 0 1 0 0 0 0 0 0 0 -1 0 1 0 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CAro_Pos_All =[Tmp2 NZeros];

Tmp1          =[0 -1 0 1 0 0 0 0 0 0 0 -1 0 1 0 0 0 0 0 0 0 -1 0 1 0 0 0 0 0 0 0 -1 0 1 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CAro_Neg_All =[Tmp2 NZeros];

Tmp1          =[1 -1 0 0 0 0 0 0 0 0 1 -1 0 0 0 0 0 0 0 0 1 -1 0 0 0 0 0 0 0 0 1 -1 0 0 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CNeutPosGTNeutNeg_All =[Tmp2 NZeros];

Tmp1          =[-1 1 0 0 0 0 0 0 0 0 -1 1 0 0 0 0 0 0 0 0 -1 1 0 0 0 0 0 0 0 0 -1 1 0 0 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CNeutPosLTNeutNeg_All =[Tmp2 NZeros];

Tmp1          =[0 0 1 -1 0 0 0 0 0 0 0 0 1 -1 0 0 0 0 0 0 0 0 1 -1 0 0 0 0 0 0 0 0 1 -1 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CPosGTNeg_All =[Tmp2 NZeros];

Tmp1          =[0 0 -1 1 0 0 0 0 0 0 0 0 -1 1 0 0 0 0 0 0 0 0 -1 1 0 0 0 0 0 0 0 0 -1 1 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CPosLTNeg_All =[Tmp2 NZeros];



%------------------------------------------------

%-------------Increase---------------------------

%------------------------------------------------


Tmp1          =[0 0 1 1 0 0 0 0 0 0 0 0 2 2 0 0 0 0 0 0 0 0 3 3 0 0 0 0 0 0 0 0 4 4 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CIncrease_lin_Aro_g_1 =[Tmp2 NZeros];

Tmp1          =[0 0 -1.5 -1.5 0 0 0 0 0 0 0 0 -0.5 -0.5 0 0 0 0 0 0 0 0 0.5 0.5 0 0 0 0 0 0 0 0 1.5 1.5 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CIncrease_lin_Aro_g_2 =[Tmp2 NZeros];

Tmp1          =[0 0 1 0 0 0 0 0 0 0 0 0 2 0 0 0 0 0 0 0 0 0 3 0 0 0 0 0 0 0 0 0 4 0 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CIncrease_lin_Aro_pos =[Tmp2 NZeros];

Tmp1          =[0 0 0 1 0 0 0 0 0 0 0 0 0 2 0 0 0 0 0 0 0 0 0 3 0 0 0 0 0 0 0 0 0 4 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CIncrease_lin_Aro_neg =[Tmp2 NZeros];

Tmp1          =[1 1 0 0 0 0 0 0 0 0 2 2 0 0 0 0 0 0 0 0 3 3 0 0 0 0 0 0 0 0 4 4 0 0 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CIncrease_lin_Neut_g =[Tmp2 NZeros];

Tmp1          =[1 0 0 0 0 0 0 0 0 0 2 0 0 0 0 0 0 0 0 0 3 0 0 0 0 0 0 0 0 0 4 0 0 0 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CIncrease_lin_NeutPos =[Tmp2 NZeros];

Tmp1          =[0 1 0 0 0 0 0 0 0 0 0 2 0 0 0 0 0 0 0 0 0 3 0 0 0 0 0 0 0 0 0 4 0 0 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CIncrease_lin_NeutNeg =[Tmp2 NZeros];

Tmp1	      =[0 0 1 1 0 0 0 0 0 0 0 0 4 4 0 0 0 0 0 0 0 0 9 9 0 0 0 0 0 0 0 0 16 16 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CIncrease_exp_Aro_g =[Tmp2 NZeros];

Tmp1          =[0 0 1 0 0 0 0 0 0 0 0 0 4 0 0 0 0 0 0 0 0 0 9 0 0 0 0 0 0 0 0 0 16 0 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CIncrease_exp_Aro_pos =[Tmp2 NZeros];

Tmp1          =[0 0 0 1 0 0 0 0 0 0 0 0 0 4 0 0 0 0 0 0 0 0 0 9 0 0 0 0 0 0 0 0 0 16 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CIncrease_exp_Aro_neg =[Tmp2 NZeros];

Tmp1          =[1 1 0 0 0 0 0 0 0 0 4 4 0 0 0 0 0 0 0 0 9 9 0 0 0 0 0 0 0 0 16 16 0 0 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CIncrease_exp_Neut_g =[Tmp2 NZeros];

Tmp1          =[1 0 0 0 0 0 0 0 0 0 4 0 0 0 0 0 0 0 0 0 9 0 0 0 0 0 0 0 0 0 16 0 0 0 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CIncrease_exp_NeutPos =[Tmp2 NZeros];

Tmp1          =[0 1 0 0 0 0 0 0 0 0 0 4 0 0 0 0 0 0 0 0 0 9 0 0 0 0 0 0 0 0 0 16 0 0 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CIncrease_exp_NeutNeg =[Tmp2 NZeros];

Tmp1          =[0 0 1 -1 0 0 0 0 0 0 0 0 2 -2 0 0 0 0 0 0 0 0 3 -3 0 0 0 0 0 0 0 0 4 -4 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CIncrease_lin_PosGTNeg =[Tmp2 NZeros];

Tmp1          =[0 0 -1 1 0 0 0 0 0 0 0 0 -2 2 0 0 0 0 0 0 0 0 -3 3 0 0 0 0 0 0 0 0 -4 4 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CIncrease_lin_PosLTNeg =[Tmp2 NZeros];


%------------------------------------------------

%-------------Decrease---------------------------

%------------------------------------------------


Tmp1	      =[0 0 4 4 0 0 0 0 0 0 0 0 3 3 0 0 0 0 0 0 0 0 2 2 0 0 0 0 0 0 0 0 1 1 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CDecrease_lin_Aro_g =[Tmp2 NZeros];

Tmp1          =[0 0 4 0 0 0 0 0 0 0 0 0 3 0 0 0 0 0 0 0 0 0 2 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CDecrease_lin_Aro_pos =[Tmp2 NZeros];

Tmp1          =[0 0 0 4 0 0 0 0 0 0 0 0 0 3 0 0 0 0 0 0 0 0 0 2 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CDecrease_lin_Aro_neg =[Tmp2 NZeros];

Tmp1          =[4 4 0 0 0 0 0 0 0 0 3 3 0 0 0 0 0 0 0 0 2 2 0 0 0 0 0 0 0 0 1 1 0 0 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CDecrease_lin_Neut_g =[Tmp2 NZeros];

Tmp1          =[4 0 0 0 0 0 0 0 0 0 3 0 0 0 0 0 0 0 0 0 2 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CDecrease_lin_NeutPos =[Tmp2 NZeros];

Tmp1          =[0 4 0 0 0 0 0 0 0 0 0 3 0 0 0 0 0 0 0 0 0 2 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CDecrease_lin_NeutNeg =[Tmp2 NZeros];

Tmp1	      =[0 0 16 16 0 0 0 0 0 0 0 0 9 9 0 0 0 0 0 0 0 0 4 4 0 0 0 0 0 0 0 0 1 1 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CDecrease_exp_Aro_g =[Tmp2 NZeros];

Tmp1          =[0 0 16 0 0 0 0 0 0 0 0 0 9 0 0 0 0 0 0 0 0 0 4 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CDecrease_exp_Aro_pos =[Tmp2 NZeros];

Tmp1          =[0 0 0 16 0 0 0 0 0 0 0 0 0 9 0 0 0 0 0 0 0 0 0 4 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CDecrease_exp_Aro_neg =[Tmp2 NZeros];

Tmp1          =[16 16 0 0 0 0 0 0 0 0 9 9 0 0 0 0 0 0 0 0 4 4 0 0 0 0 0 0 0 0 1 1 0 0 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CDecrease_exp_Neut_g =[Tmp2 NZeros];

Tmp1          =[16 0 0 0 0 0 0 0 0 0 9 0 0 0 0 0 0 0 0 0 4 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CDecrease_exp_NeutPos =[Tmp2 NZeros];

Tmp1          =[0 16 0 0 0 0 0 0 0 0 0 9 0 0 0 0 0 0 0 0 0 4 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0];
Tmp2=[]; for i=1:NSub; Tmp2=[Tmp2,Tmp1]; end
CDecrease_exp_NeutNeg =[Tmp2 NZeros];



contrasts(1) = struct( ...
    'names',  {{...
            
        'CAro_g_0', ...
        'CAro_g_11', ...
        'CAro_g_33', ...
        'CAro_g_100', ...
        'CAro_pos_0', ...
        'CAro_pos_11', ...
        'CAro_pos_33', ...
        'CAro_pos_100',...
        'CAro_neg_0',...
        'CAro_neg_11',...
        'CAro_neg_33',...
        'CAro_neg_100',...
        'CPosGTNeg_0',...
        'CPosGTNeg_11',...
        'CPosGTNeg_33',...
        'CPosGTNeg_100',...
        'CPosLTNeg_0',...
        'CPosLTNeg_11',...
        'CPosLTNeg_33',...
        'CPosLTNeg_100',...
        'CNeutPosGTNeutNeg_0',...
        'CNeutPosGTNeutNeg_11',...
        'CNeutPosGTNeutNeg_33',...
        'CNeutPosGTNeutNeg_100',...
        'CNeutPosLTNeutNeg_0',...
        'CNeutPosLTNeutNeg_11',...
        'CNeutPosLTNeutNeg_33',...
        'CNeutPosLTNeutNeg_100',...
        'CAro_g_All',...
        'CAro_Pos_All',...
        'CAro_Neg_All',...
        'CNeutPosGTNeutNeg_All',...
        'CNeutPosLTNeutNeg_All',...
        'CPosGTNeg_All',...
        'CPosLTNeg_All',...
        'CIncrease_lin_Aro_g_1',...
        'CIncrease_lin_Aro_g_2',...
        'CIncrease_lin_Aro_pos',...
        'CIncrease_lin_Aro_neg',...
        'CIncrease_lin_Neut_g',...
        'CIncrease_lin_NeutPos',...
        'CIncrease_lin_NeutNeg',...
        'CIncrease_exp_Aro_g',...
        'CIncrease_exp_Aro_pos',...
        'CIncrease_exp_Aro_neg',...
        'CIncrease_exp_Neut_g',...
        'CIncrease_exp_NeutPos',...
        'CIncrease_exp_NeutNeg',...
        'CIncrease_lin_PosGTNeg',...
        'CIncrease_lin_PosLTNeg',...
        'CDecrease_lin_Aro_g',...
        'CDecrease_lin_Aro_pos',...
        'CDecrease_lin_Aro_neg',...
        'CDecrease_lin_Neut_g',...
        'CDecrease_lin_NeutPos',...
        'CDecrease_lin_NeutNeg',...
        'CDecrease_exp_Aro_g',...
        'CDecrease_exp_Aro_pos',...
        'CDecrease_exp_Aro_neg',...
        'CDecrease_exp_Neut_g',...
        'CDecrease_exp_NeutPos,',...
        'CDecrease_exp_NeutNeg',...
            }}, ...
  'types',   {{'T','T','T','T','T','T','T','T','T','T',...
               'T','T','T','T','T','T','T','T','T','T',...
               'T','T','T','T','T','T','T','T','T','T',...
               'T','T','T','T','T','T','T','T','T','T',...
               'T','T','T','T','T','T','T','T','T','T',...
               'T','T','T','T','T','T','T','T','T','T',...
               'T','T',...
            }}, ...
  'values',  {{...
      CAro_g_0,...
      CAro_g_11,...
      CAro_g_33,...
      CAro_g_100,...
      CAro_pos_0,...
      CAro_pos_11,...
      CAro_pos_33,...
      CAro_pos_100,...
      CAro_neg_0,...
      CAro_neg_11,...
      CAro_neg_33,...
      CAro_neg_100,...
      CPosGTNeg_0,...
      CPosGTNeg_11,...
      CPosGTNeg_33,...
      CPosGTNeg_100,...
      CPosLTNeg_0,...
      CPosLTNeg_11,...
      CPosLTNeg_33,...
      CPosLTNeg_100,...
      CNeutPosGTNeutNeg_0,...
      CNeutPosGTNeutNeg_11,...
      CNeutPosGTNeutNeg_33,...
      CNeutPosGTNeutNeg_100,...
      CNeutPosLTNeutNeg_0,...
      CNeutPosLTNeutNeg_11,...
      CNeutPosLTNeutNeg_33,...
      CNeutPosLTNeutNeg_100,...
      CAro_g_All,...
      CAro_Pos_All,...
      CAro_Neg_All,...
      CNeutPosGTNeutNeg_All,...
      CNeutPosLTNeutNeg_All,...
      CPosGTNeg_All,...
      CPosLTNeg_All,...
      CIncrease_lin_Aro_g_1,...
      CIncrease_lin_Aro_g_2,...
      CIncrease_lin_Aro_pos,...
      CIncrease_lin_Aro_neg,...
      CIncrease_lin_Neut_g,...
      CIncrease_lin_NeutPos,...
      CIncrease_lin_NeutNeg,...
      CIncrease_exp_Aro_g,...
      CIncrease_exp_Aro_pos,...
      CIncrease_exp_Aro_neg,...
      CIncrease_exp_Neut_g,...
      CIncrease_exp_NeutPos,...
      CIncrease_exp_NeutNeg,...
      CIncrease_lin_PosGTNeg,...
      CIncrease_lin_PosLTNeg,...
      CDecrease_lin_Aro_g,...
      CDecrease_lin_Aro_pos,...
      CDecrease_lin_Aro_neg,...
      CDecrease_lin_Neut_g,...
      CDecrease_lin_NeutPos,...
      CDecrease_lin_NeutNeg,...
      CDecrease_exp_Aro_g,...
      CDecrease_exp_Aro_pos,...
      CDecrease_exp_Aro_neg,...
      CDecrease_exp_Neut_g,...
      CDecrease_exp_NeutPos,...
      CDecrease_exp_NeutNeg,...
       }} ...
   );
         