%   BAT.m


%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION. 


global Base BaseStr MaskStr

%---------------------------------------------------------------
% model(1) Low-Off vs High Off
%---------------------------------------------------------------
                                                                     
SubIndVec=[94 95 96 99]
Mask=[MaskStr,'*.img']
NSub=4
NSess=2
for SubInd=1:4
    ActSubInd=SubIndVec(SubInd)
    for SessInd=1:NSess
        if SessInd==1
            FolderName=['F:\ValAroRand\',int2str(ActSubInd),'\0003\']
        else
            FolderName=['F:\ValAroRand\',int2str(ActSubInd),'\0409\']
        end
        F=spm_get('Files',FolderName,Mask);
        RFile=spm_get('Files',FolderName,['realignment*.*'])
        R=ReadTxtMat(RFile,[6 406]);
        R=R';
        if size(R)~=[406,6]
            error('size(R)~=[406,6]')
        end
        eval(['F',int2str((SubInd-1).*NSess+SessInd),'=F'])
        eval(['R',int2str((SubInd-1).*NSess+SessInd),'=R;'])
    end
end

%---------------------------------------------------------------
% batch variables defined here for analysis 'model'
%---------------------------------------------------------------

model(1) = struct( ...
 'types',          4, ...
 'global_effects', {'None'}, ...
 'burst_mode',     0, ...
 'HF_fil',         'specify',  ...
 'HF_cut',         [48 48 48 48 48 48 48 48], ...
 'LF_fil',         'Gaussian', ...
 'LF_cut',         [4], ...
 'int_corr',       'none', ... 
 'now_later',      1, ...
 'stop_writing',   0, ...
 'trial_fcon',     0, ...
 'RT',             3, ...
 'replicated',     0, ...
 'same_time_param',0, ...
 'nsess',          8, ...
 'nscans',         [406 406 406 406 406 406 406 406], ...
 'files',          {{F1 F2 F3 F4 F5 F6 F7 F8}}, ...
 'conditions_nb',  [5 5 5 5 5 5 5 5], ...     
 'conditions',     [1 1 1 1 1 1 1 1], ...
 'regressors_nb',  [6 6 6 6 6 6 6 6], ...
 'regressors',     [1 2 3 4 5 6 7 8], ...
 'parametrics_type', {{'none','none','none','none','none','none','none','none'}}, ...
 'parametrics',    [], ...
 'stochastics_flag',[0 0 0 0 0 0 0 0], ...
 'stochastics',    []);
 
NScanPerBlock=4;

NegHigh=[2 9  13 20 23 30 33 39 42 49 52 59 63 70 72 80 83 89 92 98 ]*NScanPerBlock+Base
NegLow =[4 8  12 19 22 28 34 40 43 50 53 60 65 67 74 79 82 87 95 100]*NScanPerBlock+Base
Neutral=[1 6  11 16 21 26 31 36 41 46 51 56 61 66 71 76 81 86 91 96 ]*NScanPerBlock+Base
PoRand =[5 7  14 17 25 27 35 37 44 47 55 58 64 68 75 78 85 88 94 99 ]*NScanPerBlock+Base
PosHigh=[3 10 15 18 24 29 32 38 45 48 54 57 62 69 73 77 84 90 93 97 ]*NScanPerBlock+Base
%-------------------------------------------

conditions(1) = struct( ...
 'names',   {{'NegHigh','NegLow','Neutral','PoRand','PosHigh'}}, ...
 'onsets',{{NegHigh,NegLow,Neutral,PoRand,PosHigh}}, ...   
 'types',    {{'epochs','epochs','epochs','epochs','epochs'}}, ...  %'types',    {{'events','events','events','events','events'}}, ... 
 'bf_ep',   [1 1 1 1 1], ...                                        %'bf_ev',   [1 1 1 1 1], ...
 'volterra',  0, ...
 'variable_dur',0);
%-------------------------------------------

bf_ep(1) = struct( ...
  'ep_type',4, ...
  'length',NScanPerBlock, ...
  'conv',  1, ...  
  'deriv', 0);

%bf_ev(1) = struct( ...
%  'ev_type',1, ...
%  'length',4);


regressors(1) = struct('names', {{'x','y','z','Pitch','Roll','Yaw'}},'values',R1);
regressors(2) = struct('names', {{'x','y','z','Pitch','Roll','Yaw'}},'values',R2);
regressors(3) = struct('names', {{'x','y','z','Pitch','Roll','Yaw'}},'values',R3);
regressors(4) = struct('names', {{'x','y','z','Pitch','Roll','Yaw'}},'values',R4);
regressors(5) = struct('names', {{'x','y','z','Pitch','Roll','Yaw'}},'values',R5);
regressors(6) = struct('names', {{'x','y','z','Pitch','Roll','Yaw'}},'values',R6);
regressors(7) = struct('names', {{'x','y','z','Pitch','Roll','Yaw'}},'values',R7);
regressors(8) = struct('names', {{'x','y','z','Pitch','Roll','Yaw'}},'values',R8);

NZeros=zeros(1,NSub.*NSess)
%-------------------------------------------
%-------------All---------------------------
%-------------------------------------------
%-----------Arousal All---------------------
CPosHiGTNeutAll=[0 0 -1 0 1 0 0 0 0 0 0 0 0 -1 0 1 0 0 0 0 0 0];
CNegHiGTNeutAll=[1 0 -1 0 0 0 0 0 0 0 0 1 0 -1 0 0 0 0 0 0 0 0];
CPosLoGTNeutAll=[0 0 -1 1 0 0 0 0 0 0 0 0 0 -1 1 0 0 0 0 0 0 0];
CNegLoGTNeutAll=[0 1 -1 0 0 0 0 0 0 0 0 0 1 -1 0 0 0 0 0 0 0 0];

CPosHiGTNeutAll=[CPosHiGTNeutAll CPosHiGTNeutAll CPosHiGTNeutAll CPosHiGTNeutAll NZeros]
CPosHiLTNeutAll=-CPosHiGTNeutAll;
CNegHiGTNeutAll=[CNegHiGTNeutAll CNegHiGTNeutAll CNegHiGTNeutAll CNegHiGTNeutAll NZeros]
CNegHiLTNeutAll=-CNegHiGTNeutAll;
CPosLoGTNeutAll=[CPosLoGTNeutAll CPosLoGTNeutAll CPosLoGTNeutAll CPosLoGTNeutAll NZeros]
CPosLoLTNeutAll=-CPosLoGTNeutAll;
CNegLoGTNeutAll=[CNegLoGTNeutAll CNegLoGTNeutAll CNegLoGTNeutAll CNegLoGTNeutAll NZeros]
CNegLoLTNeutAll=-CNegLoGTNeutAll;
%-----------Valence All----------------------
CPosHiGTNegHiAll=[-1 0 0 0 1 0 0 0 0 0 0 -1 0 0 0 1 0 0 0 0 0 0];
CPosLoGTNegLoAll=[0 -1 0 1 0 0 0 0 0 0 0 0 -1 0 1 0 0 0 0 0 0 0];

CPosHiGTNegHiAll=[CPosHiGTNegHiAll CPosHiGTNegHiAll CPosHiGTNegHiAll CPosHiGTNegHiAll NZeros]
CPosHiLTNegHiAll=-CPosHiGTNegHiAll;
CPosLoGTNegLoAll=[CPosLoGTNegLoAll CPosLoGTNegLoAll CPosLoGTNegLoAll CPosLoGTNegLoAll NZeros]
CPosLoLTNegLoAll=-CPosLoGTNegLoAll;
%-------------------------------------------
%-----------Arousal Complex---------------------
CAroHiGTLoAll=[3 -2 -2 -2 3 0 0 0 0 0 0 3 -2 -2 -2 3 0 0 0 0 0 0];
CAroLinHiGTLoAll=[4 -1 -6 -1 4 0 0 0 0 0 0 4 -1 -6 -1 4 0 0 0 0 0 0];
CAroExp1HiGTLoAll=[2 -1 -2 -1 2 0 0 0 0 0 0 2 -1 -2 -1 2 0 0 0 0 0 0];
CAroExp2HiGTLoAll=[7 -3 -8 -3 7 0 0 0 0 0 0 7 -3 -8 -3 7 0 0 0 0 0 0];

CAroHiGTLoAll=[CAroHiGTLoAll CAroHiGTLoAll CAroHiGTLoAll CAroHiGTLoAll NZeros]
CAroHiLTLoAll=-CAroHiGTLoAll;
CAroLinHiGTLoAll=[CAroLinHiGTLoAll CAroLinHiGTLoAll CAroLinHiGTLoAll CAroLinHiGTLoAll NZeros]
CAroLinHiLTLoAll=-CAroLinHiGTLoAll;
CAroExp1HiGTLoAll=[CAroExp1HiGTLoAll CAroExp1HiGTLoAll CAroExp1HiGTLoAll CAroExp1HiGTLoAll NZeros]
CAroExp1HiLTLoAll=-CAroExp1HiGTLoAll;
CAroExp2HiGTLoAll=[CAroExp2HiGTLoAll CAroExp2HiGTLoAll CAroExp2HiGTLoAll CAroExp2HiGTLoAll NZeros]
CAroExp2HiLTLoAll=-CAroExp2HiGTLoAll;
%-------------------------------------------

%-----------Valence Complex---------------------
CValPosGTNegAll=[-1 -1 0 1 1 0 0 0 0 0 0 -1 -1 0 1 1 0 0 0 0 0 0];
CValPosGTNegAll=[CValPosGTNegAll CValPosGTNegAll CValPosGTNegAll CValPosGTNegAll NZeros]
CValPosLTNegAll=-CValPosGTNegAll;
%-------------------------------------------
%-----------Rand--------------------------
%-------------------------------------------
%-----------Arousal Rand---------------------

CPosHiGTNeutRand=[0 0 -1 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0];
CNegHiGTNeutRand=[1 0 -1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0];
CPosLoGTNeutRand=[0 0 -1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0];
CNegLoGTNeutRand=[0 1 -1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0];

CPosHiGTNeutRand=[CPosHiGTNeutRand CPosHiGTNeutRand CPosHiGTNeutRand CPosHiGTNeutRand NZeros]
CPosHiLTNeutRand=-CPosHiGTNeutRand;
CNegHiGTNeutRand=[CNegHiGTNeutRand CNegHiGTNeutRand CNegHiGTNeutRand CNegHiGTNeutRand NZeros]
CNegHiLTNeutRand=-CNegHiGTNeutRand;
CPosLoGTNeutRand=[CPosLoGTNeutRand CPosLoGTNeutRand CPosLoGTNeutRand CPosLoGTNeutRand NZeros]
CPosLoLTNeutRand=-CPosLoGTNeutRand;
CNegLoGTNeutRand=[CNegLoGTNeutRand CNegLoGTNeutRand CNegLoGTNeutRand CNegLoGTNeutRand NZeros]
CNegLoLTNeutRand=-CNegLoGTNeutRand;

%-----------Valence Rand----------------------
CPosHiGTNegHiRand=[-1 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0];
CPosLoGTNegLoRand=[0 -1 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0];

CPosHiGTNegHiRand=[CPosHiGTNegHiRand CPosHiGTNegHiRand CPosHiGTNegHiRand CPosHiGTNegHiRand NZeros]
CPosHiLTNegHiRand=-CPosHiGTNegHiRand;
CPosLoGTNegLoRand=[CPosLoGTNegLoRand CPosLoGTNegLoRand CPosLoGTNegLoRand CPosLoGTNegLoRand NZeros]
CPosLoLTNegLoRand=-CPosLoGTNegLoRand;

%-------------------------------------------
%-----------Arousal Rand Complex---------------------
CAroHiGTLoRand=[3 -2 -2 -2 3 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0];
CAroLinHiGTLoRand=[4 -1 -6 -1 4 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0];
CAroExp1HiGTLoRand=[2 -1 -2 -1 2 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0];
CAroExp2HiGTLoRand=[7 -3 -8 -3 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0];

CAroHiGTLoRand=[CAroHiGTLoRand CAroHiGTLoRand CAroHiGTLoRand CAroHiGTLoRand NZeros]
CAroHiLTLoRand=-CAroHiGTLoRand;
CAroLinHiGTLoRand=[CAroLinHiGTLoRand CAroLinHiGTLoRand CAroLinHiGTLoRand CAroLinHiGTLoRand NZeros]
CAroLinHiLTLoRand=-CAroLinHiGTLoRand;
CAroExp1HiGTLoRand=[CAroExp1HiGTLoRand CAroExp1HiGTLoRand CAroExp1HiGTLoRand CAroExp1HiGTLoRand NZeros]
CAroExp1HiLTLoRand=-CAroExp1HiGTLoRand;
CAroExp2HiGTLoRand=[CAroExp2HiGTLoRand CAroExp2HiGTLoRand CAroExp2HiGTLoRand CAroExp2HiGTLoRand NZeros]
CAroExp2HiLTLoRand=-CAroExp2HiGTLoRand;
%-------------------------------------------

%-----------Valence Rand Complex---------------------
CValPosGTNegRand=[-1 -1 0 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0];

CValPosGTNegRand=[CValPosGTNegRand CValPosGTNegRand CValPosGTNegRand CValPosGTNegRand NZeros]
CValPosLTNegRand=-CValPosGTNegRand;
%-------------------------------------------
%-----------NoRand--------------------------
%-------------------------------------------
%-----------Arousal NoRand---------------------
CPosHiGTNeutNoRand=[0 0 0 0 0 0 0 0 0 0 0 0 0 -1 0 1 0 0 0 0 0 0];
CNegHiGTNeutNoRand=[0 0 0 0 0 0 0 0 0 0 0 1 0 -1 0 0 0 0 0 0 0 0];
CPosLoGTNeutNoRand=[0 0 0 0 0 0 0 0 0 0 0 0 0 -1 1 0 0 0 0 0 0 0];
CNegLoGTNeutNoRand=[0 0 0 0 0 0 0 0 0 0 0 0 1 -1 0 0 0 0 0 0 0 0];

CPosHiGTNeutNoRand=[CPosHiGTNeutNoRand CPosHiGTNeutNoRand CPosHiGTNeutNoRand CPosHiGTNeutNoRand NZeros]
CPosHiLTNeutNoRand=-CPosHiGTNeutNoRand;
CNegHiGTNeutNoRand=[CNegHiGTNeutNoRand CNegHiGTNeutNoRand CNegHiGTNeutNoRand CNegHiGTNeutNoRand NZeros]
CNegHiLTNeutNoRand=-CNegHiGTNeutNoRand;
CPosLoGTNeutNoRand=[CPosLoGTNeutNoRand CPosLoGTNeutNoRand CPosLoGTNeutNoRand CPosLoGTNeutNoRand NZeros]
CPosLoLTNeutNoRand=-CPosLoGTNeutNoRand;
CNegLoGTNeutNoRand=[CNegLoGTNeutNoRand CNegLoGTNeutNoRand CNegLoGTNeutNoRand CNegLoGTNeutNoRand NZeros]
CNegLoLTNeutNoRand=-CNegLoGTNeutNoRand;
%-----------Valence NoRand----------------------
CPosHiGTNegHiNoRand=[0 0 0 0 0 0 0 0 0 0 0 -1 0 0 0 1 0 0 0 0 0 0];
CPosLoGTNegLoNoRand=[0 0 0 0 0 0 0 0 0 0 0 0 -1 0 1 0 0 0 0 0 0 0];

CPosHiGTNegHiNoRand=[CPosHiGTNegHiNoRand CPosHiGTNegHiNoRand CPosHiGTNegHiNoRand CPosHiGTNegHiNoRand NZeros]
CPosHiLTNegHiNoRand=-CPosHiGTNegHiNoRand;
CPosLoGTNegLoNoRand=[CPosLoGTNegLoNoRand CPosLoGTNegLoNoRand CPosLoGTNegLoNoRand CPosLoGTNegLoNoRand NZeros]
CPosLoLTNegLoNoRand=-CPosLoGTNegLoNoRand;

%-------------------------------------------
%-----------Arousal NoRand Complex---------------------
CAroHiGTLoNoRand=[0 0 0 0 0 0 0 0 0 0 0 3 -2 -2 -2 3 0 0 0 0 0 0];
CAroLinHiGTLoNoRand=[0 0 0 0 0 0 0 0 0 0 0 4 -1 -6 -1 4 0 0 0 0 0 0];
CAroExp1HiGTLoNoRand=[0 0 0 0 0 0 0 0 0 0 0 2 -1 -2 -1 2 0 0 0 0 0 0];
CAroExp2HiGTLoNoRand=[0 0 0 0 0 0 0 0 0 0 0 7 -3 -8 -3 7 0 0 0 0 0 0];

CAroHiGTLoNoRand=[CAroHiGTLoNoRand CAroHiGTLoNoRand CAroHiGTLoNoRand CAroHiGTLoNoRand NZeros]
CAroHiLTLoNoRand=-CAroHiGTLoNoRand;
CAroLinHiGTLoNoRand=[CAroLinHiGTLoNoRand CAroLinHiGTLoNoRand CAroLinHiGTLoNoRand CAroLinHiGTLoNoRand NZeros]
CAroLinHiLTLoNoRand=-CAroLinHiGTLoNoRand;
CAroExp1HiGTLoNoRand=[CAroExp1HiGTLoNoRand CAroExp1HiGTLoNoRand CAroExp1HiGTLoNoRand CAroExp1HiGTLoNoRand NZeros]
CAroExp1HiLTLoNoRand=-CAroExp1HiGTLoNoRand;
CAroExp2HiGTLoNoRand=[CAroExp2HiGTLoNoRand CAroExp2HiGTLoNoRand CAroExp2HiGTLoNoRand CAroExp2HiGTLoNoRand NZeros]
CAroExp2HiLTLoNoRand=-CAroExp2HiGTLoNoRand;

%-------------------------------------------
%-----------Valence NoRand Complex---------------------
CValPosGTNegNoRand=[0 0 0 0 0 0 0 0 0 0 0 -1 -1 0 1 1 0 0 0 0 0 0];
CValPosGTNegNoRand=[CValPosGTNegNoRand CValPosGTNegNoRand CValPosGTNegNoRand CValPosGTNegNoRand NZeros]
CValPosLTNegNoRand=-CValPosGTNegNoRand;

%-------------------------------------------
%-----------NoRand Vs Rand--------------------
%-------------------------------------------
%-----------All NoRand Vs Rand------------
CNoRandGTRandAll=[-1 -1 -1 -1 -1 0 0 0 0 0 0 1 1 1 1 1 0 0 0 0 0 0];
CNoRandGTRandNegHiAll=[-1 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0];
CNoRandGTRandNegLoAll=[0 -1 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0];
CNoRandGTRandNeutAll=[0 0 -1 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0];
CNoRandGTRandPosLoAll=[0 0 0 -1 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0];
CNoRandGTRandPosHiAll=[0 0 0 0 -1 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0];

CNoRandGTRandAll=[CNoRandGTRandAll CNoRandGTRandAll CNoRandGTRandAll CNoRandGTRandAll NZeros]
CNoRandLTRandAll=-CNoRandGTRandAll;
CNoRandGTRandNegHiAll=[CNoRandGTRandNegHiAll CNoRandGTRandNegHiAll CNoRandGTRandNegHiAll CNoRandGTRandNegHiAll NZeros]
CNoRandLTRandNegHiAll=-CNoRandGTRandNegHiAll;
CNoRandGTRandNegLoAll=[CNoRandGTRandNegLoAll CNoRandGTRandNegLoAll CNoRandGTRandNegLoAll CNoRandGTRandNegLoAll NZeros]
CNoRandLTRandNegLoAll=-CNoRandGTRandNegLoAll;
CNoRandGTRandNeutAll=[CNoRandGTRandNeutAll CNoRandGTRandNeutAll CNoRandGTRandNeutAll CNoRandGTRandNeutAll NZeros]
CNoRandLTRandNeutAll=-CNoRandGTRandNeutAll;
CNoRandGTRandPosLoAll=[CNoRandGTRandPosLoAll CNoRandGTRandPosLoAll CNoRandGTRandPosLoAll CNoRandGTRandPosLoAll NZeros]
CNoRandLTRandPosLoAll=-CNoRandGTRandPosLoAll;
CNoRandGTRandPosHiAll=[CNoRandGTRandPosHiAll CNoRandGTRandPosHiAll CNoRandGTRandPosHiAll CNoRandGTRandPosHiAll NZeros]
CNoRandLTRandPosHiAll=-CNoRandGTRandPosHiAll;

%-------------------------------------------
%-----------Arousal NoRand Vs Rand------------
CNoRandGTRandHiAroAll=[-1 0 0 0 -1 0 0 0 0 0 0 1 0 0 0 1 0 0 0 0 0 0];
CNoRandGTRandLoAroAll=[0 -1 0 -1 0 0 0 0 0 0 0 0 1 0 1 0 0 0 0 0 0 0];

CNoRandGTRandHiAroAll=[CNoRandGTRandHiAroAll CNoRandGTRandHiAroAll CNoRandGTRandHiAroAll CNoRandGTRandHiAroAll NZeros]
CNoRandLTRandHiAroAll=-CNoRandGTRandHiAroAll;
CNoRandGTRandLoAroAll=[CNoRandGTRandLoAroAll CNoRandGTRandLoAroAll CNoRandGTRandLoAroAll CNoRandGTRandLoAroAll NZeros]
CNoRandLTRandLoAroAll=-CNoRandGTRandLoAroAll;

%-------------------------------------------
%-----------Valence NoRand Vs Rand------------
CNoRandGTRandNegValAll=[-1 -1 0 0 0 0 0 0 0 0 0 1 1 0 0 0 0 0 0 0 0 0];
CNoRandGTRandPosValAll=[0 0 0 -1 -1 0 0 0 0 0 0 0 0 0 1 1 0 0 0 0 0 0];

CNoRandGTRandNegValAll=[CNoRandGTRandNegValAll CNoRandGTRandNegValAll CNoRandGTRandNegValAll CNoRandGTRandNegValAll NZeros]
CNoRandLTRandNegValAll=-CNoRandGTRandNegValAll;
CNoRandGTRandPosValAll=[CNoRandGTRandPosValAll CNoRandGTRandPosValAll CNoRandGTRandPosValAll CNoRandGTRandPosValAll NZeros]
CNoRandLTRandPosValAll=-CNoRandGTRandPosValAll;


%PosHiPosLo
CPosHiGTPosLoAll=[0 0 0 -1 1 0 0 0 0 0 0 0 0 0 -1 1 0 0 0 0 0 0];
CPosHiGTPosLoAll=[CPosHiGTPosLoAll CPosHiGTPosLoAll CPosHiGTPosLoAll CPosHiGTPosLoAll NZeros]
CPosHiLTPosLoAll=-CPosHiGTPosLoAll;

CPosHiGTPosLoRand=[0 0 0 -1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0];
CPosHiGTPosLoRand=[CPosHiGTPosLoRand CPosHiGTPosLoRand CPosHiGTPosLoRand CPosHiGTPosLoRand NZeros]
CPosHiLTPosLoRand=-CPosHiGTPosLoRand;

CPosHiGTPosLoNoRand=[0 0 0 0 0 0 0 0 0 0 0 0 0 0 -1 1 0 0 0 0 0 0];
CPosHiGTPosLoNoRand=[CPosHiGTPosLoNoRand CPosHiGTPosLoNoRand CPosHiGTPosLoNoRand CPosHiGTPosLoNoRand NZeros]
CPosHiLTPosLoNoRand=-CPosHiGTPosLoNoRand;

%NegHiNegLo
CNegHiGTNegLoAll=[1 -1 0 0 0 0 0 0 0 0 0 1 -1 0 0 0 0 0 0 0 0 0];
CNegHiGTNegLoAll=[CNegHiGTNegLoAll CNegHiGTNegLoAll CNegHiGTNegLoAll CNegHiGTNegLoAll NZeros]
CNegHiLTNegLoAll=-CNegHiGTNegLoAll;

CNegHiGTNegLoRand=[1 -1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0];
CNegHiGTNegLoRand=[CNegHiGTNegLoRand CNegHiGTNegLoRand CNegHiGTNegLoRand CNegHiGTNegLoRand NZeros]
CNegHiLTNegLoRand=-CNegHiGTNegLoRand;

CNegHiGTNegLoNoRand=[0 0 0 0 0 0 0 0 0 0 0 1 -1 0 0 0 0 0 0 0 0 0];
CNegHiGTNegLoNoRand=[CNegHiGTNegLoNoRand CNegHiGTNegLoNoRand CNegHiGTNegLoNoRand CNegHiGTNegLoNoRand NZeros]
CNegHiLTNegLoNoRand=-CNegHiGTNegLoNoRand;

%PosHiNegLo
CPosHiGTNegLoAll=[0 -1 0 0 1 0 0 0 0 0 0 0 -1 0 0 1 0 0 0 0 0 0];
CPosHiGTNegLoAll=[CPosHiGTNegLoAll CPosHiGTNegLoAll CPosHiGTNegLoAll CPosHiGTNegLoAll NZeros]
CPosHiLTNegLoAll=-CPosHiGTNegLoAll;

CPosHiGTNegLoRand=[0 -1 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0];
CPosHiGTNegLoRand=[CPosHiGTNegLoRand CPosHiGTNegLoRand CPosHiGTNegLoRand CPosHiGTNegLoRand NZeros]
CPosHiLTNegLoRand=-CPosHiGTNegLoRand;

CPosHiGTNegLoNoRand=[0 0 0 0 0 0 0 0 0 0 0 0 -1 0 0 1 0 0 0 0 0 0];
CPosHiGTNegLoNoRand=[CPosHiGTNegLoNoRand CPosHiGTNegLoNoRand CPosHiGTNegLoNoRand CPosHiGTNegLoNoRand NZeros]
CPosHiLTNegLoNoRand=-CPosHiGTNegLoNoRand;

%NegHiPosLo
CNegHiGTPosLoAll=[1 0 0 -1 0 0 0 0 0 0 0 1 0 0 -1 0 0 0 0 0 0 0];
CNegHiGTPosLoAll=[CNegHiGTPosLoAll CNegHiGTPosLoAll CNegHiGTPosLoAll CNegHiGTPosLoAll NZeros]
CNegHiLTPosLoAll=-CNegHiGTPosLoAll;

CNegHiGTPosLoRand=[1 0 0 -1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0];
CNegHiGTPosLoRand=[CNegHiGTPosLoRand CNegHiGTPosLoRand CNegHiGTPosLoRand CNegHiGTPosLoRand NZeros]
CNegHiLTPosLoRand=-CNegHiGTPosLoRand;

CNegHiGTPosLoNoRand=[0 0 0 0 0 0 0 0 0 0 0 1 0 0 -1 0 0 0 0 0 0 0];
CNegHiGTPosLoNoRand=[CNegHiGTPosLoNoRand CNegHiGTPosLoNoRand CNegHiGTPosLoNoRand CNegHiGTPosLoNoRand NZeros]
CNegHiLTPosLoNoRand=-CNegHiGTPosLoNoRand;

contrasts(1) = struct( ...
  'names',  {{...
            'CPosHiGTNeutAll','CPosHiLTNeutAll','CNegHiGTNeutAll','CNegHiLTNeutAll','CPosLoGTNeutAll',...
            'CPosLoLTNeutAll','CNegLoGTNeutAll','CNegLoLTNeutAll','CPosHiGTNegHiAll','CPosHiLTNegHiAll',...                 %10
            'CPosLoGTNegLoAll','CPosLoLTNegLoAll','CAroHiGTLoAll','CAroHiLTLoAll','CAroLinHiGTLoAll',...
            'CAroLinHiLTLoAll','CAroExp1HiGTLoAll','CAroExp1HiLTLoAll','CAroExp2HiGTLoAll','CAroExp2HiLTLoAll',...           %20
            'CValPosGTNegAll','CValPosLTNegAll','CPosHiGTNeutRand','CPosHiLTNeutRand','CNegHiGTNeutRand',...
            'CNegHiLTNeutRand','CPosLoGTNeutRand','CPosLoLTNeutRand','CNegLoGTNeutRand','CNegLoLTNeutRand',...               %30
            'CPosHiGTNegHiRand','CPosHiLTNegHiRand','CPosLoGTNegLoRand','CPosLoLTNegLoRand','CAroHiGTLoRand',...
            'CAroHiLTLoRand','CAroLinHiGTLoRand','CAroLinHiLTLoRand','CAroExp1HiGTLoRand','CAroExp1HiLTLoRand',...           %40
            'CAroExp2HiGTLoRand','CAroExp2HiLTLoRand','CValPosGTNegRand','CValPosLTNegRand','CPosHiGTNeutNoRand',...
            'CPosHiLTNeutNoRand','CNegHiGTNeutNoRand','CNegHiLTNeutNoRand','CPosLoGTNeutNoRand','CPosLoLTNeutNoRand',...               %50
            'CNegLoGTNeutNoRand','CNegLoLTNeutNoRand','CPosHiGTNegHiNoRand','CPosHiLTNegHiNoRand','CPosLoGTNegLoNoRand',...             
            'CPosLoLTNegLoNoRand','CAroHiGTLoNoRand','CAroHiLTLoNoRand','CAroLinHiGTLoNoRand','CAroLinHiLTLoNoRand',...                 %60
            'CAroExp1HiGTLoNoRand','CAroExp1HiLTLoNoRand','CAroExp2HiGTLoNoRand','CAroExp2HiLTLoNoRand','CValPosGTNegNoRand',...
            'CValPosLTNegNoRand','CNoRandGTRand','CNoRandLTRand','CNoRandGTRandNegHi','CNoRandLTRandNegHi',...               %70
            'CNoRandGTRandNegLo','CNoRandLTRandNegLo','CNoRandGTRandNeut','CNoRandLTRandNeut','CNoRandGTRandPosLo',...
            'CNoRandLTRandPosLo','CNoRandGTRandPosHi','CNoRandLTRandPosHi','CNoRandGTRandHiAro','CNoRandLTRandHiAro',...   %80
            'CNoRandGTRandLoAro','CNoRandLTRandLoAro','CNoRandGTRandNegVal','CNoRandLTRandNegVal','CNoRandGTRandPosVal',...
            'CNoRandLTRandPosVal',...
            'CPosHiLTPosLoAll','CPosHiGTPosLoAll','CPosHiLTPosLoRand','CPosHiGTPosLoRand', ...
            'CPosHiLTPosLoNoRand','CPosHiGTPosLoNoRand','CNegHiLTNegLoAll','CNegHiGTNegLoAll', ...
            'CNegHiLTNegLoRand','CNegHiGTNegLoRand','CNegHiLTNegLoNoRand','CNegHiGTNegLoNoRand', ...
            'CPosHiLTNegLoAll','CPosHiGTNegLoAll','CPosHiLTNegLoRand','CPosHiGTNegLoRand', ...
            'CPosHiLTNegLoNoRand','CPosHiGTNegLoNoRand','CNegHiLTPosLoAll','CNegHiGTPosLoAll', ...
            'CNegHiLTPosLoRand','CNegHiGTPosLoRand','CNegHiLTPosLoNoRand','CNegHiGTPosLoNoRand', ...
            }}, ...
  'types',   {{'T','T','T','T','T','T','T','T','T','T','T','T','T','T','T','T','T','T','T','T',...
               'T','T','T','T','T','T','T','T','T','T','T','T','T','T','T','T','T','T','T','T',...
               'T','T','T','T','T','T','T','T','T','T','T','T','T','T','T','T','T','T','T','T',...
               'T','T','T','T','T','T','T','T','T','T','T','T','T','T','T','T','T','T','T','T',...
               'T','T','T','T','T','T',...
               'T','T','T','T',...
               'T','T','T','T',...
               'T','T','T','T',...
               'T','T','T','T',...
               'T','T','T','T',...
               'T','T','T','T',...
            }}, ...
  'values',  {{...
            CPosHiGTNeutAll,CPosHiLTNeutAll,CNegHiGTNeutAll,CNegHiLTNeutAll,CPosLoGTNeutAll,...
            CPosLoLTNeutAll,CNegLoGTNeutAll,CNegLoLTNeutAll,CPosHiGTNegHiAll,CPosHiLTNegHiAll,...                                   %10
            CPosLoGTNegLoAll,CPosLoLTNegLoAll,CAroHiGTLoAll,CAroHiLTLoAll,CAroLinHiGTLoAll,...
            CAroLinHiLTLoAll,CAroExp1HiGTLoAll,CAroExp1HiLTLoAll,CAroExp2HiGTLoAll,CAroExp2HiLTLoAll,...                            %20
            CValPosGTNegAll,CValPosLTNegAll,CPosHiGTNeutRand,CPosHiLTNeutRand,CNegHiGTNeutRand,...
            CNegHiLTNeutRand,CPosLoGTNeutRand,CPosLoLTNeutRand,CNegLoGTNeutRand,CNegLoLTNeutRand,...                                %30
            CPosHiGTNegHiRand,CPosHiLTNegHiRand,CPosLoGTNegLoRand,CPosLoLTNegLoRand,CAroHiGTLoRand,...
            CAroHiLTLoRand,CAroLinHiGTLoRand,CAroLinHiLTLoRand,CAroExp1HiGTLoRand,CAroExp1HiLTLoRand,...                            %40
            CAroExp2HiGTLoRand,CAroExp2HiLTLoRand,CValPosGTNegRand,CValPosLTNegRand,CPosHiGTNeutNoRand,...
            CPosHiLTNeutNoRand,CNegHiGTNeutNoRand,CNegHiLTNeutNoRand,CPosLoGTNeutNoRand,CPosLoLTNeutNoRand,...                                %50
            CNegLoGTNeutNoRand,CNegLoLTNeutNoRand,CPosHiGTNegHiNoRand,CPosHiLTNegHiNoRand,CPosLoGTNegLoNoRand,...
            CPosLoLTNegLoNoRand,CAroHiGTLoNoRand,CAroHiLTLoNoRand,CAroLinHiGTLoNoRand,CAroLinHiLTLoNoRand,...                                 %60
            CAroExp1HiGTLoNoRand,CAroExp1HiLTLoNoRand,CAroExp2HiGTLoNoRand,CAroExp2HiLTLoNoRand,CValPosGTNegNoRand,...
            CValPosLTNegNoRand,CNoRandGTRandAll,CNoRandLTRandAll,CNoRandGTRandNegHiAll,CNoRandLTRandNegHiAll,...                              %70
            CNoRandGTRandNegLoAll,CNoRandLTRandNegLoAll,CNoRandGTRandNeutAll,CNoRandLTRandNeutAll,CNoRandGTRandPosLoAll,...
            CNoRandLTRandPosLoAll,CNoRandGTRandPosHiAll,CNoRandLTRandPosHiAll,CNoRandGTRandHiAroAll,CNoRandLTRandHiAroAll,...                 %80
            CNoRandGTRandLoAroAll,CNoRandLTRandLoAroAll,CNoRandGTRandNegValAll,CNoRandLTRandNegValAll,CNoRandGTRandPosValAll,...
            CNoRandLTRandPosValAll, ...
            CPosHiLTPosLoAll,CPosHiGTPosLoAll,CPosHiLTPosLoRand,CPosHiGTPosLoRand, ...
            CPosHiLTPosLoNoRand,CPosHiGTPosLoNoRand,CNegHiLTNegLoAll,CNegHiGTNegLoAll, ...
            CNegHiLTNegLoRand,CNegHiGTNegLoRand,CNegHiLTNegLoNoRand,CNegHiGTNegLoNoRand, ...
            CPosHiLTNegLoAll,CPosHiGTNegLoAll,CPosHiLTNegLoRand,CPosHiGTNegLoRand, ...
            CPosHiLTNegLoNoRand,CPosHiGTNegLoNoRand,CNegHiLTPosLoAll,CNegHiGTPosLoAll, ...
            CNegHiLTPosLoRand,CNegHiGTPosLoRand,CNegHiLTPosLoNoRand,CNegHiGTPosLoNoRand, ...
             }} ...
);