%   BAT.m


%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.


global SubInd SubIndStr Base BaseStr MaskStr

%---------------------------------------------------------------
% model(1) Low-Off vs High Off
%---------------------------------------------------------------
                                                                      
clear F1 F2 
Mask=[MaskStr,'*.img']
FolderName=['D:\ValAro\',SubIndStr,'\s08_09\']
F1=spm_get('Files',FolderName,Mask);
ValAro09RealignFile=spm_get('Files',FolderName,['realignment*.*'])
ValAro09RealignMat=ReadTxtMat(ValAro09RealignFile,[6 406]);
ValAro09RealignMat=ValAro09RealignMat';
if size(ValAro09RealignMat)~=[406,6]
   error('size(ValAro09RealignMat)~=[406,6]')
end
FolderName=['D:\ValAro\',SubIndStr,'\s08_36\'];
F2=spm_get('Files',FolderName,Mask);
ValAro36RealignFile=spm_get('Files',FolderName,['realignment*.*'])
ValAro36RealignMat=ReadTxtMat(ValAro36RealignFile,[6 406]);
ValAro36RealignMat=ValAro36RealignMat';
if size(ValAro36RealignMat)~=[406,6]
   error('size(ValAro36RealignMat)~=[406,6]')
end
F1
F2
if SubInd==21 | SubInd==23 | SubInd==24  
   F1Tmp=F2;
   F2=F1;
   F1=F1Tmp;
   ValAro36RealignMatTmp=ValAro36RealignMat;
   ValAro09RealignMat=ValAro36RealignMat;
   ValAro36RealignMat=ValAro36RealignMatTmp;
   clear F1Tmp ValAro36RealignMatTmp
   F1
   F2
end

%---------------------------------------------------------------
% batch variables defined here for analysis 'model'
%---------------------------------------------------------------

model(1) = struct( ...
 'types',          4, ...
 'global_effects', {'None'}, ...
 'burst_mode',     0, ...
 'HF_fil',         'specify',  ...
 'HF_cut',         [192 192], ...
 'LF_fil',         'Gaussian', ...
 'LF_cut',         [4], ...
 'int_corr',       'none', ... 
 'now_later',      1, ...
 'stop_writing',   0, ...
 'trial_fcon',     0, ...
 'RT',             3, ...
 'replicated',     0, ...
 'same_time_param',0, ...
 'nsess',          2, ...
 'nscans',         [406 406], ...
 'files',          {{F1 F2}}, ...
 'conditions_nb',  [5 5], ...     
 'conditions',     [1 1], ...
 'regressors_nb',  [6 6], ...
 'regressors',     [1 2], ...
 'parametrics_type',{{'none','none'}}, ...
 'parametrics',    [], ...
 'stochastics_flag',[0 0], ...
 'stochastics',    []);
 
NScanPerBlock=4;

NegHigh=[2 9  13 20 23 30 33 39 42 49 52 59 63 70 72 80 83 89 92 98 ]*NScanPerBlock+Base
NegLow =[4 8  12 19 22 28 34 40 43 50 53 60 65 67 74 79 82 87 95 100]*NScanPerBlock+Base
Neutral=[1 6  11 16 21 26 31 36 41 46 51 56 61 66 71 76 81 86 91 96 ]*NScanPerBlock+Base
PosLow =[5 7  14 17 25 27 35 37 44 47 55 58 64 68 75 78 85 88 94 99 ]*NScanPerBlock+Base
PosHigh=[3 10 15 18 24 29 32 38 45 48 54 57 62 69 73 77 84 90 93 97 ]*NScanPerBlock+Base
durations=ones(size(NegHigh)).*NScanPerBlock;
%-------------------------------------------

conditions(1) = struct( ...
 'names',   {{'NegHigh','NegLow','Neutral','PosLow','PosHigh'}}, ...
 'onsets',{{NegHigh,NegLow,Neutral,PosLow,PosHigh}}, ...   
 'durations',{{durations,durations,durations,durations,durations}}, ...   
 'types',    {{'events','events','events','events','events'}}, ... 
 'bf_ev',   [1 1 1 1 1], ...
 'volterra',  0, ...
 'variable_dur',1);
%-------------------------------------------

bf_ev(1) = struct('ev_type',2);

regressors(1) = struct( ...
 	'names', {{'xValAro09','yValAro09','zValAro09','PitchValAro09','RollValAro09','YawValAro09'}}, ...
    'values',ValAro09RealignMat);
 
regressors(2) = struct( ...
'names', {{'xValAro36','yValAro36','zValAro36','PitchValAro36','RollValAro36','YawValAro36'}}, ...
'values',ValAro36RealignMat);



%-------------------------------------------
%-------------All---------------------------
%-----------------------------------------
%-----------Arousal All---------------------

CPosHiGTNeutAll=[0 0 -1 0 1 0 0 0 0 0 0 0 0 -1 0 1 0 0 0 0 0 0 0 0]
Tmp1=CPosHiGTNeutAll;
Tmp2=zeros(1,34);
Tmp2(1:2:10)=Tmp1(1:5);
Tmp2(17:2:26)=Tmp1(12:16);
CPosHiGTNeutAll=Tmp2;

CPosHiLTNeutAll=-CPosHiGTNeutAll

CNegHiGTNeutAll=[1 0 -1 0 0 0 0 0 0 0 0 1 0 -1 0 0 0 0 0 0 0 0 0 0]
Tmp1=CNegHiGTNeutAll;
Tmp2=zeros(1,34);
Tmp2(1:2:10)=Tmp1(1:5);
Tmp2(17:2:26)=Tmp1(12:16);
CNegHiGTNeutAll=Tmp2;

CNegHiLTNeutAll=-CNegHiGTNeutAll

CPosLoGTNeutAll=[0 0 -1 1 0 0 0 0 0 0 0 0 0 -1 1 0 0 0 0 0 0 0 0 0]
Tmp1=CPosLoGTNeutAll;
Tmp2=zeros(1,34);
Tmp2(1:2:10)=Tmp1(1:5);
Tmp2(17:2:26)=Tmp1(12:16);
CPosLoGTNeutAll=Tmp2;

CPosLoLTNeutAll=-CPosLoGTNeutAll

CNegLoGTNeutAll=[0 1 -1 0 0 0 0 0 0 0 0 0 1 -1 0 0 0 0 0 0 0 0 0 0]
Tmp1=CNegLoGTNeutAll;
Tmp2=zeros(1,34);
Tmp2(1:2:10)=Tmp1(1:5);
Tmp2(17:2:26)=Tmp1(12:16);
CNegLoGTNeutAll=Tmp2;

CNegLoLTNeutAll=-CNegLoGTNeutAll

%-----------Valence All----------------------

CPosHiGTNegHiAll=[-1 0 0 0 1 0 0 0 0 0 0 -1 0 0 0 1 0 0 0 0 0 0 0 0]
Tmp1=CPosHiGTNegHiAll;
Tmp2=zeros(1,34);
Tmp2(1:2:10)=Tmp1(1:5);
Tmp2(17:2:26)=Tmp1(12:16);
CPosHiGTNegHiAll=Tmp2;

CPosHiLTNegHiAll=-CPosHiGTNegHiAll

CPosLoGTNegLoAll=[0 -1 0 1 0 0 0 0 0 0 0 0 -1 0 1 0 0 0 0 0 0 0 0 0]
Tmp1=CPosLoGTNegLoAll;
Tmp2=zeros(1,34);
Tmp2(1:2:10)=Tmp1(1:5);
Tmp2(17:2:26)=Tmp1(12:16);
CPosLoGTNegLoAll=Tmp2;

CPosLoLTNegLoAll=-CPosLoGTNegLoAll

%-------------------------------------------

%-----------Arousal Complex---------------------

CAroHiGTLoAll=[3 -2 -2 -2 3 0 0 0 0 0 0 3 -2 -2 -2 3 0 0 0 0 0 0 0 0];
Tmp1=CAroHiGTLoAll;
Tmp2=zeros(1,34);
Tmp2(1:2:10)=Tmp1(1:5);
Tmp2(17:2:26)=Tmp1(12:16);
CAroHiGTLoAll=Tmp2;

CAroHiLTLoAll=-CAroHiGTLoAll;

CAroLinHiGTLoAll=[4 -1 -6 -1 4 0 0 0 0 0 0 4 -1 -6 -1 4 0 0 0 0 0 0 0 0];
Tmp1=CAroLinHiGTLoAll;
Tmp2=zeros(1,34);
Tmp2(1:2:10)=Tmp1(1:5);
Tmp2(17:2:26)=Tmp1(12:16);
CAroLinHiGTLoAll=Tmp2;

CAroLinHiLTLoAll=-CAroLinHiGTLoAll;

CAroExp1HiGTLoAll=[2 -1 -2 -1 2 0 0 0 0 0 0 2 -1 -2 -1 2 0 0 0 0 0 0 0 0];
Tmp1=CAroExp1HiGTLoAll;
Tmp2=zeros(1,34);
Tmp2(1:2:10)=Tmp1(1:5);
Tmp2(17:2:26)=Tmp1(12:16);
CAroExp1HiGTLoAll=Tmp2;

CAroExp1HiLTLoAll=-CAroExp1HiGTLoAll;

CAroExp2HiGTLoAll=[7 -3 -8 -3 7 0 0 0 0 0 0 7 -3 -8 -3 7 0 0 0 0 0 0 0 0];
Tmp1=CAroExp2HiGTLoAll;
Tmp2=zeros(1,34);
Tmp2(1:2:10)=Tmp1(1:5);
Tmp2(17:2:26)=Tmp1(12:16);
CAroExp2HiGTLoAll=Tmp2;

CAroExp2HiLTLoAll=-CAroExp2HiGTLoAll;

%-------------------------------------------

%-----------Valence Complex---------------------

CValPosGTNegAll=[-1 -1 0 1 1 0 0 0 0 0 0 -1 -1 0 1 1 0 0 0 0 0 0 0 0];
Tmp1=CValPosGTNegAll;
Tmp2=zeros(1,34);
Tmp2(1:2:10)=Tmp1(1:5);
Tmp2(17:2:26)=Tmp1(12:16);
CValPosGTNegAll=Tmp2;

CValPosLTNegAll=-CValPosGTNegAll;



%-------------------------------------------

%-----------Slow--------------------------

%-------------------------------------------

%-----------Arousal Slow---------------------

CPosHiGTNeutSlow=[0 0 -1 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0]
Tmp1=CPosHiGTNeutSlow;
Tmp2=zeros(1,34);
Tmp2(1:2:10)=Tmp1(1:5);
Tmp2(17:2:26)=Tmp1(12:16);
CPosHiGTNeutSlow=Tmp2;

CPosHiLTNeutSlow=-CPosHiGTNeutSlow

CNegHiGTNeutSlow=[1 0 -1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0]
Tmp1=CNegHiGTNeutSlow;
Tmp2=zeros(1,34);
Tmp2(1:2:10)=Tmp1(1:5);
Tmp2(17:2:26)=Tmp1(12:16);
CNegHiGTNeutSlow=Tmp2;

CNegHiLTNeutSlow=-CNegHiGTNeutSlow

CPosLoGTNeutSlow=[0 0 -1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0]
Tmp1=CPosLoGTNeutSlow;
Tmp2=zeros(1,34);
Tmp2(1:2:10)=Tmp1(1:5);
Tmp2(17:2:26)=Tmp1(12:16);
CPosLoGTNeutSlow=Tmp2;

CPosLoLTNeutSlow=-CPosLoGTNeutSlow

CNegLoGTNeutSlow=[0 1 -1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0]
Tmp1=CNegLoGTNeutSlow;
Tmp2=zeros(1,34);
Tmp2(1:2:10)=Tmp1(1:5);
Tmp2(17:2:26)=Tmp1(12:16);
CNegLoGTNeutSlow=Tmp2;

CNegLoLTNeutSlow=-CNegLoGTNeutSlow

%-----------Valence Slow----------------------

CPosHiGTNegHiSlow=[-1 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0]
Tmp1=CPosHiGTNegHiSlow;
Tmp2=zeros(1,34);
Tmp2(1:2:10)=Tmp1(1:5);
Tmp2(17:2:26)=Tmp1(12:16);
CPosHiGTNegHiSlow=Tmp2;

CPosHiLTNegHiSlow=-CPosHiGTNegHiSlow

CPosLoGTNegLoSlow=[0 -1 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0]
Tmp1=CPosLoGTNegLoSlow;
Tmp2=zeros(1,34);
Tmp2(1:2:10)=Tmp1(1:5);
Tmp2(17:2:26)=Tmp1(12:16);
CPosLoGTNegLoSlow=Tmp2;

CPosLoLTNegLoSlow=-CPosLoGTNegLoSlow

%-------------------------------------------

%-----------Arousal Slow Complex---------------------

CAroHiGTLoSlow=[3 -2 -2 -2 3 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0];
Tmp1=CAroHiGTLoSlow;
Tmp2=zeros(1,34);
Tmp2(1:2:10)=Tmp1(1:5);
Tmp2(17:2:26)=Tmp1(12:16);
CAroHiGTLoSlow=Tmp2;

CAroHiLTLoSlow=-CAroHiGTLoSlow;

CAroLinHiGTLoSlow=[4 -1 -6 -1 4 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0];
Tmp1=CAroLinHiGTLoSlow;
Tmp2=zeros(1,34);
Tmp2(1:2:10)=Tmp1(1:5);
Tmp2(17:2:26)=Tmp1(12:16);
CAroLinHiGTLoSlow=Tmp2;

CAroLinHiLTLoSlow=-CAroLinHiGTLoSlow;

CAroExp1HiGTLoSlow=[2 -1 -2 -1 2 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0];
Tmp1=CAroExp1HiGTLoSlow;
Tmp2=zeros(1,34);
Tmp2(1:2:10)=Tmp1(1:5);
Tmp2(17:2:26)=Tmp1(12:16);
CAroExp1HiGTLoSlow=Tmp2;

CAroExp1HiLTLoSlow=-CAroExp1HiGTLoSlow;

CAroExp2HiGTLoSlow=[7 -3 -8 -3 7 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0];
Tmp1=CAroExp2HiGTLoSlow;
Tmp2=zeros(1,34);
Tmp2(1:2:10)=Tmp1(1:5);
Tmp2(17:2:26)=Tmp1(12:16);
CAroExp2HiGTLoSlow=Tmp2;

CAroExp2HiLTLoSlow=-CAroExp2HiGTLoSlow;

%-------------------------------------------

%-----------Valence Slow Complex---------------------
CValPosGTNegSlow=[-1 -1 0 1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0];
Tmp1=CValPosGTNegSlow;
Tmp2=zeros(1,34);
Tmp2(1:2:10)=Tmp1(1:5);
Tmp2(17:2:26)=Tmp1(12:16);
CValPosGTNegSlow=Tmp2;

CValPosLTNegSlow=-CValPosGTNegSlow;
%-------------------------------------------
%-----------Fast--------------------------
%-------------------------------------------
%-----------Arousal Fast---------------------
CPosHiGTNeutFast=[0 0 0 0 0 0 0 0 0 0 0 0 0 -1 0 1 0 0 0 0 0 0 0 0]
Tmp1=CPosHiGTNeutFast;
Tmp2=zeros(1,34);
Tmp2(1:2:10)=Tmp1(1:5);
Tmp2(17:2:26)=Tmp1(12:16);
CPosHiGTNeutFast=Tmp2;

CPosHiLTNeutFast=-CPosHiGTNeutFast

CNegHiGTNeutFast=[0 0 0 0 0 0 0 0 0 0 0 1 0 -1 0 0 0 0 0 0 0 0 0 0]
Tmp1=CNegHiGTNeutFast;
Tmp2=zeros(1,34);
Tmp2(1:2:10)=Tmp1(1:5);
Tmp2(17:2:26)=Tmp1(12:16);
CNegHiGTNeutFast=Tmp2;

CNegHiLTNeutFast=-CNegHiGTNeutFast

CPosLoGTNeutFast=[0 0 0 0 0 0 0 0 0 0 0 0 0 -1 1 0 0 0 0 0 0 0 0 0]
Tmp1=CPosLoGTNeutFast;
Tmp2=zeros(1,34);
Tmp2(1:2:10)=Tmp1(1:5);
Tmp2(17:2:26)=Tmp1(12:16);
CPosLoGTNeutFast=Tmp2;

CPosLoLTNeutFast=-CPosLoGTNeutFast

CNegLoGTNeutFast=[0 0 0 0 0 0 0 0 0 0 0 0 1 -1 0 0 0 0 0 0 0 0 0 0]
Tmp1=CNegLoGTNeutFast;
Tmp2=zeros(1,34);
Tmp2(1:2:10)=Tmp1(1:5);
Tmp2(17:2:26)=Tmp1(12:16);
CNegLoGTNeutFast=Tmp2;

CNegLoLTNeutFast=-CNegLoGTNeutFast

%-----------Valence Fast----------------------
CPosHiGTNegHiFast=[0 0 0 0 0 0 0 0 0 0 0 -1 0 0 0 1 0 0 0 0 0 0 0 0]
Tmp1=CPosHiGTNegHiFast;
Tmp2=zeros(1,34);
Tmp2(1:2:10)=Tmp1(1:5);
Tmp2(17:2:26)=Tmp1(12:16);
CPosHiGTNegHiFast=Tmp2;

CPosHiLTNegHiFast=-CPosHiGTNegHiFast

CPosLoGTNegLoFast=[0 0 0 0 0 0 0 0 0 0 0 0 -1 0 1 0 0 0 0 0 0 0 0 0]
Tmp1=CPosLoGTNegLoFast;
Tmp2=zeros(1,34);
Tmp2(1:2:10)=Tmp1(1:5);
Tmp2(17:2:26)=Tmp1(12:16);
CPosLoGTNegLoFast=Tmp2;

CPosLoLTNegLoFast=-CPosLoGTNegLoFast

%-------------------------------------------
%-----------Arousal Fast Complex---------------------
CAroHiGTLoFast=[0 0 0 0 0 0 0 0 0 0 0 3 -2 -2 -2 3 0 0 0 0 0 0 0 0];
Tmp1=CAroHiGTLoFast;
Tmp2=zeros(1,34);
Tmp2(1:2:10)=Tmp1(1:5);
Tmp2(17:2:26)=Tmp1(12:16);
CAroHiGTLoFast=Tmp2;

CAroHiLTLoFast=-CAroHiGTLoFast;

CAroLinHiGTLoFast=[0 0 0 0 0 0 0 0 0 0 0 4 -1 -6 -1 4 0 0 0 0 0 0 0 0];
Tmp1=CAroLinHiGTLoFast;
Tmp2=zeros(1,34);
Tmp2(1:2:10)=Tmp1(1:5);
Tmp2(17:2:26)=Tmp1(12:16);
CAroLinHiGTLoFast=Tmp2;

CAroLinHiLTLoFast=-CAroLinHiGTLoFast;

CAroExp1HiGTLoFast=[0 0 0 0 0 0 0 0 0 0 0 2 -1 -2 -1 2 0 0 0 0 0 0 0 0];
Tmp1=CAroExp1HiGTLoFast;
Tmp2=zeros(1,34);
Tmp2(1:2:10)=Tmp1(1:5);
Tmp2(17:2:26)=Tmp1(12:16);
CAroExp1HiGTLoFast=Tmp2;

CAroExp1HiLTLoFast=-CAroExp1HiGTLoFast;

CAroExp2HiGTLoFast=[0 0 0 0 0 0 0 0 0 0 0 7 -3 -8 -3 7 0 0 0 0 0 0 0 0];
Tmp1=CAroExp2HiGTLoFast;
Tmp2=zeros(1,34);
Tmp2(1:2:10)=Tmp1(1:5);
Tmp2(17:2:26)=Tmp1(12:16);
CAroExp2HiGTLoFast=Tmp2;

CAroExp2HiLTLoFast=-CAroExp2HiGTLoFast;

%-------------------------------------------
%-----------Valence Fast Complex---------------------
CValPosGTNegFast=[0 0 0 0 0 0 0 0 0 0 0 -1 -1 0 1 1 0 0 0 0 0 0 0 0];
Tmp1=CValPosGTNegFast;
Tmp2=zeros(1,34);
Tmp2(1:2:10)=Tmp1(1:5);
Tmp2(17:2:26)=Tmp1(12:16);
CValPosGTNegFast=Tmp2;

CValPosLTNegFast=-CValPosGTNegFast;
%-------------------------------------------
%-----------Fast Vs Slow--------------------
%-------------------------------------------
%-----------All Fast Vs Slow------------
CFastGTSlowAll=[-1 -1 -1 -1 -1 0 0 0 0 0 0 1 1 1 1 1 0 0 0 0 0 0 0 0];
Tmp1=CFastGTSlowAll;
Tmp2=zeros(1,34);
Tmp2(1:2:10)=Tmp1(1:5);
Tmp2(17:2:26)=Tmp1(12:16);
CFastGTSlowAll=Tmp2;

CFastLTSlowAll=-CFastGTSlowAll;

CFastGTSlowNegHiAll=[-1 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0];
Tmp1=CFastGTSlowNegHiAll;
Tmp2=zeros(1,34);
Tmp2(1:2:10)=Tmp1(1:5);
Tmp2(17:2:26)=Tmp1(12:16);
CFastGTSlowNegHiAll=Tmp2;

CFastLTSlowNegHiAll=-CFastGTSlowNegHiAll;

CFastGTSlowNegLoAll=[0 -1 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0 0];
Tmp1=CFastGTSlowNegLoAll;
Tmp2=zeros(1,34);
Tmp2(1:2:10)=Tmp1(1:5);
Tmp2(17:2:26)=Tmp1(12:16);
CFastGTSlowNegLoAll=Tmp2;

CFastLTSlowNegLoAll=-CFastGTSlowNegLoAll;

CFastGTSlowNeutAll=[0 0 -1 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0 0];
Tmp1=CFastGTSlowNeutAll;
Tmp2=zeros(1,34);
Tmp2(1:2:10)=Tmp1(1:5);
Tmp2(17:2:26)=Tmp1(12:16);
CFastGTSlowNeutAll=Tmp2;

CFastLTSlowNeutAll=-CFastGTSlowNeutAll;

CFastGTSlowPosLoAll=[0 0 0 -1 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0 0];
Tmp1=CFastGTSlowPosLoAll;
Tmp2=zeros(1,34);
Tmp2(1:2:10)=Tmp1(1:5);
Tmp2(17:2:26)=Tmp1(12:16);
CFastGTSlowPosLoAll=Tmp2;

CFastLTSlowPosLoAll=-CFastGTSlowPosLoAll;

CFastGTSlowPosHiAll=[0 0 0 0 -1 0 0 0 0 0 0 0 0 0 0 1 0 0 0 0 0 0 0 0];
Tmp1=CFastGTSlowPosHiAll;
Tmp2=zeros(1,34);
Tmp2(1:2:10)=Tmp1(1:5);
Tmp2(17:2:26)=Tmp1(12:16);
CFastGTSlowPosHiAll=Tmp2;

CFastLTSlowPosHiAll=-CFastGTSlowPosHiAll;

%-------------------------------------------
%-----------Arousal Fast Vs Slow------------
CFastGTSlowHiAroAll=[-1 0 0 0 -1 0 0 0 0 0 0 1 0 0 0 1 0 0 0 0 0 0 0 0];
Tmp1=CFastGTSlowHiAroAll;
Tmp2=zeros(1,34);
Tmp2(1:2:10)=Tmp1(1:5);
Tmp2(17:2:26)=Tmp1(12:16);
CFastGTSlowHiAroAll=Tmp2;

CFastLTSlowHiAroAll=-CFastGTSlowHiAroAll;

CFastGTSlowLoAroAll=[0 -1 0 -1 0 0 0 0 0 0 0 0 1 0 1 0 0 0 0 0 0 0 0 0];
Tmp1=CFastGTSlowLoAroAll;
Tmp2=zeros(1,34);
Tmp2(1:2:10)=Tmp1(1:5);
Tmp2(17:2:26)=Tmp1(12:16);
CFastGTSlowLoAroAll=Tmp2;

CFastLTSlowLoAroAll=-CFastGTSlowLoAroAll;

%-------------------------------------------
%-----------Valence Fast Vs Slow------------
CFastGTSlowNegValAll=[-1 -1 0 0 0 0 0 0 0 0 0 1 1 0 0 0 0 0 0 0 0 0 0 0];
Tmp1=CFastGTSlowNegValAll;
Tmp2=zeros(1,34);
Tmp2(1:2:10)=Tmp1(1:5);
Tmp2(17:2:26)=Tmp1(12:16);
CFastGTSlowNegValAll=Tmp2;

CFastLTSlowNegValAll=-CFastGTSlowNegValAll;

CFastGTSlowPosValAll=[0 0 0 -1 -1 0 0 0 0 0 0 0 0 0 1 1 0 0 0 0 0 0 0 0];
Tmp1=CFastGTSlowPosValAll;
Tmp2=zeros(1,34);
Tmp2(1:2:10)=Tmp1(1:5);
Tmp2(17:2:26)=Tmp1(12:16);
CFastGTSlowPosValAll=Tmp2;

CFastLTSlowPosValAll=-CFastGTSlowPosValAll;

%-------------------------------------------CPosHiLTPosLoSlow
%PosHiPosLo
CPosHiGTPosLoAll=[0 0 0 -1 1 0 0 0 0 0 0 0 0 0 -1 1 0 0 0 0 0 0 0 0];
Tmp1=CPosHiGTPosLoAll;
Tmp2=zeros(1,34);
Tmp2(1:2:10)=Tmp1(1:5);
Tmp2(17:2:26)=Tmp1(12:16);
CPosHiGTPosLoAll=Tmp2;

CPosHiLTPosLoAll=-CPosHiGTPosLoAll;

CPosHiGTPosLoSlow=[0 0 0 -1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0];
Tmp1=CPosHiGTPosLoSlow;
Tmp2=zeros(1,34);
Tmp2(1:2:10)=Tmp1(1:5);
Tmp2(17:2:26)=Tmp1(12:16);
CPosHiGTPosLoSlow=Tmp2;

CPosHiLTPosLoSlow=-CPosHiGTPosLoSlow;

CPosHiGTPosLoFast=[0 0 0 0 0 0 0 0 0 0 0 0 0 0 -1 1 0 0 0 0 0 0 0 0];
Tmp1=CPosHiGTPosLoFast;
Tmp2=zeros(1,34);
Tmp2(1:2:10)=Tmp1(1:5);
Tmp2(17:2:26)=Tmp1(12:16);
CPosHiGTPosLoFast=Tmp2;

CPosHiLTPosLoFast=-CPosHiGTPosLoFast;

%NegHiNegLo
CNegHiGTNegLoAll=[1 -1 0 0 0 0 0 0 0 0 0 1 -1 0 0 0 0 0 0 0 0 0 0 0];
Tmp1=CNegHiGTNegLoAll;
Tmp2=zeros(1,34);
Tmp2(1:2:10)=Tmp1(1:5);
Tmp2(17:2:26)=Tmp1(12:16);
CNegHiGTNegLoAll=Tmp2;

CNegHiLTNegLoAll=-CNegHiGTNegLoAll;

CNegHiGTNegLoSlow=[1 -1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0];
Tmp1=CNegHiGTNegLoSlow;
Tmp2=zeros(1,34);
Tmp2(1:2:10)=Tmp1(1:5);
Tmp2(17:2:26)=Tmp1(12:16);
CNegHiGTNegLoSlow=Tmp2;

CNegHiLTNegLoSlow=-CNegHiGTNegLoSlow;

CNegHiGTNegLoFast=[0 0 0 0 0 0 0 0 0 0 0 1 -1 0 0 0 0 0 0 0 0 0 0 0];
Tmp1=CNegHiGTNegLoFast;
Tmp2=zeros(1,34);
Tmp2(1:2:10)=Tmp1(1:5);
Tmp2(17:2:26)=Tmp1(12:16);
CNegHiGTNegLoFast=Tmp2;

CNegHiLTNegLoFast=-CNegHiGTNegLoFast;

%PosHiNegLo
CPosHiGTNegLoAll=[0 -1 0 0 1 0 0 0 0 0 0 0 -1 0 0 1 0 0 0 0 0 0 0 0];
Tmp1=CPosHiGTNegLoAll;
Tmp2=zeros(1,34);
Tmp2(1:2:10)=Tmp1(1:5);
Tmp2(17:2:26)=Tmp1(12:16);
CPosHiGTNegLoAll=Tmp2;

CPosHiLTNegLoAll=-CPosHiGTNegLoAll;

CPosHiGTNegLoSlow=[0 -1 0 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0];
Tmp1=CPosHiGTNegLoSlow;
Tmp2=zeros(1,34);
Tmp2(1:2:10)=Tmp1(1:5);
Tmp2(17:2:26)=Tmp1(12:16);
CPosHiGTNegLoSlow=Tmp2;

CPosHiLTNegLoSlow=-CPosHiGTNegLoSlow;

CPosHiGTNegLoFast=[0 0 0 0 0 0 0 0 0 0 0 0 -1 0 0 1 0 0 0 0 0 0 0 0];
Tmp1=CPosHiGTNegLoFast;
Tmp2=zeros(1,34);
Tmp2(1:2:10)=Tmp1(1:5);
Tmp2(17:2:26)=Tmp1(12:16);
CPosHiGTNegLoFast=Tmp2;

CPosHiLTNegLoFast=-CPosHiGTNegLoFast;

%NegHiPosLo
CNegHiGTPosLoAll=[1 0 0 -1 0 0 0 0 0 0 0 1 0 0 -1 0 0 0 0 0 0 0 0 0];
Tmp1=CNegHiGTPosLoAll;
Tmp2=zeros(1,34);
Tmp2(1:2:10)=Tmp1(1:5);
Tmp2(17:2:26)=Tmp1(12:16);
CNegHiGTPosLoAll=Tmp2;

CNegHiLTPosLoAll=-CNegHiGTPosLoAll;

CNegHiGTPosLoSlow=[1 0 0 -1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0];
Tmp1=CNegHiGTPosLoSlow;
Tmp2=zeros(1,34);
Tmp2(1:2:10)=Tmp1(1:5);
Tmp2(17:2:26)=Tmp1(12:16);
CNegHiGTPosLoSlow=Tmp2;

CNegHiLTPosLoSlow=-CNegHiGTPosLoSlow;

CNegHiGTPosLoFast=[0 0 0 0 0 0 0 0 0 0 0 1 0 0 -1 0 0 0 0 0 0 0 0 0];
Tmp1=CNegHiGTPosLoFast;
Tmp2=zeros(1,34);
Tmp2(1:2:10)=Tmp1(1:5);
Tmp2(17:2:26)=Tmp1(12:16);
CNegHiGTPosLoFast=Tmp2;

CNegHiLTPosLoFast=-CNegHiGTPosLoFast;


%-------------------------------------------

CAroHiGTLoNoNeutralAll=[1 -1 0 -1 1 0 0 0 0 0 0 1 -1 0 -1 1 0 0 0 0 0 0 0 0];
Tmp1=CAroHiGTLoNoNeutralAll;
Tmp2=zeros(1,34);
Tmp2(1:2:10)=Tmp1(1:5);
Tmp2(17:2:26)=Tmp1(12:16);
CAroHiGTLoNoNeutralAll=Tmp2;

CAroHiLTLoNoNeutralAll=-CAroHiGTLoNoNeutralAll;

CAroLoGTNeutralAll=[0 1 -2 1 0 0 0 0 0 0 0 0 1 -2 1 0 0 0 0 0 0 0 0 0];
Tmp1=CAroLoGTNeutralAll;
Tmp2=zeros(1,34);
Tmp2(1:2:10)=Tmp1(1:5);
Tmp2(17:2:26)=Tmp1(12:16);
CAroLoGTNeutralAll=Tmp2;

CAroLoLTNeutralAll=-CAroLoGTNeutralAll;

CAroHiGTLoNoNeutralSlow=[1 -1 0 -1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0];
Tmp1=CAroHiGTLoNoNeutralSlow;
Tmp2=zeros(1,34);
Tmp2(1:2:10)=Tmp1(1:5);
Tmp2(17:2:26)=Tmp1(12:16);
CAroHiGTLoNoNeutralSlow=Tmp2;

CAroHiLTLoNoNeutralSlow=-CAroHiGTLoNoNeutralSlow;

CAroLoGTNeutralSlow=[0 1 -2 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0];
Tmp1=CAroLoGTNeutralSlow;
Tmp2=zeros(1,34);
Tmp2(1:2:10)=Tmp1(1:5);
Tmp2(17:2:26)=Tmp1(12:16);
CAroLoGTNeutralSlow=Tmp2;

CAroLoLTNeutralSlow=-CAroLoGTNeutralSlow;

CAroHiGTLoNoNeutralFast=[0 0 0 0 0 0 0 0 0 0 0 1 -1 0 -1 1 0 0 0 0 0 0 0 0];
Tmp1=CAroHiGTLoNoNeutralFast;
Tmp2=zeros(1,34);
Tmp2(1:2:10)=Tmp1(1:5);
Tmp2(17:2:26)=Tmp1(12:16);
CAroHiGTLoNoNeutralFast=Tmp2;

CAroHiLTLoNoNeutralFast=-CAroHiGTLoNoNeutralFast;

CAroLoGTNeutralFast=[0 0 0 0 0 0 0 0 0 0 0 0 1 -2 1 0 0 0 0 0 0 0 0 0];
Tmp1=CAroLoGTNeutralFast;
Tmp2=zeros(1,34);
Tmp2(1:2:10)=Tmp1(1:5);
Tmp2(17:2:26)=Tmp1(12:16);
CAroLoGTNeutralFast=Tmp2;

CAroLoLTNeutralFast=-CAroLoGTNeutralFast;

CAroHiGTNeutralAll=[1 0 -2 0 1 0 0 0 0 0 0 1 0 -2 0 1 0 0 0 0 0 0 0 0];
Tmp1=CAroHiGTNeutralAll;
Tmp2=zeros(1,34);
Tmp2(1:2:10)=Tmp1(1:5);
Tmp2(17:2:26)=Tmp1(12:16);
CAroHiGTNeutralAll=Tmp2;

CAroHiLTNeutralAll=-CAroHiGTNeutralAll;

CAroHiGTNeutralSlow=[1 0 -2 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0];
Tmp1=CAroHiGTNeutralSlow;
Tmp2=zeros(1,34);
Tmp2(1:2:10)=Tmp1(1:5);
Tmp2(17:2:26)=Tmp1(12:16);
CAroHiGTNeutralSlow=Tmp2;

CAroHiLTNeutralSlow=-CAroHiGTNeutralSlow;

CAroHiGTNeutralFast=[0 0 0 0 0 0 0 0 0 0 0 1 0 -2 0 1 0 0 0 0 0 0 0 0];
Tmp1=CAroHiGTNeutralFast;
Tmp2=zeros(1,34);
Tmp2(1:2:10)=Tmp1(1:5);
Tmp2(17:2:26)=Tmp1(12:16);
CAroHiGTNeutralFast=Tmp2;

CAroHiLTNeutralFast=-CAroHiGTNeutralFast;

contrasts(1) = struct( ...
  'names',  {{...
            'CPosHiGTNeutAll','CPosHiLTNeutAll','CNegHiGTNeutAll','CNegHiLTNeutAll','CPosLoGTNeutAll',...
            'CPosLoLTNeutAll','CNegLoGTNeutAll','CNegLoLTNeutAll','CPosHiGTNegHiAll','CPosHiLTNegHiAll',...                 %10
            'CPosLoGTNegLoAll','CPosLoLTNegLoAll','CAroHiGTLoAll','CAroHiLTLoAll','CAroLinHiGTLoAll',...
            'CAroLinHiLTLoAll','CAroExp1HiGTLoAll','CAroExp1HiLTLoAll','CAroExp2HiGTLoAll','CAroExp2HiLTLoAll',...           %20
            'CValPosGTNegAll','CValPosLTNegAll','CPosHiGTNeutSlow','CPosHiLTNeutSlow','CNegHiGTNeutSlow',...
            'CNegHiLTNeutSlow','CPosLoGTNeutSlow','CPosLoLTNeutSlow','CNegLoGTNeutSlow','CNegLoLTNeutSlow',...               %30
            'CPosHiGTNegHiSlow','CPosHiLTNegHiSlow','CPosLoGTNegLoSlow','CPosLoLTNegLoSlow','CAroHiGTLoSlow',...
            'CAroHiLTLoSlow','CAroLinHiGTLoSlow','CAroLinHiLTLoSlow','CAroExp1HiGTLoSlow','CAroExp1HiLTLoSlow',...           %40
            'CAroExp2HiGTLoSlow','CAroExp2HiLTLoSlow','CValPosGTNegSlow','CValPosLTNegSlow','CPosHiGTNeutFast',...
            'CPosHiLTNeutFast','CNegHiGTNeutFast','CNegHiLTNeutFast','CPosLoGTNeutFast','CPosLoLTNeutFast',...               %50
            'CNegLoGTNeutFast','CNegLoLTNeutFast','CPosHiGTNegHiFast','CPosHiLTNegHiFast','CPosLoGTNegLoFast',...             
            'CPosLoLTNegLoFast','CAroHiGTLoFast','CAroHiLTLoFast','CAroLinHiGTLoFast','CAroLinHiLTLoFast',...                 %60
            'CAroExp1HiGTLoFast','CAroExp1HiLTLoFast','CAroExp2HiGTLoFast','CAroExp2HiLTLoFast','CValPosGTNegFast',...
            'CValPosLTNegFast','CFastGTSlow','CFastLTSlow','CFastGTSlowNegHi','CFastLTSlowNegHi',...                            %70
            'CFastGTSlowNegLo','CFastLTSlowNegLo','CFastGTSlowNeut','CFastLTSlowNeut','CFastGTSlowPosLo',...
            'CFastLTSlowPosLo','CFastGTSlowPosHi','CFastLTSlowPosHi','CFastGTSlowHiAro','CFastLTSlowHiAro',...                  %80
            'CFastGTSlowLoAro','CFastLTSlowLoAro','CFastGTSlowNegVal','CFastLTSlowNegVal','CFastGTSlowPosVal', ...
            'CFastLTSlowPosVal','CPosHiLTPosLoAll','CPosHiGTPosLoAll','CPosHiLTPosLoSlow','CPosHiGTPosLoSlow', ...              %90
            'CPosHiLTPosLoFast','CPosHiGTPosLoFast','CNegHiLTNegLoAll','CNegHiGTNegLoAll','CNegHiLTNegLoSlow', ...
            'CNegHiGTNegLoSlow','CNegHiLTNegLoFast','CNegHiGTNegLoFast','CPosHiLTNegLoAll','CPosHiGTNegLoAll', ...             %100
            'CPosHiLTNegLoSlow','CPosHiGTNegLoSlow','CPosHiLTNegLoFast','CPosHiGTNegLoFast','CNegHiLTPosLoAll', ...
            'CNegHiGTPosLoAll', 'CNegHiLTPosLoSlow','CNegHiGTPosLoSlow','CNegHiLTPosLoFast','CNegHiGTPosLoFast', ...            %110
            'CAroHiGTLoNoNeutralAll','CAroHiLTLoNoNeutralAll','CAroHiGTLoNoNeutralSlow','CAroHiLTLoNoNeutralSlow','CAroHiGTLoNoNeutralFast',...
            'CAroHiLTLoNoNeutralFast','CAroLoGTNeutralAll','CAroLoLTNeutralAll','CAroLoGTNeutralSlow','CAroLoLTNeutralSlow',...
            'CAroLoGTNeutralFast','CAroLoLTNeutralFast','CAroHiGTNeutralAll','CAroHiLTNeutralAll','CAroHiGTNeutralSlow',...
            'CAroHiLTNeutralSlow','CAroHiGTNeutralFast','CAroHiLTNeutralFast'}}, ...
  'types',   {{'T','T','T','T','T','T','T','T','T','T','T','T','T','T','T','T','T','T','T','T',...
               'T','T','T','T','T','T','T','T','T','T','T','T','T','T','T','T','T','T','T','T',...
               'T','T','T','T','T','T','T','T','T','T','T','T','T','T','T','T','T','T','T','T',...
               'T','T','T','T','T','T','T','T','T','T','T','T','T','T','T','T','T','T','T','T',...
               'T','T','T','T','T','T','T','T','T','T','T','T','T','T','T','T','T','T','T','T',...
               'T','T','T','T','T','T','T','T','T','T','T','T','T','T','T','T','T','T','T','T',...
               'T','T','T','T','T','T','T','T'...
            }}, ...
  'values',  {{...
            CPosHiGTNeutAll,CPosHiLTNeutAll,CNegHiGTNeutAll,CNegHiLTNeutAll,CPosLoGTNeutAll,...
            CPosLoLTNeutAll,CNegLoGTNeutAll,CNegLoLTNeutAll,CPosHiGTNegHiAll,CPosHiLTNegHiAll,...                                   %10
            CPosLoGTNegLoAll,CPosLoLTNegLoAll,CAroHiGTLoAll,CAroHiLTLoAll,CAroLinHiGTLoAll,...
            CAroLinHiLTLoAll,CAroExp1HiGTLoAll,CAroExp1HiLTLoAll,CAroExp2HiGTLoAll,CAroExp2HiLTLoAll,...                            %20
            CValPosGTNegAll,CValPosLTNegAll,CPosHiGTNeutSlow,CPosHiLTNeutSlow,CNegHiGTNeutSlow,...
            CNegHiLTNeutSlow,CPosLoGTNeutSlow,CPosLoLTNeutSlow,CNegLoGTNeutSlow,CNegLoLTNeutSlow,...                                %30
            CPosHiGTNegHiSlow,CPosHiLTNegHiSlow,CPosLoGTNegLoSlow,CPosLoLTNegLoSlow,CAroHiGTLoSlow,...
            CAroHiLTLoSlow,CAroLinHiGTLoSlow,CAroLinHiLTLoSlow,CAroExp1HiGTLoSlow,CAroExp1HiLTLoSlow,...                            %40
            CAroExp2HiGTLoSlow,CAroExp2HiLTLoSlow,CValPosGTNegSlow,CValPosLTNegSlow,CPosHiGTNeutFast,...
            CPosHiLTNeutFast,CNegHiGTNeutFast,CNegHiLTNeutFast,CPosLoGTNeutFast,CPosLoLTNeutFast,...                                %50
            CNegLoGTNeutFast,CNegLoLTNeutFast,CPosHiGTNegHiFast,CPosHiLTNegHiFast,CPosLoGTNegLoFast,...
            CPosLoLTNegLoFast,CAroHiGTLoFast,CAroHiLTLoFast,CAroLinHiGTLoFast,CAroLinHiLTLoFast,...                                 %60
            CAroExp1HiGTLoFast,CAroExp1HiLTLoFast,CAroExp2HiGTLoFast,CAroExp2HiLTLoFast,CValPosGTNegFast,...
            CValPosLTNegFast,CFastGTSlowAll,CFastLTSlowAll,CFastGTSlowNegHiAll,CFastLTSlowNegHiAll,...                              %70
            CFastGTSlowNegLoAll,CFastLTSlowNegLoAll,CFastGTSlowNeutAll,CFastLTSlowNeutAll,CFastGTSlowPosLoAll,...
            CFastLTSlowPosLoAll,CFastGTSlowPosHiAll,CFastLTSlowPosHiAll,CFastGTSlowHiAroAll,CFastLTSlowHiAroAll,...                 %80
            CFastGTSlowLoAroAll,CFastLTSlowLoAroAll,CFastGTSlowNegValAll,CFastLTSlowNegValAll,CFastGTSlowPosValAll,...
            CFastLTSlowPosValAll,CPosHiLTPosLoAll,CPosHiGTPosLoAll,CPosHiLTPosLoSlow,CPosHiGTPosLoSlow, ...                         %90
            CPosHiLTPosLoFast,CPosHiGTPosLoFast,CNegHiLTNegLoAll,CNegHiGTNegLoAll,CNegHiLTNegLoSlow, ...                            
            CNegHiGTNegLoSlow,CNegHiLTNegLoFast,CNegHiGTNegLoFast,CPosHiLTNegLoAll,CPosHiGTNegLoAll, ...                            %100
            CPosHiLTNegLoSlow,CPosHiGTNegLoSlow,CPosHiLTNegLoFast,CPosHiGTNegLoFast,CNegHiLTPosLoAll, ...                          
            CNegHiGTPosLoAll,CNegHiLTPosLoSlow,CNegHiGTPosLoSlow,CNegHiLTPosLoFast,CNegHiGTPosLoFast, ...                           %110
            CAroHiGTLoNoNeutralAll,CAroHiLTLoNoNeutralAll,CAroHiGTLoNoNeutralSlow,CAroHiLTLoNoNeutralSlow,CAroHiGTLoNoNeutralFast,...
            CAroHiLTLoNoNeutralFast,CAroLoGTNeutralAll,CAroLoLTNeutralAll,CAroLoGTNeutralSlow,CAroLoLTNeutralSlow,...
            CAroLoGTNeutralFast,CAroLoLTNeutralFast,CAroHiGTNeutralAll,CAroHiLTNeutralAll,CAroHiGTNeutralSlow,...
            CAroHiLTNeutralSlow,CAroHiGTNeutralFast,CAroHiLTNeutralFast}} ...
);