%   BAT.m


%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION. 


global SubInd SubIndStr MaskStr

%---------------------------------------------------------------
% model(1) Low-Off vs High Off
%---------------------------------------------------------------
                                                                     
clear F1 F2
SessVec=[2 3];
NSess=length(SessVec); 
for SessInd=1:NSess
   ActSess=SessVec(SessInd);
   ActSessStr=int2str(ActSess);
	if ActSess<10
  	 	ActSessStr=['0',ActSessStr];
	end
   FolderName=['K:\fMRIData\fMRIDataGV\',SubIndStr,'\',ActSessStr,'\']
   Mask=[MaskStr,'*.img'];
   Tmp=spm_get('Files',FolderName,Mask)
   if SessInd==1
      F1=Tmp;
   else
      F2=Tmp;
   end
end
F1
F2
%---------------------------------------------------------------
% batch variables defined here for analysis 'model'
%---------------------------------------------------------------

model(1) = struct( ...
 'types',          4, ...
 'global_effects', {'None'}, ...
 'burst_mode',     0, ...
 'HF_fil',         'specify',  ...
 'HF_cut',         [48 48], ...
 'LF_fil',         'none', ...
 'LF_cut',         0, ...
 'int_corr',       'none', ... 
 'now_later',      1, ...
 'stop_writing',   0, ...
 'trial_fcon',     0, ...
 'RT',             3, ...
 'replicated',     1, ...
 'same_time_param',1, ...
 'nsess',          2, ...
 'nscans',         [70 70], ...
 'files',          {{F1 F2}}, ...
 'conditions_nb',  [1 1], ...     
 'conditions',     [1 2], ...
 'regressors_nb',  [0 0], ...
 'regressors',     [], ...
 'parametrics_type', {{'none','none'}}, ...
 'parametrics',    [], ...
 'stochastics_flag',[0 0], ...
 'stochastics',    []);
 
%-------------------------------------------
conditions(1) = struct( ...
 'names',   {'Low'}, ...
 'onsets',{{3:8:70}}, ...   
 'types',    {{'epochs'}}, ... 
 'bf_ep',   1, ...
 'volterra',  0, ...
 'variable_dur', 0 ...
);

conditions(2) = conditions(1);
conditions(2).names = {'High'};

%-------------------------------------------

bf_ep(1) = struct( ...
  'ep_type', 4, ...
  'length',4, ...
  'conv',  1, ...  
  'deriv', 0);

%---------------------------------------------------------------
% batch variables defined here for analysis 'contrasts'
%---------------------------------------------------------------
c1=[1 0 0 0];
c2=[-1 0 0 0];
c3=[0 1 0 0];
c4=[0 -1 0 0];
c5=[-1 1 0 0];
c6=[1 -1 0 0];

contrasts(1) = struct( ...
  'names',  {{'HighLow','LowLow','HighHigh','LowHigh','High>Low','Low>High'}}, ...
  'types',   {{'T','T','T','T','T','T'}}, ...
  'values',  {{c1,c2,c3,c4,c5,c6}} ...
);
