%   BAT.m


%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION. 


global SubInd SubIndStr MaskStr

%---------------------------------------------------------------
% model(1) Low-Off vs High Off
%---------------------------------------------------------------
                                                                     
clear F1 F2 F3 F4 F5 F6
SessVec=[4 5 1 6 2 3];
NSess=length(SessVec); 
for SessInd=1:NSess
   ActSess=SessVec(SessInd);
   ActSessStr=int2str(ActSess);
	if ActSess<10
  	 	ActSessStr=['0',ActSessStr];
	end
   FolderName=['K:\fMRIData\fMRIDataGV\',SubIndStr,'\',ActSessStr,'\']
   Mask=[MaskStr,'*.img'];
   Tmp=spm_get('Files',FolderName,Mask);
   if SessInd==1
      F1=Tmp;
   elseif SessInd==2
      F2=Tmp;
   elseif SessInd==3
      F3=Tmp;
   elseif SessInd==4
      F4=Tmp;
   elseif SessInd==5
      F5=Tmp;
	elseif SessInd==6
      F6=Tmp;
	end
end
F1
F2
F3
F4
F5
F6
%---------------------------------------------------------------
% batch variables defined here for analysis 'model'
%---------------------------------------------------------------

model(1) = struct( ...
 'types',          4, ...
 'global_effects', {'None'}, ...
 'burst_mode',     0, ...
 'HF_fil',         'specify',  ...
 'HF_cut',         48, ...
 'LF_fil',         'none', ...
 'LF_cut',         0, ...
 'int_corr',       'none', ... 
 'now_later',      1, ...
 'stop_writing',   0, ...
 'trial_fcon',     0, ...
 'RT',             3, ...
 'replicated',     1, ...
 'same_time_param',1, ...
 'nsess',          1, ...
 'nscans',         [70], ...
 'files',          {{F1}}, ...
 'conditions_nb',  1, ...     
 'conditions',     1, ...
 'regressors_nb',  0, ...
 'regressors',     [], ...
 'parametrics_type', {{'none'}}, ...
 'parametrics',    [], ...
 'stochastics_flag',0, ...
 'stochastics',    []);

model(2)=model(1);
model(2).files={{F2}};
model(3)=model(1);
model(3).files={{F3}};
model(4)=model(1);
model(4).files={{F4}};
model(5)=model(1);
model(5).files={{F5}};
model(6)=model(1);
model(6).files={{F6}};


%-------------------------------------------
conditions(1) = struct( ...
 'names',   {{'High'}}, ...
 'onsets',{{[3:8:70]}}, ...   
 'types',    {{'epochs'}}, ... 
 'bf_ep',   [1], ...
 'volterra',  0, ...
 'variable_dur',0);

%conditions(2) = conditions(1);
%conditions(2).names = {'High'};

%-------------------------------------------

bf_ep(1) = struct( ...
  'ep_type', 3, ...
  'length',4, ...
  'conv',  1, ...  
  'deriv', 0);

%---------------------------------------------------------------
% batch variables defined here for analysis 'contrasts'
%---------------------------------------------------------------
c1=[1 0];
c2=[-1 0];

contrasts(1) = struct( ...
  'names',  {{'High09','Low09'}}, ...
  'types',   {{'T','T'}}, ...
  'values',  {{c1,c2}});

contrasts(2) = contrasts(1);
contrasts(2).names ={'High18','Low18'};

contrasts(3) = contrasts(1);
contrasts(3).names ={'High36','Low36'};

contrasts(4) = contrasts(1);
contrasts(4).names ={'High72','Low72'};

contrasts(5) = contrasts(1);
contrasts(5).names ={'HighLowOff','LowLowOff'};

contrasts(6) = contrasts(1);
contrasts(6).names ={'HighHighOff','LowHighOff'};