%   BAT.m


%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.


global SubInd SubIndStr MaskStr

%---------------------------------------------------------------
% model(1) Low-Off vs High Off
%---------------------------------------------------------------
                                                                      
clear F1 F2 F3 F4
SessVec=[4 5 1 6];
NSess=length(SessVec); 
for SessInd=1:NSess
   ActSess=SessVec(SessInd);
   ActSessStr=int2str(ActSess);
	if ActSess<10
  	 	ActSessStr=['0',ActSessStr];
	end
   FolderName=['K:\fMRIData\fMRIDataGV\',SubIndStr,'\',ActSessStr,'\']
   Mask=[MaskStr,'*.img'];
   Tmp=spm_get('Files',FolderName,Mask);
   if SessInd==1
      F1=Tmp;
   elseif SessInd==2
      F2=Tmp;
   elseif SessInd==3
      F3=Tmp;
   elseif SessInd==4
      F4=Tmp;
	end
end
F1
F2
F3
F4
%---------------------------------------------------------------
% batch variables defined here for analysis 'model'
%---------------------------------------------------------------

model(1) = struct( ...
 'types',          4, ...
 'global_effects', {'None'}, ...
 'burst_mode',     0, ...
 'HF_fil',         'specify',  ...
 'HF_cut',         [48 48 48 48], ...
 'LF_fil',         'none', ...
 'LF_cut',         0, ...
 'int_corr',       'none', ... 
 'now_later',      1, ...
 'stop_writing',   0, ...
 'trial_fcon',     0, ...
 'RT',             3, ...
 'replicated',     1, ...
 'same_time_param',1, ...
 'nsess',          4, ...
 'nscans',         [70 70 70 70], ...
 'files',          {{F1 F2 F3 F4}}, ...
 'conditions_nb',  [1 1 1 1], ...     
 'conditions',     [1 1 1 1], ...
 'regressors_nb',  [0 0 0 0], ...
 'regressors',     [], ...
 'parametrics_type', {{'none','none','none','none'}}, ...
 'parametrics',    [], ...
 'stochastics_flag',[0 0 0 0], ...
 'stochastics',    []);
 
%-------------------------------------------
conditions(1) = struct( ...
 'names',   {{'High'}}, ...
 'onsets',{{[3:8:70]}}, ...   
 'types',    {{'epochs'}}, ... 
 'bf_ep',   [1], ...
 'volterra',  0, ...
 'variable_dur',0);

%conditions(2) = conditions(1);
%conditions(2).names = {'High'};

%-------------------------------------------

bf_ep(1) = struct( ...
  'ep_type', 3, ...
  'length',4, ...
  'conv',  1, ...  
  'deriv', 0);

%---------------------------------------------------------------
% batch variables defined here for analysis 'contrasts'
%---------------------------------------------------------------
c1=[-1 0 0 0 0 0 0 0]
c2=[0 -1 0 0 0 0 0 0]
c3=[0 0 -1 0 0 0 0 0]
c4=[0 0 0 -1 0 0 0 0]
c5=[1 0 0 0 0 0 0 0]
c6=[0 1 0 0 0 0 0 0]
c7=[0 0 1 0 0 0 0 0]
c8=[0 0 0 1 0 0 0 0]
c9=[-1 -1 -1 -1 0 0 0 0]
c10=[1 1 1 1 0 0 0 0]
c11=[3 1 -1 -3 0 0 0 0]
c12=[-3 -1 1 3 0 0 0 0]
c13=[8.5 1.5 -3.5 -6.5 0 0 0 0]
c14=[-8.5 -1.5 3.5 6.5 0 0 0 0]
c15=[6.5 3.5 -1.5 -8.5 0 0 0 0]
c16=[-6.5 -3.5 1.5 8.5 0 0 0 0]

contrasts(1) = struct( ...
   'names',  {{'Low09','Low18','Low36','Low72','High09','High18','High36','High72', ...
   'AllLow','AllHigh','LowLin','HighLin','8.5 -6.5','-8.5 6.5','6.5 -8.5','-6.5 8.5' }}, ...
  'types',   {{'T','T','T','T','T','T','T','T','T','T','T','T','T','T','T','T'}}, ...
  'values',  {{c1,c2,c3,c4,c5,c6,c7,c8,c9,c10,c11,c12,c13,c14,c15,c16}} ...
);
