function [IndVec1,IndVec2,Num,LastShot]=CalcInd12Vec(NShot,NShotPerCycle,Lag,FigTitle,ShotOrderPlotStatus)

%	CalcInd12Vec.m

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Qun Zhao, Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.    

if nargin<5; ShotOrderPlotStatus=0; end
if nargin<4; FigTitle=[]; end
if nargin<3; Lag=0; end
if nargin<2; NShotPerCycle=[]; end
if nargin<1; NShot=[]; end
 
if isempty(NShot); return; end
if isempty(NShotPerCycle); return; end

NCycle=NShot./NShotPerCycle;
IndVec1=[];IndVec2=[];
for Ind=1:NShotPerCycle
	IndVec1=[IndVec1,Ind+Lag:NShotPerCycle.*2:NShot];
	IndVec2=[IndVec2,Ind+Lag+NShotPerCycle:NShotPerCycle.*2:NShot];
end
IndVec1=sort(IndVec1);
IndVec2=sort(IndVec2);
Num1=length(IndVec1);
Num2=length(IndVec2);
Num=Num1;
if Num2<Num1
	IndVec1=IndVec1(1:Num2);
	Num=Num2;
end
if Num1<Num2
	IndVec2=IndVec2(1:Num1);
	Num=Num1;
end
LastShot=max(max(IndVec1),max(IndVec2));
if ShotOrderPlotStatus
	hFig1=figure('Units','normal','Position',[0 .65 .6 .35],'Color',[0 0 0],'Name',FigTitle,'NumberTitle','off');
	plot(IndVec1,ones(Num,1),'*')
	hold on
	plot(IndVec2,zeros(Num,1),'ro')
	hold off
	axis([Lag+1 LastShot -1 2]);
	XTick=[Lag+1:NShotPerCycle:LastShot];
	set(gca,'XTick',XTick,'YTickLabel',[0,int2str(XTick)],'YTick',[],'YTickLabel',[],'FontSize',16,'FontWeight','bold');
	xlabel('EPI Shot #','FontSize',20,'FontWeight','bold');
	pause(.001)
end
return;
