function CalcSpmMean(FolderMat)


%   CalcSpmMean

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.   



if nargin<1; FolderMat=[]; end
%based on
% promts for a series of images and averages them
% FORMAT spm_mean_ui
%_______________________________________________________________________
%
% spm_mean_ui simply averages a set of images to produce a mean image
% that is written as type int16 to "mean.img" (in the current directory).
%
% The images must have the same dimensions, orientations (as defined by
% the Origin header field or any associated *.mat files), and the same
% voxel sizes.
%
% This is not a "softmean" - zero voxels are treated as zero.
%_______________________________________________________________________
% @(#)spm_mean_ui.m	2.4 John Ashburner, Andrew Holmes 98/10/21
SCCSid = '2.4';


%-Say hello
%-----------------------------------------------------------------------
SPMid = spm('FnBanner',mfilename,SCCSid);
MaskStr='s1'
Mask=[MaskStr,'*.img']
DefFilePath=SetDefPath(1,'*.fMEG');
[NFolder,FolderMat]=ReadFileNames(FolderMat,DefFilePath,'Please choose a fMEG batch file:');

for FolderInd=1:NFolder
    Folder=FolderMat(FolderInd,:);
    Tmp=findstr(Folder,filesep);
    MeanPath=Folder(1:Tmp(end));
    MeanFile=[Folder(Tmp(end)+1:end),'.hdr'];
    eval(['cd ',MeanPath])
    MeanFilePath=[MeanPath,MeanFile];
    %-Select images & check dimensions, orientations and voxel sizes
    %-----------------------------------------------------------------------
    fprintf(' ...select files\n')
    P=spm_get('Files',Folder,Mask);
    NImg=size(P,1);
    fprintf(' ...number of images: %g\n',NImg)
    fprintf(' ...mapping & checking files\n')
    Vi = spm_vol(P);
    
    n  = prod(size(Vi));
    if n==0, fprintf('\t%s : no images selected\n\n',mfilename), return, end
    
    if n>1 & any(any(diff(cat(1,Vi.dim),1,1),1)&[1,1,1,0])
        error('images don''t all have same dimensions'), end
    if any(any(any(diff(cat(3,Vi.mat),1,3),3)))
        error('images don''t all have same orientation & voxel size'), end
    
    
    %-Compute mean and write headers etc.
    %-----------------------------------------------------------------------
    fprintf(' ...computing')
    Vo = struct(	'fname',MeanFile,...
        'dim',		[Vi(1).dim(1:3),4],...
        'mat',		Vi(1).mat,...
        'pinfo',	[1.0,0,0]',...
        'descrip',	'spm - mean image');
    
    %-Adjust scalefactors by 1/n to effect mean by summing
    for i=1:prod(size(Vi))
        Vi(i).pinfo(1:2,:) = Vi(i).pinfo(1:2,:)./n; 
    end;
    
    %-Write basic header
    spm_create_image(Vo);
    %-Use spm_add to do the donkey work
    Vo.pinfo(1,1) = spm_add(Vi,Vo);
    %-Write header (complete with scaling information)
    spm_create_image(Vo);    
    %-End - report back
    %-----------------------------------------------------------------------
    fprintf(' ...done\n')
    fprintf('\tMean image written to file ''%s''\n\n',Vo.fname)
end
