function[]=CalcTalStatBA(DegOfFree,TdFilePath,ValFilePath,MinNVox,MaxRange);

%   CalcTalStatBA

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.  

%  clear all
%  global BATValVec BAChar BACoorChar BAStrucChar RangeVec 
%  global RightBAStrucChar NRightStruc LeftBAStrucChar NLeftStruc NBilatStruc 
%  global BilatBAStrucChar XShortSortBAStrucChar DefStruc NDefStruc
%  global RightBACenterChar LeftBACenterChar 
%  global RightBAVec LeftBAVec CoorMat

if nargin<5; MaxRange=5; end
if nargin<4; MinNVox=5; end
if nargin<3; ValFilePath=[]; end
if nargin<2; TdFilePath=[]; end
if nargin<1; DegOfFree=20; end

DefStruc=char('Cerebellum 0');
DefStruc=char(DefStruc,'Precentral Gyrus 4');
DefStruc=char(DefStruc,'Precentral Gyrus 6');
DefStruc=char(DefStruc,'Postcentral Gyrus 1');
DefStruc=char(DefStruc,'Postcentral Gyrus 2');
DefStruc=char(DefStruc,'Postcentral Gyrus 3');
DefStruc=char(DefStruc,'Postcentral Gyrus 4');
DefStruc=char(DefStruc,'Paracentral Lobule 5');
DefStruc=char(DefStruc,'Inferior Frontal Gyrus 9');
DefStruc=char(DefStruc,'Inferior Frontal Gyrus 44');
DefStruc=char(DefStruc,'Inferior Frontal Gyrus 45');
DefStruc=char(DefStruc,'Inferior Frontal Gyrus 46');
DefStruc=char(DefStruc,'Inferior Frontal Gyrus 47');
DefStruc=char(DefStruc,'Middle Frontal Gyrus 6');
DefStruc=char(DefStruc,'Middle Frontal Gyrus 8');
DefStruc=char(DefStruc,'Middle Frontal Gyrus 9');
DefStruc=char(DefStruc,'Middle Frontal Gyrus 11');
DefStruc=char(DefStruc,'Middle Frontal Gyrus 18');
DefStruc=char(DefStruc,'Fusiform Gyrus 18');
DefStruc=char(DefStruc,'Fusiform Gyrus 19');
DefStruc=char(DefStruc,'Fusiform Gyrus 20');
DefStruc=char(DefStruc,'Fusiform Gyrus 37');
DefStruc=char(DefStruc,'Lingual Gyrus 17');
DefStruc=char(DefStruc,'Lingual Gyrus 18');
DefStruc=char(DefStruc,'Lingual Gyrus 19');
DefStruc=char(DefStruc,'Inferior Occipital Gyrus 17');
DefStruc=char(DefStruc,'Inferior Occipital Gyrus 18');
DefStruc=char(DefStruc,'Inferior Occipital Gyrus 19');
DefStruc=char(DefStruc,'Middle Occipital Gyrus 18');
DefStruc=char(DefStruc,'Middle Occipital Gyrus 19');
DefStruc=char(DefStruc,'Middle Occipital Gyrus 37');
DefStruc=char(DefStruc,'Superior Occipital Gyrus 19');
DefStruc=char(DefStruc,'Superior Occipital Gyrus 39');
DefStruc=char(DefStruc,'Inferior Temporal Gyrus 10');
DefStruc=char(DefStruc,'Inferior Temporal Gyrus 19');
DefStruc=char(DefStruc,'Inferior Temporal Gyrus 37');
DefStruc=char(DefStruc,'Inferior Temporal Gyrus 45');
DefStruc=char(DefStruc,'Middle Temporal Gyrus 19');
DefStruc=char(DefStruc,'Middle Temporal Gyrus 21');
DefStruc=char(DefStruc,'Middle Temporal Gyrus 37');
DefStruc=char(DefStruc,'Middle Temporal Gyrus 39');
DefStruc=char(DefStruc,'Superior Temporal Gyrus 29');
DefStruc=char(DefStruc,'Superior Temporal Gyrus 38');
DefStruc=char(DefStruc,'Superior Temporal Gyrus 41');
DefStruc=char(DefStruc,'Superior Temporal Gyrus 42');
DefStruc=char(DefStruc,'Cuneus 07');
DefStruc=char(DefStruc,'Cuneus 17');
DefStruc=char(DefStruc,'Cuneus 18');
DefStruc=char(DefStruc,'Cuneus 19');
DefStruc=char(DefStruc,'Cuneus 30');
DefStruc=char(DefStruc,'Precuneus 07');
DefStruc=char(DefStruc,'Precuneus 18');
DefStruc=char(DefStruc,'Precuneus 19');
DefStruc=char(DefStruc,'Precuneus 20');
DefStruc=char(DefStruc,'Precuneus 31');
DefStruc=char(DefStruc,'Precuneus 39');
DefStruc=char(DefStruc,'Sub-Gyral 39');
DefStruc=char(DefStruc,'Inferior Parietal Lobule 7');
DefStruc=char(DefStruc,'Superior Parietal Lobule 7');
DefStruc=char(DefStruc,'Angular Gyrus 39');
DefStruc=char(DefStruc,'Posterior Cingulate 30');
DefStruc=char(DefStruc,'Cingulate Gyrus 24');
DefStruc=char(DefStruc,'Cingulate Gyrus 32');
DefStruc=char(DefStruc,'Anterior Cingulate 10');
DefStruc=char(DefStruc,'Anterior Cingulate 25');
DefStruc=char(DefStruc,'Anterior Cingulate 32');
DefStruc=char(DefStruc,'Anterior Cingulate 33');
DefStruc=char(DefStruc,'Anterior Cingulate 42');
DefStruc=char(DefStruc,'Superior Temporal Gyrus 22');
DefStruc=char(DefStruc,'Parahippocampal Gyrus 27');
DefStruc=char(DefStruc,'Parahippocampal Gyrus 34');
DefStruc=char(DefStruc,'Parahippocampal Gyrus 35');
DefStruc=char(DefStruc,'Parahippocampal Gyrus 36');
DefStruc=char(DefStruc,'Transverse Temporal Gyrus 41');
DefStruc=char(DefStruc,'Postcentral Gyrus 43');
DefStruc=char(DefStruc,'Uncus 28');

NDefStruc=size(DefStruc,1);
%DefBAVec=[7 17 18 19 30 31 37 39 40];
DefBAVec=[0 1 2 3 4 5 6 7 8 9 10 11 13 17 18 19 20 21 22 23 24 25 27 28 29 30 31 32 33 34 35 36 37 38 39 40 41 42 43 44 45 46 47];
NDefBAVec=length(DefBAVec);

SortBySizeStatus=0
MinNVox=MinNVox
MaxRange=MaxRange
DegOfFree=DegOfFree

if isempty(TdFilePath)
    DefFolder=['D:\ValAro\00_Stats_NoScaling\RandStatsSmooth08\All\u001k20\Filtered']
    Mask=['TD*.*'];
    TdFilePath=spm_get(1,Mask,'Choose a Talairach Daemon file',DefFolder);
end
if isempty(ValFilePath)
    [TdFile,TdPath]=SepFilePath(TdFilePath)
    ValFile=TdFile(3:length(TdFile)-4);
    ValFile=[ValFile,'Val.txt'];
    ValFilePath=[TdPath,ValFile];
    if ~exist(ValFilePath)
        Mask=['*Val.txt'];
        ValFilePath=spm_get(1,Mask,'Choose a t-value text file',DefFolder)
        if isempty(ValFilePath); return; end
    end
end

TValVec=[];
if ~isempty(ValFilePath)
	LineInd=0;
	fidVal=fopen(ValFilePath,'r');
	while 1
    	LineInd=LineInd+1;
    	ValLine= fgetl(fidVal);
		if ~isstr(ValLine)
			break
		end
    	TValVec(LineInd)=str2num(ValLine);
	end
	fclose(fidVal);
end

fidTD=fopen(TdFilePath,'r');
LineInd=0;
TDFileStatus=1;
while 1
    LineInd=LineInd+1;
	TdLine = fgetl(fidTD);
	if ~isstr(TdLine)
		break
	end
	if ~isempty(findstr(TdLine,'Range='))
		TDFileStatus=2;
	end
end

fseek(fidTD,0,'bof');
TdLine = fgetl(fidTD);%First line
Ind=0;
LineInd=0;
if TDFileStatus==1
	fprintf(1,'Talairach Daemon file status: Simple structure\n\n')
	while 1
		TdLine = fgetl(fidTD);
		LineInd=LineInd+1;
		if ~isstr(TdLine)
			fprintf('\n\n');
            if Ind==0
			    fprintf('No BA voxel',Ind);
                return;
            else
                 fprintf('%g BA voxel ...  ',Ind);
                 break;
            end
		end
		if ~isempty(findstr(TdLine,'Brodmann')) | ~isempty(findstr(TdLine,'Cerebellum'))
			Ind=Ind+1;
			if round(Ind./25)==Ind./25
				fprintf('\n');
				fprintf('Found %g BA voxel ...  ',Ind);
			end
			Tmp=findstr(TdLine,',');
			TdCoorTmp=TdLine(Tmp(1)+2:Tmp(4)-1);
             if isempty(findstr(TdLine,'Cerebellum'))
			    TdLineTmp=[TdLine(Tmp(4)+2:Tmp(7)+4),',',TdLine(Tmp(8)+15:length(TdLine))];
            else
                TdLineTmp=[TdLine(Tmp(4)+2:Tmp(9)-1)];
            end
			LTdLineVec(Ind)=length(TdLineTmp);
			if Ind==1
				BAChar=char(TdLineTmp);
				BACoorChar=char(TdCoorTmp);
			else
				BAChar=char(BAChar,TdLineTmp);
				BACoorChar=char(BACoorChar,TdCoorTmp);
			end
			BAValIndVec(Ind)=LineInd;
		end
	end
    if Ind==0
        BATValVec=[];
    else
	    BATValVec=TValVec(BAValIndVec);
        if isempty(TValVec);
		    TValVec=ones(1,max(BAValIndVec));
	    end
    end
elseif TDFileStatus==2
	fprintf(1,'Talairach Daemon file status: Nearest gray matter\n\n')
	while 1
		TdLine = fgetl(fidTD);
		LineInd=LineInd+1;
		if ~isstr(TdLine)
			fprintf('\n\n');
            if Ind==0
			    fprintf('No BA voxel',Ind);
                return;
            else
                 fprintf('%g BA voxel ...  ',Ind);
                 break;
             end
		end
		if ~isempty(findstr(TdLine,'Brodmann'))
			Ind=Ind+1;
			if round(Ind./25)==Ind./25
				fprintf('\n');
				fprintf('Found %g BA voxel ...  ',Ind);
			end
			Tmp=findstr(TdLine,',');
			TdCoorTmp=TdLine(Tmp(1)+2:Tmp(4)-1);
			TdLineTmp=[TdLine(Tmp(4)+2:Tmp(7)+4),',',TdLine(Tmp(8)+15:Tmp(9)-1)];
			RangeVec(Ind)=str2num(TdLine(Tmp(9)+7:length(TdLine)));
			LTdLineVec(Ind)=length(TdLineTmp);
			if Ind==1
				BAChar=char(TdLineTmp);
				BACoorChar=char(TdCoorTmp);
			else
				BAChar=char(BAChar,TdLineTmp);
				BACoorChar=char(BACoorChar,TdCoorTmp);
			end
			BAValIndVec(Ind)=LineInd;
		end
	end
    if Ind==0
        BATValVec=[];
        TValVec=[];
    else
        %[MaxBATValVec,MaxBATValVecInd]=max(BATValVec)
        %BAChar(MaxBATValVecInd,:)
        %BACoorChar(MaxBATValVecInd,:)
        %pause
        MaxRangeIndVec=find(RangeVec<=MaxRange);
        BAChar=BAChar(MaxRangeIndVec,:);
        BACoorChar=BACoorChar(MaxRangeIndVec,:);
        BATValVec=BATValVec(MaxRangeIndVec);
        if isempty(TValVec);
		    TValVec=ones(1,max(BAValIndVec));
	    end
    end
end
fclose(fidTD);

BAZValVec=spm_t2z(BATValVec,DegOfFree,10^-16);

BATValTmp=BATValVec;
BAZValTmp=BAZValVec;

i=0;
BACharTmp=BAChar;
BACoorCharTmp=BACoorChar;
BAVec=[];
NRightStruc=0;
NLeftStruc=0;
RightBAStrucChar=[];
LeftBAStrucChar=[];
RightBAVec=[];
LeftBAVec=[];
while ~isempty(BACharTmp)
	i=i+1;
	Line=deblank(BACharTmp(1,:))
	if strcmp(Line(length(Line)),',')
		Line=Line(1:length(Line)-1);
	end
	Tmp1=findstr(Line,',')
    if isempty(findstr(Line,'Cerebellum'))
	    ActBA=str2num(Line(Tmp1(length(Tmp1))+1:length(Line)))
    else
        ActBA=0;
    end
	VoxInStrucIndVec=strmatch(Line,BACharTmp);
	NVoxInStruc=length(VoxInStrucIndVec);
	NVoxInStrucVec(i)=NVoxInStruc;
	VoxTValVec=BATValTmp(VoxInStrucIndVec);
	VoxZValVec=BAZValTmp(VoxInStrucIndVec);
	[MaxVoxTVal,MaxVoxTInd]=max(VoxTValVec);
   	[MaxVoxZVal,MaxVoxZInd]=max(VoxZValVec);
   	MaxBACoorChar=BACoorCharTmp(VoxInStrucIndVec(MaxVoxTInd),:);
   	SumVoxTValVec=sum(VoxTValVec);
	SumVoxZValVec=sum(VoxZValVec);
	MeanTValInStrucVec(i)=mean(VoxTValVec);
	MeanZValInStrucVec(i)=mean(VoxZValVec);
	CoorMat=zeros(NVoxInStruc,3);
	for m=1:NVoxInStruc
		CoorLine=deblank(BACoorCharTmp(VoxInStrucIndVec(m),:));
		Tmp=findstr(CoorLine,',');
		Coor1=CoorLine(1:Tmp(1)-1);
		Coor2=CoorLine(Tmp(1)+2:Tmp(2)-1);
		Coor3=CoorLine(Tmp(2)+2:length(CoorLine));
		CoorMat(m,:)=[str2num(Coor1),str2num(Coor2),str2num(Coor3)];
	end
	if NVoxInStruc>1
		MeanCoorVec=round(mean(CoorMat));
	else
		MeanCoorVec=round(CoorMat);
	end
	MeanTWeightCoorVec=MeanCoorVec;
	MeanZWeightCoorVec=MeanCoorVec;
	CoorMatTTmp=CoorMat;
	CoorMatZTmp=CoorMat;
	for j=1:3
		CoorMatTTmp(:,j)=CoorMatTTmp(:,j).*VoxTValVec';
		CoorMatZTmp(:,j)=CoorMatZTmp(:,j).*VoxZValVec';
		MeanTWeightCoorVec(j)=round(sum(CoorMatTTmp(:,j))./SumVoxTValVec);
		MeanZWeightCoorVec(j)=round(sum(CoorMatZTmp(:,j))./SumVoxZValVec);
	end
	TmpLine1=[',',num2str(NVoxInStrucVec(i))];
	TmpLine2=[',',num2str(round(MaxVoxTVal.*100)./100),',',num2str(round(MeanTValInStrucVec(i).*100)./100)];
	TmpLine3=[',',num2str(round(MaxVoxZVal.*100)./100),',',num2str(round(MeanZValInStrucVec(i).*100)./100)];
	TmpLine4=[',',num2str(round(CoorMat(MaxVoxTInd,1))),' ',num2str(round(CoorMat(MaxVoxTInd,2))),' ',num2str(round(CoorMat(MaxVoxTInd,3)))];
	TmpLine5=[',',num2str(MeanCoorVec)];
	TmpLine6=[',',num2str(MeanTWeightCoorVec)];
	TmpLine7=[',',num2str(MeanZWeightCoorVec)];
	if ~isempty(findstr(Line,'Right')) 
		NRightStruc=NRightStruc+1;
		RightBAVec(NRightStruc)=ActBA;
		for k=1:NDefBAVec
			if ~any(DefBAVec==ActBA)
				fprintf(1,'Right BA %g not in DefBAVec',ActBA)
				pause
			end
		end
		NRightVoxInStrucVec(NRightStruc)=NVoxInStruc;
		RightBAStrucChar=char(RightBAStrucChar,[Line,TmpLine1,TmpLine2,TmpLine3,TmpLine4,TmpLine5,TmpLine6,TmpLine7]);
	else
		NLeftStruc=NLeftStruc+1
		ActBA
		LeftBAVec(NLeftStruc)=ActBA
		for k=1:NDefBAVec
			if ~any(DefBAVec==ActBA)
				fprintf(1,'Left BA %g not in DefBAVec',ActBA)
				pause
			end
		end
		NLeftVoxInStrucVec(NLeftStruc)=NVoxInStruc;
		LeftBAStrucChar=char(LeftBAStrucChar,[Line,TmpLine1,TmpLine2,TmpLine3,TmpLine4,TmpLine5,TmpLine6,TmpLine7]);
	end
	NRestLines=size(BACharTmp,1);
	l=0;
	RestIndVec=[];
	for k=1:NRestLines
		if all(VoxInStrucIndVec-k)
			l=l+1;
			RestIndVec(l)=k;
		end
	end
	BATValTmp=BATValTmp(RestIndVec);
   	BAZValTmp=BAZValTmp(RestIndVec);
	BACharTmp=BACharTmp(RestIndVec,:);
	BACoorCharTmp=BACoorCharTmp(RestIndVec,:);
end	

if NRightStruc>0
	RightBAStrucChar=RightBAStrucChar(2:size(RightBAStrucChar,1),:);
	%===================================================================
% 	SumBAChar='BA,Side,NVox,MaxT,MaxZ,MaxCoor';
	SumBAChar='BA,Side,NVox,MaxT,MaxCoor';
	RightBACenterChar=',BA,R-NVox,R-MaxT,R-MaxCoor';
	for i=1:NDefBAVec
		RightSumBAStr=[int2str(DefBAVec(i)),',R,'];
		RightCenterBAStr=[',',int2str(DefBAVec(i)),',,,'];
		IndVec=find(RightBAVec==DefBAVec(i));
		NIndVec=length(IndVec);
		if NIndVec>0
			NVoxVec=zeros(NIndVec,1);
			MaxTVec=zeros(NIndVec,1);
			MaxZVec=zeros(NIndVec,1);
			MaxZCoorMat=zeros(NIndVec,3);
			for j=1:length(IndVec)
				Line=deblank(RightBAStrucChar(IndVec(j),:));
				Tmp1=findstr(Line,',');
				NVoxVec(j)=str2num(Line(Tmp1(5)+1:Tmp1(6)-1));
				MaxTVec(j)=str2num(Line(Tmp1(6)+1:Tmp1(7)-1));
				MaxZVec(j)=str2num(Line(Tmp1(8)+1:Tmp1(9)-1));
				MaxZCoorMat(j,:)=str2num(Line(Tmp1(10)+1:Tmp1(11)-1));
			end
			[MaxMaxTVal,MaxMaxTInd]=max(MaxTVec);
			MaxMaxZVal=MaxZVec(MaxMaxTInd);
			SumNVox=sum(NVoxVec);
			MaxMaxZCoorVec=MaxZCoorMat(MaxMaxTInd,:);
% 			RightSumBAStr=[RightSumBAStr,int2str(SumNVox),',',num2str(MaxMaxTVal),',',num2str(MaxMaxZVal),',',num2str(MaxMaxZCoorVec)];
			RightSumBAStr=[RightSumBAStr,int2str(SumNVox),',',num2str(MaxMaxTVal),',',num2str(MaxMaxZCoorVec)];
			RightCenterBAStr=[',',int2str(DefBAVec(i)),',',int2str(SumNVox),',',num2str(MaxMaxTVal),',',num2str(MaxMaxZCoorVec)];
		end
		SumBAChar=char(SumBAChar,RightSumBAStr);
		SumBAChar=char(SumBAChar,'');
		RightBACenterChar=char(RightBACenterChar,RightCenterBAStr);
	end
	%===================================================================
	RightDiffLobeChar='Gyrus,BA,Side,Lobe_1,NVox_1,MaxT_1,MaxZ_1,MaxCoor_1,Lobe_2,NVox_2,MaxT_2,MaxZ_2,MaxCoor_2,Lobe_3,NVox_3,MaxT_3,MaxZ_3,MaxCoor_3';
	SumLobeChar='Gyrus,BA,Side,NVox,MaxT,MaxZ,MaxCoor';
	for i=1:NDefStruc
		DefStrucTmp1=deblank(DefStruc(i,:));
		DefStrucTmp2=DefStrucTmp1(1:length(DefStrucTmp1)-3);
		DefBAStr=DefStrucTmp1(length(DefStrucTmp1)-1:length(DefStrucTmp1));
		DefBA=str2num(DefBAStr);
		RightDiffLobeStr=[DefStrucTmp2,',',DefBAStr,',R',];
		RightSumLobeStr=RightDiffLobeStr;
		NLobe=0;
		MaxTVec=[];
		MaxZVec=[];
		NVoxVec=[];
		for j=1:NRightStruc
			Line=deblank(RightBAStrucChar(j,:));
			Tmp1=findstr(Line,',');
			Lobe=Line(Tmp1(1)+1:Tmp1(2)-1);
			Gyrus=Line(Tmp1(2)+1:Tmp1(3)-1);
			BAStr=Line(Tmp1(4)+1:Tmp1(5)-1);
			NVoxStr=Line(Tmp1(5)+1:Tmp1(6)-1);
			MaxTStr=Line(Tmp1(6)+1:Tmp1(7)-1);
			MaxZStr=Line(Tmp1(8)+1:Tmp1(9)-1);
			MaxZCoorStr=Line(Tmp1(10)+1:Tmp1(11)-1);
			BA=str2num(BAStr);
			if ~isempty(findstr(Gyrus,DefStrucTmp2)) & DefBA==BA
				if ~isempty(findstr(Lobe,'Occipital'))
					Lobe='Occipital Lobe';
				elseif ~isempty(findstr(Lobe,'Temporal'))
					Lobe='Temporal Lobe';
				elseif ~isempty(findstr(Lobe,'Parietal'))
					Lobe='Parietal Lobe';
				elseif ~isempty(findstr(Lobe,'Limbic'))
					Lobe='Limbic Lobe';
				elseif ~isempty(findstr(Lobe,'*'))
					Lobe='* Lobe';
				end
				RightDiffLobeStr=[RightDiffLobeStr,',',Lobe,',',NVoxStr,',',MaxTStr,',',MaxZStr,',',MaxZCoorStr];
				NLobe=NLobe+1;
				NVoxVec(NLobe)=str2num(NVoxStr);
				MaxTVec(NLobe)=str2num(MaxTStr);
				MaxZVec(NLobe)=str2num(MaxZStr);
				MaxZCoorMatNew=zeros(NLobe,3);
				if NLobe>1
					MaxZCoorMatNew(1:NLobe-1,:)=MaxZCoorMatOld;
				end
				MaxZCoorMatNew(NLobe,:)=str2num(MaxZCoorStr);
				MaxZCoorMatOld=MaxZCoorMatNew;
			end
		end
		RightDiffLobeChar=char(RightDiffLobeChar,RightDiffLobeStr);
		if NLobe>0
			[MaxMaxTVal,MaxMaxTInd]=max(MaxTVec);
			MaxMaxZVal=MaxZVec(MaxMaxTInd);
			SumNVox=sum(NVoxVec);
			MaxMaxZCoorVec=MaxZCoorMatNew(MaxMaxTInd,:);
			RightSumLobeStr=[RightSumLobeStr,',',int2str(SumNVox),',',num2str(MaxMaxTVal),',',num2str(MaxMaxZVal),',',num2str(MaxMaxZCoorVec)];
		end
		SumLobeChar=char(SumLobeChar,RightSumLobeStr);
		SumLobeChar=char(SumLobeChar,'');
	end
	RightDiffLobeChar
	SumLobeChar
end
if NLeftStruc>0
	LeftBAStrucChar=LeftBAStrucChar(2:size(LeftBAStrucChar,1),:);
	LeftBACenterChar='L-MaxCoor,L-MaxT,L-NVox';
	%===================================================================
	for i=1:NDefBAVec
		LeftSumBAStr=',L,';
		LeftCenterBAStr=[',,'];
		IndVec=find(LeftBAVec==DefBAVec(i));
		NIndVec=length(IndVec);
		if NIndVec>0
			NVoxVec=zeros(NIndVec,1);
			MaxTVec=zeros(NIndVec,1);
			MaxZVec=zeros(NIndVec,1);
			MaxZCoorMat=zeros(NIndVec,3);
			for j=1:length(IndVec)
				Line=deblank(LeftBAStrucChar(IndVec(j),:));
				Tmp1=findstr(Line,',');
				NVoxVec(j)=str2num(Line(Tmp1(5)+1:Tmp1(6)-1));
				MaxTVec(j)=str2num(Line(Tmp1(6)+1:Tmp1(7)-1));
				MaxZVec(j)=str2num(Line(Tmp1(8)+1:Tmp1(9)-1));
				MaxZCoorMat(j,:)=str2num(Line(Tmp1(10)+1:Tmp1(11)-1));
			end
			[MaxMaxTVal,MaxMaxTInd]=max(MaxTVec);
			MaxMaxZVal=MaxZVec(MaxMaxTInd);
			SumNVox=sum(NVoxVec);
			MaxMaxZCoorVec=MaxZCoorMat(MaxMaxTInd,:);
			%LeftSumBAStr=[LeftSumBAStr,int2str(SumNVox),',',num2str(MaxMaxTVal),',',num2str(MaxMaxZVal),',',num2str(MaxMaxZCoorVec)];
			LeftSumBAStr=[LeftSumBAStr,int2str(SumNVox),',',num2str(MaxMaxTVal),',',num2str(MaxMaxZCoorVec)];
			LeftCenterBAStr=[num2str(MaxMaxZCoorVec),',',num2str(MaxMaxTVal),',',int2str(SumNVox)];
		end
		SumBAChar(1+i.*2,1:length(LeftSumBAStr))=LeftSumBAStr;
		LeftBACenterChar=char(LeftBACenterChar,LeftCenterBAStr);
	end
	%===================================================================
	LeftDiffLobeChar='Gyrus,BA,Side,Lobe_1,NVox_1,MaxT_1,MaxZ_1,MaxCoor_1,Lobe_2,NVox_2,MaxT_2,MaxZ_2,MaxCoor_2,Lobe_3,NVox_3,MaxT_3,MaxZ_3,MaxCoor_3';
	for i=1:NDefStruc
		DefStrucTmp1=deblank(DefStruc(i,:));
		DefStrucTmp2=DefStrucTmp1(1:length(DefStrucTmp1)-3);
		DefBAStr=DefStrucTmp1(length(DefStrucTmp1)-1:length(DefStrucTmp1));
		DefBA=str2num(DefBAStr);
		LeftDiffLobeStr=[DefStrucTmp2,',',DefBAStr,',L',];
		LeftSumLobeStr=',,L';
		NLobe=0;
		MaxTStr=[];
		MaxTVec=[];
		MaxZVec=[];
		NVoxVec=[];
		for j=1:NLeftStruc
			Line=deblank(LeftBAStrucChar(j,:));
			Tmp1=findstr(Line,',');
			Lobe=Line(Tmp1(1)+1:Tmp1(2)-1);
			Gyrus=Line(Tmp1(2)+1:Tmp1(3)-1);
			BAStr=Line(Tmp1(4)+1:Tmp1(5)-1);
			NVoxStr=Line(Tmp1(5)+1:Tmp1(6)-1);
			MaxTStr=Line(Tmp1(6)+1:Tmp1(7)-1);
			MaxZStr=Line(Tmp1(8)+1:Tmp1(9)-1);
			MaxZCoorStr=Line(Tmp1(10)+1:Tmp1(11)-1);
			BA=str2num(BAStr);
			if ~isempty(findstr(Gyrus,DefStrucTmp2)) & DefBA==BA
				if ~isempty(findstr(Lobe,'Occipital'))
					Lobe='Occipital Lobe';
				elseif ~isempty(findstr(Lobe,'Temporal'))
					Lobe='Temporal Lobe';
				elseif ~isempty(findstr(Lobe,'Parietal'))
					Lobe='Parietal Lobe';
				elseif ~isempty(findstr(Lobe,'Limbic'))
					Lobe='Limbic Lobe';
				elseif ~isempty(findstr(Lobe,'*'))
					Lobe='* Lobe';
				end
				LeftDiffLobeStr=[LeftDiffLobeStr,',',Lobe,',',NVoxStr,',',MaxTStr,',',MaxZStr,',',MaxZCoorStr];
				NLobe=NLobe+1;
				NVoxVec(NLobe)=str2num(NVoxStr);
				MaxTVec(NLobe)=str2num(MaxTStr);
				MaxZVec(NLobe)=str2num(MaxZStr);
				MaxZCoorMatNew=zeros(NLobe,3);
				if NLobe>1
					MaxZCoorMatNew(1:NLobe-1,:)=MaxZCoorMatOld;
				end
				MaxZCoorMatNew(NLobe,:)=str2num(MaxZCoorStr);
				MaxZCoorMatOld=MaxZCoorMatNew;
			end
		end
		LeftDiffLobeChar=char(LeftDiffLobeChar,LeftDiffLobeStr);
		if NLobe>0
			[MaxMaxTVal,MaxMaxTInd]=max(MaxTVec);
			MaxMaxZVal=MaxZVec(MaxMaxTInd);
			SumNVox=sum(NVoxVec);
			MaxMaxZCoorVec=MaxZCoorMatNew(MaxMaxTInd,:);
			LeftSumLobeStr=[LeftSumLobeStr,',',int2str(SumNVox),',',num2str(MaxMaxTVal),',',num2str(MaxMaxZVal),',',num2str(MaxMaxZCoorVec)];
		end
		SumLobeChar(1+i.*2,1:length(LeftSumLobeStr))=LeftSumLobeStr;
	end
	LeftDiffLobeChar=LeftDiffLobeChar
	SumLobeChar=SumLobeChar
end

RightLeftDiffLobeChar=char(RightDiffLobeChar,'');
RightLeftDiffLobeChar=char(RightLeftDiffLobeChar,LeftDiffLobeChar);
BACenterChar=strcat(LeftBACenterChar,RightBACenterChar);

if SortBySizeStatus
	[NonUse,SortNRightVoxInStrucVec]=sort(-NRightVoxInStrucVec);
	RightBAStrucChar=RightBAStrucChar(SortNRightVoxInStrucVec,:);
	[NonUse,SortNLeftVoxInStrucVec]=sort(-NLeftVoxInStrucVec);
	LeftBAStrucChar=LeftBAStrucChar(SortNLeftVoxInStrucVec,:);
else
	if NRightStruc>1
		for i=1:NRightStruc
			Tmp1=findstr(RightBAStrucChar(i,:),',');
			Tmp2=RightBAStrucChar(i,Tmp1(2)+1:Tmp1(3)-1);
			if ~isempty(findstr(Tmp2,'Inferior'))
				Tmp2=[Tmp2(10:length(Tmp2)),' Inferior'];
			elseif ~isempty(findstr(Tmp2,'Middle'))
				Tmp2=[Tmp2(8:length(Tmp2)),' Middle'];
			elseif ~isempty(findstr(Tmp2,'Superior'))
				Tmp2=[Tmp2(10:length(Tmp2)),' Superior'];
			end
			if i==1
				RightBAStrucCharTmp=char(Tmp2);
			else
				RightBAStrucCharTmp=char(RightBAStrucCharTmp,Tmp2);
			end
		end
		[NonUse,SortNRightVoxInStrucVec]=sort(RightBAStrucCharTmp);
		RightBAStrucChar=RightBAStrucChar(SortNRightVoxInStrucVec(:,1),:);
	end
	if NLeftStruc>1
		for i=1:NLeftStruc
			Tmp1=findstr(LeftBAStrucChar(i,:),',');
			Tmp2=LeftBAStrucChar(i,Tmp1(2)+1:Tmp1(3)-1);
			if ~isempty(findstr(Tmp2,'Inferior'))
				Tmp2=[Tmp2(10:length(Tmp2)),' Inferior'];
			elseif ~isempty(findstr(Tmp2,'Middle'))
				Tmp2=[Tmp2(8:length(Tmp2)),' Middle'];
			elseif ~isempty(findstr(Tmp2,'Superior'))
				Tmp2=[Tmp2(10:length(Tmp2)),' Superior'];
			end
			if i==1
				LeftBAStrucCharTmp=char(Tmp2);
			else
				LeftBAStrucCharTmp=char(LeftBAStrucCharTmp,Tmp2);
			end
		end
		[NonUse,SortNLeftVoxInStrucVec]=sort(LeftBAStrucCharTmp);
		LeftBAStrucChar=LeftBAStrucChar(SortNLeftVoxInStrucVec(:,1),:);
	end
end
NBilatStruc=0;
NJustRightStruc=0;
NJustLeftStruc=0;
BilatBAStrucChar=[];
JustRightBAStrucChar=[];
JustLeftBAStrucChar=[];
for i=1:NRightStruc	
	RightLine=RightBAStrucChar(i,:);
	Tmp=findstr(RightLine,',');
	RightLineTmp=deblank(RightLine(Tmp(1)+1:Tmp(5)-1));
	BilatStatus=0;
	j=0;
	while j<NLeftStruc
		j=j+1;
		LeftLine=LeftBAStrucChar(j,:);
		if ~isempty(findstr(LeftLine,RightLineTmp))
			BilatStatus=1;
			NBilatStruc=NBilatStruc+1;
			LeftBilatVec(NBilatStruc)=j;
			BilatBAStrucChar=char(BilatBAStrucChar,RightLine);
			BilatBAStrucChar=char(BilatBAStrucChar,LeftLine);
			break
		end
	end
	if ~BilatStatus
		NJustRightStruc=NJustRightStruc+1;
		JustRightBAStrucChar=char(JustRightBAStrucChar,RightLine);
	end
end
for j=1:NLeftStruc
	if all(LeftBilatVec-j)
		NJustLeftStruc=NJustLeftStruc+1;
		JustLeftBAStrucChar=char(JustLeftBAStrucChar,LeftBAStrucChar(j,:));
	end
end
ShortBilatBAStrucChar=[];
XShortBilatBAStrucChar=[];
if NBilatStruc>0
	BilatBAStrucChar=BilatBAStrucChar(2:size(BilatBAStrucChar,1),:);
	for i=1:size(BilatBAStrucChar,1)
      	Line=deblank(BilatBAStrucChar(i,:));
		Tmp=findstr(Line,',');
		Lobe=Line(Tmp(1)+1:Tmp(2)-1);
		Gyrus=Line(Tmp(2)+1:Tmp(3)-1);
		if ~isempty(findstr(Lobe,'Occipital')) & isempty(findstr(Gyrus,'Occipital'))
			AddLobe=' (Occipital)';
		elseif ~isempty(findstr(Lobe,'Temporal')) & isempty(findstr(Gyrus,'Temporal'))
			AddLobe=' (Temporal)';
		elseif ~isempty(findstr(Lobe,'Parietal')) & isempty(findstr(Gyrus,'Parietal'))
			AddLobe=' (Parietal)';
		elseif ~isempty(findstr(Lobe,'Frontal')) & isempty(findstr(Gyrus,'Frontal'))
			AddLobe=' (Frontal)';
		elseif ~isempty(findstr(Lobe,'*')) & isempty(findstr(Gyrus,'*'))
			AddLobe=' (*)';
		else
			AddLobe=[];
		end
		NBilatVox=Line(Tmp(5)+1:Tmp(6)-1);
		NBilatVoxVec(i)=str2num(NBilatVox);
		if ~isempty(findstr(Line,'Right'))
			XLine=[Line(1:5),' ',Line(Tmp(2)+1:Tmp(3)-1),AddLobe,Line(Tmp(4):Tmp(7)-1),Line(Tmp(8):Tmp(9)-1),Line(Tmp(10):Tmp(11)-1)];
			Line=[Line(1:5),' ',Line(Tmp(2)+1:Tmp(3)-1),AddLobe,Line(Tmp(4):Tmp(12)-1)];
		else
			XLine=[Line(1:5),Line(Tmp(2)+1:Tmp(3)-1),AddLobe,Line(Tmp(4):Tmp(7)-1),Line(Tmp(8):Tmp(9)-1),Line(Tmp(10):Tmp(11)-1)];
			Line=[Line(1:5),Line(Tmp(2)+1:Tmp(3)-1),AddLobe,Line(Tmp(4):Tmp(12)-1)];
		end
      	ShortBilatBAStrucChar=char(ShortBilatBAStrucChar,Line);
		XShortBilatBAStrucChar=char(XShortBilatBAStrucChar,XLine);
	end
   	ShortBilatBAStrucChar=ShortBilatBAStrucChar(2:size(ShortBilatBAStrucChar,1),:);
	XShortBilatBAStrucChar=XShortBilatBAStrucChar(2:size(XShortBilatBAStrucChar,1),:);
	NMinVoxIndVec=find(NBilatVoxVec>=MinNVox);
	MinBilatBAStrucChar=BilatBAStrucChar(NMinVoxIndVec,:);
   	MinShortBilatBAStrucChar=ShortBilatBAStrucChar(NMinVoxIndVec,:);
	XMinShortBilatBAStrucChar=XShortBilatBAStrucChar(NMinVoxIndVec,:);
end
ShortJustRightBAStrucChar=[];
XShortJustRightBAStrucChar=[];
if NJustRightStruc>0
	JustRightBAStrucChar=JustRightBAStrucChar(2:size(JustRightBAStrucChar,1),:);
	for i=1:size(JustRightBAStrucChar,1)
		Line=deblank(JustRightBAStrucChar(i,:));
		Tmp=findstr(Line,',');
		Lobe=Line(Tmp(1)+1:Tmp(2)-1);
		Gyrus=Line(Tmp(2)+1:Tmp(3)-1);
		if ~isempty(findstr(Lobe,'Occipital')) & isempty(findstr(Gyrus,'Occipital'))
			AddLobe=' (Occipital)';
		elseif ~isempty(findstr(Lobe,'Temporal')) & isempty(findstr(Gyrus,'Temporal'))
			AddLobe=' (Temporal)';
		elseif ~isempty(findstr(Lobe,'Parietal')) & isempty(findstr(Gyrus,'Parietal'))
			AddLobe=' (Parietal)';
		elseif ~isempty(findstr(Lobe,'Frontal')) & isempty(findstr(Gyrus,'Frontal'))
			AddLobe=' (Frontal)';
		elseif ~isempty(findstr(Lobe,'*')) & isempty(findstr(Gyrus,'*'))
			AddLobe=' (*)';
		else
			AddLobe=[];
		end
		NJustRightVox=Line(Tmp(5)+1:Tmp(6)-1);
		NJustRightVoxVec(i)=str2num(NJustRightVox);
		XLine=[Line(Tmp(2)+1:Tmp(3)-1),AddLobe,Line(Tmp(4):Tmp(7)-1),Line(Tmp(8):Tmp(9)-1),Line(Tmp(10):Tmp(11)-1)];
		XShortJustRightBAStrucChar=char(XShortJustRightBAStrucChar,XLine);
		Line=[Line(Tmp(2)+1:Tmp(3)-1),AddLobe,Line(Tmp(4):Tmp(12)-1)];
		ShortJustRightBAStrucChar=char(ShortJustRightBAStrucChar,Line);
	end
	ShortJustRightBAStrucChar=ShortJustRightBAStrucChar(2:size(ShortJustRightBAStrucChar,1),:);
	XShortJustRightBAStrucChar=XShortJustRightBAStrucChar(2:size(XShortJustRightBAStrucChar,1),:);
	NMinVoxIndVec=find(NJustRightVoxVec>=MinNVox);
	MinJustRightBAStrucChar=JustRightBAStrucChar(NMinVoxIndVec,:);
	MinShortJustRightBAStrucChar=ShortJustRightBAStrucChar(NMinVoxIndVec,:);
	XMinShortJustRightBAStrucChar=XShortJustRightBAStrucChar(NMinVoxIndVec,:);
end
ShortJustLeftBAStrucChar=[];
XShortJustLeftBAStrucChar=[];
if NJustLeftStruc>0
	JustLeftBAStrucChar=JustLeftBAStrucChar(2:size(JustLeftBAStrucChar,1),:);
	for i=1:size(JustLeftBAStrucChar,1)
		Line=deblank(JustLeftBAStrucChar(i,:));
		Tmp=findstr(Line,',');
		Lobe=Line(Tmp(1)+1:Tmp(2)-1);
		Gyrus=Line(Tmp(2)+1:Tmp(3)-1);
		if ~isempty(findstr(Lobe,'Occipital')) & isempty(findstr(Gyrus,'Occipital'))
			AddLobe=' (Occipital)';
		elseif ~isempty(findstr(Lobe,'Temporal')) & isempty(findstr(Gyrus,'Temporal'))
			AddLobe=' (Temporal)';
		elseif ~isempty(findstr(Lobe,'Parietal')) & isempty(findstr(Gyrus,'Parietal'))
			AddLobe=' (Parietal)';
		elseif ~isempty(findstr(Lobe,'Frontal')) & isempty(findstr(Gyrus,'Frontal'))
			AddLobe=' (Frontal)';
		elseif ~isempty(findstr(Lobe,'*')) & isempty(findstr(Gyrus,'*'))
			AddLobe=' (*)';
		else
			AddLobe=[];
		end
		NJustLeftVox=Line(Tmp(5)+1:Tmp(6)-1);
		NJustLeftVoxVec(i)=str2num(NJustLeftVox);
		XLine=[Line(Tmp(2)+1:Tmp(3)-1),AddLobe,Line(Tmp(4):Tmp(7)-1),Line(Tmp(8):Tmp(9)-1),Line(Tmp(10):Tmp(11)-1)];
		XShortJustLeftBAStrucChar=char(XShortJustLeftBAStrucChar,XLine);
		Line=[Line(Tmp(2)+1:Tmp(3)-1),AddLobe,Line(Tmp(4):Tmp(12)-1)];
		ShortJustLeftBAStrucChar=char(ShortJustLeftBAStrucChar,Line);
	end
	ShortJustLeftBAStrucChar=ShortJustLeftBAStrucChar(2:size(ShortJustLeftBAStrucChar,1),:);
	XShortJustLeftBAStrucChar=XShortJustLeftBAStrucChar(2:size(XShortJustLeftBAStrucChar,1),:);
	NMinVoxIndVec=find(NJustLeftVoxVec>=MinNVox);
	MinJustLeftBAStrucChar=JustLeftBAStrucChar(NMinVoxIndVec,:);
	MinShortJustLeftBAStrucChar=ShortJustLeftBAStrucChar(NMinVoxIndVec,:);
	XMinShortJustLeftBAStrucChar=XShortJustLeftBAStrucChar(NMinVoxIndVec,:);
end
%==============================================================================

SortBAStrucChar=char('Bilateral',BilatBAStrucChar,'Right',JustRightBAStrucChar,'Left',JustLeftBAStrucChar)
MinSortBAStrucChar=char('Bilateral',MinBilatBAStrucChar,'Right',MinJustRightBAStrucChar,'Left',MinJustLeftBAStrucChar)
ShortSortBAStrucChar=char('Bilateral',MinShortBilatBAStrucChar,'Right',MinShortJustRightBAStrucChar,'Left',MinShortJustLeftBAStrucChar)
XShortSortBAStrucChar=char('Bilateral',XMinShortBilatBAStrucChar,'Right',XMinShortJustRightBAStrucChar,'Left',XMinShortJustLeftBAStrucChar)
SumBAChar=SumBAChar
BACenterChar=BACenterChar

%==============================================================================
if TDFileStatus==1
	OutFilePath=[TdFilePath(1:length(TdFilePath)-4),'_S.txt'];
elseif TDFileStatus==2
	OutFilePath=[TdFilePath(1:length(TdFilePath)-4),'_SR',int2str(MaxRange),'.txt'];
end
fidOut=fopen(OutFilePath,'w');
fprintf(fidOut,'Right/Left,Lobe,Gyrus,Gray/White,BA,NVox,Max. t,Mean t,Max. Z,Mean Z,Max. xyz,Mean xyz,t-weighted xyz,Z-weighted xyz\n');
for i=1:size(SortBAStrucChar,1)
	Line=deblank(SortBAStrucChar(i,:));
	fprintf(fidOut,Line);
	fprintf(fidOut,'\n');
end
fclose(fidOut);

%==============================================================================
if TDFileStatus==1
	OutFilePath=[TdFilePath(1:length(TdFilePath)-4),'_SM',int2str(MinNVox),'.txt'];
elseif TDFileStatus==2
	OutFilePath=[TdFilePath(1:length(TdFilePath)-4),'_SM',int2str(MinNVox),'R',int2str(MaxRange),'.txt'];
end
fidOut=fopen(OutFilePath,'w');
fprintf(fidOut,'Right/Left,Lobe,Gyrus,Gray/White,BA,NVox,Max. t,Mean t,Max. Z,Mean Z,Max. xyz,Mean xyz,t-weighted xyz,Z-weighted xyz\n');
for i=1:size(MinSortBAStrucChar,1)
	Line=deblank(MinSortBAStrucChar(i,:));
	fprintf(fidOut,Line);
	fprintf(fidOut,'\n');
end
fclose(fidOut);
%==============================================================================
if TDFileStatus==1
	OutFilePath=[TdFilePath(1:length(TdFilePath)-4),'_SSM',int2str(MinNVox),'.txt'];
elseif TDFileStatus==2
	OutFilePath=[TdFilePath(1:length(TdFilePath)-4),'_SSM',int2str(MinNVox),'R',int2str(MaxRange),'.txt'];
end
fidOut=fopen(OutFilePath,'w');
fprintf(fidOut,'Gyrus,BA,NVox,Max. t,Mean t,Max. Z,Mean Z,Max. xyz,Mean xyz\n');
for i=1:size(ShortSortBAStrucChar,1)
	Line=deblank(ShortSortBAStrucChar(i,:));
	fprintf(fidOut,Line);
	fprintf(fidOut,'\n');
end
fclose(fidOut);
%==============================================================================
if TDFileStatus==1
	OutFilePath=[TdFilePath(1:length(TdFilePath)-4),'_XSM',int2str(MinNVox),'.txt'];
elseif TDFileStatus==2
	OutFilePath=[TdFilePath(1:length(TdFilePath)-4),'_XSM',int2str(MinNVox),'R',int2str(MaxRange),'.txt'];
end
fidOut=fopen(OutFilePath,'w');
fprintf(fidOut,'Gyrus,BA,NVox,Max. t,Max. Z,Max. xyz\n');
for i=1:size(XShortSortBAStrucChar,1)
	Line=deblank(XShortSortBAStrucChar(i,:));
	fprintf(fidOut,Line);
	fprintf(fidOut,'\n');
end
fclose(fidOut);
%==============================================================================
if TDFileStatus==1
	OutFilePath=[TdFilePath(1:length(TdFilePath)-4),'_RDL',int2str(MinNVox),'.txt'];
elseif TDFileStatus==2
	OutFilePath=[TdFilePath(1:length(TdFilePath)-4),'_RDL',int2str(MinNVox),'R',int2str(MaxRange),'.txt'];
end
fidOut=fopen(OutFilePath,'w');
for i=1:size(RightDiffLobeChar,1)
	Line=deblank(RightDiffLobeChar(i,:));
	fprintf(fidOut,Line);
	fprintf(fidOut,'\n');
end
fclose(fidOut);
%==============================================================================
if TDFileStatus==1
	OutFilePath=[TdFilePath(1:length(TdFilePath)-4),'_LDL',int2str(MinNVox),'.txt'];
elseif TDFileStatus==2
	OutFilePath=[TdFilePath(1:length(TdFilePath)-4),'_LDL',int2str(MinNVox),'R',int2str(MaxRange),'.txt'];
end
fidOut=fopen(OutFilePath,'w');
for i=1:size(LeftDiffLobeChar,1)
	Line=deblank(LeftDiffLobeChar(i,:));
	fprintf(fidOut,Line);
	fprintf(fidOut,'\n');
end
fclose(fidOut);
%==============================================================================
if TDFileStatus==1
	OutFilePath=[TdFilePath(1:length(TdFilePath)-4),'_SL',int2str(MinNVox),'.txt'];
elseif TDFileStatus==2
	OutFilePath=[TdFilePath(1:length(TdFilePath)-4),'_SL',int2str(MinNVox),'R',int2str(MaxRange),'.txt'];
end
fidOut=fopen(OutFilePath,'w');
for i=1:size(SumLobeChar,1)
	Line=deblank(SumLobeChar(i,:));
	fprintf(fidOut,Line);
	fprintf(fidOut,'\n');
end
fclose(fidOut);
%==============================================================================
if TDFileStatus==1
	OutFilePath=[TdFilePath(1:length(TdFilePath)-4),'_BA',int2str(MinNVox),'.txt'];
elseif TDFileStatus==2
	OutFilePath=[TdFilePath(1:length(TdFilePath)-4),'_BA',int2str(MinNVox),'R',int2str(MaxRange),'.txt'];
end
fidOut=fopen(OutFilePath,'w');
for i=1:size(SumBAChar,1)
	Line=deblank(SumBAChar(i,:));
	fprintf(fidOut,Line);
	fprintf(fidOut,'\n');
end
fclose(fidOut);
%==============================================================================
if TDFileStatus==1
	OutFilePath=[TdFilePath(1:length(TdFilePath)-4),'_CBA',int2str(MinNVox),'.txt'];
elseif TDFileStatus==2
	OutFilePath=[TdFilePath(1:length(TdFilePath)-4),'_CBA',int2str(MinNVox),'R',int2str(MaxRange),'.txt'];
end
fidOut=fopen(OutFilePath,'w');
for i=1:size(BACenterChar,1)
	Line=deblank(BACenterChar(i,:));
	fprintf(fidOut,Line);
	fprintf(fidOut,'\n');
end
fclose(fidOut);
return

