function [MeanZ,StdZ,z]=CalcXY(xY,Str)

%   CalcXY

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      

if nargin<2; Str='Giessen'; end
global z xY
if strcmp(Str,'GV')
    y=xY.y;
    Ny=size(y,1)
    NCond=Ny./70;
    y=mean(y,2);
    z=zeros(NCond,70);
    for i=1:NCond
        z(i,:)=y((i-1).*70+1:i.*70)';
    end
    MeanZ=zeros(NCond,10);
    ZZ=zeros(NCond,10,8);
    for i=1:NCond
        for j=3:12
            Vec=[j:8:70];
            MeanZ(i,j-2)=mean(z(i,Vec),2);
            StdZ(i,j-2)=std(z(i,Vec),2);
            % ZZ(i,j-2,:)=z(i,Vec(1:8));
        end
    end
    
elseif strcmp(Str,'Giessen')
    
    NCond=5;
    NEpochs=40;
    NScanPerBlock=4;
    Base=0;
    y=xY.y;
    Ny=size(y,1)
    Ny2=Ny./2
    y=mean(y,2);

    NegHigh=[2 9  13 20 23 30 33 39 42 49 52 59 63 70 72 80 83 89 92 98 ]*NScanPerBlock+Base;
    NegLow =[4 8  12 19 22 28 34 40 43 50 53 60 65 67 74 79 82 87 95 100]*NScanPerBlock+Base;
    Neutral=[1 6  11 16 21 26 31 36 41 46 51 56 61 66 71 76 81 86 91 96 ]*NScanPerBlock+Base;
    PosLow =[5 7  14 17 25 27 35 37 44 47 55 58 64 68 75 78 85 88 94 99 ]*NScanPerBlock+Base;
    PosHigh=[3 10 15 18 24 29 32 38 45 48 54 57 62 69 73 77 84 90 93 97 ]*NScanPerBlock+Base;
    
    CondMat1=[NegHigh;NegLow;Neutral;PosLow;PosHigh]
    CondMat2=CondMat1+Ny2
    CondMat=[CondMat1,CondMat2]
    
    figure
    plot(y)
    hold on
    plot(CondMat(1,:)+4,y(CondMat(1,:)+4),'ro')
    plot(CondMat(5,:)+4,y(CondMat(5,:)+4),'mo')
    plot(CondMat(3,:)+4,y(CondMat(3,:)+4),'go')

    z=zeros(NCond,NEpochs,6);
    for CondInd=1:NCond
        for EpochInd=1:NEpochs
            z(CondInd,EpochInd,:)=y(CondMat(CondInd,EpochInd)-1:CondMat(CondInd,EpochInd)+4);
        end
    end
    MeanZ=squeeze(mean(z,2));
    StdZ=squeeze(std(z,2));
    figure
    for i=1:5
        subplot(5,1,i)
        Tmp=MeanZ(i,:)-MeanZ(i,1)
        plot(Tmp)
    end
end
return;