function [MMat,BMat,MFile,BFile]=CombPosTal(PosFilePath,TalFilePath)

%   CombPosTal

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      


if nargin<2; TalFilePath=[]; end
if nargin<1; PosFilePath=[]; end

[DefFilePath] = SetDefPath('r','*.stats');
[PosFile,PosPath,PosFilePath]=ReadFilePath(PosFilePath,DefFilePath,'Choose a Stats file:');
if PosFile==0; return; end
SetDefPath('w',PosPath);
[DefFilePath] = SetDefPath('r','*.res');
[TalFile,TalPath,TalFilePath]=ReadFilePath(TalFilePath,DefFilePath,'Choose a TalRes file:');
if PosFile==0; return; end
CombFile=[PosFile,'.com'];
CombFilePath=[PosPath,CombFile];
fidw=fopen(CombFilePath,'w');
fprintf(fidw,['#\t Cluster_p(cor)\t Cluster_equivk\t Cluster_p(unc)\t Voxel_p(cor)\t Voxel_T\t Voxel_equivZ\t Voxel_p(unc)\t x,y,z\t x_Tal\t y_Tal\t z_Tal\t Tal_1\t Tal_2\t Tal_3\t Tal_4\t Tal_5\n'])
fidPos=fopen(PosFilePath,'r');
fidTal=fopen(TalFilePath,'r');

Start=0;
MniMat=[0 0 0];
NKo=0;
NKo=0;
for i=1:5
   PosLine=fgetl(fidPos);
   disp(PosLine)
end
%TalLine = fgetl(fidTal); on PC
PosLineInd=0;
while 1
   PosLine = fgetl(fidPos);
   PosLineInd=PosLineInd+1;
   if  isempty(PosLine) | ~isempty(findstr(PosLine,'table')), break, end
   TalLine = fgetl(fidTal);
   Tmp=findstr(TalLine,',');
   %TalLineNew=TalLine(1:Tmp(1)-1);
   TalLineNew=TalLine(Tmp(1)+1:Tmp(2)-1);
   for i=3:length(Tmp);
      TalLineNew=[TalLineNew,'\t',TalLine(Tmp(i-1)+1:Tmp(i)-1)];
   end
   disp([int2str(PosLineInd),'\t ',PosLine,TalLineNew,'\n']);
   fprintf(fidw,[int2str(PosLineInd),'\t ',PosLine,TalLineNew,'\n']);
end
fclose(fidw);
fclose(fidPos);
fclose(fidTal);
retur   