%   PlotFittedResponses.m

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION. 

global GraphMJ


GenderStr='Female'
Voxel=[-4 42 -4]
                                                                     
StrucStr='AntCingulum'
if Voxel(1)<0; LRStr='Left'; elseif Voxel(1)>0; LRStr='Right'; else; LRStr='Center'; end
VoxelStr=[int2str(Voxel(1)),'_',int2str(Voxel(2)),'_',int2str(Voxel(3))];
File=[GenderStr,'_',StrucStr,'_',LRStr,'_',VoxelStr,'.txt'];
NPoints=length(GraphMJ(1).Y);
Mat=zeros(NPoints,6);
figure('Units','normal','Position',[.7 .7 .25 .25],'Name',File,'Color',[1 1 1],'NumberTitle','off');
Mat(:,1)=GraphMJ(1).x';
for i=1:5
    plot(GraphMJ(i).x,GraphMJ(i).Y,GraphMJ(i).COL(i))
    Mat(:,i+1)=GraphMJ(i).Y;
    hold on
end
fid=fopen(['D:\ValAro\00_Plot\',GenderStr,'\',File],'w','b');
Str0='Peri-Stimulus Time [s]';
Str1=[GenderStr,'_',StrucStr,'_',LRStr,'_',VoxelStr,'_Very_Unpleasant'];
Str2=[GenderStr,'_',StrucStr,'_',LRStr,'_',VoxelStr,'_Unpleasant'];
Str3=[GenderStr,'_',StrucStr,'_',LRStr,'_',VoxelStr,'_Neutral'];
Str4=[GenderStr,'_',StrucStr,'_',LRStr,'_',VoxelStr,'_Pleasant'];
Str5=[GenderStr,'_',StrucStr,'_',LRStr,'_',VoxelStr,'_Very_Pleasant'];
fprintf(fid,[Str0,'\t',Str1,'\t',Str2,'\t',Str3,'\t',Str4,'\t',Str5,'\t']);
fprintf(fid,'\n');
for i=1:NPoints
    fprintf(fid,'%g\t',Mat(i,:));
    fprintf(fid,'\n');
end
hold off
fclose(fid);	
return;    