function [FlowMat]=ReadFlow(Path,SaveStatus)
%	ReadFlow.m

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.   

if nargin<2; SaveStatus=1; end
if nargin<1; Path=[]; end


if isempty(Path)
	DefPath=SetDefPath(1)
	[File,Path]=ReadFilePath([],DefPath,'Choose an image file:');
	if File==0; return; end
end
if strcmp(Path,'def')
 	Path='Movie:MRI:012:'
end
SetDefPath(2,Path);
NSlice=7;
m=256;
n=256;
NSeek=7904;
FlowMat=zeros(n,m,NSlice);
clc;
for ImgInd=1:NSlice
	if ImgInd<10
		ImgIndStr=['00' int2str(ImgInd)];
	elseif ImgInd>9 & ImgInd <100
		ImgIndStr=['0' int2str(ImgInd)];
	elseif ImgInd>99 & ImgInd <1000
		ImgIndStr=[int2str(ImgInd)];
	else 
		error('ImgInd>1000 in Read504')
	end
	FilePath=[Path,'I.',ImgIndStr];
	fprintf('\n')
	fprintf('Read file:  ')
	fprintf(FilePath)
	ImgFid=fopen(FilePath,'r');
	SeekStatus=fseek(ImgFid,NSeek,-1);
	FlowMat(:,:,ImgInd)=fread(ImgFid,[m,n],'int16')';
	fclose(ImgFid);
end
if SaveStatus
	SaveNDimData(FlowMat,[Path,'Flow'],'int16');
end
return;
