function [DataMat,FilePath,SizeDataMat,NDim,Version]=ReadNDimDataKN(FilePath,Format,FilterSpec,DialogTitle,SizeStatus);
%	ReadNDimData.m

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.  

if nargin<5;SizeStatus=0;end;
if nargin<4;DialogTitle=[];end;
if nargin<3;FilterSpec=[];end;
if nargin<2;Format='int16';end;
if nargin<1;FilePath=[];end;

if isempty(DialogTitle)
	DialogTitle='Read MRI data from file:';
end
if isempty(FilterSpec)
	FilterSpec='*';
end
if isempty(Format)
	Format='int16';
end
[File,Path,FilePath]=ReadFilePath(FilePath,FilterSpec,DialogTitle);
if File==0; DataMat=[]; FilePath=[]; SizeDataMat=0; NDim=0; Version=[]; return; end
fprintf('Read data from file...\n\n');
fprintf(1,FilePath)
fid=fopen(FilePath,'r','ieee-be');
% Version=fread(fid,1,Format);
% NDim=fread(fid,1,Format);
% SizeDataMat=fread(fid,NDim,Format);
NDim=4;
SizeDataMat=[64 64 6 128]
if SizeStatus
	DataMat=[];
	return;
end
if size(SizeDataMat,1)~=1
	SizeDataMat=SizeDataMat';
end
[Data,Count]=fread(fid,Format);

if Count~=prod(SizeDataMat)
	Count=Count
	ProdSizeDataMat=prod(SizeDataMat)
	error('Count~=prod(SizeDataMat)')
end
DataMat=reshape(Data,SizeDataMat);
fclose(fid);	
fprintf(1,'\n\n')
fprintf('End reading data from file...\n\n');	
fprintf(1,'\n\n')
fprintf(1,'Data size:  '); 
for i=1:NDim-1
	fprintf(1,'%g x ',SizeDataMat(i)); 
end
fprintf(1,'%g \n\n',SizeDataMat(NDim)); 
DataMatTmp=DataMat;
for i=1:128
	for j=1:6
		DataMatTmp(:,:,j,i)=squeeze(DataMat(:,:,j,i))';
	end
end
DataMat=DataMatTmp;
for j=1:6
	DataMat(:,:,7-j,:)=DataMatTmp(:,:,j,:);
end
return;
