function [TValVec,MniMat,MMat,BMat]=Vox2Tal(FilePathImg)
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      

if nargin<1; FilePathImg=[]; end

if isempty(FilePathImg)
    DefFolder=['F:\ValAro\00_Stats\RandStatsSmooth08\All\u001k20\Filtered\002_PosHiGTNeutAll']
    Mask=['*.img'];
    FilePathImg=spm_get(1,Mask,'Choose a "Write filtered" analyze file',DefFolder);
    FilePathExt=lower(FilePathImg(length(FilePathImg)-3:length(FilePathImg)));
    if strcmp(FilePathExt,'.hdr')
        FilePathImg=[FilePathImg(1:length(FilePathImg)-4),'.img'];
        FilePathExt='.img';
    end
    if ~strcmp(FilePathExt,'.img')
        error('Please choose an analyze .img format file.')
    end
end

FilePathHdr=[FilePathImg(1:length(FilePathImg)-3),'hdr']
ValFilePath=[FilePathImg(1:length(FilePathImg)-4),'Val.txt']
MniFilePath=[FilePathImg(1:length(FilePathImg)-4),'Mni.txt']
BTalFilePath=[FilePathImg(1:length(FilePathImg)-4),'BTal.txt']
MTalFilePath=[FilePathImg(1:length(FilePathImg)-4),'MTal.txt']

[Dim,Vox,Scale,Type,Offset,Origin,Descrip]=spm_hread(FilePathHdr);
ProdDim=prod(Dim);
if Type==2
    ImgDataFormat='ubit8';
elseif Type==3
    ImgDataFormat='ubit16';
else
    error('Unknown Type')
end
fid=fopen(FilePathImg,'r','ieee-le');
[ImgMat,Count]=fread(fid,ProdDim,ImgDataFormat);
fclose(fid);
ImgMat=reshape(ImgMat,Dim);
[IndVec1,IndVec2,IndVec3]=Ind2Sub(Dim,find(ImgMat>0));
NInd=length(IndVec1);
TValVec=zeros(NInd,1);
MniMat=zeros(NInd,3);
MMat=MniMat;
BMat=MniMat;
fprintf(1,'Write data to file...\n\n');
disp(ValFilePath)
fprintf(1,'\n\n')
if NInd<=9999
    NStart=1;
    NEnd=NInd;
    nj=1;
else
    nj=floor(NInd./9999)
    rest=NInd-nj.*9999
    if rest>0
        NStart=[1:9999:(nj+1).*9999]
        NEnd=[9999:9999:NInd,NInd]
    else
        NStart=[1:9999:nj.*9999]
        NEnd=[9999:9999:NInd]
    end
end
for j=1:nj
    if nj>1
        MniFilePathTmp=[MniFilePath,'_',int2str(j)] 
        ValFilePathTmp=[ValFilePath,'_',int2str(j)] 
        BTalFilePathTmp=[BTalFilePath,'_',int2str(j)] 
        MTalFilePathTmp=[MTalFilePath,'_',int2str(j)] 
    else
        MniFilePathTmp=MniFilePath 
        ValFilePathTmp=ValFilePath
        BTalFilePathTmp=BTalFilePath
        MTalFilePathTmp=MTalFilePath
    end
    %     fidMni=fopen(MniFilePathTmp,'w','ieee-le');
    fidBTal=fopen(BTalFilePathTmp,'w','ieee-le');
    %     fidMTal=fopen(MTalFilePathTmp,'w','ieee-le');
    fidVal=fopen(ValFilePathTmp,'w','ieee-le');
    for i=NStart(j):NEnd(j)
        TVal=ImgMat(IndVec1(i),IndVec2(i),IndVec3(i)).*Scale;
        MniMat(i,:)=[(IndVec1(i)-Origin(1)).*Vox(1),(IndVec2(i)-Origin(2)).*Vox(2),(IndVec3(i)-Origin(3)).*Vox(3)];
        MMat(i,1)=0.88.*MniMat(i,1)-0.8;	%Meyer-Lindenberg
        MMat(i,2)=0.97.*MniMat(i,2)-3.32;
        MMat(i,3)=0.05.*MniMat(i,2)+0.88.*MniMat(i,3)-0.44;
        BMat(i,1)=0.99.*MniMat(i,1);			%Brett
        if MniMat(i,3)>=0
            BMat(i,2)=0.9688.*MniMat(i,2)+0.046.*MniMat(i,3);
            BMat(i,3)=-0.0485.*MniMat(i,2)+0.9189.*MniMat(i,3);
        else
            BMat(i,2)=0.9688.*MniMat(i,2)+0.042.*MniMat(i,3);
            BMat(i,3)=-0.0485.*MniMat(i,2)+0.839.*MniMat(i,3);
        end
        MniMat(i,:)=round(MniMat(i,:));
        MMat(i,:)=round(MMat(i,:));
        BMat(i,:)=round(BMat(i,:));
        TValVec(i)=TVal;
        %         fprintf(fidMni,'%g %g %g\n',MniMat(i,:)); 
        fprintf(fidBTal,'%g %g %g\n',BMat(i,:)); 
        %fprintf(fidMTal,'%g %g %g\n',MMat(i,:)); 
        fprintf(fidVal,'%g\n',TVal); 
    end
    %     fclose(fidMni);
    fclose(fidBTal);
    %     fclose(fidMTal);
    fclose(fidVal);
end
return;