function [MiCs1,MiCs2,IndVec1,IndVec2,MiCsMat,LastShot]=fMriTStat(FuncMat,StatStatus,Base,NShotPerCycle,MinLag,MaxLag,ShotOrderPlotStatus)

%   fMriTStat.m
%
%   This program is designed to calculate the independent and dependent t-
%   statistics of fMRI signal 

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Qun Zhao, Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.   

if nargin<7; ShotOrderPlotStatus=0; end
if nargin<6; MaxLag=0; end
if nargin<5; MinLag=0; end
if nargin<4; NShotPerCycle=4; end
if nargin<3; Base=2; end
if nargin<2; StatStatus='CalcIndT21'; end
if nargin<1; FuncMat=[]; end

[XSizeFunc,YSizeFunc,NSlice,NShot]=size(FuncMat);
NLag=MaxLag-MinLag+1;
MiCs=zeros(XSizeFunc,YSizeFunc,NSlice);
if NLag>1
	MiCsMat=zeros(XSizeFunc,YSizeFunc,NSlice,NLag);
end
Message=char(zeros(7,150));
hMsgbox=msgbox(Message,'Progress Info:','help'); 
hChildMsgbox=get(hMsgbox,'Children');
set(hChildMsgbox(length(hChildMsgbox)),'Visible','off');	
ActLag=0;
for LagIndex=MinLag:MaxLag
	ActLag=ActLag+1;
	if strcmp(StatStatus,'CalcIndT12') | strcmp(StatStatus,'CalcIndT21')
		FigTitle=['Independent t-Test Shot Order; Base: ',int2str(Base),'; Lag: ',int2str(LagIndex)];
		[IndVec1,IndVec2,Num,LastShot]=CalcInd12Vec(NShot,NShotPerCycle,Base+LagIndex,FigTitle,ShotOrderPlotStatus);
		for SliceInd=1:NSlice
			Message=char('Calculate');
			Message=char(Message,'Independent t-Test ');
			Message=char(Message,'');
			Message=char(Message,['Calculate Lag ',int2str(LagIndex)]);
			Message=char(Message,'');
			Message=char(Message,['Lag   ',int2str(ActLag),' of ',int2str(NLag)]);
			Message=char(Message,['Slice ',int2str(SliceInd),' of ',int2str(NSlice)]);
			set(hChildMsgbox(2),'String',Message);
			pause(.01);
			Mean1=mean(FuncMat(:,:,SliceInd,IndVec1),4);
			Mean2=mean(FuncMat(:,:,SliceInd,IndVec2),4);
			Std1=std(FuncMat(:,:,SliceInd,IndVec1),0,4);
			Std2=std(FuncMat(:,:,SliceInd,IndVec2),0,4);
			Vari=sqrt((Std1.^2+Std2.^2)./Num);
			ZeroVari=Vari==0;
			Vari=Vari+ZeroVari;										%Set Vari=1 if Vari=0
			if strcmp(StatStatus,'CalcIndT12') 
				MiCs(:,:,SliceInd)=(Mean1-Mean2)./Vari;
			elseif strcmp(StatStatus,'CalcIndT21') 
				MiCs(:,:,SliceInd)=(Mean2-Mean1)./Vari;
			end
			MiCs(:,:,SliceInd)=MiCs(:,:,SliceInd)-MiCs(:,:,SliceInd).*ZeroVari;	%Set Vari=0 if Vari=0
		end
	elseif strcmp(StatStatus,'CalcDepT12') | strcmp(StatStatus,'CalcDepT21')
		FigTitle=['Dependent t-Test Shot Order; Base: ',int2str(Base),'; Lag: ',int2str(LagIndex)];
		[IndVec1,IndVec2,Num,LastShot]=CalcInd12Vec(NShot,NShotPerCycle,Base+LagIndex,FigTitle,ShotOrderPlotStatus);
		for SliceInd=1:NSlice
			Message=char('Calculate ');
			Message=char(Message,'Dependent t-Test');
			Message=char(Message,'');
			Message=char(Message,['Calculate Lag ',int2str(LagIndex)]);
			Message=char(Message,'');
			Message=char(Message,['Lag   ',int2str(ActLag),' of ',int2str(NLag)]);
			Message=char(Message,['Slice ',int2str(SliceInd),' of ',int2str(NSlice)]);
			set(hChildMsgbox(2),'String',Message);
			pause(.01);
			if strcmp(StatStatus,'CalcDepT12')
				Diff=FuncMat(:,:,SliceInd,IndVec1)-FuncMat(:,:,SliceInd,IndVec2);
			elseif strcmp(StatStatus,'CalcDepT21')
				Diff=FuncMat(:,:,SliceInd,IndVec2)-FuncMat(:,:,SliceInd,IndVec1);
			end
			MeanTmp=mean(Diff(:,:,1,:),4);
			StdTmp=std(Diff(:,:,1,:),0,4);
			ZeroStdTmp=StdTmp==0;
			StdTmp=StdTmp+ZeroStdTmp;									%Set Std=1 if Std=0
			MiCs(:,:,SliceInd)=MeanTmp./(StdTmp./sqrt(Num));
			MiCs(:,:,SliceInd)=MiCs(:,:,SliceInd)-MiCs(:,:,SliceInd).*ZeroStdTmp;	%Set Std=0 if Std=0
		end
	else
  		disp(sprintf('fMriTStat: action string ''%s'' not recognized, no action taken.',StatStatus))
		return
	end
	if NLag>1
		MiCsMat(:,:,:,ActLag)=MiCs;
	end
end
close(hMsgbox);
 if NLag>1
	 [MiCs1,MiCs2]=max(MiCsMat,[],4);
	 MiCs2=MiCs2-1;
 else
	MiCs1=MiCs;
	MiCs2=ones(size(MiCs1)).*MinLag;
	MiCsMat=MiCs1;
end
return;
