function CalcSpmContrast

%   CalcSpmContrast

%   callbackresetmenu
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION. 




%load defaults
%=======================
spm_defaults
global defaults

nsub = 10;
nses = 2;

initpath = SetDefPath(1);
[NStatFolders,StatFolderMat]=ReadDirNames([],[initpath],'Please choose subject''s statistic-directories:');



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


for sub=1:nsub

    [File,Path,FilePath]=GetFileNameOfMat(StatFolderMat,sub);
    cd(FilePath);
    SPMmatPath = [FilePath,filesep,'SPM.mat'];
    load(SPMmatPath);
    % Add extra contrasts
    %======================================================================
    ocon = length(SPM.xCon);			% default contrasts
    eb = eye(SPM.xBF.order);			% basis functions


%     prepost           1 0 0  1 0 0  1 0 0  1 0 0  1 0 0  1 0 0 -1 0 0 -1 0 0 -1 0 0 -1 0 0 -1 0 0 -1 0 0
%     emo               1 0 0  1 0 0 -2 0 0  1 0 0  1 0 0 -2 0 0  1 0 0  1 0 0 -2 0 0  1 0 0  1 0 0 -2 0 0
%     emo_post          0 0 0  0 0 0  0 0 0  0 0 0  0 0 0  0 0 0  1 0 0  1 0 0 -2 0 0  1 0 0  1 0 0 -2 0 0 
%     emo_pre           1 0 0  1 0 0 -2 0 0  1 0 0  1 0 0 -2 0 0  0 0 0  0 0 0  0 0 0  0 0 0  0 0 0  0 0 0 
%     block             1 0 0  1 0 0  1 0 0 -1 0 0 -1 0 0 -1 0 0  1 0 0  1 0 0  1 0 0 -1 0 0 -1 0 0 -1 0 0
%     emoXprepost       1 0 0  1 0 0 -2 0 0  1 0 0  1 0 0 -2 0 0 -1 0 0 -1 0 0  2 0 0 -1 0 0 -1 0 0  2 0 0
%     emoXblock         1 0 0  1 0 0 -2 0 0 -1 0 0 -1 0 0  2 0 0  1 0 0  1 0 0 -2 0 0 -1 0 0 -1 0 0  2 0 0
%     blockXprepost     1 0 0  1 0 0  1 0 0 -1 0 0 -1 0 0 -1 0 0 -1 0 0 -1 0 0 -1 0 0  1 0 0  1 0 0  1 0 0
%     emoXblockXprepost 1 0 0  1 0 0 -2 0 0 -1 0 0 -1 0 0  2 0 0 -1 0 0 -1 0 0  2 0 0  1 0 0  1 0 0 -2 0 0
%     emoXblock_post    0 0 0  0 0 0  0 0 0  0 0 0  0 0 0  0 0 0 -1 0 0 -1 0 0  2 0 0  1 0 0  1 0 0 -2 0 0
%     emoXblock_pre     1 0 0 -1 0 0  2 0 0  1 0 0  1 0 0 -2 0 0  0 0 0  0 0 0  0 0 0  0 0 0  0 0 0  0 0 0 


%     cnam{1} = 'prepost';
%     cwgt{1} = [1 0 0  1 0 0  1 0 0  1 0 0  1 0 0  1 0 0 -1 0 0 -1 0 0 -1 0 0 -1 0 0 -1 0 0 -1 0 0 0 0];		% zeros = movement params
%     ctyp{1} = 'T';
%     cnam{2} = 'emo';
%     cwgt{2} = [1 0 0  1 0 0 -2 0 0  1 0 0  1 0 0 -2 0 0  1 0 0  1 0 0 -2 0 0  1 0 0  1 0 0 -2 0 0 0 0];			
%     ctyp{2} = 'T';
%     cnam{3} = 'emo_post';
%     cwgt{3} = [0 0 0  0 0 0  0 0 0  0 0 0  0 0 0  0 0 0  1 0 0  1 0 0 -2 0 0  1 0 0  1 0 0 -2 0 0 0 0];		
%     ctyp{3} = 'T';
%     cnam{4} = 'emo_pre';
%     cwgt{4} = [1 0 0  1 0 0 -2 0 0  1 0 0  1 0 0 -2 0 0  0 0 0  0 0 0  0 0 0  0 0 0  0 0 0  0 0 0 0 0];			
%     ctyp{4} = 'T';
%     cnam{5} = 'block';
%     cwgt{5} = [1 0 0  1 0 0  1 0 0 -1 0 0 -1 0 0 -1 0 0  1 0 0  1 0 0  1 0 0 -1 0 0 -1 0 0 -1 0 0 0 0];
%     ctyp{5} = 'T';
%     cnam{6} = 'emoXprepost';
%     cwgt{6} = [1 0 0  1 0 0 -2 0 0  1 0 0  1 0 0 -2 0 0 -1 0 0 -1 0 0  2 0 0 -1 0 0 -1 0 0  2 0 0 0 0];
%     ctyp{6} = 'T';
%     cnam{7} = 'emoXblock';
%     cwgt{7} = [1 0 0  1 0 0 -2 0 0 -1 0 0 -1 0 0  2 0 0  1 0 0  1 0 0 -2 0 0 -1 0 0 -1 0 0  2 0 0 0 0];
%     ctyp{7} = 'T';
%     cnam{8} = 'blockXprepost';
%     cwgt{8} = [1 0 0  1 0 0  1 0 0 -1 0 0 -1 0 0 -1 0 0 -1 0 0 -1 0 0 -1 0 0  1 0 0  1 0 0  1 0 0 0 0];
%     ctyp{8} = 'T';
%     cnam{9} = 'emoXblockXprepost';
%     cwgt{9} = [1 0 0  1 0 0 -2 0 0 -1 0 0 -1 0 0  2 0 0 -1 0 0 -1 0 0  2 0 0  1 0 0  1 0 0 -2 0 0 0 0];
%     ctyp{9} = 'T';
%     cnam{10}= 'emoXblock_post';
%     cwgt{10}= [0 0 0  0 0 0  0 0 0  0 0 0  0 0 0  0 0 0 -1 0 0 -1 0 0  2 0 0  1 0 0  1 0 0 -2 0 0 0 0];
%     ctyp{10}= 'T';
%     cnam{11}= 'emoXblock_pre';
%     cwgt{11}=[-1 0 0 -1 0 0  2 0 0  1 0 0  1 0 0 -2 0 0  0 0 0  0 0 0  0 0 0  0 0 0  0 0 0  0 0 0 0 0];
%     ctyp{11} = 'T';
%     cnam{1} = 'block_pre';
%     cwgt{1} = [1 0 0  1 0 0  1 0 0 -1 0 0 -1 0 0 -1 0 0  0 0 0  0 0 0  0 0 0  0 0 0  0 0 0  0 0 0 0 0];		% zeros = movement params
%     ctyp{1} = 'T';
%     cnam{2} = 'block_post';
%     cwgt{2} = [0 0 0  0 0 0  0 0 0  0 0 0  0 0 0  0 0 0  1 0 0  1 0 0  1 0 0 -1 0 0 -1 0 0 -1 0 0 0 0];			
%     ctyp{2} = 'T';


%     cnam{1} = 'emoneg ';
%     cwgt{1} =   [0 0 0  1 0 0 -1 0 0  0 0 0  1 0 0 -1 0 0  0 0 0  1 0 0 -1 0 0  0 0 0  1 0 0 -1 0 0 0 0];
%     ctyp{1} =  'T';
%     cnam{2} = 'emoneg_post';
%     cwgt{2}=    [0 0 0  0 0 0  0 0 0  0 0 0  0 0 0  0 0 0  0 0 0  1 0 0 -1 0 0  0 0 0  1 0 0 -1 0 0 0 0];
%     ctyp{2} =  'T';
%     cnam{3} = 'emoneg_pre';
%     cwgt{3}=    [0 0 0  1 0 0 -1 0 0  0 0 0  1 0 0 -1 0 0  0 0 0  0 0 0  0 0 0  0 0 0  0 0 0  0 0 0 0 0];
%     ctyp{3} =  'T';
%     cnam{4} = 'emopos ';
%     cwgt{4}=    [1 0 0  0 0 0 -1 0 0  1 0 0  0 0 0 -1 0 0  1 0 0  0 0 0 -1 0 0  1 0 0  0 0 0 -1 0 0 0 0];
%     ctyp{4} =  'T';
%     cnam{5} = 'emopos_post';
%     cwgt{5}=    [0 0 0  0 0 0  0 0 0  0 0 0  0 0 0  0 0 0  1 0 0  0 0 0 -1 0 0  1 0 0  0 0 0 -1 0 0 0 0];
%     ctyp{5} =  'T';
%     cnam{6} = 'emopos_pre';
%     cwgt{6}=    [1 0 0  0 0 0 -1 0 0  1 0 0  0 0 0 -1 0 0  0 0 0  0 0 0  0 0 0  0 0 0  0 0 0  0 0 0 0 0];
%     ctyp{6} =  'T';
%     cnam{7} = 'emopos_post_bl1';
%     cwgt{7}=    [0 0 0  0 0 0  0 0 0  0 0 0  0 0 0  0 0 0  1 0 0  1 0 0 -2 0 0  0 0 0  0 0 0  0 0 0 0 0];
%     ctyp{7} =  'T';
%     cnam{8} = 'emopos_post_bl2';
%     cwgt{8}=    [0 0 0  0 0 0  0 0 0  0 0 0  0 0 0  0 0 0  0 0 0  0 0 0  0 0 0  1 0 0  1 0 0 -2 0 0 0 0];
%     ctyp{8} =  'T';
%     cnam{9} = 'emoXblock_pre';
%     cwgt{9}=   [-1 0 0 -1 0 0  2 0 0  1 0 0  1 0 0 -2 0 0  0 0 0  0 0 0  0 0 0  0 0 0  0 0 0  0 0 0 0 0];
%     ctyp{9} =  'T';
%     cnam{10}= 'emoXblock_pre';
%     cwgt{10}=  [-1 0 0 -1 0 0  2 0 0  1 0 0  1 0 0 -2 0 0  0 0 0  0 0 0  0 0 0  0 0 0  0 0 0  0 0 0 0 0];
%     ctyp{10} = 'T';
    
    cnam{7} = 'emoneg_post_bl1';
    cwgt{7}=    [0 0 0  0 0 0  0 0 0  0 0 0  0 0 0  0 0 0  0 0 0  1 0 0 -1 0 0  0 0 0  0 0 0  0 0 0 0 0];
    ctyp{7} =  'T';
    cnam{8} = 'emoneg_post_bl2';
    cwgt{8}=    [0 0 0  0 0 0  0 0 0  0 0 0  0 0 0  0 0 0  0 0 0  0 0 0  0 0 0  0 0 0  1 0 0 -1 0 0 0 0];
    ctyp{8} =  'T';



    for c = 1:length(cnam)
        cw = [cwgt{c}]';	
        SPM.xCon(c+ocon)     = spm_FcUtil('Set',cnam{c},ctyp{c},'c',cw,SPM.xX.xKXs);
    end
    % and evaluate
    %---------------------------------------------------------------------------
    spm_contrasts(SPM);
    
    
    
end


