function varargout = FileManScript(action,varargin)

%   FileManScript

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION. 
if nargin<1;action = 'Initialize';end
mversion = version;
mvnr = str2num(mversion(1:3));

%======================================
%  Initialize 
%======================================
if strcmp(action,'Initialize')
    
    FileMan;
    
    
%======================================
%  SetStartPath 
%======================================
elseif strcmp(action,'SetStartPath')
    
    startpathstatic = findobj('tag','startpathstatic');
    if mvnr>6.1
        initpath = SetDefPath(1);
        [file,initpath] = SepFilePath(initpath);
        if isempty(initpath);initpath = '';end
        [filepath] = uigetdir(initpath,'Please choose start folder:');
    else
        initpath = SetDefPath(1);
        [file,initpath] = SepFilePath(initpath);
        if isempty(initpath);initpath = '';end
        [filename,filepath] = uiputfile(initpath,'Please create file in start folder:');
    end
    set(startpathstatic,'String',[filepath,filesep]);
    SetDefPath(2,[filepath,filesep]);
 
%======================================
%  SetFolderWizStartPath 
%======================================
elseif strcmp(action,'SetFolderWizStartPath')
    
    startpathstatic = findobj('tag','FolderWizardStartFolderText');
    if mvnr>6.1
        initpath = SetDefPath(1);
        [file,initpath] = SepFilePath(initpath);
        if isempty(initpath);initpath = '';end
        [filepath] = uigetdir(initpath,'Please choose start folder:');
    else
        initpath = SetDefPath(1);
        [file,initpath] = SepFilePath(initpath);
        if isempty(initpath);initpath = '';end
        [filename,filepath] = uiputfile(initpath,'Please create file in start folder:');
    end
    set(startpathstatic,'String',[filepath,filesep]);
    SetDefPath(2,[filepath,filesep]);
    
    
%======================================
%  FolderWizard 
%======================================
elseif strcmp(action,'FolderWizard')
    
    startpathstatic = findobj('tag','FolderWizardStartFolderText');
    PreFixEdit = findobj('tag','FolderWizardPrefixEdit');
    NFolderEdit = findobj('tag','NFolderEdit');
    NSubEdit = findobj('tag','NSubEdit');
	answer{1} = str2num(get(NFolderEdit,'String'));
    answer{2} = str2num(get(NSubEdit,'String'));
    answer{3} = get(startpathstatic,'String');
	nrofsubjects = answer{1};
	nrofsubs = answer{2};
	rootdirtitle = answer{3};
    PreFix = get(PreFixEdit,'String');
    
	olddir = pwd;
	cd(rootdirtitle);
	if exist([rootdirtitle])~=7
        status = mkdir(filepath,rootdirtitle)
        cd([rootdirtitle]);
	else
        cd([rootdirtitle]);
	end
	
    if isempty(PreFix)
		for r=1:nrofsubjects
            if r<10
                if exist([rootdirtitle,filesep,['0',num2str(r)]])~=7
                    mkdir([rootdirtitle],['0',num2str(r)]);
                    subjectroot = [rootdirtitle,filesep,['0',num2str(r)]];
                    cd([rootdirtitle,filesep,['0',num2str(r)]]);
                else
                    subjectroot = [rootdirtitle,filesep,['0',num2str(r)]];
                    cd([rootdirtitle,filesep,['0',num2str(r)]]);
                end
            else
                if exist(([rootdirtitle,filesep num2str(r)]))~=7
                    mkdir([rootdirtitle], num2str(r));
                    subjectroot = [rootdirtitle,filesep,num2str(r)];
                    cd([rootdirtitle,filesep,num2str(r)]);
                else
                    subjectroot = [rootdirtitle,filesep,num2str(r)];
                    cd([rootdirtitle,filesep,num2str(r)]);
                end
            end
            
            
            for s=1:nrofsubs
                if s<10
                    if exist(([rootdirtitle,filesep,[PreFix,'0',num2str(r)] filesep ['0',num2str(s)]]))~=7
                        mkdir(subjectroot,[PreFix,'0',num2str(s)]);
                    end
                else
                    if exist(([rootdirtitle,filesep,[PreFix,'0',num2str(r)] filesep num2str(s)]))~=7
                        mkdir(subjectroot, [PreFix, num2str(s)]);
                    end
                end
            end
		end
    else
	    for r=1:nrofsubjects
            if r<10
                if exist([rootdirtitle,filesep,[PreFix,'0',num2str(r)]])~=7
                    mkdir([rootdirtitle],[PreFix,'0',num2str(r)]);
                    subjectroot = [rootdirtitle,filesep,[PreFix,'0',num2str(r)]];
                    cd([rootdirtitle,filesep,[PreFix,'0',num2str(r)]]);
                else
                    subjectroot = [rootdirtitle,filesep,['0',num2str(r)]];
                    cd([rootdirtitle,filesep,['0',num2str(r)]]);
                end
            else
                if exist(([rootdirtitle,filesep num2str(r)]))~=7
                    mkdir([rootdirtitle], [PreFix,num2str(r)]);
                    subjectroot = [rootdirtitle,filesep,PreFix,num2str(r)];
                    cd([rootdirtitle,filesep,PreFix,num2str(r)]);
                else
                    subjectroot = [rootdirtitle,filesep,PreFix,num2str(r)];
                    cd([rootdirtitle,filesep,PreFix,num2str(r)]);
                end
            end
            
            
            for s=1:nrofsubs
                if s<10
                    if exist(([rootdirtitle,filesep,[PreFix,'0',num2str(r)] filesep ['0',num2str(s)]]))~=7
                        mkdir(subjectroot,[PreFix,'0',num2str(s)]);
                    end
                else
                    if exist(([rootdirtitle,filesep,[PreFix,'0',num2str(r)] filesep num2str(s)]))~=7
                        mkdir(subjectroot, [PreFix,num2str(s)]);
                    end
                end
            end
		end
    end
	cd(olddir);
	ok
    
    
%======================================
%  EnableDir2BatchFilterString 
%======================================  
elseif strcmp(action,'EnableDir2BatchFilterString')
    
    dir2batchfilterstringedit = findobj('tag','dir2batchfilterstringedit');
    if get(gcbo,'Value')==0
        set(dir2batchfilterstringedit,'Enable','off');
    else
        set(dir2batchfilterstringedit,'Enable','on');
    end
%======================================
%  Dir2Batch 
%======================================  

elseif strcmp(action,'Dir2Batch')
     startpathstatic = findobj('tag','startpathstatic');
     initpath = get(startpathstatic,'String');
     FileManDir2BatchIncludeSubFolders = get(findobj('tag','FileManDir2BatchIncludeSubFolders'),'Value');
     dir2batchfilterstringedit = findobj('tag','dir2batchfilterstringedit');
     FileManDir2BatchFilterString = get(findobj('tag','FileManDir2BatchFilterStringRadio'),'Value');
     filter = get(dir2batchfilterstringedit,'String');
     FileManDir2BatchFullPaths = get(findobj('tag','FileManDir2BatchFullPaths'),'Value');
     FileManCreateBatchFile = get(findobj('tag','FileManCreateBatchFile'),'Value');
     if FileManDir2BatchFilterString
         FileManDir2BatchFilterString = 'y';
     else
         FileManDir2BatchFilterString = 'n';
     end
     [filemat]=Dir2BatchFm(initpath,FileManDir2BatchIncludeSubFolders,FileManCreateBatchFile,FileManDir2BatchFullPaths,...
         FileManDir2BatchFilterString,filter,[],1,1) ;
     
     fprintf('\n\n\n');
	
	 fprintf([num2str(length(filemat)),' file(s) found! \n']);
     if isempty(filemat);return;end
	 fprintf('\n');
	 if ~strcmp(FileManDir2BatchFullPaths,'n')    
        fprintf(1,'%s',char([filemat{1}]));
	 else
        fprintf(1,'%s',char(filemat{1}));
	 end
	
	 for i=2:size(filemat,2)
        if ~strcmp(FileManDir2BatchFullPaths,'n')    
            fprintf(1,'\n');
            fprintf(1,'%s',char([filemat{i}]));
        else
            fprintf(1,'\n');
            fprintf(1,'%s',char(filemat{i}));
        end
	 end
     
     FileMatMenu = findobj('tag','FileMatMenu');
     ActiveFileMat = get(FileMatMenu,'Value');
     FileMatCell = get(FileMatMenu,'userdata');
     if isempty(FileMatCell);FileMatCell = cell(1);end
     FileMatCell{ActiveFileMat} = filemat;
     set(FileMatMenu,'userdata',FileMatCell);
     
     for i=1:length(FileMatCell)+1
        FileMatString{i,1} = num2str(i);
     end
     set(FileMatMenu,'String',FileMatString);
     
     
%======================================
%  SetFileMatNr 
%====================================== 
elseif strcmp(action,'SetFileMatNr')

     ActiveFileMat = get(gcbo,'Value');
     FileMatCell = get(gcbo,'userdata');
     if length(FileMatCell)<ActiveFileMat;return;end
     fprintf('\n\n');
     fprintf([num2str(ActiveFileMat),'. batch:\n\n']);
     fprintf(1,'%s',char([FileMatCell{ActiveFileMat}{1}]));
	 for i=2:size(FileMatCell{ActiveFileMat},2)  
            fprintf(1,'\n');
            fprintf(1,'%s',char([FileMatCell{ActiveFileMat}{i}]));
	 end
%======================================
%  Zipper 
%======================================   
elseif strcmp(action,'Zipper')
    
     FileMatMenu = findobj('tag','FileMatMenu');
     ActiveFileMat = get(FileMatMenu,'Value');
     FileMatCell = get(FileMatMenu,'userdata');
     FileMatTransCell = cell(length(FileMatCell),1);
     if length(FileMatCell)<ActiveFileMat;return;end
     for j=1:length(FileMatCell)
         fprintf('\n\n');
         FileMatTmp = [];
         fprintf([num2str(j),'. batch:\n\n']);
         FileMatTmp = char([FileMatCell{j}{1}]);
		 for i=2:size(FileMatCell{ActiveFileMat},2) 
                FileMatTmp = char(FileMatTmp,[FileMatCell{j}{i}]);
		 end
         FileMatTransCell{j} = FileMatTmp;
     end
       
     ZippedFileMat = ZipBatchFiles(FileMatTransCell)
     
end

return
