function [filenamecell,filepathcell]=LookInDirWild(filepath,filter,filenamecell,filepathcell,subfolderstatus,filter_ex,endofnamestatus,endofnameexstatus,searchpart,logictype)

%   lookindirwild

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      

if nargin < 10; searchpart = 1;end
if nargin < 9;logictype = 1;end
if nargin < 8; endofnameexstatus = 0;end
if nargin<7; endofnamestatus = 0;end

if logictype==1
    logicmod = 1;
elseif logictype ==2
    logicmod = 0;
else
    logicmod = 1;
end

clc
fprintf(1,'%s',['Actual path: ',filepath]);

if ~isempty(filter_ex)
    findstr = filter_ex(1:strfind(filter_ex,char(32))-1);
    replacestring = filter_ex((strfind(filter_ex,char(32))+1):length(filter_ex));
end


try
    cd(filepath);
catch
    fprintf('\n');
    fprintf(1,'%s',['Directory ',filepath,' could not be opened...']);
    return
end   

if endofnamestatus
    lengthfilter = size(filter,2);
end
if endofnameexstatus
    lenghfilter_ex = size(filter_ex,2),
end


% check for subfolders
%=============================
filepathcelltmp=dir;
subfoldervec=[];
subfolderzaehler=1;
for j=1:size(filepathcelltmp,1)
    if ~strcmp(filepathcelltmp(j).name,'.') & ~strcmp(filepathcelltmp(j).name,'..')
        %check if its a subdirectory
        if ~strcmp(filepath(end),filesep)
            filepath = [filepath,filesep];
        end
        if exist([filepath,filepathcelltmp(j).name],'dir')~=7
        
        else
            subfoldervec(subfolderzaehler)=j;
            subfolderzaehler=subfolderzaehler+1;
        end
    end
end

% search for files
%============================
if isempty(filter)
    filter = '*';
end
filepathcelltmpwild = dir(filter);
for j=1:size(filepathcelltmpwild,1)
    if ~strcmp(filepathcelltmpwild(j).name,'.') & ~strcmp(filepathcelltmpwild(j).name,'..')
        %check if its a subdirectory
        if ~strcmp(filepath(end),filesep)
            filepath = [filepath,filesep];
        end
        if exist([filepath,filepathcelltmpwild(j).name],'dir')~=7
            %filter
            found = 0;
            if ~isempty(filenamecell{1})
                    filenamecell{end+1}=filepathcelltmpwild(j).name;
                    filepathcell{end+1}=filepath;
                    found = 1;
            else
                    filenamecell{1}=filepathcelltmpwild(j).name;
                    filepathcell{1}=filepath;
                    found = 1;
            end
        end
    end
end

if strcmp(filter,'*')
    filter = [];
end
if subfolderstatus==1
    for i=1:subfolderzaehler-1
        if strcmp(computer,'PCWIN')
            [filenamecell,filepathcell]=LookInDirWild([filepath,filepathcelltmp(subfoldervec(i)).name,'\'],filter,filenamecell,filepathcell,subfolderstatus,filter_ex,endofnamestatus,endofnameexstatus);
        elseif strcmp(computer, 'GLNX86')
            [filenamecell,filepathcell]=LookInDirWild([filepath,filepathcelltmp(subfoldervec(i)).name,'/'],filter,filenamecell,filepathcell,subfolderstatus,filter_ex,endofnamestatus,endofnameexstatus);
        end    
	end
end
return