function varargout = MriViewer(action,varargin);

%   MriViewer

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.  

global hMriViewerFig;
if nargin<1;action = 'Initialize';end


if strcmp(action,'Initialize')
    
    
	%figure
	%---------------
	hMriViewerFig= figure(...
	'units','normal',...
	'position',[0.1    0.03         0.6      0.9],...
	'units','characters',...
	'color',[1 1 1],...
	'Name','MriViewer',...
	'Numbertitle','off',...
	'Resize','off',...
	'Menubar','none',...
	'units','characters',...
    'resize','on');
	
	%text4
	%----------------
	text4= uicontrol(...
	'units','normal',...
	'BackgroundColor',[1 1 1],...
	'style','text',...
    'position',[0.5313     0.47532     0.28596     0.03385],...
	'BackgroundColor',[1 1 1],...
	'foregroundcolor',[0  0  0],...
	'String','Modelled',...
	'Value',0,...
    'units','normalized',...
	'tag','text4');
	
	%text3
	%----------------
	text3= uicontrol(...
	'units','normal',...
	'BackgroundColor',[1 1 1],...
	'style','text',...
    'position',[0.53299     0.94781     0.28596     0.03385],...
	'BackgroundColor',[1 1 1],...
	'foregroundcolor',[0  0  0],...
	'String','Sagittal',...
	'Value',0,...
	'tag','text3');
	
	%text2
	%----------------
	text2= uicontrol(...
	'units','normal',...
	'BackgroundColor',[1 1 1],...
	'style','text',...
    'position',[0.055838     0.47532     0.28596     0.03385],...
	'BackgroundColor',[1 1 1],...
	'foregroundcolor',[0  0  0],...
	'String','Coronal',...
	'Value',0,...
	'tag','text2');
	
	%text1
	%----------------
	text1= uicontrol(...
	'units','normal',...
	'style','text',...
    'position',[0.059222     0.94076     0.28596     0.03385],...
	'BackgroundColor',[1 1 1],...
	'foregroundcolor',[0  0  0],...
	'String','Axial',...
	'Value',0,...
	'tag','text1' );
	
	%axes5
	%----------------
	ModelAxes= axes(...
	'units','normalized',...
	'position',[0.53299    0.059238     0.39932     0.39915],...
	'tag','ModelAxes',...
	'XColor',[1 1 1],...
	'XTick',[],...
	'YColor',[1 1 1],...
	'YTick',[],...
	'ZColor',[0 1 1],...
	'ZTick',[]  );
	
	%axes4
	%----------------
	CoronalAxes= axes(...
	'units','normalized',...
	'position',[0.059222    0.059238     0.39932     0.39915],...
	'tag','CoronalAxes',...
	'XColor',[1 1 1],...
	'XTick',[],...
	'YColor',[1 1 1],...
	'YTick',[],...
	'ZColor',[1 1 1],...
	'ZTick',[]  );
	
	%axes2
	%----------------
	SagittalAxes= axes(...
	'units','normalized',...
	'position',[0.5313     0.53032     0.39932     0.39915],...
	'tag','SagittalAxes',...
	'XColor',[1 1 1],...
	'XTick',[],...
	'YColor',[1 1 1],...
	'YTick',[],...
	'ZColor',[1 1 1],...
	'ZTick',[] );
	
	%axes1
	%----------------
	AxialAxes= axes(...
	'units','normalized',...
	'position',[0.05753     0.53032     0.39932     0.39915],...
	'tag','AxialAxes',...
	'XColor',[1 1 1],...
	'XTick',[],...
	'YColor',[1 1 1],...
	'YTick',[],...
	'ZColor',[1 1 1],...
	'ZTick',[]  );

    hList = [ModelAxes,CoronalAxes,SagittalAxes,AxialAxes];
    set(hMriViewerFig,'userdata',hList);
    
else
    
end

return

