function ZippedFileMat = ZipBatchFiles(FileMatInCell)

%   ZipBatchFiles

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE 

FileMatCell = cell(1);
if nargin<1
    FileMat = [];
else
    FileMat = FileMatInCell{1};
end

[DefFilePath]=SetDefPath('r',[],[],0);
[NFiles,FileMatCell{1},NonUse,BatchFilePath]=ReadFileNames(FileMat,DefFilePath,'Choose first batch file:');
if NFiles==0; OutFilePath=[]; return; end
[BatchFile,BatchPath]=SepFilePath(BatchFilePath);
SetDefPath(2,BatchPath,[],0);

filematcounter = 2;
while NFiles~=0
    [DefFilePath]=SetDefPath('r',[],[],0);
    if nargin<1
        [NFilesTmp,FileMatCell{filematcounter},NonUse,BatchFilePath]=ReadFileNames(FileMat,DefFilePath,['Choose ',num2str(filematcounter),'. batch file or press cancel:']);
    else
        [NFilesTmp,FileMatCell{filematcounter},NonUse,BatchFilePath]=ReadFileNames(FileMatInCell{filematcounter},DefFilePath,['Choose ',num2str(filematcounter),'. batch file or press cancel:']);
    end
    
    if NFilesTmp==0; OutFilePath=[]; break; end
    [BatchFile,BatchPath]=SepFilePath(BatchFilePath);
    SetDefPath(2,BatchPath,[],0);
    if NFilesTmp~=NFiles
        errordlg('Batchfiles must have same length!');
    end
    filematcounter = filematcounter +1;
    if nargin>0
        if filematcounter > length(FileMatInCell)
            break;
        end
    end
end

NFileMat = filematcounter-1;

fprintf(1,'\n');
ZippedFileMat = [];
for FileIndex=1:NFiles
    for i=1:NFileMat
		[File,Path,FilePath]=GetFileNameOfMat(FileMatCell{i},FileIndex);
        fprintf(1,'%c',FilePath);
        fprintf(1,'\n');
        if isempty(ZippedFileMat)
            ZippedFileMat = FilePath;
        else
            ZippedFileMat = char(ZippedFileMat,FilePath);
        end
        
    end
end

    

return