function addcopyrightnote(filename,filepath,editstatus)

%   addcopyrightnote - adds a copyrightnote to m-files.

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer, Peter Peyk, Andreas Keil, Olaf Hauk,
%   Thomas Gruber & Andrea de Cesarei.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
                                                                     
                                                                    
header =char('%   This software is protected by german copyright and international treaties.',...
'%   Copyright 2004 Markus Junghfer, Peter Peyk, Andreas Keil, Olaf Hauk,',...
'%   Thomas Gruber, Andrea de Cesarei & Nathan Weisz.  All Rights Reserved.',...
'%   ',...
'%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE',...
'%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,',...
'%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE',...
'%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,',...
'%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,' ,...
'%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE ',...
'%   OR DOCUMENTATION.');
if nargin<3;editstatus = 0;end
if nargin<2;filepath = [];end
if nargin<1;[filename,filepath]=uigetfile('*.*','Please choose file to modify:');
    if isequal(filename,0) | isequal(filepath,0);return;
    end
    editstatus = 1;
end
file = [filepath,filename];
if (isempty(findstr(file,'.m')) & ~isempty(findstr(file,'.mat'))) | ~isempty(findstr(file,'.txt'))
    return
end
%
helpstring = helpstring2char( help(file) );
fid = fopen(file,'rt');
filestring = fscanf(fid,'%c');
fseek(fid,0,'bof');
line = fgets(fid);
lastline = line;
counter = 0;
while isempty(findstr(line,'function'))
    lastline = fgets(fid);
    counter = counter + 1;
    line = [line lastline];
    if counter>3
        break;
        line = [];
    end
end
counter = 1;
while ~isempty(findstr(lastline,'...'))
    counter = counter + 1;
    lastline = fgets(fid);
    line = [line lastline];
end
fclose(fid);
fid = fopen(file,'wt');
fprintf(fid,'%c',line);
for i=1:size(helpstring,1)
    fprintf(fid,'%c',['%',char(9),removeindent(debreak(helpstring(i,:))),char(10)]);
end
fprintf(fid,'%c',[char(9),char(10)]);
for z=1:size(header,1)
    fprintf(fid,'%c',[header(z,:),char(10)]);
end
filestringchar = helpstring2char(strrep(filestring,line,''));
for j=i+counter:size(filestringchar,1)
    fprintf(fid,'%c',[filestringchar(j,:),char(10)]);
end

fclose(fid);

if editstatus
    edit(file);
end

return