function addremvar(action)

%   addremvar
%
%   addremvar is called, when plotting results of a repeated measures
%   anova, that is calculated in emegs2d. Adding a factor to the x-axes
%   adds this factor to the effect that is plotted.
%
%   See also ANOVAPLOTMENU, ANOVADRAW, RMANOVA, CALCRMANOVA.

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
global hPlot3dMenuFig 
uigettextfigure = findobj('tag','uigettextfigure');
curplotmodel = get(uigettextfigure,'userdata');

plot2dlibfilepath= which('plot3d.m');
plot2dlibfilepath(findstr(plot2dlibfilepath,'Plot3d.m'):findstr(plot2dlibfilepath,'Plot3d.m')+7)=[];
filetmp= [plot2dlibfilepath,'anovautil.mat'];
load(filetmp,'plotstringcell');




%get data
%-------------
hPlot3dList=get(hPlot3dMenuFig,'Userdata');
if ~isempty(findobj('tag','hanovadata'))
    factor = get(findobj('tag','hfactor'),'userdata');
elseif ~isempty(hPlot3dList) 
    uiwait(errordlg('Could not retrieve factor information!','Fatal error:'));
    return
end



if isempty(curplotmodel)
    curplotmodel = zeros(1,3);
    posthocmenu = findobj('tag','posthocmenu');
    if ~isempty(posthocmenu)
        set(posthocmenu,'Enable','off');
    end
end
if isempty(curplotmodel(1)) & isempty(curplotmodel(2)) & isempty(curplotmodel(3))
    nextxindex = 1;
    nextyindex = 1;
    nextzindex = 1;
else
    nextxindex = 0;
    nextyindex = 0;
    nextzindex = 0;
    t = 0;
    for t=1:size(curplotmodel,1)
        if curplotmodel(t,1)==0 & nextxindex == 0
            nextxindex = t;
        end
        if curplotmodel(t,2)==0 & nextyindex == 0
            nextyindex = t;
        end
        if curplotmodel(t,3)==0 & nextzindex == 0
            nextzindex = t;
        end
    end
    if nextxindex == 0
        nextxindex = t+1;
    end
    if nextyindex == 0
        nextyindex = t+1;
    end
    if nextzindex == 0
        nextzindex = t+1;
    end
end


if strcmp(action,'x+')
    
    xachsenpopup = findobj('tag','xachsenpopup'); 
    xval = get(xachsenpopup,'Value');
    vexist = 0; 
    for z=1:size(curplotmodel,1)
        if curplotmodel(z,1)~=0
            if xval == curplotmodel(z,1);
                vexist = 1;
            end
        end
    end
    if vexist == 0
        curplotmodel(nextxindex,1)= xval;
    end
       
    
elseif strcmp(action,'x-')
    xachsenpopup = findobj('tag','xachsenpopup');
    xval = get(xachsenpopup,'Value');
 
    vexist = 0; 
    for z=1:size(curplotmodel,1)
        if curplotmodel(z,1)~=0
            if xval == curplotmodel(z,1);
                vexist = 1;
                curplotmodel(z,1)=0;
            end
        end
    end
    if vexist==0
        %uiwait(errordlg('Could not delete factor because it had not been selected!','Error:'));
    end
    
elseif strcmp(action,'y+')
    yachsenpopup = findobj('tag','yachsenpopup');
    yval = get(yachsenpopup,'Value'); 
    vexist = 0; 
    for z=1:size(curplotmodel,1)
        if curplotmodel(z,2)~=0
            if yval == curplotmodel(z,2);
                vexist = 1;
            end
        end
    end
    if vexist == 0
        curplotmodel(nextyindex,2)= yval;
    end
    
elseif strcmp(action,'y-')
    yachsenpopup = findobj('tag','yachsenpopup'); 
    yval = get(yachsenpopup,'Value'); 
 
    vexist = 0; 
    for z=1:size(curplotmodel,1)
        if curplotmodel(z,2)~=0
            if yval == curplotmodel(z,2);
                vexist = 1;
                curplotmodel(z,2)=0;
            end
        end
    end
    if vexist==0
        %uiwait(errordlg('Could not delete factor because it had not been selected!','Error:'));
    end
    
elseif strcmp(action,'z+')
    zachsenpopup = findobj('tag','zachsenpopup'); 
    zval = get(zachsenpopup,'Value'); 
    vexist = 0; 
    for z=1:size(curplotmodel,1)
        if curplotmodel(z,3)~=0
            if zval == curplotmodel(z,3);
                vexist = 1;
            end
        end
    end
    if vexist == 0
        curplotmodel(nextzindex,3)= zval;
    end
    
elseif strcmp(action,'z-')
    zachsenpopup = findobj('tag','zachsenpopup'); 
    zval = get(zachsenpopup,'Value'); 
 
    vexist = 0; 
    for z=1:size(curplotmodel,1)
        if curplotmodel(z,3)~=0
            if zval == curplotmodel(z,3);
                vexist = 1;
                curplotmodel(z,3)=0;
            end
        end
    end
    if vexist==0
        %uiwait(errordlg('Could not delete factor because it had not been selected!','Error:'));
    end 
    
end

t = 1;
while t<=size(curplotmodel,1)
    if isempty(find(curplotmodel(t,:)))
        curplotmodel(t,:)=[];
        t=0;
    end
    t = t+1;
end
set(uigettextfigure,'userdata',curplotmodel);


instringtext = findobj('tag','instringtext');

xeffectstring = [];
yeffectstring = [];
zeffectstring = [];

if ~isempty(curplotmodel)
	if curplotmodel(1,1)~=0
        xeffectstring = [factor{curplotmodel(1,1),1}];
	end
    for t=2:size(curplotmodel,1)
        if curplotmodel(t,1)~=0
            xeffectstring = [xeffectstring ,' x ',factor{curplotmodel(t,1),1}];
        end
    end
    posthocmenu = findobj('Label','posthoc');
    if ~isempty(posthocmenu)
        set(posthocmenu,'Enable','on');
    end
else
    xeffectstring = '';
    
     posthocmenu = findobj('Label','posthoc');
    if ~isempty(posthocmenu)
        set(posthocmenu,'Enable','off');
    end
end

  
effectstring = [xeffectstring,yeffectstring,zeffectstring];
anovaaxes = findobj('tag','anovaaxes')
if ~isempty(effectstring)  
    %set(instringtext,'String',effectstring);
    if ~isempty(anovaaxes)
         axes(anovaaxes);
     end
    title(effectstring);
    set(anovaaxes,'XLabel',text('String',effectstring));
else 
    %set(instringtext,'String','no effect selected');
    
    if ~isempty(anovaaxes)
         axes(anovaaxes);
     end
    title('no effect selected');
    
    XLabel('');
end


anovadraw;
return
