function [varnames,filename,filepath,mode]=batchfilewaehlen(filename,filepath,mode)

%   batchfilewaehlen

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.          



batchmoderadio=findobj('tag','batchmoderadio');
fileradio=findobj('tag','fileradio');
filebutton=findobj('tag','filebutton');
directoryradio=findobj('tag','directoryradio');
batchfileradio=findobj('tag','batchfileradio');
batchfilebutton=findobj('tag','batchfilebutton');
directorybutton=findobj('tag','directorybutton');
filemonitor=findobj('tag','filemonitor');
batchfilemonitor=findobj('tag','batchfilemonitor');
directorymonitor=findobj('tag','directorymonitor');

initfilepath = SetDefPath(1);
[initfile,initpath] = SepFilePath(initfilepath);
[filename, filepath] = uigetfile(initfilepath, 'Bitte whlen das gewnscht File aus:', 300, 300);
if isequal(filename,0)| isequal(filepath,0)
       uiwait(errordlg('File not found!','Error:'));
       return
end
SetDefPath(2,filepath);

[filemat,mode]=batchfiletomat(filename,filepath,1);

varnames=cell(1);
varnames{1}='filename';
varnames{2}='filepath';
varnames{3}='mode';
if ~isempty(mode)
    set(batchfilemonitor, 'string', strcat(filepath,filename));
   cd (filepath);
end
return