function [gleichreqsmetmat,stimnummerncell]=checkgleichreqs(gleichreqs,celladressmat,groessenreqinds,dim,stimnummerncell,paramat,gleichreqsmetmat)
%   checkgleichreqs

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      

if ~isempty(gleichreqs{1,1})
    for j=1:size(gleichreqs,1)
        cell1adress=gleichreqs{j,2};
        cell2adress=gleichreqs{j,3};
        aktivecell1=find(groessenreqinds(:,3)==cell1adress);
        aktivecell2=find(groessenreqinds(:,3)==cell2adress);
        cell1anzahlstim=groessenreqinds(aktivecell1,2);
        cell2anzahlstim=groessenreqinds(aktivecell2,2);
        sample1=zeros(cell1anzahlstim,1);
        sample2=zeros(cell2anzahlstim,1);
        cellnummer1=find(celladressmat==gleichreqs{j,2});
        cellnummer2=find(celladressmat==gleichreqs{j,3});
        for dimzaehler=1:length(dim)
            if ~isempty(findstr(dim{dimzaehler},gleichreqs{j,4}))
                dimnummer=dimzaehler;
            end
        end
        for zaehler=1:cell1anzahlstim
            sample1(zaehler,1)=paramat(stimnummerncell{cellnummer1}(zaehler),dimnummer-1);
        end
        for zaehler=1:cell2anzahlstim
            sample2(zaehler,1)=paramat(stimnummerncell{cellnummer2}(zaehler),dimnummer-1);
        end
        h=0;
        
        if var(sample1)*var(sample2)~=0
                    [h,significance,ci] = ttest2(sample1,sample2,gleichreqs{j,5},0);
        else
            msgbox(['In einer der Stichproben besteht keine Varianz auf der Dimension "',dim{dimnummer},'"!',' Bedingung wird ignoriert!'],'Achtung:');
        end
        
        
        if h~=0
             [h,significance,ci] = ttest2(sample1,sample2,gleichreqs{j,5},1);
            if h~=1
                gleichreqsmetmat(j,1)=2; % -->cell1 < cell2  
            else
               gleichreqsmetmat(j,1)=1;  % --> cell1 > cell2
            end
        else
            gleichreqsmetmat(j,1)=0;
        end
    end
end 


return