function chooseappfile

%   chooseappfile

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
global appfilemat appmode
%app-files

[batappfilename,batappfilepath]=uigetfile('*.app*','bitte geben Sie ein Batchfile der app-files an:');
if isequal(batappfilename,0)|isequal(batappfilepath,0)
        uiwait(msgbox('File not found!','Error:'));
   return
else
   cd(batappfilepath);
   fid = fopen([batappfilepath,batappfilename],'r');
   FilePath=fgetl(fid);
   disp(FilePath);
   batchfilestatus = exist(FilePath,'file');
   if batchfilestatus ~= 0
       appfilemat=batchfiletomat(batappfilename,batappfilepath,0);
       disp('Batchfile found!');
       appmode = 12;
   else
       disp('app-single-file-mode initiated');
       appfilemat=cell(1);
       
       appfilemat{1}=[batappfilepath,batappfilename];
       appmode = 2;
   end
end

if isempty(appfilemat)
    appmode = 0;
    return;
else
    appfilemonitor=findobj('tag','appfilemonitor');
    set(appfilemonitor,'String',batappfilename);
    
end

return