function chooselogfile

%   chooselogfile

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
global logfilemat logmode


[batlogfilename,batlogfilepath]=uigetfile('*.log','Bitte geben Sie ein Batchfile der Logfiles an:');
    
if isequal(batlogfilename,0)|isequal(batlogfilepath,0)
        uiwait(msgbox('File not found!','Error:'));
        return
else
   fid = fopen([batlogfilepath,batlogfilename],'r');
   FilePath=fgetl(fid);
   disp(FilePath);
   batchfilestatus = exist(FilePath,'file');
   if batchfilestatus~=0
       logfilemat=batchfiletomat(batlogfilename,batlogfilepath,0);
       disp('Batchfile found!');
       logmode = 12;
   else
       disp('log-single-file-mode initiated');
       logfilemat=cell(1);
       logfilemat{1}=[batlogfilepath,batlogfilename];
       logmode = 2;
   end
end

if isempty(logfilemat);
    logmode = 0;
    return;
else
    logfilemonitor=findobj('tag','logfilemonitor');
    set(logfilemonitor,'String',batlogfilename);
end

return
