function choosetargetdir

%   choosetargetdir

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION. 

versionstring = version;
matlabnr = str2num(versionstring(1:3));
if matlabnr>6.1
    startpath = SetDefPath(1);
    startpath = startpath(1:max(findstr(startpath,filesep)));
    [targetfilepath]=uigetdir([startpath],'Please choose the start folder:');
    SetDefPath(2,[filepath,filesep]);
else
    startpath = SetDefPath(1);
    [filename,targetfilepath]=uiputfile([startpath,filesep,'*.*'],'Please create a file in the start folder:');
    if ~isequal(targetfilepath,0)
        SetDefPath(2,filepath);
    end
end


if isequal(targetfilepath,0)
   uiwait(errordlg('File not found'));
   return
end


targetdirectorymonitor=findobj('tag','targetdirectorymonitor');
set(targetdirectorymonitor,'String',targetfilepath);

return
