function comparelegfiles

%   comparelegfiles

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      


pppath =  which('ppfig.fig');
pppath(end-8:end)=[];

if exist('comparepaths.mat')==0
	[filename1,filepath1]=uigetfile('*.*','please choose file1:');
	[filename2,filepath2]=uigetfile('*.*','please choose file2:');
    filepath1 = [filepath1,filename1];
    filepath2 = [filepath2,filename2];
    save([pppath 'comparepaths.mat'],'filepath1','filepath2');
	fid1 = fopen(filepath1,'r','b');
	fid2 = fopen(filepath2,'r','b');
else
    answer = questdlg('Do you wish to use last-time-paths?','cache:','Yes','No','Yes');
    if strcmp(answer,'Yes')
        load([pppath 'comparepaths.mat'],'filepath1','filepath2');
		fid1 = fopen(filepath1,'r','b');
		fid2 = fopen(filepath2,'r','b');
    else
        load([pppath 'comparepaths.mat'],'filepath1','filepath2');
        [pathstr,name,ext,versn]=fileparts(filepath1);
        cd(pathstr);
		[filename1,filepath1]=uigetfile('*.*','please choose file1:');
        [pathstr,name,ext,versn]=fileparts(filepath2);
        cd(pathstr);
		[filename2,filepath2]=uigetfile('*.*','please choose file2:');
        filepath1 = [filepath1,filename1];
        filepath2 = [filepath2,filename2];
        save([pppath 'comparepaths.mat'],'filepath1','filepath2');
		fid1 = fopen(filepath1,'r','b');
		fid2 = fopen(filepath2,'r','b');
    end
end
        
    





[ScalpLegVec1] =fread(fid1,inf,'float32');
[ScalpLegVec2] =fread(fid2,inf,'float32');


fclose(fid1);
fclose(fid2);

ScalpLegVec1 == ScalpLegVec2

n1 = num2str(length(find((ScalpLegVec1-ScalpLegVec2)<0.00000001)))

fprintf(1,[num2str(length(find((ScalpLegVec1-ScalpLegVec2)<0.00000001))),' von ',num2str(length(ScalpLegVec1)),' Differenzen kleiner als 1*e-8!\n']);
fprintf(1,[num2str(length(find((ScalpLegVec1-ScalpLegVec2)<0.0001))),' von ',num2str(length(ScalpLegVec1)),' Differenzen kleiner als 0.0001!\n']);

ScalpLegVec1indices =find(ScalpLegVec1~=ScalpLegVec2);
ScalpLegVec2indices =find(ScalpLegVec1~=ScalpLegVec2);

NaN1 =length(find(isnan(ScalpLegVec1(ScalpLegVec1indices))));
NaN2 =length(find(isnan(ScalpLegVec2(ScalpLegVec1indices))));

fprintf(1,[num2str(NaN1),' Werte in file 1 waren NaN!\n']);
fprintf(1,[num2str(NaN2),' Werte in file 2 waren NaN!\n']);
if NaN1==NaN2 & str2num(n1)+NaN1==length(ScalpLegVec1)
    fprintf(1,['Nur NaN-paare waren nicht identisch!\n']);
end    

return