function [varnames,filename,filepath,mode]=directorywaehlen(filename,filepath,mode)

%   directorywaehlen

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION. 

mversion = version;
mvnr = str2num(mversion(1:3));

batchmoderadio=findobj('tag','batchmoderadio');
fileradio=findobj('tag','fileradio');
filebutton=findobj('tag','filebutton');
directoryradio=findobj('tag','directoryradio');
batchfileradio=findobj('tag','batchfileradio');
batchfilebutton=findobj('tag','batchfilebutton');
directorybutton=findobj('tag','directorybutton');
filemonitor=findobj('tag','filemonitor');
batchfilemonitor=findobj('tag','batchfilemonitor');
directorymonitor=findobj('tag','directorymonitor');


if mvnr>6.1
    initpath = SetDefPath(1);
    [file,initpath] = SepFilePath(initpath);
    if isempty(initpath);initpath = '';end
    [filepath] = uigetdir(initpath,'Please choose folder:');
    if isequal(filepath,0)
       return
	end
    SetDefPath(2,[filepath,filesep]);
else
    initpath = SetDefPath(1);
    [file,initpath] = SepFilePath(initpath);
    if isempty(initpath);initpath = '';end
    [filename, filepath] = uiputfile(initpath, 'Please create file in target folder:', 300, 300);
	if isequal(filename,0)| isequal(filepath,0)
       uiwait(errordlg('File not found!','Error:'));
       return
	end
    SetDefPath(2,[filepath,filesep]);
end
    
    

mode=11;
filename='';
varnames=cell(1);
varnames{1}='filename';
varnames{2}='filepath';
varnames{3}='mode';


set(directorymonitor, 'string', strcat(filepath,filename));
if isstr(filepath)
   cd (filepath);
end
return