function displayeegquery

%  displayeegquery

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      

global handles paramat paravec repeatstatus NChan NPoints normalization anzahldifftrials anzahltottrials...
    stimulinames trialanzahl anzahlvp reihenfolgematcell



answerempty = questdlg('Exclude empty trials?','Display-options:',...
                    'yes','no','yes');
if strcmp(answerempty,'yes')
    emptystring='non-empty';
else
    emptystring='all';
end

answerrepeat = questdlg('Average repeated trials?','Display-options:',...
                    'yes','no','yes');    
 
if strcmp(answerrepeat,'yes')
    repeatstring='(repetitions averaged)';
else
    repeatstring='(repetitions not averaged)';
end

answerstimulinames = questdlg('Show names of the 10 stimuli with maximum parameter values?','Stimulinames:',...
                    'yes','no','yes');
                

%All trials, all repetitions
%---------------------------------------------
%paramat (paramat=zeros(trialanzahl,anzahlvp);), z.B. 400 X 19
paramat=paramat;
%paravec (paravec=zeros(trialanzahl,1);) z.B. 400 X 1
paravec=paravec;
 

%All trials, averaged repetitions
%---------------------------------------------
%avgparamat (avgparamat=zeros(size(reihenfolgematcell{1},1),anzahlvp);) z.B. 200 X 19
%avgdata (avgdata = zeros(size(reihenfolgematcell{1},1),anzahlvp,size(reihenfolgematcell{1},2));) z.B. 200 X 19 X 2
if repeatstatus~=0
    avgdata=zeros(size(reihenfolgematcell{1},1),anzahlvp,size(reihenfolgematcell{1},2));
    avgdataweightmat=zeros(size(reihenfolgematcell{1},1),anzahlvp,size(reihenfolgematcell{1},2));
end
avgparamat=zeros(size(reihenfolgematcell{1},1),anzahlvp);
weightmat=zeros(size(reihenfolgematcell{1},1),anzahlvp);
for j=1:anzahlvp
    for k=1:size(reihenfolgematcell{1},2)
        for i=1:size(reihenfolgematcell{1},1)
            if paramat(find(reihenfolgematcell{j}(:,k)==i)+(k-1)*size(reihenfolgematcell{1},1),j)~=-1
                avgparamat(i,j)=avgparamat(i,j)+paramat(find(reihenfolgematcell{j}(:,k)==i)+(k-1)*size(reihenfolgematcell{1},1),j);
                weightmat(i,j)=weightmat(i,j)+1;
                if repeatstatus~=0
                    avgdata(i,j,k)=avgdata(i,j,k)+paramat(find(reihenfolgematcell{j}(:,k)==i)+(k-1)*size(reihenfolgematcell{1},1),j);
                    avgdataweightmat(i,j,k)=avgdataweightmat(i,j,k)+1;
                end
            end
        end
    end
end
weightmat(find(weightmat==0))=1;
avgparamat=avgparamat./weightmat;
avgdataweightmat(find(avgdataweightmat==0))=1;
avgdata=avgdata./avgdataweightmat;               

%avgparavec (avgparavec=zeros(size(reihenfolgematcell{1},1),1);) z.B. 200 X 1
%avgvecdata (avgvecdata=zeros(size(reihenfolgematcell{1},1),size(reihenfolgematcell{1},2));) z.B. 200 X 2
avgparavec=zeros(size(reihenfolgematcell{1},1),1);
weightvec=zeros(size(reihenfolgematcell{1},1),1);
avgvecdata=zeros(size(reihenfolgematcell{1},1),size(reihenfolgematcell{1},2));
avgvecweightvec=zeros(size(reihenfolgematcell{1},1),size(reihenfolgematcell{1},2));
for s=1:size(reihenfolgematcell{1},1)
    for t=1:anzahlvp
        %Gesamt
        if avgparamat(s,t)~=0
            avgparavec(s)=avgparavec(s)+avgparamat(s,t);
            weightvec(s)=weightvec(s)+1;
        end
        %separat fr Wiederholungen
        for u=1:repeatstatus+1
            if avgdata(s,t,u)~=0
                avgvecdata(s,u)=avgvecdata(s,u)+avgdata(s,t,u);
                avgvecweightvec(s,u)=avgvecweightvec(s,u)+1;
            end
        end  
    end
    if weightvec(s)~=0
        avgparavec(s)=avgparavec(s)./weightvec(s);
    else 
        avgparavec(s)=-1;
    end
    for u=1:repeatstatus+1
        if avgvecweightvec(s,u)~=0
            avgvecdata(s,u)=avgvecdata(s,u)./avgvecweightvec(s,u);
        end
    end     
    if mod(s,5)==0
        fprintf('.');
    end
    if mod(s,100)==0
        fprintf('\n');
    end
end


%Non-emtpy trials, all repetitions
%---------------------------------------------
%paramattmp=paramat; paramattmp(excludetrialvec,:)=[]; z.B. 200 X 19
%paravectmp=paravec;paravectmp(excludetrialvec)=[]; z.B. 200 X 1 

countexcludetrials=0;
for i=1:size(paramat,1)
    if sum(paramat(i,:)==-1)==anzahlvp
        countexcludetrials=countexcludetrials+1;
        excludetrialvec(countexcludetrials)=i;
    end
end
paramattmp=paramat;
paravectmp=paravec;
paramattmp(excludetrialvec,:)=[];
paravectmp(excludetrialvec)=[];
  
%Non-emtpy trials, averaged repetitions
%---------------------------------------------
% avgparamattmp=avgparamat;avgparamattmp(excludetrialvec,:)=[]; z.B. 100 X 19
% avgparavectmp=avgparavec;avgparavectmp(excludetrialvec)=[]; z.B. 100 X 1
% avgdatatmp=avgdata;avgdatatmp(excludetrialvec,:,:)=[]; z.B. 100 X 19 X 2
% avgvecdatatmp=avgvecdata;avgvecdatatmp(excludetrialvec,:)=[]; z.B. 100 X 2

%exclude emptytrials
countexcludetrials=0;
excludetrialvec=[];
for i=1:size(avgparamat,1)
    if sum(avgparamat(i,:)==0)==anzahlvp
        countexcludetrials=countexcludetrials+1;
        excludetrialvec(countexcludetrials)=i;
    end
end
%tmp-mats
avgparamattmp=avgparamat;
avgparavectmp=avgparavec;
avgdatatmp=avgdata;
avgvecdatatmp=avgvecdata;
avgparamattmp(excludetrialvec,:)=[];
avgparavectmp(excludetrialvec)=[];
avgdatatmp(excludetrialvec,:,:)=[];
avgvecdatatmp(excludetrialvec,:)=[];
            



%Plot data
%-------------------------------------------------------------------------------
    
			%plot paramat
            titlestring = ['EEGquery: Parameters over ',emptystring,' trials ',repeatstring];
			figure('Name',titlestring,'Numbertitle','off');
			linehandle=[];
			colors=colormap;
			hold on
            if strcmp(answerempty,'no')
                if strcmp(answerrepeat,'no')
					for i=1:size(paramat,2)
                        linehandle(i)=plot(paramat(:,i),'color',colors(round((length(colors)/size(paramat,2)))*i,:));
					end
					legendtext=num2str(linspace(1,anzahlvp,anzahlvp)');
					legend(linehandle',legendtext);
                elseif strcmp(answerrepeat,'yes')
                    for i=1:size(avgparamat,2)
                        linehandle(i)=plot(avgparamat(:,i),'color',colors(round((length(colors)/size(avgparamat,2)))*i,:));
			        end
			        hold off
			        legendtext=num2str(linspace(1,anzahlvp,anzahlvp)');
			        legend(linehandle',legendtext);
                end
                
            elseif strcmp(answerempty,'yes')
                   if strcmp(answerrepeat,'no')
                        for i=1:size(paramat,2)
                            linehandle(i)=plot(paramattmp(:,i),'color',colors(round((length(colors)/size(paramat,2)))*i,:));
					    end
					    hold off
					    legendtext=num2str(linspace(1,anzahlvp,anzahlvp)');
					    legend(linehandle',legendtext);
                   elseif strcmp(answerrepeat,'yes')
						for i=1:size(avgparamattmp,2)
                            linehandle(i)=plot(avgparamattmp(:,i),'color',colors(round((length(colors)/size(avgparamattmp,2)))*i,:));
						end
						hold off
						legendtext=num2str(linspace(1,anzahlvp,anzahlvp)');
						legend(linehandle',legendtext);
                   end
            end
            hold off
            
            
               %stimulinamen
			hold on 
            if strcmp(answerempty,'no')
                if strcmp(answerrepeat,'no')
                    difftrials=length(stimulinames{1});
                    for j=1:size(paramat,2)
                        for i=1:repeatstatus+1
							for k=1:difftrials
							      text(((i-1)*difftrials+k)*1.02,paramat((i-1)*difftrials+k,j),stimulinames{1}{reihenfolgematcell{1}(k,i)});
							end
                        end
                    end
                elseif strcmp(answerrepeat,'yes')
                    for j=1:size(avgparamat,2)
                        for k=1:size(avgparamat,1)
						      text(k*1.02,avgparamat(k,j),stimulinames{1}{k});
						end
                    end
                end
            elseif strcmp(answerempty,'yes')
                if strcmp(answerrepeat,'no')
                    difftrials=length(stimulinames{1});
                    difftrialstmp=difftrials-length(excludetrialvec);
                    stimulinamestmp=stimulinames{1};
                    stimulinamestmp(excludetrialvec)=[];
                    for j=1:size(paramattmp,2)
                        for i=1:max(repeatstatus)+1
							for k=1:difftrialstmp
							      text(((i-1)*difftrialstmp+k)*1.02,paramattmp((i-1)*difftrialstmp+k,j),stimulinamestmp{ceil((reihenfolgematcell{1}(k,i))/2)});
							end
                        end
                    end
                    
                elseif strcmp(answerrepeat,'yes')
                    stimulinamestmp=stimulinames{1};
                    stimulinamestmp(excludetrialvec)=[];
                    for j=1:size(avgparamattmp,2)
						for k=1:length(avgparavectmp)
						      text(k*1.02,avgparamattmp(k,j),stimulinames{1}{k})
						end
                    end
                end
            end
            hold off
                    
			%plot paravec
            titlestring = ['EEGquery: VP-average-parameters over ',emptystring,' trials ',repeatstring];
			figure('Name',titlestring,'Numbertitle','off');
            if strcmp(answerempty,'no')
                if strcmp(answerrepeat,'no')
                    plot(paravec)
                elseif strcmp(answerrepeat,'yes')
                    plot(avgparavec)
                end
            elseif strcmp(answerempty,'yes')
                if strcmp(answerrepeat,'no')
                    plot(paravectmp)
                elseif strcmp(answerrepeat,'yes')
                    plot(avgparavectmp)
                end
            end
              
            %stimulinamen
			hold on 
            if strcmp(answerempty,'no')
                if strcmp(answerrepeat,'no')
                    difftrials=length(stimulinames{1});
                    for i=1:repeatstatus+1
						for k=1:difftrials
						      text(((i-1)*difftrials+k)*1.02,paravec((i-1)*difftrials+k),stimulinames{1}{reihenfolgematcell{1}(k,i)});
						end
                    end
                elseif strcmp(answerrepeat,'yes')
					for k=1:length(avgparavec)
					      text(k*1.02,avgparavec(k),stimulinames{1}{k});
					end
                end
            elseif strcmp(answerempty,'yes')
                if strcmp(answerrepeat,'no')
                    difftrials=length(stimulinames{1});
                    difftrialstmp=difftrials-length(excludetrialvec);
                    stimulinamestmp=stimulinames{1};
                    stimulinamestmp(excludetrialvec)=[];
                    for i=1:max(repeatstatus)+1
						for k=1:difftrialstmp
						      text(((i-1)*difftrialstmp+k)*1.02,paravectmp((i-1)*difftrialstmp+k),stimulinamestmp{ceil((reihenfolgematcell{1}(k,i))/2)});
						end
                    end
                    
                elseif strcmp(answerrepeat,'yes')
                    stimulinamestmp=stimulinames{1};
                    stimulinamestmp(excludetrialvec)=[];
					for k=1:length(avgparavectmp)
					      text(k*1.02,avgparavectmp(k),stimulinames{1}{k})
					end
                end
            end
            hold off
            
            
            %plot repeatcomparison
            
            if strcmp(answerrepeat,'yes')
                titlestring=['EEGquery: VP-average-parameter over ',emptystring,' trials separately for repetitions'];
                figure('Name',titlestring,'Numbertitle','off');
                hold on
                if strcmp(answerrepeat,'no')
                    
                    for i=1:size(avgvecdata,2)
                        linehandle(i)=plot(avgvecdata(:,i),'color',colors(round((length(colors)/size(avgvecdata,2)))*i,:));
					end
					legendtext=num2str(linspace(1,size(avgvecdata,2),size(avgvecdata,2))');
					legend(linehandle',legendtext);
                    
                elseif strcmp(answerrepeat,'yes')
                    
                    for i=1:size(avgvecdata,2)
                        linehandle(i)=plot(avgvecdatatmp(:,i),'color',colors(round((length(colors)/size(avgvecdatatmp,2)))*i,:));
					end
					legendtext=num2str(linspace(1,size(avgvecdatatmp,2),size(avgvecdatatmp,2))');
					legend(linehandle',legendtext);
                    
                end
                hold off
            end


if strcmp(answerstimulinames,'yes')
    dlgcell=cell(anzahlvp,1);
    rowmat=[];
    for t=1:anzahlvp
        sortedvalues=sort(avgparamattmp(:,t),1);
        maxtenvalues=sortedvalues(end-10:end);
        rowvec=[];
        dlgcell{t}=['VP ',num2str(t),':'];
        for u=1:10
            rowvec=[rowvec, str2num(stimulinames{t}{(find(avgparamattmp(:,t)==maxtenvalues(u)))*2-1})];
        end
        rowvec=sort(rowvec);
        rowmat=[rowmat;rowvec];
        dlgcell{t}=[dlgcell{t},num2str(rowvec)];
    end
    fprintf('\n\nStimulinamen nach Hufigkeit des Vorkommens\n');
    fprintf('unter den 10 Stimuli mit den hchsten Parameterwerten pro Versuchsperson....\n');
    [elements]=finddiffel(rowmat)
    
end



return



%Grenze per var
% [y,x]=ind2sub(size(gpmat),find(gpmat>0.2)); 
% 
% 
% picindices=finddiffel(x);
% length(picindices)
% 
% for u=1:length(picindices)
%     fprintf(1,[order_lpls{   (u)},'\n'])
% end



((reihenfolgematcell{1}(k,i))+1)/2;
				