function editeconfig(EConfigFilePath)

%   editeconfig

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      

if nargin<1;EConfigFilePath =[];end

if isempty(EConfigFilePath)
    [nouse1,Plot2dFolder]=SepFilePath(which('Plot2d.m'));
    cd([Plot2dFolder,'Plot2dUtil\SensorCfg\']);
    [ecfgfilename,ecfgpath]=uigetfile('*.ecfg','please choose ecfg-file to remove the reference channel of:');
    if isequal(ecfgfilename,0)| isequal(ecfgpath,0)
        return
    end
    EConfigFilePath = [ecfgpath,ecfgfilename];
end


[NChan,SpherRadius,EPosSpher,ENames,EConfigFile,EConfigPath,EConfigFilePath]=ReadEConfig(EConfigFilePath);
EPosSpher([50,63],:)=EPosSpher([63,50],:);
    
filterspec = [num2str(NChan),'.ecfg'];
[savefilename,savefilepath]=uiputfile(filterspec,'Please name reduced ecfg-file:');
SaveFile =[savefilepath,savefilename];
[FilePath]=SaveEConfig(EPosSpher,ENames,'.ecfg',SaveFile);

return