function [dataout]=expdata(filename,filepath,subjects,zeitpunkte,channelgroups,movies,printstatus)

%   expdata - rearranges exported text-files from emegs2d.
%
%   See also PP.

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
if nargin < 7
    printstatus = 0;
end
if nargin < 3
    extstatus = 0;
else
    extstatus = 1;
end
if nargin < 2
    filepath = [];
end
file = [filepath,filename];
filehandle=fopen(file,'rt');

if filehandle == -1
    uiwait(errordlg(['Could not open data-export-file: ',file],'Error:'));
    dataout = [];
    return
end

if extstatus == 0 
	% prepare datamat
	subjectedit=findobj('tag','subjectedit');
	subjectstring=str2num(get(subjectedit,'String'));
	subjects=subjectstring;
	zeitpunkteedit=findobj('tag','zeitpunkteedit');
	zeitpunktestring=str2num(get(zeitpunkteedit,'String'));
	zeitpunkte=zeitpunktestring;
	channelgroupedit=findobj('tag','channelgroupedit');
	channelgroupstring=str2num(get(channelgroupedit,'String'));
	channelgroups=channelgroupstring;
	movieedit=findobj('tag','movieedit');
	moviestring=str2num(get(movieedit,'String'));
	movies=moviestring;
end

spaltenzahl=zeitpunkte*channelgroups*movies;
zeilenzahl=subjects;

data=cell(zeilenzahl,spaltenzahl);
% read header
header = fgetl(filehandle);
whiteline=fgetl(filehandle);



if isempty(findstr(header,'Shell_Number'))
     
%Scalp,CSD
%----------
	%read datamat und rowtitlemat
	for moviezaehler=1:movies
      for zeilenzaehler=1:zeilenzahl
       	for channelgroupzaehler=1:channelgroups
            line=fgetl(filehandle);
            whitespace=findstr(line,char(9));
            if ~isempty(whitespace)
                index=channelgroupzaehler+((zeilenzaehler-1)*channelgroups)+((moviezaehler-1)*zeilenzahl*channelgroups);
                rowtitle{channelgroupzaehler+((zeilenzaehler-1)*channelgroups)+((moviezaehler-1)*zeilenzahl*channelgroups)}=line(1:whitespace(10)-1);
           		rowtitle{index}(findstr(rowtitle{index},char(9)))=[];
                for zeitpunktezaehler=1:zeitpunkte
                   if zeitpunktezaehler==1
                          data{zeilenzaehler,(moviezaehler-1)*channelgroups*zeitpunkte+(channelgroupzaehler-1)*zeitpunkte+zeitpunktezaehler}=str2num(line(whitespace(12)+1:whitespace(12+zeitpunktezaehler)-1));
                   elseif zeitpunktezaehler< zeitpunkte
                          data{zeilenzaehler,(moviezaehler-1)*channelgroups*zeitpunkte+(channelgroupzaehler-1)*zeitpunkte+zeitpunktezaehler}=str2num(line(whitespace(12+zeitpunktezaehler-1)+1:whitespace(12+zeitpunktezaehler)-1));
                   elseif zeitpunktezaehler==zeitpunkte
                         data{zeilenzaehler,(moviezaehler-1)*channelgroups*zeitpunkte+(channelgroupzaehler-1)*zeitpunkte+zeitpunktezaehler}=str2num(line(whitespace(12+zeitpunktezaehler-1)+1:end));
                
                   end
                end
           end
        end
      end
	end

%MinimumNorm
%---------------
else
    %read datamat und rowtitlemat
	for moviezaehler=1:movies
      for zeilenzaehler=1:zeilenzahl
       	for channelgroupzaehler=1:channelgroups
            line=fgetl(filehandle);
            whitespace=findstr(line,char(9));
          	rowtitle{zeilenzaehler}=line(1:whitespace(10)-1);
           for zeitpunktezaehler=1:zeitpunkte
               if zeitpunktezaehler==1
                      data{zeilenzaehler,(moviezaehler-1)*channelgroups*zeitpunkte+(channelgroupzaehler-1)*zeitpunkte+zeitpunktezaehler}=str2num(line(whitespace(13)+1:whitespace(13+zeitpunktezaehler)-1));
               elseif zeitpunktezaehler< zeitpunkte
                      data{zeilenzaehler,(moviezaehler-1)*channelgroups*zeitpunkte+(channelgroupzaehler-1)*zeitpunkte+zeitpunktezaehler}=str2num(line(whitespace(13+zeitpunktezaehler-1)+1:whitespace(13+zeitpunktezaehler)-1));
               elseif zeitpunktezaehler==zeitpunkte
                     data{zeilenzaehler,(moviezaehler-1)*channelgroups*zeitpunkte+(channelgroupzaehler-1)*zeitpunkte+zeitpunktezaehler}=str2num(line(whitespace(13+zeitpunktezaehler-1)+1:end));
            
               end
           end
        end
      end
	end 

end

if extstatus == 0 
    [targetfilename,targetfilepath]=uiputfile('*.txt','Please name the datafile:');
    if isempty(findstr(targetfilename,'.txt'))
        targetfilename=[targetfilename '.txt'];
    end
    targetfile = [targetfilepath targetfilename];
	targetfilehandle=fopen(targetfile,'wt');
        
	%write header
	header='filename;';
	for moviezaehler=1:movies
       for channelgroupzaehler=1:channelgroups
          for zeitpunktezaehler=1:zeitpunkte
             variablename=sprintf('\tm%ic%it%i;',moviezaehler,channelgroupzaehler,zeitpunktezaehler);
             header=strrep(header,';',variablename);
          end
       end
	end
	header=strrep(header,';','');
	fprintf(targetfilehandle,'%c',header);
	fprintf(targetfilehandle,'\n');
	
	%write data
	for zeilenzaehler=1:zeilenzahl
       fprintf(targetfilehandle,'%c',rowtitle{zeilenzaehler*channelgroups});
       fprintf(targetfilehandle,'\t');
       for spaltenzaehler=1:spaltenzahl
          fprintf(targetfilehandle,'%f\t',data{zeilenzaehler,spaltenzaehler});
       end
       fprintf(targetfilehandle,'\n');
	end
	fclose(targetfilehandle);

else
    
    if printstatus == 1
        [targetfilename,targetfilepath]=uiputfile('*.txt','Please name the datafile:');
        if isempty(findstr(targetfilename,'.txt'))
            targetfilename=[targetfilename '.txt'];
        end
        targetfile = [targetfilepath targetfilename];
		targetfilehandle=fopen(targetfile,'wt');
        header='filename;';
		for moviezaehler=1:movies
           for channelgroupzaehler=1:channelgroups
              for zeitpunktezaehler=1:zeitpunkte
                 variablename=sprintf('\tm%ic%it%i;',moviezaehler,channelgroupzaehler,zeitpunktezaehler);
                 header=strrep(header,';',variablename);
              end
           end
		end
		header=strrep(header,';','');
		fprintf(targetfilehandle,'%c',header);
		fprintf(targetfilehandle,'\n');
    
        
        for zeilenzaehler=1:zeilenzahl
           fprintf(targetfilehandle,'%c',rowtitle{zeilenzaehler*channelgroups});
           fprintf(targetfilehandle,'\t');
           for spaltenzaehler=1:spaltenzahl
               fprintf(targetfilehandle,[num2str(data{zeilenzaehler,spaltenzaehler}),'\t']);
               dataout(zeilenzaehler,spaltenzaehler)=data{zeilenzaehler,spaltenzaehler};
           end
		   fprintf(targetfilehandle,'\n');
		end
        
        fclose (targetfilehandle);
        
    else
        dataout = zeros(zeilenzahl,spaltenzahl);
        try
            %cell to array
			for zeilenzaehler=1:zeilenzahl
               for spaltenzaehler=1:spaltenzahl
                   dataout(zeilenzaehler,spaltenzaehler)=data{zeilenzaehler,spaltenzaehler};
               end
			end
            
        catch
            dataout=[];
        end
            
    end
    
end

fclose(filehandle);

if nargout<1
    dataout =[];
end


return