function fig2mfile

%   fig2mfile

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      

pplibpath = which('pp.m');
[File,Path] = SepFilePath(pplibpath);
cd(Path);
[figfilename,figfilepath]=uigetfile('*.fig','Please choose fig-file:');
if isequal(figfilename,0) | isequal(figfilepath,0)
    return
end
figfile=[figfilepath,figfilename];
fig=openfig(figfile);

handles=get(fig,'children');

[mfilename,mfilepath]=uiputfile('*.m','Please name m-file:');
mfile=[mfilepath,mfilename];
if isempty(findstr(mfile,'.m'))
    mfile=[mfile,'.m'];
end




figposition=get(fig,'position');
figunits=get(fig,'Units');
figtag=get(fig,'tag');
if ~isempty(get(fig,'color'))
    color=get(fig,'color');
else
    color=[];
end
figname=get(fig,'Name');
fignrtitle=get(fig,'Numbertitle');
figmenubar=get(fig,'Menubar');
figresize=get(fig,'Resize');




fid=fopen(mfile,'wt');

fprintf(fid,'%s',['%figure']);
fprintf(fid,'\n');
fprintf(fid,'%s',['%---------------']);
fprintf(fid,'\n');

fprintf(fid,[figtag,'= figure(...\n',char(39),'units',char(39),',',char(39),figunits,char(39),',...\n',char(39),'position',char(39),',[',num2str(figposition),'],...\n',char(39),'units',char(39),',',char(39),figunits,char(39),',...\n']);
fprintf(fid,[char(39),'color',char(39),',[',num2str(color),'],...\n',char(39),'Name',char(39),',',char(39),figname,char(39),',...\n',char(39),'Numbertitle',char(39)]);
fprintf(fid,[',',char(39),fignrtitle,char(39),',...\n',char(39),'Resize',char(39),',',char(39),figresize,char(39),',...\n',char(39),'Menubar',char(39),',',char(39),figmenubar,char(39),',...\n',char(39),'units',char(39),',',char(39),figunits,char(39),');']);
fprintf(fid,'\n\n');


for i=1:length(handles)
    %try
        style=[];
        callback=[];
        position=[];
        value=[];
        backgroundcolor=[];
        controlstring=[];
        controlhalignment=[];
        foregroundcolor=[];
        labelstring = [];

        if ~strcmp(get(handles(i),'type'),'axes') & ~strcmp(get(handles(i),'type'),'uipanel')
            style=get(handles(i),'style');
            callback=get(handles(i),'Callback');
            position=get(handles(i),'position');
            value=get(handles(i),'Value');
            tag=get(handles(i),'tag');
            labelstring = get(handles(i),'String');
            controlunits=get(handles(i),'units');
            backgroundcolor=get(handles(i),'Backgroundcolor');
            foregroundcolor=get(handles(i),'foregroundcolor');
        elseif strcmp(get(handles(i),'type'),'uipanel')
            style=[];
            callback=[];
            position=get(handles(i),'position');
            value=[];
            backgroundcolor=[];
            labelstring = get(handles(i),'Title');
            controlstring=[];
            controlhalignment=[];
            tag=get(handles(i),'tag');
            controlunits=get(handles(i),'units');
            foregroundcolor=[];
        else
            
            style=[];
            callback=[];
            position=get(handles(i),'position');
            value=[];
            backgroundcolor=[];
            controlstring=[];
            labelstring = [];
            controlhalignment=[];
            tag=get(handles(i),'tag');
            controlunits=get(handles(i),'units');
            foregroundcolor=[];
        end



        fprintf(fid,'%s',['%',tag]);
        fprintf(fid,'\n');
        fprintf(fid,'%s','%----------------');
        fprintf(fid,'\n');
        
        %uicontrol,uipanel,axes
        %--------------
        if ~strcmp(get(handles(i),'type'),'axes') & ~strcmp(get(handles(i),'type'),'uipanel')
            fprintf(fid,[tag,'= uicontrol(...',char(10),char(39),'units',char(39),',',char(39),controlunits,char(39),',...\n',char(39),'style',char(39),',',char(39),style,char(39),',...\n',char(39),'position',char(39),',[',num2str(position),']']);
        elseif strcmp(get(handles(i),'type'),'uipanel')
            fprintf(fid,[tag,'= uipanel(...',char(10),char(39),'units',char(39),',',char(39),controlunits,char(39),',...\n',char(39),'position',char(39),',[',num2str(position),']']);
        else
            fprintf(fid,[tag,'= axes(...',char(10),char(39),'units',char(39),',',char(39),controlunits,char(39),',',char(39),',...\n',char(39),'position',char(39),',[',num2str(position),']']);
        end
        
        %backgroundcolor
        %--------------
        if ~isempty(backgroundcolor)
            fprintf(fid,[',...\n',char(39),'backgroundcolor',char(39),',[',num2str(backgroundcolor),']']);
        end
        
        %foregroundcolor
        %--------------
        if ~isempty(foregroundcolor)
            fprintf(fid,[',...\n',char(39),'foregroundcolor',char(39),',[',num2str(foregroundcolor),']']);
        end
        
        %string
        %--------------
        if ~strcmp(get(handles(i),'type'),'axes') & ~strcmp(get(handles(i),'type'),'uipanel')
            controlstring= labelstring;
            if iscell(controlstring)
                 fprintf(fid,[',...\n',char(39),'String',char(39),',','{']);
                fprintf(fid,[char(39),controlstring{1},char(39)]); 
                for i=2:size(controlstring,1)
                    fprintf(fid,[',',char(39),controlstring{i},char(39)]); 
                end
                fprintf(fid,['}']);
            else
                fprintf(fid,[',...\n',char(39),'String',char(39),',''',controlstring,'''']);
            end
        elseif strcmp(get(handles(i),'type'),'uipanel')
            fprintf(fid,[',...\n',char(39),'Title',char(39),',''',labelstring,'''']);
        end
        
        %callback
        %--------------
        if ~isempty(callback)
            if ~isempty(findstr(callback,char(39)))
                callback=strrep(callback,char(39),[char(39),char(39)]);
            end
            callback = callback
            fprintf(fid,[',...\n',char(39),'Callback',char(39),',',char(39),callback,char(39)]);
        end
        
        
        %value
        %--------------
        if ~isempty(value)
             fprintf(fid,[',...\n',char(39),'Value',char(39),',',num2str(value)]);
        end
        
        
        %tag
        %--------------
        if ~isempty(tag)
            fprintf(fid,[',...\n',char(39),'tag',char(39),',',char(39),tag,char(39)]); 
        end
        
        
        %HorizontalAlignment
        %--------------
        if ~isempty(controlhalignment)
            fprintf(fid,[',...\n',char(39),'HorizontalAlignment',char(39),',',char(39),controlhalignment,char(39)]); 
        end
        fprintf(fid,');\n\n');
        
        
        
        childchild = get(handles(i),'children');
        topposition = get(handles(i),'Position');
        topfactor = [topposition(3),topposition(4),topposition(3),topposition(4)];
        if ~isempty(childchild)
            for r=1:length(childchild)
                
                style=[];
                callback=[];
                position=[];
                value=[];
                backgroundcolor=[];
                controlstring=[];
                controlhalignment=[];
                foregroundcolor=[];
                labelstring = [];

                if ~strcmp(get(childchild(r),'type'),'axes') & ~strcmp(get(childchild(r),'type'),'uipanel')
                    style=get(childchild(r),'style');
                    callback=get(childchild(r),'Callback');
                    position=get(childchild(r),'position');
                    position = topposition + position.*topfactor;
                    value=get(childchild(r),'Value');
                    tag=get(childchild(r),'tag');
                    labelstring = get(childchild(r),'String');
                    controlunits=get(childchild(r),'units');
                    backgroundcolor=get(childchild(r),'Backgroundcolor');
                    foregroundcolor=get(childchild(r),'foregroundcolor');
                elseif strcmp(get(childchild(r),'type'),'uipanel')
                    style=[];
                    callback=[];
                    position=get(childchild(r),'position');
                    position = topposition + position.*topfactor;
                    value=[];
                    backgroundcolor=[];
                    labelstring = get(childchild(r),'Title');
                    controlstring=[];
                    controlhalignment=[];
                    tag=get(childchild(r),'tag');
                    controlunits=get(childchild(r),'units');
                    foregroundcolor=[];
                else
                    style=[];
                    callback=[];
                    position=get(childchild(r),'position');
                    position = topposition + position.*topfactor;
                    value=[];
                    backgroundcolor=[];
                    controlstring=[];
                    labelstring = [];
                    controlhalignment=[];
                    tag=get(childchild(r),'tag');
                    controlunits=get(childchild(r),'units');
                    foregroundcolor=[];
                end



                fprintf(fid,'%s',['%',tag]);
                fprintf(fid,'\n');
                fprintf(fid,'%s','%----------------');
                fprintf(fid,'\n');

                %uicontrol,uipanel,axes
                %--------------
                if ~strcmp(get(childchild(r),'type'),'axes') & ~strcmp(get(childchild(r),'type'),'uipanel')
                    fprintf(fid,[tag,'= uicontrol(...',char(10),char(39),'units',char(39),',',char(39),controlunits,char(39),',...\n',char(39),'style',char(39),',',char(39),style,char(39),',...\n',char(39),'position',char(39),',[',num2str(position),']']);
                elseif strcmp(get(childchild(r),'type'),'uipanel')
                    fprintf(fid,[tag,'= uipanel(...',char(10),char(39),'units',char(39),',',char(39),controlunits,char(39),',...\n',char(39),'position',char(39),',[',num2str(position),']']);
                else
                    fprintf(fid,[tag,'= axes(...',char(10),char(39),'units',char(39),',',char(39),controlunits,char(39),',',char(39),',...\n',char(39),'position',char(39),',[',num2str(position),']']);
                end

                %backgroundcolor
                %--------------
                if ~isempty(backgroundcolor)
                    fprintf(fid,[',...\n',char(39),'backgroundcolor',char(39),',[',num2str(backgroundcolor),']']);
                end

                %foregroundcolor
                %--------------
                if ~isempty(foregroundcolor)
                    fprintf(fid,[',...\n',char(39),'foregroundcolor',char(39),',[',num2str(foregroundcolor),']']);
                end

                %string
                %--------------
                if ~strcmp(get(childchild(r),'type'),'axes') & ~strcmp(get(childchild(r),'type'),'uipanel')
                    controlstring= labelstring;
                    if iscell(controlstring)
                         fprintf(fid,[',...\n',char(39),'String',char(39),',','{']);
                        fprintf(fid,[char(39),controlstring{1},char(39)]); 
                        for i=2:size(controlstring,1)
                            fprintf(fid,[',',char(39),controlstring{i},char(39)]); 
                        end
                        fprintf(fid,['}']);
                    else
                        fprintf(fid,[',...\n',char(39),'String',char(39),',''',controlstring,'''']);
                    end
                elseif strcmp(get(childchild(r),'type'),'uipanel')
                    fprintf(fid,[',...\n',char(39),'Title',char(39),',''',labelstring,'''']);
                end

                %callback
                %--------------
                if ~isempty(callback)
                    if ~isempty(findstr(callback,char(39)))
                        callback=strrep(callback,char(39),[char(39),char(39)]);
                    end
                    callback = callback
                    fprintf(fid,[',...\n',char(39),'Callback',char(39),',',char(39),callback,char(39)]);
                end


                %value
                %--------------
                if ~isempty(value)
                     fprintf(fid,[',...\n',char(39),'Value',char(39),',',num2str(value)]);
                end


                %tag
                %--------------
                if ~isempty(tag)
                    fprintf(fid,[',...\n',char(39),'tag',char(39),',',char(39),tag,char(39)]); 
                end


                %HorizontalAlignment
                %--------------
                if ~isempty(controlhalignment)
                    fprintf(fid,[',...\n',char(39),'HorizontalAlignment',char(39),',',char(39),controlhalignment,char(39)]); 
                end
                fprintf(fid,');\n\n');
            end
        end
        
        
    %catch
    %end
    
end

fclose(fid);
close(fig);

return
            


