function fignavigator(action)

%   fignavigator

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      


if nargin<1
    action = [];
end

if isempty(action)
	fig = openfig(mfilename,'reuse');
		
	% Generate a structure of handles to pass to callbacks, and store it. 
	handles = guihandles(fig);
	guidata(fig, handles);
    
elseif strcmp(action,'togglecamtarget')
    if strcmp(get(findobj('tag','targetcambutton'),'String'),'cam')
        set(findobj('tag','targetcambutton'),'String','target');
    else
        set(findobj('tag','targetcambutton'),'String','cam');
    end

else
    
    mode = get(findobj('tag','targetcambutton'),'String');
    
    %=============
    %target
    %===========
    if strcmp(mode,'target')
        
    
		if strcmp(action,'figforward')
            
            heads = findobj('tag','head3d');
            headaxes = get(heads,'Parent');
            
            for r=1:length(headaxes)
                axes(headaxes{r});
                set(headaxes{r},'DataAspectRatioMode','manual','CameraViewAngleMode','manual',...
                                'CameraUpVectorMode','manual','CameraPositionMode','manual',...
                                'CameraTargetMode','manual');
                CameraTarget = get(headaxes{r},'CameraTarget');
                CameraTarget(1)=CameraTarget(1)+0.5
                set(headaxes{r},'CameraTarget',CameraTarget);
            end
            
		elseif strcmp(action,'figback')
            
            heads = findobj('tag','head3d');
            headaxes = get(heads,'Parent');
            
            for r=1:length(headaxes)
                axes(headaxes{r});
                set(headaxes{r},'DataAspectRatioMode','manual','CameraViewAngleMode','manual',...
                                'CameraUpVectorMode','manual','CameraPositionMode','manual',...
                                'CameraTargetMode','manual');
                CameraTarget = get(headaxes{r},'CameraTarget');
                CameraTarget = get(headaxes{r},'CameraTarget');
                CameraTarget(1)=CameraTarget(1)-0.5
                set(headaxes{r},'CameraTarget',CameraTarget);
            end
            
		elseif strcmp(action,'figleft')
            
            heads = findobj('tag','head3d');
            headaxes = get(heads,'Parent');
            
            for r=1:length(headaxes)
                axes(headaxes{r});
                set(headaxes{r},'DataAspectRatioMode','manual','CameraViewAngleMode','manual',...
                                'CameraUpVectorMode','manual','CameraPositionMode','manual',...
                                'CameraTargetMode','manual');
                CameraTarget = get(headaxes{r},'CameraTarget');
                CameraTarget = get(headaxes{r},'CameraTarget');
                CameraTarget(2)=CameraTarget(2)+0.5
                set(headaxes{r},'CameraTarget',CameraTarget);
            end
            
		elseif strcmp(action,'figright')
            
            heads = findobj('tag','head3d');
            headaxes = get(heads,'Parent');
            
            for r=1:length(headaxes)
                axes(headaxes{r});
                set(headaxes{r},'DataAspectRatioMode','manual','CameraViewAngleMode','manual',...
                                'CameraUpVectorMode','manual','CameraPositionMode','manual',...
                                'CameraTargetMode','manual');
                CameraTarget = get(headaxes{r},'CameraTarget');
                CameraTarget = get(headaxes{r},'CameraTarget');
                CameraTarget(2)=CameraTarget(2)-0.5
                set(headaxes{r},'CameraTarget',CameraTarget);
            end
            
		elseif strcmp(action,'figup')
		
            heads = findobj('tag','head3d');
            headaxes = get(heads,'Parent');
            
            for r=1:length(headaxes)
                axes(headaxes{r});
                set(headaxes{r},'DataAspectRatioMode','manual','CameraViewAngleMode','manual',...
                                'CameraUpVectorMode','manual','CameraPositionMode','manual',...
                                'CameraTargetMode','manual');
                CameraTarget = get(headaxes{r},'CameraTarget');
                CameraTarget = get(headaxes{r},'CameraTarget');
                CameraTarget(3)=CameraTarget(3)+0.5
                set(headaxes{r},'CameraTarget',CameraTarget);
            end
            
		elseif strcmp(action,'figdown')
            
            heads = findobj('tag','head3d');
            headaxes = get(heads,'Parent');
            
            for r=1:length(headaxes)
                axes(headaxes{r});
                set(headaxes{r},'DataAspectRatioMode','manual','CameraViewAngleMode','manual',...
                                'CameraUpVectorMode','manual','CameraPositionMode','manual',...
                                'CameraTargetMode','manual');
                CameraTarget = get(headaxes{r},'CameraTarget');
                CameraTarget = get(headaxes{r},'CameraTarget');
                CameraTarget(3)=CameraTarget(3)-0.5
                set(headaxes{r},'CameraTarget',CameraTarget);
            end
            
        end
       
    %==============
    %camera
    %==============
    else
        
       
                
        if strcmp(action,'figforward')
            
            heads = findobj('tag','head3d');
            headaxes = get(heads,'Parent');
            
            for r=1:length(headaxes)
                axes(headaxes{r});
                set(headaxes{r},'DataAspectRatioMode','manual','CameraViewAngleMode','manual',...
                                'CameraUpVectorMode','manual','CameraPositionMode','manual',...
                                'CameraTargetMode','manual');
                CameraTarget = get(headaxes{r},'CameraTarget');
                CameraPosition = get(headaxes{r},'CameraPosition');
                set(headaxes{r},'CameraPosition',CameraPosition*0.9);
            end
            
		elseif strcmp(action,'figback')
              
            heads = findobj('tag','head3d');
            headaxes = get(heads,'Parent');
            
            for r=1:length(headaxes)
                axes(headaxes{r});
                set(headaxes{r},'DataAspectRatioMode','manual','CameraViewAngleMode','manual',...
                                'CameraUpVectorMode','manual','CameraPositionMode','manual',...
                                'CameraTargetMode','manual');
                CameraTarget = get(headaxes{r},'CameraTarget');
                CameraPosition = get(headaxes{r},'CameraPosition');
                set(headaxes{r},'CameraPosition',CameraPosition*1.1);
            end
            
		elseif strcmp(action,'figleft')
            
             heads = findobj('tag','head3d');
            headaxes = get(heads,'Parent');
            
            for r=1:length(headaxes)
                axes(headaxes{r});
                set(headaxes{r},'DataAspectRatioMode','manual','CameraViewAngleMode','manual',...
                                'CameraUpVectorMode','manual','CameraPositionMode','manual',...
                                'CameraTargetMode','manual');
                CameraTarget = get(headaxes{r},'CameraTarget');
                [theta,phi]=view(headaxes{r});
                theta = theta -30;
                view(headaxes{r},theta,phi);
            end
            
		elseif strcmp(action,'figright')
            
             heads = findobj('tag','head3d');
            headaxes = get(heads,'Parent');
            
            for r=1:length(headaxes)
                axes(headaxes{r});
                set(headaxes{r},'DataAspectRatioMode','manual','CameraViewAngleMode','manual',...
                                'CameraUpVectorMode','manual','CameraPositionMode','manual',...
                                'CameraTargetMode','manual');
                CameraTarget = get(headaxes{r},'CameraTarget');
                [theta,phi]=view(headaxes{r});
                theta = theta +30;
                view(headaxes{r},theta,phi);
            end
            
		elseif strcmp(action,'figup')
            
            heads = findobj('tag','head3d');
            headaxes = get(heads,'Parent');
            
            for r=1:length(headaxes)
                axes(headaxes{r});
                set(headaxes{r},'DataAspectRatioMode','manual','CameraViewAngleMode','manual',...
                                'CameraUpVectorMode','manual','CameraPositionMode','manual',...
                                'CameraTargetMode','manual');
                CameraTarget = get(headaxes{r},'CameraTarget');
                [theta,phi]=view(headaxes{r});
                phi = phi +30;
                view(headaxes{r},theta,phi);
            end
            
		elseif strcmp(action,'figdown')
            heads = findobj('tag','head3d');
            headaxes = get(heads,'Parent');
            
            for r=1:length(headaxes)
                axes(headaxes{r});
                set(headaxes{r},'DataAspectRatioMode','manual','CameraViewAngleMode','manual',...
                                'CameraUpVectorMode','manual','CameraPositionMode','manual',...
                                'CameraTargetMode','manual');
                CameraTarget = get(headaxes{r},'CameraTarget');
                [theta,phi]=view(headaxes{r});
                phi = phi -30;
                view(headaxes{r},theta,phi);
            end
            
        end
        
    end
    
end
                
                

if ~isempty(action)
    fig = findobj('tag','fignavigator');
    figure(fig);
else
    figure(fig);
end
    





