function [out,pos]=findarg(instring,targetpos,direction)

%   findarg

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
if nargin<3
    direction = 0;
end

if length(targetpos)>1
    targetpos =targetpos(1);
end
%opening brackets
if strcmp(instring(targetpos),'(') 
    startpos = targetpos;
    endpos = startpos+1;
    open = 0;
    while 1
        if open==0 & strcmp(instring(endpos),')')
            break;
        end
        
        if strcmp(instring(endpos),'(') | strcmp(instring(endpos),'[') | strcmp(instring(endpos),'{')
            open = open+1;
        elseif strcmp(instring(endpos),')') | strcmp(instring(endpos),']') | strcmp(instring(endpos),'}')
            open = open-1;
        end
        endpos = endpos +1;
        if endpos>length(instring)
            disp('unresolved line:')
            fprintf(1,'\n');
            disp(instring);
            fprintf(1,'\n');
            out =[];
            return
        end
    end
    maxl = max(startpos-1,1);
    minr = min(endpos+1,length(instring));
    while ~isdelimiter(instring(maxl))
        maxl = maxl -1;
        if maxl<1
            maxl = 1;
            startofline = 1;
            break;
        end
    end
    
    if maxl == targetpos & strcmp(instring(targetpos),'(') & minr~=length(instring)
        out = instring(maxl:minr-1) ; 
    elseif maxl == targetpos & strcmp(instring(targetpos),'(') & minr==length(instring)
        out = instring(maxl:minr) ; 
    elseif maxl ~= targetpos & strcmp(instring(targetpos),'(') & minr~=length(instring)
        out = instring(maxl+1:minr-1) ; 
    elseif maxl ~= targetpos & strcmp(instring(targetpos),'(') & minr==length(instring)
        out = instring(maxl+1:minr) ; 
    end
        
      
    pos = maxl;
  
    
%closing  brackets
elseif strcmp(instring(targetpos),')')
    startpos = targetpos;
    endpos = startpos-1;
    open = 0;
    while 1
        if endpos == 0
            endpos = 2;
            break;
        end
        if open==0 & strcmp(instring(endpos),'(')
            break;
        end
        
        if strcmp(instring(endpos),')') | strcmp(instring(endpos),']')| strcmp(instring(endpos),'}')
            open = open+1;
        elseif strcmp(instring(endpos),'(') | strcmp(instring(endpos),'[')| strcmp(instring(endpos),'{')
            open = open-1;
        end
        endpos = endpos -1; 
        
        if endpos == 1
            endpos = 2;
            break;
        end
    end
    maxl = endpos-1;
    minr = startpos;
    
    if maxl<1
        maxl = 1;
        startofline = 1;
    end
    if minr>size(instring,2)
        minr = size(instring,2)
        endofline =1;
    end
    
    while ~isdelimiter(instring(maxl))
        maxl = maxl -1;
        if maxl<1
            maxl = 1;
            startofline = 1;
            break;
        end
    end
    maxl = maxl+1;
    
    pos = maxl;
    out = instring(maxl:minr);


 %opening square brackets
elseif strcmp(instring(targetpos),'[') 
    startpos = targetpos;
    endpos = startpos+1;
    open = 0;
    while 1
        if open==0 & strcmp(instring(endpos),']')
            break;
        end
        
        if strcmp(instring(endpos),'(') | strcmp(instring(endpos),'[') | strcmp(instring(endpos),'{')
            open = open+1;
        elseif strcmp(instring(endpos),')') | strcmp(instring(endpos),']') | strcmp(instring(endpos),'}')
            open = open-1;
        end
        endpos = endpos +1;
        if endpos>length(instring)
            disp('unresolved line:')
            fprintf(1,'\n');
            disp(instring);
            fprintf(1,'\n');
            out =[];
            return
        end
    end
    maxl = max(startpos-1,1);
    minr = min(endpos+1,length(instring));
    
    
    if maxl == targetpos & strcmp(instring(targetpos),'[') & minr~=length(instring)
        out = instring(maxl:minr-1) ; 
    elseif maxl == targetpos & strcmp(instring(targetpos),'[') & minr==length(instring)
        out = instring(maxl:minr) ; 
    elseif maxl ~= targetpos & strcmp(instring(targetpos),'[') & minr~=length(instring)
        out = instring(maxl+1:minr-1) ; 
    elseif maxl ~= targetpos & strcmp(instring(targetpos),'[') & minr==length(instring)
        out = instring(maxl+1:minr) ; 
    end
        
      
    pos = maxl;
  
    
%closing square brackets
elseif strcmp(instring(targetpos),']')
    startpos = targetpos;
    endpos = startpos-1;
    open = 0;
    while 1
        if endpos == 0
            endpos = 2;
            break;
        end
        if open==0 & strcmp(instring(endpos),'[')
            break;
        end
        
        if strcmp(instring(endpos),')') | strcmp(instring(endpos),']')| strcmp(instring(endpos),'}')
            open = open+1;
        elseif strcmp(instring(endpos),'(') | strcmp(instring(endpos),'[')| strcmp(instring(endpos),'{')
            open = open-1;
        end
        endpos = endpos -1; 
        
        if endpos == 1
            endpos = 2;
            break;
        end
    end
    maxl = endpos-1;
    minr = startpos;
    
    if maxl<1
        maxl = 1;
        startofline = 1;
    end
    if minr>size(instring,2)
        minr = size(instring,2)
        endofline =1;
    end
    
   
    maxl = maxl+1;
    
    pos = maxl;
    out = instring(maxl:minr);
  
    
 %opening curly brackets
elseif strcmp(instring(targetpos),'{') 
    startpos = targetpos;
    endpos = startpos+1;
    open = 0;
    while 1
        if open==0 & strcmp(instring(endpos),'}')
            break;
        end
        
        if strcmp(instring(endpos),'(') | strcmp(instring(endpos),'[') | strcmp(instring(endpos),'{')
            open = open+1;
        elseif strcmp(instring(endpos),')') | strcmp(instring(endpos),']') | strcmp(instring(endpos),'}')
            open = open-1;
        end
        endpos = endpos +1;
        if endpos>length(instring)
            disp('unresolved line:')
            fprintf(1,'\n');
            disp(instring);
            fprintf(1,'\n');
            out =[];
            return
        end
    end
    maxl = max(startpos-1,1);
    minr = min(endpos+1,length(instring));
    while ~isdelimiter(instring(maxl))
        maxl = maxl -1;
        if maxl<1
            maxl = 1;
            startofline = 1;
            break;
        end
    end
    
      if maxl == targetpos & strcmp(instring(targetpos),'{') & minr~=length(instring)
        out = instring(maxl:minr-1) ; 
    elseif maxl == targetpos & strcmp(instring(targetpos),'{') & minr==length(instring)
        out = instring(maxl:minr) ; 
    elseif maxl ~= targetpos & strcmp(instring(targetpos),'{') & minr~=length(instring)
        out = instring(maxl+1:minr-1) ; 
    elseif maxl ~= targetpos & strcmp(instring(targetpos),'{') & minr==length(instring)
        out = instring(maxl+1:minr) ; 
    end
        
      
    pos = maxl;
  
    
%closing curly brackets
elseif strcmp(instring(targetpos),'}')
    startpos = targetpos;
    endpos = startpos-1;
    open = 0;
    while 1
        if endpos == 0
            endpos = 2;
            break;
        end
        if open==0 & strcmp(instring(endpos),'{')
            break;
        end
        
        if strcmp(instring(endpos),')') | strcmp(instring(endpos),']') | strcmp(instring(endpos),'}')
            open = open+1;
        elseif strcmp(instring(endpos),'(') | strcmp(instring(endpos),'[') | strcmp(instring(endpos),'}')
            open = open-1;
        end
        endpos = endpos -1; 
        
        if endpos == 1
            endpos = 2;
            break;
        end
    end
    maxl = endpos-1;
    minr = startpos;
    
    if maxl<1
        maxl = 1;
        startofline = 1;
    end
    if minr>size(instring,2)
        minr = size(instring,2)
        endofline =1;
    end
    
    while ~isdelimiter(instring(maxl))
        maxl = maxl -1;
        if maxl<1
            maxl = 1;
            startofline = 1;
            break;
        end
    end
    maxl = maxl+1;
    
    pos = maxl;
    out = instring(maxl:minr);
    
%no brackets
else
    
	if direction == 0
        startpos = targetpos;
        endpos = targetpos+1;
    else
        startpos = targetpos-1;
        endpos = targetpos;
    end
    
    open = 1;
    closedright = 0;
    openright = 0;
    
    closedleft = 0;
    endofline = 0;
    startofline = 0;
    counter = 0;
    while 1
        counter = counter +1;
        if counter > 1000
            disp('unresolved line:')
            fprintf(1,'\n');
            disp(instring);
            fprintf(1,'\n');
            out =[];
            return
        end
        
        if endpos > length(instring)
            endpos = length(instring);
            closedright = 1;
            if ~isdelimiter(instring(endpos))
                endofline = 1;
            end
        end
        
        
        if startpos == 0
            startpos = 1;
            closedleft = 1;
            if ~isdelimiter(instring(startpos))
                startofline = 1;
            end
        end
        
        if open==0
            break;
        end
        
        if strcmp(instring(startpos),'(')
            closedleft = 1;
        end
        
        if closedright & closedleft & openright==0
            open = 0;
        end
        
      
        if isdelimiter(instring(endpos))
            if strcmp(instring(endpos),')') | strcmp(instring(endpos),']')  | strcmp(instring(endpos),'}')
                if openright >0
                    openright = openright-1;
                    if openright == 0
                        endpos = endpos +1;
                    end
                end
                if openright == 0
                    closedright = 1;
                end
            elseif strcmp(instring(endpos),'(') | strcmp(instring(endpos),'[') | strcmp(instring(endpos),'{')
                openright = openright +1;
            else
                closedright = 1;
            end
        end
        
        if isdelimiter(instring(startpos))
            closedleft = 1;
            startpos = startpos +1;
        end
        
        if openright  | ~closedright
            endpos = endpos +1;
            if openright & closedright
                closedright = 0;
            end
        end
        if ~closedleft
            startpos = startpos-1;
        end
            
    end
    maxl = endpos;
    minr = startpos;
    if maxl>1
        while ~isdelimiter(instring(maxl)) 
            maxl = maxl -1;
            if maxl ==1
                break
            end
        end
    end
    if startofline & endofline
        out = instring(minr:maxl);
        pos = minr;  
    elseif startofline
        out = instring(minr:maxl-1);
        pos = minr;  
    elseif endofline
        out = instring(minr:maxl);
        pos = minr;  
    else
        out = instring(minr:maxl-1);
        pos = minr;  
    end
    
          
    
    if ~isempty(findstr(out,'.cell'))  & findstr(out,'.cell')+4==length(out)
        closed = 0;
        open = 0;
        start = findstr(instring,out)+length(out);
        while ~closed
            if strcmp(instring(start),'(');
                open = open +1;
            end
            if strcmp(instring(start),')');
                open = open -1;
            end
            if open == 0
                closed = 1;
            end
            start = start +1;
        end
        out = instring(minr:start-1);
    end
    
    %fprintf(1,'argument found...\n');

end


if strcmp(out(end),';') | strcmp(out(end),',') | strcmp(out(end),':')
    out(end)=[];
end
return
        

