function [out,pos]=findcolarg(instring,targetpos,direction)

%   findcolarg

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
if nargin<3
    direction = 0;
end

if length(targetpos)>1
    targetpos =targetpos(1);
end

    
if direction == 0
    startpos = targetpos;
    endpos = targetpos+1;
else
    startpos = targetpos-1;
    endpos = targetpos;
end

open = 1;
closedright = 0;
openright = 0;

closedleft = 0;
endofline = 0;
startofline = 0;
counter = 0;
endbrackstatus = 0;
startbrackstatus = 0;
while 1
    counter = counter +1;
    if counter > 1000
        disp('unresolved line:')
        fprintf(1,'\n');
        disp(instring);
        fprintf(1,'\n');
        out =[];
        return
    end
    
    if endpos > length(instring)
        endpos = length(instring);
        closedright = 1;
        if ~isdelimiter(instring(endpos))
            endofline = 1;
        end
    end
    
    
    if startpos == 0
        startpos = 1;
        closedleft = 1;
        if ~isdelimiter(instring(startpos))
            startofline = 1;
        end
    end
    
    if open==0
        break;
    end
    
    if strcmp(instring(startpos),'(')
        closedleft = 1;
    end
    
    if closedright & closedleft & openright==0
        open = 0;
    end
    
  
    if iscoldelimiter(instring(endpos))
        if strcmp(instring(endpos),')') | strcmp(instring(endpos),']')  | strcmp(instring(endpos),'}')
            if openright >0
                openright = openright-1;
                if openright == 0
                    endpos = endpos +1;
                end
            end
            if openright == 0
                endbrackstatus = 1;
                closedright = 1;
            end
        elseif strcmp(instring(endpos),'(') | strcmp(instring(endpos),'[') | strcmp(instring(endpos),'{')
            openright = openright +1;
        else
            closedright = 1;
        end
    end
    
    if iscoldelimiter(instring(startpos),0)
        closedleft = 1;
    end
    
    if openright  | ~closedright
        endpos = endpos +1;
        if openright & closedright
            closedright = 0;
        end
    end
    if ~closedleft
        startpos = startpos-1;
    end
        
end
maxl = endpos;
minr = startpos;
if minr>1
    if strcmp(instring(minr),'(') & strcmp(instring(maxl),')')
		while ~isdelimiter(instring(minr-1)) 
           minr = minr -1;
           if minr ==1
               break
           end
		end
    end
end

    
if strcmp(instring(minr),'(') & strcmp(instring(maxl),')') 
    out = instring(minr:maxl);
    if length(findstr(out,'('))> length(findstr(out,')'))
        out(1)=[];
    elseif length(findstr(out,'('))< length(findstr(out,')'))
        out(end)=[];
    end
    pos = minr;
else 
    
    out = instring(minr:maxl);
    if length(findstr(out,'('))> length(findstr(out,')'))
        out(1)=[];
        minr = minr+1;
    elseif length(findstr(out,'('))< length(findstr(out,')'))
        out(end)=[];
    end
    if strcmp(out(1),':') | strcmp(out(1),',')| strcmp(out(1),';')
        out(1)=[];
        minr = minr+1;
    end
    if strcmp(out(end),':')| strcmp(out(end),',')| strcmp(out(end),';')
        out(end)=[];
    end
    pos = minr;
end
 




%fprintf(1,'argument found...\n');


return
        

