function [peak]=findpeaks(mat)

%   findpeaks

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
peak=0;
groesse=size(mat);
anzahlintervalle=10;
intervallaenge=groesse(1)/anzahlintervalle;
laenge=floor(intervallaenge);
intervalle=zeros(laenge,anzahlintervalle);

for i=1:anzahlintervalle
    intervalle(1:laenge,i)=mat(floor((i-1)*intervallaenge)+1:floor((i-1)*intervallaenge)+laenge);
end

intervallsummen=sum(abs(intervalle));
distmat=zeros(anzahlintervalle+1,anzahlintervalle+1);
distmat(1,2:anzahlintervalle+1)=intervallsummen;
distmat(2:anzahlintervalle+1,1)=intervallsummen';

for j=2:anzahlintervalle+1
    for k=2:anzahlintervalle+1
        distmat(j,k)=distmat(j,1)-distmat(1,k);
    end
end

standardsum=intervallaenge*0.20;

peakmat=(distmat>standardsum/2 | distmat<-standardsum/2);
if sum(peakmat(2:anzahlintervalle+1,2:anzahlintervalle+1))>0
    peak=sum(sum(peakmat(2:anzahlintervalle+1,2:anzahlintervalle+1)));
end

return