function ifileplotmanage(filename,filepath,mode)

%   ifileplotmanage

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      



if mode==0
   modefehler
   return

% directory mode   
elseif mode==11
   cd (filepath);
   filelist=dir(filepath);
   filelistsize=size(filelist);
   ifilecell = cell(1);   
	% Schleife fr Files
   for filezaehler=3:filelistsize(1)
      [ifilecell{filezaehler-2,1},ifilecell{filezaehler-2,2}]=ifileplot(filelist(filezaehler).name);
   end
   ok
   
% batchfile mode   
elseif mode==12
   filemat=batchfiletomat(filename,filepath);
   filematgroessevec=size(filemat);
   filematgroesse=filematgroessevec(2);
   ifilecell = cell(1);   
   for r=1:filematgroesse
       [ifilecell{r,1},ifilecell{r,2}]=ifileplot(filemat{r});
   end
   
   
   
   prompt={'How many columns do you want to compare:','How many files are in each column:','How many conditions per person?','What was the total number of trials?'};
   def={'2','96','6','300'};
   dlgTitle='Input for trial summary';
   lineNo=1;
   answer=inputdlg(prompt,dlgTitle,lineNo,def);
   
   colorvec = {'red';'blue';'green';'cyan';'magenta';'black'};
   %try
       
   fig = figure('Name','Trial summary:','units','normalized','position',[0.1 0.1 0.8 0.8]);
  
   for i=1:str2num(answer{1})
       axes(i)=subplot(1,str2num(answer{1}),i);
        hold on
       set(axes(i),'XLim',[1,   str2num(answer{4})]);
       set(axes(i),'YLim',[-3,   str2num(answer{2})+3]);
       set(axes(i),'YTickMode','manual');
       
       anumberoftrials(1)=0;
       anumberoftrials(2)=0;
       anumberoftrials(3)=0;
       anumberoftrials(4)=0;
       anumberoftrials(5)=0;
       anumberoftrials(6)=0;
       jfileadjust = (i-1)*str2num(answer{2});
       
       for j=1:str2num(answer{2})
           
           [PATHSTR,NAME,EXT,VERSN] = fileparts(filemat{j});
           
           if mod(j,str2num(answer{3}))==1
                text(3,str2num(answer{2})+3-j,NAME);
                numberoftrials = ifilecell{j+jfileadjust,1};
                numberoftrialsstr = num2str(numberoftrials(1));
                text(diff(get(axes(i),'XLim'))/2+((diff(get(axes(i),'XLim'))/2)*mod(j,str2num(answer{3})))/str2num(answer{3}),str2num(answer{2})+3-j+1,numberoftrialsstr,'Color','red','FontSize',8);
               anumberoftrials(1) = anumberoftrials(1) + numberoftrials(1);
                for k=1:str2num(answer{4})
                    if ~isempty(find(ifilecell{j+jfileadjust,2}==k))
                        plot(k,str2num(answer{2})+1-j+0.5*mod(j,str2num(answer{3})),'r.')
                    end
                end
            elseif mod(j,str2num(answer{3}))==2
                numberoftrials = ifilecell{j+jfileadjust,1};
                numberoftrialsstr = num2str(numberoftrials(1));
                text(diff(get(axes(i),'XLim'))/2+((diff(get(axes(i),'XLim'))/2)*mod(j,str2num(answer{3})))/str2num(answer{3}),str2num(answer{2})+3-j+2,numberoftrialsstr,'Color','blue','FontSize',8);
                anumberoftrials(2) = anumberoftrials(2) + numberoftrials(1);
                for k=1:str2num(answer{4})
                    if ~isempty(find(ifilecell{j+jfileadjust,2}==k))
                        plot(k,str2num(answer{2})+1-j+0.5*mod(j,str2num(answer{3})),'b.')
                    end
                end
            elseif mod(j,str2num(answer{3}))==3
                numberoftrials = ifilecell{j+jfileadjust,1};
                numberoftrialsstr = num2str(numberoftrials(1));
                text(diff(get(axes(i),'XLim'))/2+((diff(get(axes(i),'XLim'))/2)*mod(j,str2num(answer{3})))/str2num(answer{3}),str2num(answer{2})+3-j+3,numberoftrialsstr,'Color','green','FontSize',8);
                anumberoftrials(3) = anumberoftrials(3) + numberoftrials(1);
                for k=1:str2num(answer{4})
                    if ~isempty(find(ifilecell{j+jfileadjust,2}==k))
                        plot(k,str2num(answer{2})+1-j+0.5*mod(j,str2num(answer{3})),'g.')
                    end
                end
            elseif mod(j,str2num(answer{3}))==4
                 numberoftrials = ifilecell{j+jfileadjust,1};
                numberoftrialsstr = num2str(numberoftrials(1));
                text(diff(get(axes(i),'XLim'))/2+((diff(get(axes(i),'XLim'))/2)*mod(j,str2num(answer{3})))/str2num(answer{3}),str2num(answer{2})+3-j+4,numberoftrialsstr,'Color','cyan','FontSize',8);
               anumberoftrials(4) = anumberoftrials(4) + numberoftrials(1);
                for k=1:str2num(answer{4})
                    if ~isempty(find(ifilecell{j+jfileadjust,2}==k))
                        plot(k,str2num(answer{2})+1-j+0.5*mod(j,str2num(answer{3})),'c.')
                    end
                end
            elseif mod(j,str2num(answer{3}))==5
                 numberoftrials = ifilecell{j+jfileadjust,1};
                numberoftrialsstr = num2str(numberoftrials(1));
                text(diff(get(axes(i),'XLim'))/2+((diff(get(axes(i),'XLim'))/2)*mod(j,str2num(answer{3})))/str2num(answer{3}),str2num(answer{2})+3-j+5,numberoftrialsstr,'Color','magenta','FontSize',8);
               anumberoftrials(5) = anumberoftrials(5) + numberoftrials(1);
                for k=1:str2num(answer{4})
                    if ~isempty(find(ifilecell{j+jfileadjust,2}==k))
                        plot(k,str2num(answer{2})+1-j+0.5*mod(j,str2num(answer{3})),'m.')
                    end
                end
            elseif mod(j,str2num(answer{3}))==0
                numberoftrials = ifilecell{j+jfileadjust,1};
                numberoftrialsstr = num2str(numberoftrials(1));
                text(diff(get(axes(i),'XLim'))/2+((diff(get(axes(i),'XLim'))/2)*6/str2num(answer{3})),str2num(answer{2})+3-j+6,numberoftrialsstr,'Color','black','FontSize',8);
                anumberoftrials(6) = anumberoftrials(6) + numberoftrials(1);
                for k=1:str2num(answer{4})
                    if ~isempty(find(ifilecell{j+jfileadjust,2}==k))
                        plot(k,str2num(answer{2})+1-j+0.5*6,'k.')
                    end
                end
            end
       end
       %summary
       for z=1:str2num(answer{3})   
           text(diff(get(axes(i),'XLim'))/2+((diff(get(axes(i),'XLim'))/2)*z/str2num(answer{3})),0,num2str( anumberoftrials(z)),'Color',colorvec{z});
       end
       
       
   end
   
   %catch
       %errordlg('Ran out of files to plot...');
       %end
           
      
   
   
   
   
   
   ok
      
% single file mode   
elseif mode==2
   ifileplot(filename);
   ok
  
end

return