function [okfigure]=infdlg(title,instring,status,text1,text2)
%   infdlg

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      

if nargin < 5
    text2=[];end
if nargin < 4
    text1=[];end
if nargin < 3
    disp('Error in infdlg.m: not enough input arguments...'),
    return
end

    
                              

okfigure = figure('Clipping','off', ...
	'Color',[0.83 0.81 0.79], ...
	'MenuBar','none', ...
	'Name',title, ...
	'NumberTitle','off', ...
	'PaperType','a4letter', ...
	'Position',[393 557 180 100], ...
	'Tag','infdlg');
oktext = uicontrol('Parent',okfigure, ...
	'Units','points', ...
	'BackgroundColor',[0.83 0.81 0.79], ...
	'Position',[8.25 45 120.75 24.75], ...
	'String',instring, ...
	'Style','text', ...
	'Tag','msgtext');

oktext = uicontrol('Parent',okfigure, ...
	'Units','points', ...
	'BackgroundColor',[0.83 0.81 0.79], ...
	'Position',[8.25 30 120.75 24.75], ...
	'String',status, ...
	'Style','text', ...
	'Tag','statustext');

oktext1 = uicontrol('Parent',okfigure, ...
	'Units','points', ...
	'BackgroundColor',[0.83 0.81 0.79], ...
	'Position',[20.25 10 40.75 24.75], ...
	'String',text1, ...
	'Style','text', ...
	'Tag','infdlgtext1');

oktext2 = uicontrol('Parent',okfigure, ...
	'Units','points', ...
	'BackgroundColor',[0.83 0.81 0.79], ...
	'Position',[60.25 10 60.75 24.75], ...
	'String',text2, ...
	'Style','text', ...
	'Tag','infdlgtext2');


okfigure = findobj('tag','infdlg');


return




