function [status,length] = isdelimiter(in)

%   isdelimiter

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION. 

if isempty(in)
    status = 0;
    length = 0;
    return
end

status = 0;
length = 0;
delimiters = {' ','=',',',',','*','+','-',':','/','\','''',';','(',')','[',']','~','^','&','|','>','<','%','$','&','!','?','#','','.','"','{','}',char(9),char(10),char(13),char(32)};
doubledelimiters = cell(1);
doubledelimiters = {'.^','.*','./','<=','>=','~='};


for r=1:size(doubledelimiters,2)
    if ~isempty(find(strcmp(in,doubledelimiters{r})))
        if size(find(strcmp(in,doubledelimiters{r})),2)==size(in,2)
            status = 1;
            length = 2;
            return
        end
    end
end
for r=1:size(delimiters,2)
    if ~isempty(find(strcmp(in,delimiters{r})))
        if size(find(strcmp(in,delimiters{r})),2)==size(in,2)
            status = 1;
            length = 1;
            return;
        end
    end
end
return