function local2global(globalfile,globalfilepath,localfiledirectory);

%   local2global

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      




globalpicmat=double(imread([globalfilepath,globalfile],'jpg'));


cd(localfiledirectory);
filelist=dir(localfiledirectory);
filelistsize=size(filelist);

anzahllocs=filelistsize(1)-2;

% Schleife fr Files
for filezaehler=3:filelistsize(1)
  localpicmat{filezaehler-2}=double(imread(filelist(filezaehler).name,'jpg'));
end

globalhoehe=size(globalpicmat,1);
globalbreite=size(globalpicmat,2);

localhoehe=size(localpicmat{1},1);
localbreite=size(localpicmat{1},2);



locspercolumn=globalhoehe/localhoehe;
locsperrow=globalbreite/localbreite;

anzahllocsperglob=globalhoehe/localhoehe*globalbreite/localbreite;
if anzahllocsperglob/round(anzahllocsperglob)~=1
    errordlg('Verhltniss-mismatch!','Fehler:');
    return
end

diffmattot=zeros(locspercolumn,locsperrow,anzahllocs,4); %4=totbr,redbr,grbr,bluebr,hue
zaehler=0;
for i=1:locspercolumn
    for j=1:locsperrow
        for k=1:anzahllocs
            diffmattot(i,j,k,1)=sum(sum(abs(mean(globalpicmat((i-1)*localhoehe+1:i*localhoehe,(j-1)*localbreite+1:j*localbreite,:),3)-globalpicmat((i-1)*localhoehe+1:i*localhoehe,(j-1)*localbreite+1:j*localbreite,3))));
            diffmattot(i,j,k,2)=sum(sum(abs(globalpicmat((i-1)*localhoehe+1:i*localhoehe,(j-1)*localbreite+1:j*localbreite,1)-localpicmat{k}(1:localhoehe,1:localbreite,1))));
            diffmattot(i,j,k,3)=sum(sum(abs(globalpicmat((i-1)*localhoehe+1:i*localhoehe,(j-1)*localbreite+1:j*localbreite,2)-localpicmat{k}(1:localhoehe,1:localbreite,2))));
            diffmattot(i,j,k,4)=sum(sum(abs(globalpicmat((i-1)*localhoehe+1:i*localhoehe,(j-1)*localbreite+1:j*localbreite,3)-localpicmat{k}(1:localhoehe,1:localbreite,3))));
   
        end
     fprintf('.');
    zaehler=zaehler+1;
    if zaehler>20
        fprintf('\n');
        zaehler=0;
    end
    end
   
    
end

%Gewichtung
bestfitmat=0*diffmattot(:,:,:,1)+1*diffmattot(:,:,:,2)+1*diffmattot(:,:,:,3)+1*diffmattot(:,:,:,4);


%Bilderliste
picnummern=zeros(locsperrow*locspercolumn,1);
piczaehler=1;

locpicnummat=zeros(locspercolumn,locsperrow);
for i=1:locspercolumn
    for j=1:locsperrow
        locpicnummat(i,j)=find(bestfitmat(i,j,:)==min(bestfitmat(i,j,:)));
        imwrite(uint8(globalpicmat((i-1)*localhoehe+1:i*localhoehe,(j-1)*localbreite+1:j*localbreite,:)),'C:\tempglobalpic.jpg','jpg');
        imwrite(uint8(localpicmat{locpicnummat(i,j)}),'C:\templocalpic.jpg','jpg');
        
        [bildnumasdfmer,totbright,totcont,redbasdfright,redcadfont,greenbriasdfght,greencasdfont,bluebasdfasright,bluecoadsfant,miadsfasdfnb,maasdfasdfxb]=ppara('tempglobalpic.jpg','C:\');
        localpicmat{locpicnummat(i,j)}=tradebrcont('templocalpic.jpg','C:\',2,totbright,totcont);
        bestfitmat(:,:,find(bestfitmat(i,j,:)==min(bestfitmat(i,j,:))))=10000000000;
         
    end
end


finalpicmat=zeros(size(globalpicmat));

for i=1:locspercolumn
    for j=1:locsperrow
            finalpicmat((i-1)*localhoehe+1:i*localhoehe,(j-1)*localbreite+1:j*localbreite,:)=localpicmat{locpicnummat(i,j)};
    end
end

imwrite(uint8(finalpicmat),strrep([globalfilepath,globalfile],'.jpg','_l2g.jpg'),'jpg');
figure;
image(uint8(finalpicmat));
figure;
colormap(gray);
image(uint8(mean(finalpicmat,3)));
[modmatpic]=matchbrightness(globalfile,globalfilepath,strrep(globalfile,'.jpg','_l2g.jpg'),globalfilepath);
figure;
image(uint8(modmatpic));
return

    