function out = m2cpp(mfile,cppfile,headerfile,sourceappendstatus)

%   m2cpp
%
%   'm2cpp' translates approximately from matlab
%   to c++


%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION. 


fclose all;
if nargin<4;
    sourceappendstatus = 0;
end
m2cppdefaultpath =[];
m2cppdefaultmfile = [];
m2cppdefaultcppfile =[];
m2cppdefaultheaderfile = [];
defaultstatus = 0;
fidhpp = [];
printcell = cell(1);
printlength = 1;
declarevariablescell = cell(1);
declarevariableslength = 1;
declareposition = 0;
narginlines=zeros(1);
narginstatus = 0;
narginlinezaehler=1;

if nargin==1
    line = mfile;
end
    
if nargin<1
	utilpath = which('m2cpp.m');
	utilpath(end-7:end)=[];
	utilpath = [utilpath,'m2cpputil.mat'];
	if exist(utilpath)==2
        load(utilpath);
	end
	
	if ~isempty(m2cppdefaultpath)
        answer = questdlg('Do you wish to use the default settings?','Default:','Yes','No','No');
        if strcmp(answer,'Yes')
            cd(m2cppdefaultpath);
            cppfile = m2cppdefaultcppfile;
            mfile = m2cppdefaultmfile;
            headerfile = m2cppdefaultheaderfile;
            defaultstatus = 1;
            sourceappendstatus = m2cppdefaultsourceappendstatus;
            librarystatus = m2cppdefaultlibrarystatus;
        end
	end
end
        
        
linecount = 0;
if nargin<3;
    headerfile = [];
end
if nargin<2 & ~defaultstatus;
    cppfile = [];
end
 outinvar=[];   
 

if nargin<1
    
    if ~defaultstatus
        buildanswer = questdlg('Do you wish to build a library from an entire directory?','translation options:','Yes','No','No');
    else
        if m2cppdefaultlibrarystatus
            buildanswer = 'Yes';
        else
            buildanswer = 'No';
        end
    end
    
    %library
    %==============
    if strcmp(buildanswer,'Yes')
        librarystatus = 1;
        if ~defaultstatus
            appendanswer = questdlg('Do you wish to append to existing files?','translation options:','Yes','No','No');
        else
           if m2cppdefaultsourceappendstatus
                appendanswer = 'Yes';
            else
                appendanswer = 'No';
            end 
        end
        
        %append
        %=========
        if strcmp(appendanswer,'Yes')
            sourceappendstatus=1;
            if ~defaultstatus
                [cppfilename,cppfilepath]=uigetfile('*.cpp','Please choose cpp-file to append:');
                 if isempty(findstr(cppfilename,'.cpp'))
                     cppfilename = [cppfilename,'.cpp'];
                 end
                 cppfile = [cppfilepath,cppfilename];
                 [headerfilename,headerfilepath]=uigetfile('*.h','Please choose headerfile to append function declarations to:');
                 if isempty(findstr(headerfilename,'.h'))
                       headerfilename = [cppfilename,'.h'];
                 end
                 headerfile = [headerfilepath,headerfilename];
            else
                cppfile = m2cppdefaultcppfile;
                headerfile = m2cppdefaultheaderfile;
            end
            
        %create
        %=========
        else
           sourceappendstatus=0;
           if ~defaultstatus
               [cppfilename,cppfilepath]=uiputfile('*.cpp','Please name cpp-file:'); 
               if isempty(findstr(cppfilename,'.cpp'))
                   cppfilename = [cppfilename,'.cpp'];
               end
               cppfile = [cppfilepath,cppfilename];
               headerfilename = strrep(cppfilename,'.cpp','.h');
               headerfile = [cppfilepath,headerfilename];
           else
                cppfile = m2cppdefaultcppfile;
                headerfile = m2cppdefaultheaderfile;
           end 
        end
        
        if ~defaultstatus
            [sourcefilename,sourcefilepath]=uigetfile('*.m','Please choose m-file from source-directory:');
            cd (sourcefilepath);
            filelist=dir(sourcefilepath);
            filelistsize=size(filelist);
        else
            mfile = m2cppdefaultmfile;
            cd (m2cppdefaultpath);
            filelist=dir(m2cppdefaultpath);
            filelistsize=size(filelist);
        end
        
        m2cppdefaultsourceappendstatus = sourceappendstatus;
         if ~defaultstatus
            m2cppdefaultpath =sourcefilepath;
        else
            m2cppdefaultpath = m2cppdefaultpath;
        end
		m2cppdefaultmfile = filelist(3).name;
		m2cppdefaultcppfile =cppfile;
		m2cppdefaultheaderfile = headerfile;
        m2cppdefaultlibrarystatus = librarystatus;
        save(utilpath,'m2cppdefaultpath','m2cppdefaultmfile','m2cppdefaultcppfile','m2cppdefaultheaderfile',...
            'm2cppdefaultsourceappendstatus','m2cppdefaultlibrarystatus');
    
		% Schleife fr Files
        for filezaehler=3:filelistsize(1)
            if ~isempty(findstr(filelist(filezaehler).name,'.m')) & isempty(findstr(filelist(filezaehler).name,'.mat'))
                m2cpp(filelist(filezaehler).name,cppfile,headerfile,1)
            end
            fprintf(1,'%g of %g files done...\n',filezaehler,filelistsize(1));
        end
        
        edit(cppfile);
		edit(headerfile);
        ok
        return
      
    
    %single file
    %==============
    else
        
        librarystatus = 0;
        if ~defaultstatus
            appendanswer = questdlg('Do you wish to append to existing files?','translation options:','Yes','No','No');
        else
           if m2cppdefaultsourceappendstatus
                appendanswer = 'Yes';
            else
                appendanswer = 'No';
            end 
        end
        
        %append
        %=========
        if strcmp(appendanswer,'Yes')
            sourceappendstatus=1;
            if ~defaultstatus
                [cppfilename,cppfilepath]=uigetfile('*.cpp','Please choose cpp-file to append:');
                if isequal(cppfilename,0) | isequal(cppfilepath,0)
                    return;
                end
                 if isempty(findstr(cppfilename,'.cpp'))
                     cppfilename = [cppfilename,'.cpp'];
                 end
                 cppfile = [cppfilepath,cppfilename];
                 [headerfilename,headerfilepath]=uigetfile('*.h','Please choose headerfile to append function declarations to:');
                 if isempty(findstr(headerfilename,'.h'))
                       headerfilename = [cppfilename,'.h'];
                 end
                 headerfile = [headerfilepath,headerfilename];
            else
                cppfile = m2cppdefaultcppfile;
                headerfile = m2cppdefaultheaderfile;
                mfile = m2cppdefaultmfile;
            end
          
        %create
        %========= 
        else
            sourceappendstatus=0;
            if ~defaultstatus
               [filename,filepath]=uigetfile('*.m','Please choose m-file to translate:');
               if isequal(filename,0) | isequal(filepath,0)
                   return;
               end
               mfile =[filepath,filename];
               cppfile= strrep(mfile,'.m','.cpp'); 
               headerfile = strrep(cppfile,'.cpp','.h');
               m2cppdefaultpath =filepath;
            else
               cppfile = m2cppdefaultcppfile;
               headerfile = m2cppdefaultheaderfile;
               mfile = m2cppdefaultmfile;
               [path,name,ext,versn] = fileparts(mfile);
               m2cppdefaultpath =path;
            end          
        end
        
        m2cppdefaultsourceappendstatus = sourceappendstatus;
		m2cppdefaultmfile = mfile;
		m2cppdefaultcppfile =cppfile;
		m2cppdefaultheaderfile = headerfile;
        m2cppdefaultlibrarystatus = librarystatus;
        save(utilpath,'m2cppdefaultpath','m2cppdefaultmfile','m2cppdefaultcppfile','m2cppdefaultheaderfile',...
            'm2cppdefaultsourceappendstatus','m2cppdefaultlibrarystatus');

        m2cpp(mfile,cppfile,headerfile,sourceappendstatus);
        edit(cppfile);
		edit(headerfile);
		edit(mfile);
        ok
        return
    end
end

if nargin>1
	if isempty(cppfile)   
        [cppfilename,cppfilepath]=uigetfile('*.m','Please choose cpp-file to append:');
        if isequal(cppfilename,0) | isequal(cppfilepath,0)
            sourceappendstatus = 0;
            cppfile = strrep(mfile,'.m','.cpp');
        else
           if isempty(findstr(cppfilename,'.cpp'))
               cppfilename = [cppfilename,'.cpp'];
           end
           cppfile = [cppfilepath,cppfilename];
        end 
	end
end

if nargin>1
	fidm = fopen(mfile,'rt');
	mfilestring = fscanf(fidm,'%c');
	fclose(fidm);
end





if nargin>1
	fidm = fopen(mfile,'rt');
	if sourceappendstatus
        if isempty(headerfile)
            [headerfilename,headerfilepath]=uigetfile('*.h','Please choose headerfile to append function declarations to:');
            headerfile = [headerfilepath,headerfilename];
        end
        fidhpp = fopen(headerfile,'at');
        fidcpp = fopen(cppfile,'at');
	else
        if ~isempty(headerfile)
            fidhpp = fopen(headerfile,'wt');  
        end
        fidcpp = fopen(cppfile,'wt');
	end
end

if nargin>1
	line=0;
	line = fgets(fidm);
end

first = 1;
linebreakstatus=0;

commentstatus = 0;
comment =[];
outvar = [];
numberofvars = 1;

varcell = cell(1);
varcell{1} = 'pi';
varcell{2} = 'inf';
varcell{3} = 'eps';
varcell{4} = 'nan';

numberofvars= 4;

functiondefinedstatus = 0;
warning off

while ~isequal(line,-1)
    
    warning on
    
    
     try 
        if commentstatus
            printcell{printlength} = sprintf('%c',comment);
            printlength = printlength +1;
            commentstatus = 0;
        end
        %write line to file, replace linebreak, tabs etc..
        %=================================
        if ~first
            
            %print in cell
            if narginstatus
                narginlines(narginlinezaehler)=printlength;
                narginstatus = 0;
                narginlinezaehler = narginlinezaehler+1;
            end
            printcell{printlength} = sprintf('%c',line);
            printlength = printlength+1;
            
            lastline = line;
            if nargin>1
		        line = fgets(fidm)
            end
            
            if ~isempty(findstr(line,'Remove NaN values'))
                fprintf('hallo')
            end
            if ~isempty(findstr(line,'fprintf(''Please insert the number of the '))
                disp('hallo')
            end
            
            if~isempty(findstr(line,'var('))
                disp('hallo')
            end
            
            linecount = linecount+1;
            if mod(linecount,50)==0
                fprintf(1,'%g lines done...\n',linecount);
            end
            if ~isempty(findstr(line,'...')) & isempty(findstr(line,'(...)'))
                indent = getlineindent(line);
                while 1
                    
                    line = debreak(strrep(line,'...',''));
                    
                    nextline = fgets(fidm);
                    if findstr(nextline,'%')<3
                        nextline = strrep(nextline,'%','');
                    end
                    if isempty(findstr(nextline,'...')) & isempty(findstr(line,'(...)'))
                        line = [line,debreak(nextline)];
                        break;
                    else
                        line = [line,nextline];
                    end
                end
                line = [indent,line,char(10)];
            end
        else
            first = 0;
            if ~isempty(findstr(line,'...'))
                while 1
                    line = strrep( strrep(strrep(strrep(line,'...',''),char(10),''),char(9),''),char(13),'');
                    nextline = fgets(fidm);
                    if isempty(findstr(nextline,'...'))
                        line = [line,nextline];
                        line = strrep(strrep(line,char(10),''),char(9),'');
                        break;
                    else
                        line = [line,nextline];
                    end
                end
                line = [line,char(10)];
            end
        end
        if line==-1
            continue;
        end
        if length(line)==1;
            line ='';
        end
        linedebl = deblank(line);
        linedebl = strrep( strrep(strrep(line,char(10),''),char(9),''),char(13),'');
        if ~isempty(findstr(linedebl,'lta = ones(n,1) * (max(y) - min(y)) * groupwidth / (n-1) / m'))
            disp('pause')
        end
        %line = strrep(line,'\n','\\n');
        
        
       
        %graphical commands
        %====================
        if ~isempty(findstr(line,'%'))
            indent = getlineindent(line);
            oldline = line;
            if ~isempty(indent)
                line = strinsert(line,[1:1+length(indent)-1],'');
            end
            if (min(findstr(line,'%'))<3)
                if ~isempty(findstr(line,'figure')) |  ~isempty(findstr(line,'set(')) |   ~isempty(findstr(line,'get(')) | ...
                        ~isempty(findstr(line,'plot(')) |  ~isempty(findstr(line,'plot3('))|  ~isempty(findstr(line,'surf(')) |...
                        ~isempty(findstr(line,'text(')) | ~isempty(findstr(line,'xlabel(')) |  ~isempty(findstr(line,'ylabel('))...
                        ~isempty(findstr(line,'zlabel('))|  ~isempty(findstr(line,'title('))|  ~isempty(findstr(line,'subplot(')) |...
                        ~isempty(findstr(line,'axes('))  | ~isempty(findstr(line,'uicontrol(')) |~isempty(findstr(line,'uimenu('))|...
                        ~isempty(findstr(line,'axis('))  | ~isempty(findstr(line,'hold on')) | ~isempty(findstr(line,'hold off')) |...
                        ~isempty(findstr(line,'close(')) | ~isempty(findstr(line,'ginput')) | ~isempty(findstr(line,'axis off')) |...
                        ~isempty(findstr(line,'axis(''off'')')) | ~isempty(findstr(line,'pause('))| ~isempty(findstr(line,'clc;')) |...
                        ~isempty(findstr(line,'title;'))
                    line = [indent '//' line];
                    continue;
                end
            end
            line = [indent line];
        elseif ~isempty(line)
            indent = getlineindent(line);
            if ~isempty(indent)
                line = strinsert(line,[1:length(indent)-1],'');
            end
             if ~isempty(findstr(line,'figure')) |  ~isempty(findstr(line,'set(')) |   ~isempty(findstr(line,'get(')) | ...
                        ~isempty(findstr(line,'plot(')) |  ~isempty(findstr(line,'plot3('))|  ~isempty(findstr(line,'surf(')) |...
                        ~isempty(findstr(line,'text(')) | ~isempty(findstr(line,'xlabel(')) |  ~isempty(findstr(line,'ylabel('))...
                        ~isempty(findstr(line,'zlabel('))|  ~isempty(findstr(line,'title('))|  ~isempty(findstr(line,'subplot('))|...
                        ~isempty(findstr(line,'axes('))  | ~isempty(findstr(line,'uicontrol(')) |~isempty(findstr(line,'uimenu(')) |...
                        ~isempty(findstr(line,'axis('))  | ~isempty(findstr(line,'hold on')) |~isempty(findstr(line,'hold off'))|...
                        ~isempty(findstr(line,'close(')) | ~isempty(findstr(line,'ginput'))  | ~isempty(findstr(line,'axis off')) |...
                        ~isempty(findstr(line,'axis(''off'')')) | ~isempty(findstr(line,'pause('))| ~isempty(findstr(line,'clc;')) |...
                        ~isempty(findstr(line,'title;'))
                line = [indent '//' line];
                continue;
            end
            line = [indent line];
        end
        
 
        
        %comments
        %================================= 
        if ~isempty(findstr(line,'%'))
            indent = getlineindent(line);
            if ~isempty(indent)
                linetmp = strinsert(line,[1:1+length(indent)-1],'');
                if strcmp(linetmp(1),'%')
                    line = [getlineindent(line),'//',linetmp(2:end)];
                    continue;
                end
            else
                if strcmp(line(1),'%')
                    line = [getlineindent(line),'//',line(2:end)];
                    continue;
                end
            end
            if isempty(findstr(line,''''))
                if ~isempty(findstr(line,'%')) & isempty(findstr(line,'''%')) 
                    [nrofargs,argcell,stringcell,numcell]  = strparse(line);
                    breakstatus = 0;
                    for e=1:length(stringcell)
                        if ~isempty(findstr(stringcell{e},'%'))
                            breakstatus = 1;
                        end
                    end
                    if ~breakstatus
                        if findstr(linedebl,'%')<3
                            line = strrep(line,'%','//');
                            if length(line)<5
                                line = '';
                            end
                            continue;
                        elseif findstr(linedebl,'%')>2
                            indent = getlineindent(line);
                            comment = [indent,strrep(line(findstr(line,'%'):end),'%','//'),char(10)];
                            
                            printcell{printlength} = sprintf(comment); 
                            printlength = printlength+1;
                            
				            line = [line(1:findstr(line,'%')-1),char(10)];
                            commentstatus = 0;
                            comment=[];
                        end
                    end
                end
            else
                [nrofargs,argcell,stringcell,numcell]  = strparse(line);
                breakstatus = 0;
                for e=1:length(stringcell)
                    if ~isempty(findstr(stringcell{e},'%'))
                        breakstatus = 1;
                    end
                end
                if ~breakstatus
                   if ~isempty(findstr(line,'%')) & isempty(findstr(line,'''%'))
                        if findstr(linedebl,'%')<3
                            line = strrep(line,'%','//');
                            if length(line)<5
                                line = '';
                            end
                            continue;
                        elseif findstr(linedebl,'%')>2
                            indent = getlineindent(line);
                            comment = [indent,strrep(line(findstr(line,'%'):end),'%','//'),char(10)];
                            
                            printcell{printlength} = sprintf(comment); 
                            printlength = printlength+1;
                            
				            line = [line(1:findstr(line,'%')-1),char(10)];
                            commentstatus = 0;
                            comment=[];
                        end
                    end  
                end
            end
        end
        
        
      
        
        
         %structures
        %=================
        if ~isempty(findstr(line,'.')) &  isempty(findstr(line,'.*')) &  isempty(findstr(line,'.^'))  &  isempty(findstr(line,'.\')) ...
                 &  isempty(findstr(line,'.'''))   
            
            nrofdots = length(findstr(line,'.'));
            for r=1:nrofdots
                dots = findstr(line,'.');
                if (isdelimiter(line(dots(r)-1)) | strcmp(line(dots(r)-1),' ')) & isnumstring(line(dots(r)+1))
                    line = strinsert(line,[dots(r):dots(r)],['0',line(dots(r))]);
                    continue;
                end
                if isnumstring(line(dots(r)-1)) & isnumstring(line(dots(r)+1))
                    continue;
                end
                if isdelimiter(line(dots(r)-1)) | isdelimiter(line(dots(r)+1))
                    continue;
                end
                if isempty(dots)
                    break;
                end
                
                [rightarg,pos] = findarg(line,dots(r)+1);
                if length(findstr(line,rightarg))==1
                    line= strrep(line,rightarg,['field("',rightarg,'")']);
                else
                    line = strinsert(line,[dots(r)+1:dots(r)+length(rightarg)],['field("',rightarg,'")']);
                end
            end   
        end
        if ~isempty(findstr(line,'struct'))
            line = strrep(line,'struct','struct_func');
        end
        
        
          %cell arrays
        %=================
        if ~isempty(findstr(line,'{')) | ~isempty(findstr(line,'{'))
            if ~isempty(findstr(line,'stimnummerncell'))
                a=[];
            end
            if length(findstr(line,'{'))==1
                %cellhcat
                if strcmp(line(findstr(line,'{')-1),' ')
                    line = strrep(line,'{','cellhcat(');
                    line = strrep(line,'}',')');
                elseif isletterpp(line(findstr(line,'{')-1))
                    line = strrep(line,'{','.cell(');
                    line = strrep(line,'}',')');
                end  
            else
                nrofb = length(findstr(line,'{'));
                for r=1:nrofb
                    brs = findstr(line,'{');
                    if isempty(brs)
                        break;
                    end
                    
                    if strcmp(line(brs(1)-1),' ')
                        [nouse,arg] = getrargof(line(1:brs(1)-1),line,1);
                        line= strrep(line,line(1:brs(1)),[line(1:brs(1)-1),'cellhcat(']);
                        line = strrep(line,[arg,'}'],[arg,')']);
                    elseif isletterpp(line(brs(1)-1))
                        [nouse,arg] = getrargof(line(1:brs(1)-1),line,1);
                        line = strrep(line,line(1:brs(1)),[line(1:brs(1)-1),'.cell(']);
                        line = strrep(line,[arg,'}'],[arg,')']);
                    end  
                end
                
            end
        end
        
        %function definition
        %=================================
        if ~isempty(findstr(linedebl,'function')) & isempty(findstr(linedebl,'definition')) & isempty(findstr(line,'//')) &  functiondefinedstatus==0
            
            nrofoutarg = 0;
            nrofinarg = 0;
            %functionname
            if ~isempty(findstr(linedebl,'='))
                if ~isempty(findstr(linedebl,'('))
                    functionname = linedebl(findstr(linedebl,'=')+1:findstr(linedebl,'(')-1);
                else
                    functionname = linedebl(findstr(linedebl,'=')+1:end-1);
                end
            else
                 if ~isempty(findstr(linedebl,'('))
                    functionname = linedebl(findstr(linedebl,'function')+9:findstr(linedebl,'(')-1);
                else
                    functionname = strrep(deblankex(linedebl(findstr(linedebl,'function')+9:end)),';','');
                end
            end
            %argin
            %==============
            if ~isempty(findstr(linedebl,'('))
                inarg = linedebl(findstr(linedebl,'(')+1:findstr(linedebl,')')-1);
                if ~isempty(findstr(inarg,','))
                    nrofinarg = length(findstr(inarg,','));
                    invar = cell(1);
                    kommata = findstr(inarg,',');
                    invar{1}=inarg(1:findstr(inarg,',')-1);
                    for i=2:nrofinarg
                        invar{i}=inarg(kommata(i-1)+1:kommata(i)-1);
                    end
                    invar{nrofinarg+1}=inarg(kommata(end)+1:end);
                    nrofinarg = nrofinarg +1;
                else
                    invar = cell(1);
                    invar{1} = inarg;
                    nrofinarg = 1;
                end
            else
                nrofinarg = 0;
                invar=[];
            end
            %add argin to variable-buffer
            if nrofinarg
                r=1;
                while r<=nrofinarg
                    varcell{numberofvars}=deblankex(invar{r});
                    numberofvars = numberofvars+1;
                    r = r+1;
                end
            end
            %argout
            %================
            if ~isempty(findstr(linedebl,'='))
                outarg = linedebl(findstr(linedebl,'function')+8:findstr(linedebl,'=')-1);
                if ~isempty(findstr(outarg,','))
                    nrofoutarg = length(findstr(outarg,','));
                    kommata = findstr(outarg,',');
                    outvar = deblankex(outarg(findstr(outarg,'[')+1:kommata(1)-1)) ;
                    
                    outinvar = cell(1);
                    for i=2:nrofoutarg
                        if isempty(findstr(outarg(kommata(i-1)+1:kommata(i)-1),char(13))) | isempty(findstr(outarg(kommata(i-1)+1:kommata(i)-1),char(10))) 
                            outinvar{i-1}=deblankex(outarg(kommata(i-1)+1:kommata(i)-1)) ;
                        else
                             outinvar{i-1}=deblankex(strrep(outarg(kommata(i-1)+1:kommata(i)-1),char(10),'') );
                             outinvar{i-1} = [outinvar{i-1},char(10)];
                         end
                    end
                    outarg = deblankex(outarg);
                    kommata = findstr(outarg,',');
                    outinvar{nrofoutarg}=outarg(kommata(end)+1:end-1);
                else
                    
                    outvar = outarg;
                    outvar(findstr(outvar,'['))=[];
                    outvar(findstr(outvar,']'))=[];
                    nrofoutarg = 1;
                end
            end
            %add argin to variable-buffer
            if nrofoutarg
                varcell{numberofvars}=deblankex(outvar);
                numberofvars = numberofvars+1;
                if nrofoutarg>1
                    r=2;
                    while r<=nrofoutarg
                        varcell{numberofvars}=deblankex(outinvar{r-1});
                        numberofvars = numberofvars+1;
                        r = r+1;
                    end
                end
            end
            if nrofoutarg       
                line = 'mwArray ';
            else
                line = 'void ';
            end
            line = [line functionname];
            if nrofoutarg>=1
                if ~isempty(outinvar)
                    line = [line '(mwArray* p' outinvar{1}];
                    for r=2:nrofoutarg
                        line = [line ',mwArray* p' outinvar{r}];
                    end
                else
                    line = [line '('];
                end
            else
                if nrofinarg
                    line = [line '('];
                end
            end  
            if nrofinarg
                if nrofoutarg>=1
                    if isempty(outinvar)
                        line = [line 'mwArray ' invar{1}];
                        for r=2:nrofinarg
                                line = [line ', mwArray ' invar{r}];
                        end
                        line = [line ')'];
                    else
                        for r=1:nrofinarg
                                line = [line ', mwArray ' invar{r}];
                        end
                        line = [line ')'];
                    end
                else
                    line = [line 'mwArray ' invar{1}];
                    for r=2:nrofinarg
                            line = [line ', mwArray ' invar{r}];
                    end
                    line = [line ')'];
                end
            else
                if nrofoutarg<2
                    line = [line '(void)'];
                end
            end
            
            
            functiondefinedstatus = 1;
            
            printcell{printlength} = sprintf('%s',[char(10),char(10),'//=====================================================']);
            printlength = printlength+1;
            printcell{printlength} = sprintf('%c',char(10));
            printlength = printlength+1;
            printcell{printlength} = sprintf(line); 
            printlength = printlength+1;
            
          
           
            if ~isempty(headerfile)
                fprintf(fidhpp,'%s',[char(10),char(10),'//=====================================================']);
                fprintf(fidhpp,'%c',char(10));
                fprintf(fidhpp,[line,';',char(10)]);
            end
            printcell{printlength} = sprintf('%c',char(10));
            printlength = printlength+1;
            printcell{printlength} = sprintf('%c',['{',char(10)]);
            printlength = printlength+1;
            if ~isempty(findstr(linedebl,'='))
                line = ['mwArray ',outvar,';',char(10)];
                printcell{printlength} = sprintf(line);
                printlength = printlength+1;
                line = '';
            else 
                line = '';
            end
            declareposition = printlength;
            continue;
            
        elseif ~isempty(findstr(linedebl,'function')) & isempty(findstr(linedebl,'definition')) & isempty(findstr(line,'//')) & functiondefinedstatus==1
        
                     
                        
            if isempty(findstr(lastline,'return'))
                %return
                %=======================
                if ~isempty(outvar)
                    newline = [char(10),'return ',outvar,';',char(10)];
                else
                    newline = [char(10),'return;',char(10)];
                end
                printcell{printlength} = sprintf(newline);
                printlength = printlength +1;
			end
               
			printcell{printlength} = sprintf('%c',['}',char(10)]);
			printlength = printlength +1;
			
			for e=1:size(printcell,2)
                if e == declareposition
                    if ~isempty(declarevariablescell)
                        if ~isempty(declarevariablescell{1})
                            for f = 1:size(declarevariablescell,2)
                                 fprintf(fidcpp,declarevariablescell{f});
                             end
                         end
                     end
                 end 
                 if e>declareposition & e<size(printcell,2)
                    fprintf(fidcpp,strrep(printcell{e},char(13),char(10)));
                else
                    fprintf(fidcpp,strrep(printcell{e},char(13),char(10)));
                end
			end
            first = 1;
            varcell = cell(1);
			varcell{1} = 'pi';
			varcell{2} = 'i';
			varcell{3} = 'j';
			numberofvars= 4;
			functiondefinedstatus = 0;
			printcell = cell(1);
			printlength = 1;
			declarevariablescell = cell(1);
			declarevariableslength = 1;
            argout = 0;
            argin = 0;
            outinvar = cell(1);
            invar = cell(1);
            continue;

        end
        
        
        
        
        
        %nargin
        %=====================
        if ~isempty(findstr(line,'nargin')) & functiondefinedstatus
            while strcmp(line(findstr(line,'nargin')+6),' ')
                line(findstr(line,'nargin')+6)=[];
            end
            if strcmp(line(findstr(line,'nargin')+6),'=')
                eq = findstr(line,'==');
                while strcmp(line(eq+2),' ')
                    line(eq+2)=[];
                end
                arg = findarg(line,eq+2);
                argnum = str2num(arg);
                newline = [];
                first = 1;
                for r=argnum+1:length(invar)
                    if first
                        newline = [newline,[' isempty(',invar{r},') ']];
                        first = 0;
                    else
                        newline = [newline,['& isempty(',invar{r},') ']];
                    end
                end
                narginstatus = 1;
                line = strinsert(line,[findstr(line,'nargin'):findstr(line,'==')+2+length(arg)-1],[newline]);
            elseif strcmp(line(findstr(line,'nargin')+6),'<') & ~strcmp(line(findstr(line,'nargin')+7),'=')
                 eq = findstr(line,'<');
                while strcmp(line(eq+1),' ')
                    line(eq+1)=[];
                end
                arg = findarg(line,eq+1);
                argnum = str2num(arg)-1;
                newline = [];
                first = 1;
                for r=argnum+1:length(invar)
                    if first
                        newline = [newline,[' isempty(',invar{r},') ']];
                        first = 0;
                    else
                        newline = [newline,['& isempty(',invar{r},') ']];
                    end
                end
                narginstatus = 1;
                line = strinsert(line,[findstr(line,'nargin'):findstr(line,'<')+1+length(arg)-1],[newline]);
            elseif strcmp(line(findstr(line,'nargin')+6),'>') & ~strcmp(line(findstr(line,'nargin')+7),'=')
                eq = findstr(line,'>');
                while strcmp(line(eq+1),' ')
                    line(eq+1)=[];
                end
                arg = findarg(line,eq+1);
                argnum = str2num(arg)+1;
                newline = [];
                first = 1;
                for r=argnum+1
                    if first
                        newline = [newline,[' !isempty(',invar{r},') ']];
                        first = 0;
                    else
                        newline = [newline,['& !isempty(',invar{r},') ']];
                    end
                end
                narginstatus = 1;
                line = strinsert(line,[findstr(line,'nargin'):findstr(line,'>')+1+length(arg)-1],[newline]);
            end
        end
        
        
        
        
        %function calls
        %===========================================
        if isempty(findstr(line,'//'))
            if ~isempty(findstr(line,'=')) & isempty(findstr(line,'=='))
                left = line(1:findstr(line,'='));
                right = line(findstr(line,'=')+1:end);
                rightdbl = strrep(strrep(strrep(right,char(9),''),char(10),''),char(32),'');
                rightfuncname = findarg(rightdbl,1);
                if ~isempty(findstr(rightfuncname,'('))
                    rightfuncname = rightfuncname(1:findstr(rightfuncname,'(')-1);
                end
                
                %m-file
                %========
                if ~isempty(findstr(left,'[')) & ~isempty(findstr(left,']')) & ~isempty(findstr(right,'(')) ...
                        & ~isempty(findstr(right,')')) & (exist(rightfuncname)==2 | exist(rightfuncname)==6  | exist(rightfuncname)==3| exist(rightfuncname)==4)
                    [line,inargstatus,outargstatus,argcell] = trfuncall(line);
                    if outargstatus & ~isempty(argcell{1})
                        zaehler = 1;
                        comment ='mwArray ';
                        
                        while ~strcmp(argcell{zaehler},'empty()')
                            if zaehler ==1
                                comment = [comment,argcell{zaehler}];
                            else
                                comment = [comment,', ',argcell{zaehler}];
                            end
                            zaehler = zaehler+1;
                            if zaehler>length(argcell)
                                break;
                            end
                        end
                        comment = [comment,';',char(10)];
                        commentstatus = 1;
                        pos = 1;
                        while ~isletterpp(line(pos))
                            pos = pos+1;
                        end
                        firstpart = line(1:pos);
                        indents = length(findstr(firstpart,char(10)));
                        indents2 = length(findstr(firstpart,char(9)));
                        indents3 = length(findstr(firstpart,char(32)));
                        comment = [char(ones(1,indents)*10),char(ones(1,indents2)*9),char(ones(1,indents3)*32),comment];
                
                    end
                %built-in function
                %======================
                elseif ~isempty(findstr(left,'[')) & ~isempty(findstr(left,']')) & ~isempty(findstr(right,'(')) ...
                        & ~isempty(findstr(right,')')) & (exist(rightfuncname)==5 )
                    [line,inargstatus,outargstatus,argcell] = trfuncall(line,1);
                    
                  
                    if outargstatus
                        zaehler = 1;
                        comment ='mwArray ';
                        while ~strcmp(argcell{zaehler},'empty()')
                            if zaehler ==1
                                comment = [comment,argcell{zaehler}];
                            else
                                comment = [comment,', ',argcell{zaehler}];
                            end
                            zaehler = zaehler+1;
                            if zaehler>length(argcell)
                                break;
                            end
                        end
                        comment = [comment,';',char(10)];
                        commentstatus = 1;
                        pos = 1;
                        while ~isletterpp(line(pos))
                            pos = pos+1;
                        end
                        firstpart = line(1:pos);
                        indents = length(findstr(firstpart,char(10)));
                        indents2 = length(findstr(firstpart,char(9)));
                        indents3 = length(findstr(firstpart,char(32)));
                        comment = [char(ones(1,indents)*10),char(ones(1,indents2)*9),char(ones(1,indents3)*32),comment];
                
                    end
                end
            end
        end
        
        
       
        
        
      
        
         % ^  and .^
        %========================================
        if ~isempty(findstr(line,'^')) & isempty(findstr(line,'fprintf(1')) & isempty(findstr(line,'error'))  & isempty(findstr(line,'disp')) 
            if length(findstr(line,'^'))==1 & isempty(findstr(line,'//')) 
                %delete blanks before argument after *
                while strcmp(line(findstr(line,'^')+1),' ') | strcmp(line(findstr(line,'^')+1),char(9)) | strcmp(line(findstr(line,'^')+1),char(10)) 
                    line(findstr(line,'^')+1)=[];
                end
                
                if ~isempty(findstr(line,'.^'))
                     while strcmp(line(findstr(line,'^')-2),' ') | strcmp(line(findstr(line,'^')-2),char(9)) | strcmp(line(findstr(line,'^')-2),char(10)) 
                        line(findstr(line,'^')-2)=[];
                    end
                    right = findstr(line,'.^')+2;
                    left = findstr(line,'.^')-1;
                    rightarg = findarg(line,right);
                    leftarg = findarg(line,left);
                    if length(findstr(line,leftarg))==1 & length(findstr(line,rightarg))==1
                        line = strrep(line,leftarg,['power(',leftarg]);
                        while strcmp(line(findstr(line,['power(',leftarg])+6+length(leftarg)),' ')
                            line(findstr(line,['power(',leftarg])+6+length(leftarg))=[];
                        end
                        line  = strrep(line,['power(',leftarg,'.^'],['power(',leftarg,',']);
                        
                        line = strrep(line,rightarg,[rightarg,')']);
                    else
                        [leftarg,pos]= findarg(line,left,1) ;
                        line = strinsert(line,[pos:pos+length(leftarg)-1],['power(',leftarg]);
                        sterne = findstr(line,'.^');
                        right = findstr(line,'.^')+2;
                        line  = strinsert(line,[sterne(1):sterne(1)+1],',');
                        line = strinsert(line,[right(1):right(1)+length(rightarg)-1],[rightarg,')']);
                    end
                else
                     while strcmp(line(findstr(line,'^')-1),' ') | strcmp(line(findstr(line,'^')-1),char(9)) | strcmp(line(findstr(line,'^')-1),char(10)) 
                        line(findstr(line,'^')-1)=[];
                    end
                    right = min(findstr(line,'^')+1);
                    left = min(findstr(line,'^')-1);
                    rightarg = findarg(line,right);
                    leftarg = findarg(line,left);
                    if length(findstr(line,leftarg))==1 & length(findstr(line,rightarg))==1
                        line = strrep(line,leftarg,['mpower(',leftarg]);
                        line  = strrep(line,['mpower(',leftarg,'^'],['mpower(',leftarg,',']);
                        line = strrep(line,rightarg,[rightarg,')']);
                    else
                        [leftarg,pos]= findarg(line,left,1) ;
                        line = strinsert(line,[pos:pos+length(leftarg)-1],['mpower(',leftarg]);
                        sterne = findstr(line,'^');
                        right = findstr(line,'^')+1;
                        line  = strinsert(line,[sterne(1)],',');
                        line = strinsert(line,[right(1):right(1)+length(rightarg)-1],[rightarg,')']);
                    end
                        
                end
            elseif length(findstr(line,'^'))>1 & isempty(findstr(line,'//'))
                sterne = findstr(line,'^');
                anzahl = length(sterne);
                for e=1:anzahl
                    sterne = findstr(line,'^');
                    if isempty(sterne)
                        break
                    end
                    %delete blanks before argument after *
                     while strcmp(line(sterne(1)+1),' ') | strcmp(line(sterne(1)+1),char(9)) | strcmp(line(sterne(1)+1),char(10)) 
                        line(sterne(1)+1)=[];
                     end
                     if strcmp(line(sterne(1)-1),'.')
                        while strcmp(line(sterne(1)-2),' ') | strcmp(line(sterne(1)-2),char(9)) | strcmp(line(sterne(1)-2),char(10)) 
                            line(sterne(1)-2)=[];
                        end
                        right = sterne(1)+1;
                        left = sterne(1)-2;
                        rightarg = findarg(line,right);
                        leftarg = findarg(line,left);
                        if length(findstr(line,leftarg))==1 & length(findstr(line,rightarg))==1
                            line = strrep(line,leftarg,['power(',leftarg]);
                            line  = strrep(line,[leftarg,'.^'],[leftarg,',']);
                            line = strrep(line,rightarg,[rightarg,')']);                            
                        else
                            [leftarg,pos]= findarg(line,left,1) ;
                            line = strinsert(line,[pos:pos+length(leftarg)-1],['power(',leftarg]);
                            sterne = findstr(line,'.^');
                            right = findstr(line,'.^')+2;
                            line  = strinsert(line,[sterne(1):sterne(1)+1],',');
                            line = strinsert(line,[right(1):right(1)+length(rightarg)-1],[rightarg,')']);
                        end
                        
                    else
                        while strcmp(line(sterne(1)-1),' ') | strcmp(line(sterne(1)-1),char(9)) | strcmp(line(sterne(1)-1),char(10)) 
                            line(sterne(1)-1)=[];
                        end
                        right = min(findstr(line,'^')+1);
                        left = min(findstr(line,'^')-1);
                        rightarg = findarg(line,right);
                        leftarg = findarg(line,left) ;
                        if length(findstr(line,leftarg))==1 & length(findstr(line,rightarg))==1
                            line = strrep(line,leftarg,['mpower(',leftarg]);
                            line  = strrep(line,['mpower(',leftarg,'^'],['mpower(',leftarg,',']);
                            line  = strrep(line,'^',',');
                            line = strrep(line,rightarg,[rightarg,')']);                            
                        else
                            [leftarg,pos]= findarg(line,left,1) ;
                            line = strinsert(line,[pos:pos+length(leftarg)-1],['mpower(',leftarg]);
                            sterne = findstr(line,'^');
                            right = findstr(line,'^')+1;
                            line  = strinsert(line,[sterne(1)],',');
                            line = strinsert(line,[right(1):right(1)+length(rightarg)-1],[rightarg,')']);                            
                        end
                    end
                end
            end
        end
        
         %' an .'
        %=================================
        if ~isempty(findstr(line,'''')) & length(findstr(line,''''))==1 & isempty(findstr(line,'fprintf')) ...
                & isempty(findstr(line,'disp')) & isempty(findstr(line,'error'))...
                  & isempty(findstr(line,'num2str')) & isempty(findstr(line,'in2str'))
           lindebl = deblank(line);
           if strcmp(lindebl(findstr(lindebl,char(39))-1),']') & length(findstr(lindebl,'['))==1
               line = strrep(line,'[',' transpose([');
               line = strrep(line,']','])');
               line = strrep(line,'''','');
               
           else
               if isempty(findstr(line,'.'''))
                  if length(findstr(line,''''))==1
                      arg = findarg(line,findstr(line,'''')-1,1);
                      line = strrep(line,[arg,''''],['transpose(',arg,')']);
                  end
              else
                   if length(findstr(line,'.'''))==1
                      arg = findarg(line,findstr(line,'.''')-1,1);
                      line = strrep(line,[arg,'.'''],['ctranspose(',arg,')']);
                  end
              end  
           end  
        elseif ~isempty(findstr(line,'''')) & length(findstr(line,''''))>1 & rem(length(findstr(line,'''')),2)==1 ...
            & isempty(findstr(line,'fprintf')) & isempty(findstr(line,'disp')) & isempty(findstr(line,'error'))...
                & isempty(findstr(line,'num2str')) & isempty(findstr(line,'in2str'))
            while 1
                aps = findstr(line,'''');
                cstatus = 0;
                replacedstatus = 0;
                for r=1:length(aps)
                    
                    cstatus = 0;
                    if strcmp(line(aps(r)-1),'.')
                        aps(r)=aps(r)-1;
                        cstatus = 1;
                    end
                    while strcmp(line(aps(r)-1),' ')
                        line(aps(r)-1)=[];
                        if aps(r)-1<1
                            break;
                        end
                    end
                    if strcmp(line(aps(r)-1),'(') | strcmp(line(aps(r)-1),'[') | strcmp(line(aps(r)-1),'{') | strcmp(line(aps(r)-1),',') | strcmp(line(aps(r)-1),';') 
                        continue;
                    else
                        [arg,argpos] = findarg(line,aps(r)-1);
                        if cstatus
                            line = strinsert(line,[argpos:argpos+length(arg)+1],['ctranspose(',arg,')']);
                            replacedstatus = 1;
                            break;
                        else
                            line = strinsert(line,[argpos:argpos+length(arg)+0],['transpose(',arg,')']);
                            replacedstatus = 1;
                            break;
                        end
                    end
                end
                if ~replacedstatus
                    break;
                end
            end
        elseif ~isempty(findstr(line,'''')) & length(findstr(line,''''))>1 & rem(length(findstr(line,'''')),2)==0 & isempty(findstr(line,'fprintf')) ...
                & isempty(findstr(line,'disp')) & isempty(findstr(line,'error')) ...
                  & isempty(findstr(line,'num2str')) & isempty(findstr(line,'int2str'))
            
            [nrofargs,argcell,stringcell,numcell] = strparse(line);
            if isempty(stringcell{1}) & ~ischar(stringcell{1})
                while 1
                    aps = findstr(line,'''');
                    cstatus = 0;
                    replacedstatus = 0;
                    for r=1:length(aps)
                        
                        cstatus = 0;
                        if strcmp(line(aps(r)-1),'.')
                            aps(r)=aps(r)-1;
                            cstatus = 1;
                        end
                        while strcmp(line(aps(r)-1),' ')
                            line(aps(r)-1)=[];
                            if aps(r)-1<1
                                break;
                            end
                        end
                        if strcmp(line(aps(r)-1),'(') | strcmp(line(aps(r)-1),'[') | strcmp(line(aps(r)-1),'{') | strcmp(line(aps(r)-1),',') | strcmp(line(aps(r)-1),';') 
                            continue;
                        else
                            [arg,argpos] = findarg(line,aps(r)-1);
                            if cstatus
                                line = strinsert(line,[argpos:argpos+length(arg)+1],['ctranspose(',arg,')']);
                                replacedstatus = 1;
                                break;
                            else
                                line = strinsert(line,[argpos:argpos+length(arg)+0],['transpose(',arg,')']);
                                replacedstatus = 1;
                                break;
                            end
                        end
                    end
                    if ~replacedstatus
                        break;
                    end
                end
            end
        end
        
        
         % division / and ./
        %========================================
        if ~isempty(findstr(line,'/')) & isempty(findstr(line,'fprintf(1')) & isempty(findstr(line,'error'))  & isempty(findstr(line,'disp'))   & isempty(findstr(line,'//'))
            if length(findstr(line,'/'))==1 & isempty(findstr(line,'://*')) & isempty(findstr(line,':\\'))
                %delete blanks before argument after *
                 sterne = findstr(line,'/');
                 while strcmp(line(sterne(1)+1),' ') | strcmp(line(sterne(1)+1),char(9)) | strcmp(line(sterne(1)+1),char(10)) 
                    line(sterne(1)+1)=[];
                 end
                 
                
                if ~isempty(findstr(line,'./'))
                    sterne = findstr(line,'./');
                    while strcmp(line(sterne(1)-1),' ') | strcmp(line(sterne(1)-1),char(9)) | strcmp(line(sterne(1)-1),char(10)) 
                        line(sterne(1)-1)=[];
                    end
                    right = findstr(line,'./')+2;
                    left = findstr(line,'./')-1;
                    rightarg = findarg(line,right);
                    leftarg = findarg(line,left,1);
                    if length(findstr(line,leftarg))==1 & length(findstr(line,rightarg))==1
                        line = strrep(line,leftarg,['rdivide(',leftarg]);
                        while strcmp(line(findstr(line,['rdivide(',leftarg])+8+length(leftarg)),' ')
                            line(findstr(line,['rdivide(',leftarg])+8+length(leftarg))=[];
                        end
                        line  = strrep(line,['rdivide(',leftarg,'./'],['rdivide(',leftarg,',']);
                        line = strrep(line,rightarg,[rightarg,')']);
                    else
                        [leftarg,pos]= findarg(line,left,1) ;
                        line = strinsert(line,[pos:pos+length(leftarg)-1],['rdivide(',leftarg]);
                        sterne = findstr(line,'./');
                        right = findstr(line,'./')+2;
                        line  = strinsert(line,[sterne(1):sterne(1)+1],',');
                        line = strinsert(line,[right(1):right(1)+length(rightarg)-1],[rightarg,')']);
                    end 
                end
            elseif length(findstr(line,'/'))>1 & isempty(findstr(line,'://')) & isempty(findstr(line,':\\'))
                sterne = findstr(line,'/');
                anzahl = length(sterne);
                for e=1:anzahl
                    sterne = findstr(line,'/');
                    if isempty(sterne)
                        break
                    end
                    %delete blanks before argument after *
                     while strcmp(line(sterne(1)+1),' ') | strcmp(line(sterne(1)+1),char(9)) | strcmp(line(sterne(1)+1),char(10)) 
                        line(sterne(1)+1)=[];
                     end
                     
                     if strcmp(line(sterne(1)-1),'.')
                         while strcmp(line(sterne(1)-2),' ') | strcmp(line(sterne(1)-2),char(9)) | strcmp(line(sterne(1)-2),char(10)) 
                            line(sterne(1)-2)=[];
                         end
                         
                        sterne = findstr(line,'/');
                        right = sterne(1)+1;
                        left = sterne(1)-2;
                        rightarg = findarg(line,right);
                        leftarg = findarg(line,left,1);
                        if length(findstr(line,leftarg))==1 & length(findstr(line,rightarg))==1
                            line = strrep(line,leftarg,['rdivide(',leftarg]);
                            line  = strrep(line,[leftarg,'./'],[leftarg,',']);
                            line = strrep(line,rightarg,[rightarg,')']);
                        else
                            [leftarg,pos]= findarg(line,left,1) ;
                            line = strinsert(line,[pos:pos+length(leftarg)-1],['rdivide(',leftarg]);
                            sterne = findstr(line,'./');
                            right = findstr(line,'./')+2;
                            line  = strinsert(line,[sterne(1):sterne(1)+1],',');
                            line = strinsert(line,[right(1):right(1)+length(rightarg)-1],[rightarg,')']);
                        end
                    end
                end                 
            end
        end
        
        % division \ and .\
        %========================================
        if ~isempty(findstr(line,'\')) & isempty(findstr(line,'\n')) & isempty(findstr(line,'\t'))
            if length(findstr(line,'\'))==1 & isempty(findstr(line,':\')) 
                %delete blanks before argument after *
                 sterne = findstr(line,'\');
                 while strcmp(line(sterne(1)+1),' ') | strcmp(line(sterne(1)+1),char(9)) | strcmp(line(sterne(1)+1),char(10)) 
                    line(sterne(1)+1)=[];
                 end
                 
                
                if ~isempty(findstr(line,'.\'))
                    sterne = findstr(line,'.\');
                    while strcmp(line(sterne(1)-1),' ') | strcmp(line(sterne(1)-1),char(9)) | strcmp(line(sterne(1)-1),char(10)) 
                        line(sterne(1)-1)=[];
                    end
                    right = findstr(line,'.\')+2;
                    left = findstr(line,'.\')-1;
                    rightarg = findarg(line,right);
                    leftarg = findarg(line,left,1);
                    if length(findstr(line,leftarg))==1 & length(findstr(line,rightarg))==1
                        line = strrep(line,leftarg,['ldivide(',leftarg]);
                        while strcmp(line(findstr(line,['ldivide(',leftarg])+8+length(leftarg)),' ')
                            line(findstr(line,['ldivide(',leftarg])+8+length(leftarg))=[];
                        end
                        line  = strrep(line,['ldivide(',leftarg,'.\'],['ldivide(',leftarg,',']);
                        line = strrep(line,rightarg,[rightarg,')']);
                    else
                        [leftarg,pos]= findarg(line,left,1) ;
                        line = strinsert(line,[pos:pos+length(leftarg)-1],['rdivide(',leftarg]);
                        sterne = findstr(line,'.\');
                        right = findstr(line,'.\')+2;
                        line  = strinsert(line,[sterne(1):sterne(1)+1],',');
                        line = strinsert(line,[right(1):right(1)+length(rightarg)-1],[rightarg,')']);
                    end 
                else
                    sterne = findstr(line,'\');
                    while strcmp(line(sterne(1)-1),' ') | strcmp(line(sterne(1)-1),char(9)) | strcmp(line(sterne(1)-1),char(10)) 
                        line(sterne(1)-1)=[];
                    end
                    right = min(findstr(line,'\')+1);
                    left = min(findstr(line,'\')-1);
                    rightarg = findarg(line,right);
                    leftarg = findarg(line,left,1);
                    if length(findstr(line,leftarg))==1 & length(findstr(line,rightarg))==1
                        line = strrep(line,leftarg,['mldivide(',leftarg]);
                        right = findstr(line,'\')+1;
                        line  = strrep(line,['mldivide(',leftarg,'\'],['mldivide(',leftarg,',']);
                        if length(findstr(line,rightarg))==1
                            line = strrep(line,rightarg,[rightarg,')']);
                        else
                            line = strinsert(line,[right(1):right(1)+length(rightarg)-1],[rightarg,')']);
                        end
                    else
                        [leftarg,pos]= findarg(line,left,1) ;
                        line = strinsert(line,[pos:pos+length(leftarg)-1],['mldivide(',leftarg]);
                        sterne = findstr(line,'\');
                        right = findstr(line,'\')+1;
                        line  = strinsert(line,[sterne(1)],',');
                        line = strinsert(line,[right(1):right(1)+length(rightarg)-1],[rightarg,')']);
                    end  
                end
            elseif length(findstr(line,'\'))>1 & isempty(findstr(line,':\')) & (isempty(findstr(line,'char'))| isempty(findstr(line,'fprintf')))
                 [nrofargs,argcell,stringcell,numcell] = strparse(line);
                 if isempty(stringcell{1}) & ~ischar(stringcell{1})
                    sterne = findstr(line,'\');
                    anzahl = length(sterne);
                    for e=1:anzahl
                        sterne = findstr(line,'\');
                        if isempty(sterne)
                            break
                        end
                        %delete blanks before argument after *
                         while strcmp(line(sterne(1)+1),' ') | strcmp(line(sterne(1)+1),char(9)) | strcmp(line(sterne(1)+1),char(10)) 
                            line(sterne(1)+1)=[];
                         end
                         
                         if strcmp(line(sterne(1)-1),'.')
                             while strcmp(line(sterne(1)-2),' ') | strcmp(line(sterne(1)-2),char(9)) | strcmp(line(sterne(1)-2),char(10)) 
                                line(sterne(1)-2)=[];
                             end
                             
                            sterne = findstr(line,'\');
                            right = sterne(1)+1;
                            left = sterne(1)-2;
                            rightarg = findarg(line,right);
                            leftarg = findarg(line,left,1);
                            if length(findstr(line,leftarg))==1 & length(findstr(line,rightarg))==1
                                line = strrep(line,leftarg,['ldivide(',leftarg]);
                                line  = strrep(line,[leftarg,'.\'],[leftarg,',']);
                                line = strrep(line,rightarg,[rightarg,')']);
                            else
                                [leftarg,pos]= findarg(line,left,1) ;
                                line = strinsert(line,[pos:pos+length(leftarg)-1],['ldivide(',leftarg]);
                                sterne = findstr(line,'.\');
                                right = findstr(line,'.\')+2;
                                line  = strinsert(line,[sterne(1):sterne(1)+1],',');
                                line = strinsert(line,[right(1):right(1)+length(rightarg)-1],[rightarg,')']);
                            end
                        else
                            while strcmp(line(sterne(1)-1),' ') | strcmp(line(sterne(1)-1),char(9)) | strcmp(line(sterne(1)-1),char(10)) 
                                line(sterne(1)-1)=[];
                            end
                            right = min(findstr(line,'\')+1);
                            left = min(findstr(line,'\')-1);
                            rightarg = findarg(line,right);
                            leftarg = findarg(line,left,1) ;
                            if length(findstr(line,leftarg))==1 & length(findstr(line,rightarg))==1
                                line = strrep(line,leftarg,['mldivide(',leftarg]);
                                line = strrep(line,['mldivide(',leftarg,'\'],['mldivide(',leftarg,',']);
                                line = strrep(line,rightarg,[rightarg,')']);
                            else
                                [leftarg,pos]= findarg(line,left,1) ;
                                line = strinsert(line,[pos:pos+length(leftarg)-1],['mldivide(',leftarg]);
                                sterne = findstr(line,'\');
                                right = findstr(line,'\')+1;
                                line  = strinsert(line,[sterne(1)],',');
                                line = strinsert(line,[right(1):right(1)+length(rightarg)-1],[rightarg,')']);
                            end  
                        end
                    end    
                end
            end
        end
        
        % multiplication * and .*
        %========================================
        if ~isempty(findstr(line,'*')) & isempty(findstr(line,'fprintf(1')) & isempty(findstr(line,'error'))  & isempty(findstr(line,'disp')) 
            if length(findstr(line,'*'))==1 & isempty(findstr(line,'''*')) & isempty(findstr(line,'*.*')) & isempty(findstr(line,'"*'))
                sterne = findstr(line,'*');
                %delete blanks before argument after *
                 while strcmp(line(sterne(1)+1),' ') | strcmp(line(sterne(1)+1),char(9)) | strcmp(line(sterne(1)+1),char(10)) 
                    line(sterne(1)+1)=[];
                 end
                if ~isempty(findstr(line,'.*'))
                     while strcmp(line(sterne(1)-2),' ') | strcmp(line(sterne(1)-2),char(9)) | strcmp(line(sterne(1)-2),char(10)) 
                        line(sterne(1)-2)=[];
                     end
                    right = findstr(line,'.*')+2;
                    left = findstr(line,'.*')-1;
                    rightarg = findarg(line,right);
                    leftarg = findarg(line,left,1);
                    if length(findstr(line,leftarg)) ==1 & length(findstr(line,rightarg))==1
                        line = strrep(line,leftarg,['times(',leftarg]);                        
                        while strcmp(line(findstr(line,['times(',leftarg])+6+length(leftarg)),' ')
                                line(findstr(line,['times(',leftarg])+6+length(leftarg))=[];
                        end
                        line  = strrep(line,['times(',leftarg,'.*'],['times(',leftarg,',']);
                        line = strrep(line,rightarg,[rightarg,')']);
                    else
                        [leftarg,pos]= findarg(line,left(1),1) ;
                        line = strinsert(line,[pos:pos+length(leftarg)-1],['times(',leftarg]);
                        sterne = findstr(line,'.*');
                        right = findstr(line,'.*')+2;
                        line  = strinsert(line,[sterne(1):sterne(1)+1],',');
                        line = strinsert(line,[right(1):right(1)+length(rightarg)-1],[rightarg,')']);
                    end
                end
            elseif length(findstr(line,'*'))>1 & isempty(findstr(line,'*.*'))
                sterne = findstr(line,'*');
                    
                anzahl = length(sterne);
                for e=1:anzahl
                    sterne = findstr(line,'*');
                    %delete blanks before argument after *
                     while strcmp(line(sterne(1)+1),' ') | strcmp(line(sterne(1)+1),char(9)) | strcmp(line(sterne(1)+1),char(10)) 
                        line(sterne(1)+1)=[];
                     end
                    
                     if strcmp(line(sterne(1)-1),'.')
                          %delete blanks after left argument before *
                         while strcmp(line(sterne(1)-2),' ') | strcmp(line(sterne(1)-2),char(9)) | strcmp(line(sterne(1)-2),char(10)) 
                            line(sterne(1)-2)=[];
                         end
                        right = sterne(1)+1;
                        left = sterne(1)-2;
                        rightarg = findarg(line,right);
                        leftarg = findarg(line,left,1);
                        if length(findstr(line,leftarg))==1 & length(findstr(line,rightarg))==1
                            line = strrep(line,leftarg,['times(',leftarg]);
                            line  = strrep(line,[leftarg,'.*'],[leftarg,',']);
                            line = strrep(line,rightarg,[rightarg,')']);
                        else
                            [leftarg,pos]= findarg(line,left(1),1) ;
                            line = strinsert(line,[pos:pos+length(leftarg)-1],['times(',leftarg]);
                            sterne = findstr(line,'.*');
                            right = findstr(line,'.*')+2;
                            line  = strinsert(line,[sterne(1):sterne(1)+1],',');
                            line = strinsert(line,[right(1):right(1)+length(rightarg)-1],[rightarg,')']);
                        end
                    end
                    sterne = findstr(line,'*');
                    if length(sterne)==0
                        break;
                    end
                end
            end
        end
        
        
        
        
           
        
        
        
       
       
        
        
        %return
        %=======================
        if ~isempty(outvar) & ~isempty(findstr(line,'return'));
            line = strrep(line,'return',['return ',outvar]);
            if isempty(findstr(line,';'))
                line = [debreak(line),';',char(10)];
            end
        elseif isempty(outvar) & ~isempty(findstr(line,'return')) & isempty(findstr(line,';'))
            line = [line,';',char(10)];
        end
       
        
        %if-else-end
        %=================================
        if ~isempty(findstr(line,'if ')) & isempty(findstr(line,'elseif')) & isempty(findstr(line,'else')) & isempty(findstr(line,'end'))
            
            line = remtrailkom(line);
            if ~isempty(findstr(line,'if ~rem'))
                disp('hallo')
            end
            line = strrep(line,'if ','if (tobool(');
            line = strrep(line,';','');
            line = debreak(line);
            line = [line, ')) {',char(10)];
                
        elseif ~isempty(findstr(line,'if ')) & isempty(findstr(line,'elseif'))  & isempty(findstr(line,'else'))& ~isempty(findstr(line,'end'))
            
            
            
            ifpos = findstr(line,'if');
            sems = findstr(line,';');
            semstatus = 0;
            semind =[];
            for q=1:length(sems)
                if isempty(findleftopenbrackof(line,sems(q))) & isempty(findrightopenbrackof(line,sems(q)))
                    semstatus = 1;
                    semind = [semind q];
                end
            end
            firstsemafterif = min(semind(find(sems(semind)>ifpos)));
            
            komms = findstr(line,',');
            kommstatus = 0;
            kommind =[];
            for q=1:length(komms)
                if isempty(findleftopenbrackof(line,komms(q))) & isempty(findrightopenbrackof(line,komms(q)))
                    kommstatus = 1;
                    kommind = [kommind q];
                end
            end
            firstkommafterif = min(kommind(find(komms(kommind)>ifpos)));
            
            if kommstatus & ~semstatus
                line(komms(firstkommafterif))='@';
                for w=1:length(komms)
                    if w~=firstkommafterif
                        line(komms(w))=';';
                    end
                end
                line = strrep(line,'@',')) {');
            elseif semstatus & ~kommstatus
                line(sems(firstsemafterif))='@';
                line = strrep(line,'@',')) {');
            elseif kommstatus & semstatus
                if firstsemafterif<firstkommafterif
                    ind = firstsemafterif;
                    vec = sems;
                    line(vec(ind))='@';
                    for w=1:length(komms)
                        line(komms(w))=';';
                    end
                else
                    ind = firstkommafterif;
                    vec = komms;
                    line(vec(ind))='@';
                    for w=1:length(komms)
                        if w~=firstkommafterif
                            line(komms(w))=';';
                        end
                    end
                end
               
                line = strrep(line,'@',')) {');
            else
                error(['Unrecognized line endings in ''',line,'''!']);
            end
            
            line = strrep(line,'if ','if (tobool(');
            line = strrep(line,'end','}');   
       elseif ~isempty(findstr(line,'if ')) & isempty(findstr(line,'elseif'))  & ~isempty(findstr(line,'else'))& ~isempty(findstr(line,'end'))
            
           
            indent = line(1:findstr(line,'if'));
            indents = length(findstr(indent,char(10)));
            indents2 = length(findstr(indent,char(9)));
            indents3 = length(findstr(indent,char(32)));
            %   ,char(ones(1,indents)*10),char(ones(1,indents2)*9),char(ones(1,indents2)*32)
            
            line = strrep(line,'if ','if (tobool(');
            sems = findstr(line,';');
            firstsem = sems(1);
            line = strrep(line,line(1:firstsem),[line(1:firstsem-1),')){',char(10),char(ones(1,indents)*10),char(ones(1,indents2)*9),char(ones(1,indents3)*32)]);
            if ~isempty(findstr(line,'else;'))
                line = strrep(line,'else;',[char(10),char(ones(1,indents)*10),char(ones(1,indents2)*9),char(ones(1,indents3)*32),'}',char(10),char(ones(1,indents)*10),char(ones(1,indents2)*9),char(ones(1,indents3)*32),'else {',char(10),char(ones(1,indents)*10),char(ones(1,indents2)*9),char(ones(1,indents3)*32)]);
            elseif ~isempty(findstr(line,'else ;'))
                line = strrep(line,'else ;',['}',char(10),char(ones(1,indents)*10),char(ones(1,indents2)*9),char(ones(1,indents3)*32),'else {',char(10),char(ones(1,indents)*10),char(ones(1,indents2)*9),char(ones(1,indents3)*32)]);
            elseif ~isempty(findstr(line,'else  ;'))
                line = strrep(line,'else  ;',['}',char(10),char(ones(1,indents)*10),char(ones(1,indents2)*9),char(ones(1,indents3)*32),'else {',char(10),char(ones(1,indents)*10),char(ones(1,indents2)*9),char(ones(1,indents3)*32)]);
            end
            line = strrep(line,'end',[char(10),char(ones(1,indents)*10),char(ones(1,indents2)*9),char(ones(1,indents3)*32),'}',char(10),char(ones(1,indents)*10),char(ones(1,indents2)*9),char(ones(1,indents3)*32)]);
            
            
        elseif ~isempty(findstr(line,'if ')) & ~isempty(findstr(line,'elseif'))  & isempty(findstr(line,'else '))& ~isempty(findstr(line,'end'))
           
             indent = line(1:findstr(line,'if'));
            indents = length(findstr(indent,char(10)));
            indents2 = length(findstr(indent,char(9)));
            indents3 = length(findstr(indent,char(32)));
            %   ,char(ones(1,indents)*10),char(ones(1,indents2)*9),char(ones(1,indents2)*32)
            
            line = strrep(line,'if ','if (tobool(');
            line  = strrep(line,'elseif (','elseif ');
            sems = findstr(line,';');
            firstsem = sems(1);
            
            line = strrep(line,line(1:firstsem),[line(1:firstsem-1),')){',char(10),char(ones(1,indents)*10),char(ones(1,indents2)*9),char(ones(1,indents3)*32)]);
            if ~isempty(findstr(line,'elseif'))
                line = strrep(line,'elseif',[char(10),char(ones(1,indents)*10),char(ones(1,indents2)*9),char(ones(1,indents3)*32),'}',char(10),char(ones(1,indents)*10),char(ones(1,indents2)*9),char(ones(1,indents3)*32),'else if (tobool(']);
                sems = findstr(line,';');
                eif = findstr(line,'else if');
                firstsem = min(sems(find(sems>eif)));
                line = strrep(line,line(findstr(line,'else if')+9:firstsem),[line(findstr(line,'else if')+9:firstsem-1),')){',char(10),char(ones(1,indents)*10),char(ones(1,indents2)*9),char(ones(1,indents3)*32)]);
           
            end
            line = strrep(line,'end',[char(10),char(ones(1,indents)*10),char(ones(1,indents2)*9),char(ones(1,indents3)*32),'}',char(10),char(ones(1,indents)*10),char(ones(1,indents2)*9),char(ones(1,indents3)*32)]);
            
            
        end
        
        
        %for
        %=================================
         if ~isempty(findstr(line,'for ')) & isempty(findstr(line,'end')) & ~isempty(findstr(line,':')) & ~isempty(findstr(line,'='))
            line = strrep(line,'for ','for (int ');
            line = [line(1:end-1) ') {',char(10)];
            fors = findstr(line,'for (int ')+9;
            equ = findstr(line,'=');
            var = line(fors:equ-1);
            line = strrep(line,':',[';',var,'<=']);
            line = strrep(line,[') {',char(10)],['.ExtractScalar(1);',var,'++) {',char(10)]);
        elseif ~isempty(findstr(line,'for ')) & ~isempty(findstr(line,'end'))  & ~isempty(findstr(line,':')) & ~isempty(finsdtr(line,'='))
            line = strrep(line,'for ','for (int ');
            sems = findstr(line,';');
            line(sems(1))='@';
            line = strrep(line,'@',') {');
            line = strrep(line,'end','}');
        end
        
        %switch
        %=================================
        if ~isempty(findstr(line,'switch ')) & isempty(findstr(line,'//'))
            line = strrep(line,'switch ','switch (');
            line = [line(1:end-1),') {',char(10)];
        end
        if ~isempty(findstr(line,'case ')) & isempty(findstr(line,'//'))
            if isempty(findstr(line,'"'))
                if isempty(findstr(lastline,'switch'))
                    indent = getlineindent(line);
                    lastindent = getlineindent(lastline);
                    printcell{printlength} = sprintf([lastindent,'break;',char(10)]);
                    printlength = printlength+1;
                    line = [debreak(line),' :',char(10)];
                else
                    line = [debreak(line),' :',char(10)];
                end
            else
                 if isempty(findstr(lastline,'switch'))
                    indent = getlineindent(line);
                    lastindent = getlineindent(lastline);
                    printcell{printlength} = sprintf([lastindent,'break;',char(10)]);
                    printlength = printlength+1;
                    line = [strrep(strrep(debreak(line),'case','if (tobool(strcmp(  ,"'),':','"))) {'),char(10)];
                else
                    line = [strrep(strrep(debreak(line),'case','if (tobool(strcmp(  ,"'),':','"))) {'),char(10)];
                end
            end
        end
        if ~isempty(findstr(line,'otherwise')) & isempty(findstr(line,'//'))
            if isempty(findstr(lastline,'switch'))
                indent = getlineindent(line);
                lastindent = getlineindent(lastline);
                printcell{printlength} = sprintf([lastindent,'break;',char(10)]);
                printlength = printlength+1;
                line = [debreak(strrep(line,'otherwise','default')),' :',char(10)];
            else
                line = [debreak(strrep(line,'otherwise','default')),' :',char(10)];
            end
        end
        
        %while
        %=================================
         if ~isempty(findstr(line,'while ')) &  isempty(findstr(line,'end'))
            line = strrep(line,'while ','while (tobool(');
            line = [line(1:end-1),')) {',char(10)];
        elseif ~isempty(findstr(line,'while ')) & ~isempty(findstr(line,'end'))
            line = strrep(line,'while ','while (tobool(');
            sems = findstr(line,';');
            line(sems(1))='@';
            line = strrep(line,'@',')) {');
            line = strrep(line,'end','}');
        end
              
        
        %else
        %=================================
        if ~isempty(findstr(line,'else')) & length(strrep(strrep(deblank(line),char(9),''),char(32),''))<8
            indent = line(1:findstr(line,'else'));
            indents = length(findstr(indent,char(32)));
            indents2 = length(findstr(indent,char(9)));
             
            line = [strrep(line,'else',['}',char(10),char(ones(1,indents)*32) ,char(ones(1,indents2)*9),'else {'])];
        end
        
        %elseif
        %=================================
        if ~isempty(findstr(line,'elseif'))  
            indent = line(1:findstr(line,'elseif'));
            indents = length(findstr(indent,char(32)));
            indents2 = length(findstr(indent,char(9)));
            line = strrep(line,'elseif',['}',char(10),char(ones(1,indents)*32),char(ones(1,indents2)*9),' else if (tobool(']);
            line = [line(1:end-1) ')) {',char(10)];
            line = strrep(line,';','');
        end
        
        
        %end
        %=================================
        if ~isempty(findstr(line,'end'))
            if length(strrep(strrep(deblank(line),char(9),''),char(32),''))<8
                line = strrep(line,'end','}');
                line = strrep(line,';','');
            end
        end
               
       
        
        %' ...  '
        %=================================
        if ~isempty(findstr(line,'''')) & length(findstr(line,''''))>1
            line = strrep(line,'''','"');
        end
        
       
          %check for unknown variables to declare
        %===========================================
        if isempty(findstr(line,'//'))
            [nr,argcell,strcell,numcell]=strparse(line);
            if numberofvars==1
                if ~isempty(line)
                    indent = deblanklbr(getlineindent(line));
                end
                for r=1:length(argcell)
                    varcell{numberofvars}= strrep(argcell{r},'.cell','');
                    numberofvars = numberofvars+1;
                    declarevariablescell{declarevariableslength} = sprintf(argcell{r});
                    declarevariableslength = declarevariableslength + 1;
                end
            else
                for r=1:length(argcell)
                    new = 1;
                    
                    %check if its a known variable, an m-file or a built-in function
                    for v=1:length(varcell)
                        if strcmp(varcell{v},strrep(argcell{r},'.cell',''))
                            
                                pos = findstr(line,argcell{r});
                                
                                 for f=1:length(pos)
                                     if f>length(pos)
                                         break;
                                     end
                                     if pos(f)-1>0
                                        if isdelimiter(line(pos(f)-1)) & isdelimiter(line(pos(f)+length(argcell{r})))
                                            if strcmp(argcell{r},'pi')
                                                line = strinsert(line,[pos(f):pos(f)+length(argcell{r})-1],['pi()']);
                                            elseif strcmp(argcell{r},'inf')
                                                line = strinsert(line,[pos(f):pos(f)+length(argcell{r})-1],['inf()']);
                                            elseif strcmp(argcell{r},'eps')
                                                line = strinsert(line,[pos(f):pos(f)+length(argcell{r})-1],['eps()']);
                                            elseif strcmp(argcell{r},'nan')
                                                line = strinsert(line,[pos(f):pos(f)+length(argcell{r})-1],['nan()']);
                                            end
                                        end
                                    else
                                          if isdelimiter(line(pos(f)+length(argcell{r})))
                                            if strcmp(argcell{r},'pi')
                                                line = strinsert(line,[pos(f):pos(f)+length(argcell{r})-1],['pi()']);
                                            elseif strcmp(argcell{r},'inf')
                                                line = strinsert(line,[pos(f):pos(f)+length(argcell{r})-1],['inf()']);
                                            elseif strcmp(argcell{r},'eps')
                                                line = strinsert(line,[pos(f):pos(f)+length(argcell{r})-1],['eps()']);
                                            elseif strcmp(argcell{r},'nan')
                                                line = strinsert(line,[pos(f):pos(f)+length(argcell{r})-1],['nan()']);
                                            end
                                        end
                                    end
                                    pos = findstr(line,argcell{r});
                                end  
                                      
                            new = 0;
                        elseif exist(argcell{r})== 2 | exist(argcell{r})==5 | exist(argcell{r})==6 | exist(argcell{r})==3 | exist(argcell{r})==4 
                            new = 0;
                        elseif strcmp(argcell{r}(1),'"') |strcmp(argcell{r}(end),'"')
                            new = 0;
                        elseif strcmp(argcell{r},'ExtractScalar') | strcmp(argcell{r},'tobool') | strcmp(argcell{r},'empty')| strcmp(argcell{r},'transpose') | strcmp(argcell{r},'int')
                            new = 0;
                        end
                        
                    end
                    
                    if new == 1
                        varcell{numberofvars}= strrep(argcell{r},'.cell','');
                        numberofvars = numberofvars+1;
                        indent = deblanklbr(getlineindent(line));;
                        declarevariablescell{declarevariableslength} = sprintf(argcell{r});
                        declarevariableslength = declarevariableslength + 1;
                    end
                    
                    %replace outinvar with *poutinvar
					%=================================
                    for e=1:length(outinvar)
                        if strcmp(outinvar{e},argcell{r})
                            pos = findstr(line,argcell{r});
                            oldlength = length(pos);
                            if length(pos)==1
                                if pos(1)==1
                                    line = strrep(line,argcell{r},['*p',outinvar{e}]);
                                else
                                    if strcmp(line(pos(1)-1),'&')
                                        line = strrep(line,argcell{r},['p',outinvar{e}]);
                                    end
                                end
                            else
                                for f=1:length(pos)
                                    pos = findstr(line,argcell{r});
                                    if length(pos)~=oldlength
                                        disp('hallo')
                                    end
                                    if pos(f)==1
                                        if isdelimiter(line(pos(f)+length(outinvar{e})))
                                           line = strinsert(line,[1:pos(f)+length(outinvar{e})-1],['(*p',outinvar{e},')']);
                                        end
                                    else
                                        if strcmp(line(pos(f)-1),'&')
                                            if isdelimiter(line(pos(f)-1)) & isdelimiter(line(pos(f)+length(outinvar{e})))
                                               line = strinsert(line,[pos(f):pos(f)+length(outinvar{e})-1],['p',outinvar{e},'']);
                                            end
                                        else
                                            if isdelimiter(line(pos(f)-1)) & isdelimiter(line(pos(f)+length(outinvar{e})))
                                               line = strinsert(line,[pos(f):pos(f)+length(outinvar{e})-1],['(*p',outinvar{e},')']);
                                            end
                                        end
                                    end
                                    pos = findstr(line,argcell{r});
                                end                                        
                            end
                        end
                    end  
                end
            end
        end
        
          % []
        %=================================
        line = strrep(line,'[]','empty()');
        if isempty(findstr(line,'for'))
            line = strrep(line,',:',',colon()');
            line = strrep(line,':,','colon(),');
            line = strrep(line,':)','colon())');
            line = strrep(line,'(:','(colon()');
        end
        line = strrep(line,'...','');
        
        
        %horizontal concats
        %=================================
        if ~isempty(findstr(line,'['))
            if (length(findstr(line,'['))==1) & (length(findstr(line,';'))<=1)
                firstb = findstr(line,'[');
                secondb = findstr(line,']');
                linetmp  = line(firstb:secondb);
                if isempty(findstr(linetmp,'"'))
                    while ~isempty(findstr(linetmp,'  '))
                        linetmp = strrep(linetmp,'  ',' ');
                    end
                    linetmp  = strrep(linetmp,' ',',');
                end
                line  = strrep(line,line(firstb:secondb),linetmp);
                line = strrep(line,'[','horzcat(');
                line = strrep(line,']',')');
            elseif  (length(findstr(line,'['))==1) & (length(findstr(line,';'))>0)
                firstb = findstr(line,'[');
                secondb = findstr(line,']');
                linetmp  = line(firstb:secondb);
                if isempty(findstr(linetmp,'"'))
                    while ~isempty(findstr(linetmp,'  '))
                        linetmp = strrep(linetmp,'  ',' ');
                    end
                    linetmp  = strrep(linetmp,';',',');
                end
                line  = strrep(line,line(firstb:secondb),linetmp);
                line = strrep(line,'[','vertcat(');
                line = strrep(line,']',')');
            elseif length(findstr(line,'['))>1
                if length(findstr(line,'['))~=length(findstr(line,']'))
                else
                    while 1
                        bracks = findstr(line,'[');
                        if isempty(findstr(line,'['))
                            break;
                        end
                        arg = findarg(line,bracks(1));
                        if ~isempty(findstr(arg,';'))
                            if isempty(findstr(arg,'"'))
                                line = strrep(line,arg,['vertcat(',strrep(strrep(strrep(arg,';',','),'[',''),']',''),')']);
                            else
                                line = strrep(line,arg,['vertcat(',strrep(strrep(arg,'[',''),']',''),')']);
                            end
                        else
                            if isempty(findstr(arg,'"'))
                                line = strrep(line,arg,['horzcat(',strrep(strrep(strrep(arg,' ',','),'[',''),']',''),')']);
                            else
                                line = strrep(line,arg,['horzcat(',strrep(strrep(arg,'[',''),']',''),')']);
                            end
                        end
                    end
                end
            end  
        end
        
        %~
        %=================================
        if ~isempty(findstr(line,'~'));
            line = strrep(line,'~','!');
        end
        
         %ramp,colon...
        %=================================
        if ~isempty(findstr(line,':')) & isempty(findstr(line,'(:')) & isempty(findstr(line,':)')) & isempty(findstr(line,'"'))
            if length(findstr(line,':'))==1
                colon = findstr(line,':');
                colinarg = iscoloninind(line,colon);
                [left,lpos] = findarg(line,colon-1);
                if colinarg
                    line = strinsert(line,lpos:lpos+length(left),['colon(',left,':']);
                else
                    line = strinsert(line,lpos:lpos+length(left),['ramp(',left,':']);
                end
                colon = findstr(line,':');
                [right,rpos]=findarg(line,colon+1);
                line = strinsert(line,rpos-1:rpos+length(right)-1,[',',right,')']);
            elseif length(findstr(line,':'))>1
                cols = length(findstr(line,':'));
                while 1
                    colon = findstr(line,':');
                    if isempty(colon)
                        break;
                    end
                    colinarg = [];
                    colinarg = iscoloninind(line,colon(1));
                    if isempty(colinarg)
                        disp('hallo')
                    end
                    [left,lpos] = findcolarg(line,colon(1)-1,1);
                    [right,rpos]=findcolarg(line,colon(1)+1);
                    if strcmp(line(rpos+length(right)),':')
                        [rightright,rrpos]= findcolarg(line,colon(2)+1);
                        rrstatus = 1;
                    else 
                        rrstatus = 0;
                    end
                    if colinarg
                        line = strinsert(line,lpos:lpos+length(left),['colon(',left,':']);
                    else
                        line = strinsert(line,lpos:lpos+length(left),['ramp(',left,':']);
                    end
                    colon = findstr(line,':');
                    [right,rpos]=findcolarg(line,colon(1)+1);
                    if rrstatus
                        line = strinsert(line,rpos-1:rpos+length(right),[',',right,':']);
                        colon = findstr(line,':');
                        [rightright,rrpos]= findcolarg(line,colon(1)+1);
                        line = strinsert(line,rrpos-1:rrpos+length(rightright)-1,[',',rightright,')']);
                    else
                        line = strinsert(line,rpos-1:rpos+length(right)-1,[',',right,')']);
                    end
                end
            end
        end
        
        
        %fprintf(1)
        %=================================
        line =strrep(line,'clc;','');
        line =strrep(line,'clc','');
        line = strrep(line,'fprintf("\n")','TRACE("\n")');
        line = strrep(line,'fprintf("\n")','TRACE("\n")');
        line = strrep(line,'fprintf("\n\n")','TRACE("\n\n")');
        line = strrep(line,'fprintf(1,','TRACE(');
        line = strrep(line,'fprintf("','TRACE("');
        if ~isempty(findstr(line,'pause'))
            line = '';
        end
        if ~isempty(findstr(line,'TRACE'))
            if length(findstr(line,'TRACE'))==1
                if ~iscell(getrargof('TRACE',line))
                    if isempty(findstr(getrargof('TRACE',line),'"')) & isempty(findstr(getrargof('TRACE',line),'*'))
                        tabs = length(findstr(line,char(9)));
                        tabsstring=[];
                        for r=1:tabs
                            tabsstring = [tabsstring char(9)];
                        end
                        arg = getrargof('TRACE',line);
                        if ~isempty(arg)
                            line = [tabsstring,'char* p',arg,';',char(10),tabsstring,'p',arg,'=strdup((char*) ',arg,'.ToString());',char(10),tabsstring,'CString tmp_',arg,';',char(10),tabsstring,'tmp_',arg,'=p',arg,';',char(10),tabsstring,'delete p',arg,';',char(10),tabsstring,'TRACE(tmp_',arg,');',char(10)];
                        end
                    elseif  isempty(findstr(getrargof('TRACE',line),'"')) & ~isempty(findstr(getrargof('TRACE',line),'*'))   
                        tabs = length(findstr(line,char(9)));
                        tabsstring=[];
                        for r=1:tabs
                            tabsstring = [tabsstring char(9)];
                        end
                        arg = getrargof('TRACE',line);
                        argminus = arg;
                        argminus(findstr(argminus,'*'))=[];
                        if ~isempty(arg)
                            line = [tabsstring,'char* p',argminus,';',char(10),tabsstring,'p',argminus,'=strdup((char*) ',arg,'.ToString());',char(10),tabsstring,'CString tmp_',argminus,';\n',tabsstring,'tmp_',argminus,'=p',argminus,';',char(10),tabsstring,'delete p',argminus,';',char(10),tabsstring,'TRACE(tmp_',argminus,');',char(10)];
                        end
                   
                    end
                else
                    
                    printcell{printlength} = sprintf('%c',line);
                    printlength = printlength+1;
		            line = fgets(fidm);
                    first = 1;
                end
                    
            else
                lines = findstr(line,'TRACE');
                totline = line;
                for h=1:length(lines)-1
                    if h==1
                        line = totline(1:lines(h+1)-1)
                    else
                        line = totline(lines(h):lines(h+1)-1);
                    end
                     if isempty(findstr(getrargof('TRACE',line),'"')) & isempty(findstr(getrargof('TRACE',line),'*'))
                        tabs = length(findstr(line,char(9)));
                        tabsstring=[];
                        for r=1:tabs
                            tabsstring = [tabsstring char(9)];
                        end
                        arg = getrargof('TRACE',line);
                        if ~isempty(arg)
                            line = [tabsstring,'char* p',arg,';',char(10),tabsstring,'p',arg,'=strdup((char*) ',arg,'.ToString());',char(10),tabsstring,'CString tmp_',arg,';',char(10),tabsstring,'tmp_',arg,'=p',arg,';',char(10),tabsstring,'delete p',arg,';',char(10),tabsstring,'TRACE(tmp_',arg,');',char(10)];
                        end
                    elseif  isempty(findstr(getrargof('TRACE',line),'"')) & ~isempty(findstr(getrargof('TRACE',line),'*'))   
                        tabs = length(findstr(line,char(9)));
                        tabsstring=[];
                        for r=1:tabs
                            tabsstring = [tabsstring char(9)];
                        end
                        arg = getrargof('TRACE',line);
                        argminus = arg;
                        argminus(findstr(argminus,'*'))=[];
                        if ~isempty(arg)
                            line = [tabsstring,'char* p',argminus,';',char(10),tabsstring,'p',argminus,'=strdup((char*) ',arg,'.ToString());',char(10),tabsstring,'CString tmp_',argminus,';',char(10),tabsstring,'tmp_',argminus,'=p',argminus,';',char(10),tabsstring,'delete p',argminus,';\n',tabsstring,'TRACE(tmp_',argminus,');',char(10)];
                        end
                   
                    end
                    if ~isempty(findstr(line,'\\'))
                         printcell{printlength} = sprintf('%c',line);
                     else
                        printcell{printlength} = sprintf('%c',line);
                    end
                    printlength = printlength +1;
                end
                  
            end
            
            
        end
        
        %disp
        %==========
        if ~isempty(findstr(line,'disp'))
            if length(findstr(line,'disp'))==1
                [tmparg,argstring]=getrargof('disp',line);
                line = strrep(line,'disp(', 'TRACE((');
                if length(findstr(line,')'))==1
                    line = strrep(line,')',').ToString())');
                else
                    bracks = findstr(line,')');
                    line = strinsert(line,bracks(end),[').ToString())']);
                end
            end
        end
        
        
        %error
        %==========
        if ~isempty(findstr(line,'error'))
            if length(findstr(line,'error'))==1
                [tmparg,argstring]=getrargof('error',line);
                line = strrep(line,'error(', 'TRACE((');
                if length(findstr(line,')'))==1
                    line = strrep(line,')',').ToString())');
                end
            end
        end
        
        
        %char
        %==========
        if ~isempty(findstr(line,'char('))
            line = strrep(line,'char(','char_func(');
        end
        
        
        
        if nargin==1
            break;
        end
            
    catch
        disp('There was an error while processing the line:');
        fprintf('\n');
        disp(line);
        fprintf('\n');
        disp('The error message was:');
        disp(lasterr);
        disp('continuing with following line...');
    end
     warning off  
end


if nargin==1
    out = line;
    return
end
    
fclose(fidm);
if isempty(findstr(lastline,'return'))
    %return
    %=======================
    if ~isempty(outvar)
        newline = [char(10),'return ',outvar,';',char(10)];
    else
        newline = [char(10),'return;',char(10)];
    end
    printcell{printlength} = sprintf(newline);
    printlength = printlength +1;
end
   
printcell{printlength} = sprintf('}\n');
printlength = printlength +1;

narginprintzaehler = 0;


for e=1:size(printcell,2)
    if e == declareposition
        if ~isempty(declarevariablescell)
            if ~isempty(declarevariablescell{1})
                fprintf(fidcpp,'%c','mwArray ');
                for f = 1:size(declarevariablescell,2)-1
                     fprintf(fidcpp,'%c',[declarevariablescell{f},',']);
                end
                fprintf(fidcpp,'%c',[declarevariablescell{size(declarevariablescell,2)},';',char(10)]);
                fprintf(fidcpp,'%c',['mwArray respath = ((CP2dApp*)AfxGetApp())->varresourcepath;',char(10)]);
                 
                %debug line
                %==========
                debugvarzaehler = 1;
                fprintf(fidcpp,'%c','//save(horzcat(respath,"\\","debug.mat"),');
                if nrofoutarg >0      
                    fprintf(fidcpp,'%c',['"',deblankex(outvar),'",',deblankex(outvar)]);
                    debugvarzaehler = debugvarzaehler+1;
                end
                if nrofoutarg>=1
                    if ~isempty(outinvar) 
                       if ~isempty(outinvar{1})
                            for r=1:nrofoutarg
                                if ~isempty(outinvar{r})
                                    fprintf(fidcpp,'%c',[',"',outinvar{r},'",',outinvar{r}]);
                                    debugvarzaehler = debugvarzaehler+1;
                                    if mod(debugvarzaehler,10)==0
                                        nr = floor(debugvarzaehler/10);
                                        fprintf(fidcpp,'%c',[');',char(10),'//save(horzcat(respath,"\\","debug.mat")']);
                                    end
                                end
                            end
                        end
                    end
                end 
                if nrofinarg>=1
                    for r=1:nrofinarg
                        if ~(r>length(invar))
                            if~isempty(invar{r})
                                fprintf(fidcpp,'%c',[',"',invar{r},'",',invar{r}]);
                                 debugvarzaehler = debugvarzaehler+1;
                                if mod(debugvarzaehler,10)==0
                                    nr = floor(debugvarzaehler/10);
                                    fprintf(fidcpp,'%c',[');',char(10),'//save(horzcat(respath,"\\","debug.mat")']);
                                end
                            end
                        end
                    end
                end
                for f = 1:size(declarevariablescell,2)-1
                    fprintf(fidcpp,'%c',[',"',declarevariablescell{f},'"',',',declarevariablescell{f}]);
                    debugvarzaehler = debugvarzaehler+1;
                    if mod(debugvarzaehler,10)==0
                        nr = floor(debugvarzaehler/10);
                        fprintf(fidcpp,'%c',[');',char(10),'//save("F:\\user\\peter\\debug',num2str(nr),'.mat"']);
                    end
                end
                fprintf(fidcpp,'%c',[',"',declarevariablescell{size(declarevariablescell,2)},'"',',',declarevariablescell{size(declarevariablescell,2)},');',char(10)]);
             end
         end
         
         
         fprintf(fidcpp,'%c',[char(10),'try {',char(10),char(10)]);
     end 
    
     
     if e==size(printcell,2)-1
         fprintf(fidcpp,'%c',[char(10),'}',char(10),char(10),'catch(mwException &mwex) {',char(10),char(9),'strstream stre;',char(10),char(9),...
                 'stre<<mwex;',char(10),char(9),'CString tmpstring;',char(10),char(9),'char* pchar = stre.str();',char(10),char(9),'tmpstring = pchar;'...
                 ,char(10),char(9),'delete pchar;',char(10),char(9),'tmpstring += "\nmwException in ',functionname,...
                 '";',char(10),char(9),'AfxMessageBox(tmpstring);',char(10),'}',char(10)]);
          fprintf(fidcpp,'%c',['catch(CException &cex) {',char(10),char(9),'CString tmpstring = "CException in ',functionname,...
              '";',char(10),char(9),'AfxMessageBox(tmpstring);',char(10),'}',char(10),char(10)]);
         fprintf(fidcpp,'%c',['catch(...) {',char(10),char(9),'CString tmpstring = "Unknown exception in ',functionname,...
              '";',char(10),char(9),'AfxMessageBox(tmpstring);',char(10),'}',char(10),char(10)]);
     end
     
     if ~isempty(find(narginlines==e))
         narginprintzaehler = narginprintzaehler+1;
         fprintf(fidcpp,'%c',strrep(printcell{narginlines(end+1-narginprintzaehler)},char(13),char(10)));
     else
         fprintf(fidcpp,'%c',strrep(printcell{e},char(13),char(10)));
     end
    
   
end


fclose(fidcpp);
if ~isempty(fidhpp)
    fclose(fidhpp);
end
if nargin<3 | defaultstatus
	edit(cppfile);
	edit(mfile);
end






return



