function makehtmlhelpfile(filename,filepath,outpath)

%  makehtmlhelpfile

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION. 

if nargin<1;[filename,filepath]=uigetfile('*.m','Please choose m-file to html-help:');outpath = filepath;end
if nargin<2;filepath=[];end
if nargin<3;outpath = filepath;end
file = [filepath filename];
helpstring = help(filename);

disp(helpstring);
% ok = input('ok?')
% if ~isempty(ok)
%     return
% end
    
if isempty(filepath)
    [name,path]= sepfilepath(file);
else
    name = filename;
end
if isempty(outpath)
    fid = fopen([path,strrep(name,'.m','.html')],'wt');
else
    fid = fopen([outpath,strrep(name,'.m','.html')],'wt');
end

fprintf(fid,'<html>\n');
fprintf(fid,'<header>\n');
fprintf(fid,'%c',['<link rel="stylesheet" type="text/css" href="../style.css">']);
fprintf(fid,'%c',['<title>',name,'</title>']);
fprintf(fid,'</header>\n');
fprintf(fid,'<body>\n');
fprintf(fid,'%c',['<!--navigation bar--><img src="../images/logo.jpg" width="242" height="55" border="0" alt=""><br><br><hr><a style="margin-left:0.0cm;color:#000000;margin-right:0.5cm" href="../index.html">topics</a> - <a style="margin-left:0.5cm;color:#000000;margin-right:0.5cm" href="../allfunctions.html">functions</a> - <a style="margin-left:0.5cm;color:#000000;margin-right:0.5cm" href="../allindex.html">index</a> - <a style="margin-left:0.5cm;color:#000000;margin-right:0.5cm" href="../search.html">search</a><br><hr>  <br>']);
fprintf(fid,'%c',['<p>',name,'</p>']);
fprintf(fid,'\n');
fprintf(fid,'%c','<p>');
stringmat = char(helpstring);
linebreaks = findstr(stringmat,sprintf('\n'));
nroflinebreaks = length(linebreaks);
for r=1:nroflinebreaks-1
    fprintf(fid,'%c',stringmat(linebreaks(r):linebreaks(r+1)));
    %stringmat(linebreaks(r):linebreaks(r+1))
    fprintf(fid,'<br>');
end
fprintf(fid,'%c',stringmat(linebreaks(nroflinebreaks):end));


fprintf(fid,'%c','</p>');
fprintf(fid,'\n');
fprintf(fid,'</body>\n');
fprintf(fid,'</html>\n');

fclose(fid);
if isempty(outpath)
    fprintf(1,'%c',[path,strrep(name,'.m','.html')]);
else
    fprintf(1,'%c',[outpath,strrep(name,'.m','.html')]);
end
fprintf(1,'\n');





return