function movefiletomanage(filename,filepath,mode)

%   movefiletomanage

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      


movestatus = questdlg('Do you want to move (m) or copy (c) the files?','Option:','m','c','c');
[savefilename,targetdirectory]=uiputfile('*.m','Create file in targetdirectory:');

if mode==0
   modefehler
   return


% directory mode   
elseif mode==11
   cd (filepath);
   filelist=dir(filepath);
   filelistsize=size(filelist);
      
	% Schleife fr Files
   for filezaehler=3:filelistsize(1)
      movefileto(targetdirectory,movestatus,filelist(filezaehler).name);
   end
   ok
   
% batchfile mode   
elseif mode==12
   filemat=batchfiletomat(filename,filepath);
   filematgroessevec=size(filemat);
   filematgroesse=filematgroessevec(2);
   for l=1:filematgroesse
      movefileto(targetdirectory,movestatus,filemat{l});
   end
   ok

%search mode
elseif mode ==13
    
   find=get(findobj('tag','filterstringedit'),'String');
   if isempty(find)
       uiwait(errordlg('Search string is empty!','Error:'));
       return
   end
   
   inclsubdir = get(findobj('tag','subdircheck'),'Value')
   [filemat]=dir2batch(filepath,inclsubdir,0,1,1,find,[]);
   if isempty(filemat)
        return
   end 
   for filezaehler=1:size(filemat,2)
      movefileto(targetdirectory,movestatus,filemat{filezaehler});
   end
   ok
      
% single file mode   
elseif mode==2
    movefileto(targetdirectory,movestatus,filename,filepath);    
	ok
  
end
return
